<?php

/******************************* ECMS SYSTEM FUNCTIONS START *************************************/

// Some globals that may come in handy...
   exec('cat /proc/cpuinfo', $cpuinfo);
   exec('cat /proc/loadavg', $loadavg);
   exec('cat /proc/meminfo', $meminfo);
   exec('cat /proc/uptime',  $uptime);

function getValue($str)
   {
        return substr($str,strrpos($str,":")+1,strlen($str)-strrpos($str,":")+1);
   }

function getSimple($str)
   {
           $start = strpos($str, "(");
           $end   = strpos($str, ")");

        return substr($str,0,$start-1).substr($str,$end+1,strlen($str)-$end+1);
   }

// Server Processor (CPU) properties...
$cpu_info = getSimple(getValue($cpuinfo[4])) . ' ' . round(getValue($cpuinfo[6]),0) . ' Mhz';

/* Server harddrive properties...268435456 */
function disk_info()
{
    $free_space = floor(disk_free_space(".") / 1073741824);
    $max_space = floor(disk_total_space(".") / 1073741824);
	return 'Total: '.$max_space.' GB ('.$free_space.' GB free)';
}

// Server RAM properties...
$ram_info    = "Total: " . round(getValue($meminfo[3])/1000,0) . " MB (" . round(getValue($meminfo[4])/1000,0) . " MB free)";

// Server Kernel properties...
exec('cat /proc/version', $version);
function formatVersion($str)
   {
           $ar = explode(' ', $str);
        return $ar[2];
   }
$version_info  = formatVersion($version[0]);

// Average server load (1min, 5min and 15min)...
function serverload()
{
    $loadavg_array = explode(" ", exec("cat /proc/loadavg"));
    $a = $loadavg_array[0];
    $b = $loadavg_array[1];
    $c = $loadavg_array[2];
    return $a.', '.$b.', '.$c;
}

// Display server uptime...
function formatUptime($time)
   {
        $days = floor($time/60/60/24);
        $time = $time-($days*60*60*24);

        if($days==1)
            $days = $days . ' day, ';
        else
            $days = $days .' days, ';

        $hours = floor($time/60/60);
        $time = $time-($hours*60*60);

        if($hours==1)
            $hours = $hours . ' h, ';
        else
            $hours = $hours . ' hrs, ';

        $minutes = floor($time/60);

        if($minutes==1)
            $minutes = $minutes . ' min';
        else
            $minutes = $minutes . ' mins';

        return $days . $hours . $minutes;

   }
$uptime_info = formatUptime(substr($uptime[0], 0, strpos($uptime[0], " ")));

// Display server uptime (works on Unix/Linux only)...
function uptime()
{
    $uptime_array = explode(" ", exec("cat /proc/uptime"));
    $seconds = round($uptime_array[0], 0);
    $minutes = $seconds / 60;
    $hours = $minutes / 60;
    $days = floor($hours / 24);
    $hours = floor($hours - ($days * 24));
    $minutes = floor($minutes - ($days * 24 * 60) - ($hours * 60));
    $seconds = floor($seconds - ($days * 24 * 60 * 60) - ($hours * 60 * 60) - ($minutes * 60));
    $uptime_array = array($days, $hours, $minutes, $seconds);

    if ($uptime_array[0] == 0) {
        if ($uptime_array[1] == 0) {
            if ($uptime_array[2] == 0) {
			    $uptime = $uptime_array[3] . " seconds";
            }
            else
            {
                $uptime = $uptime_array[2] . " minutes";
            }
        }
        else
        {
            $uptime = $uptime_array[1] . " hours";
        }
    }
    else
     {
        $uptime = $uptime_array[0] . " days";
    }
return $uptime;
}
$server_uptime = uptime();

// Displays current Apache version...
function apache_v()
{
    $ver = $_SERVER['SERVER_SOFTWARE'];
    return substr($ver,strpos($ver,'/')+1,strpos($ver,' ')-strpos($ver,'/')-1);
}

// Displays current mySQL version...
function mysql_v()
{
    if(@mysql_connect('localhost', 'evaria_admin', 'annichen01'))
		return mysql_get_server_info();
    else
    	return "Not running";
}

// Displays current PHP version...
$php_v = phpversion();

// Displaying visitors browser, version and OS...
function extract_agent($AGT) { // extract agent from $HTTP_USER_AGENT ($AGT)
    $st_sys = '';
    $st_ver = '';
    $st_sysver = '';

    if     (eregi("(opera) ([0-9]{1,2}.[0-9]{1,3}){0,1}",$AGT,$st_regs) ||
            eregi("(opera/)([0-9]{1,2}.[0-9]{1,3}){0,1}",$AGT,$st_regs))       {$st_brows = "Opera"; $st_ver = $st_regs[2];}
    else if(eregi("(konqueror)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))        {$st_brows = "Konqueror"; $st_ver = $st_regs[2]; $st_sys = "Linux";}
    else if(eregi("(lynx)/([0-9]{1,2}.[0-9]{1,2}.[0-9]{1,2})",$AGT,$st_regs) ) {$st_brows = "Lynx"; $st_ver = $st_regs[2];}
    else if(eregi("(links) \(([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "Links"; $st_ver = $st_regs[2];}
    else if(eregi("(omniweb/)([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "OmniWeb"; $st_ver = $st_regs[2];}
    else if(eregi("(webtv/)([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))            {$st_brows = "WebTV"; $st_ver = $st_regs[2];}
    else if(eregi("(msie) ([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))             {$st_brows = "Internet Explorer"; $st_ver = $st_regs[2];}
    else if(eregi("(netscape6)/(6.[0-9]{1,3})",$AGT,$st_regs))                 {$st_brows = "Netscape"; $st_ver = $st_regs[2];}
    else if(eregi("mozilla/5",$AGT))                                           {$st_brows = "Netscape"; $st_ver = '6';        }
    else if(eregi("(mozilla)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "Netscape"; $st_ver = $st_regs[2];}
    else if(eregi("w3m",$AGT))                                                 {$st_brows = "w3m";                           }
    else if(eregi("(scooter)-([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "Scooter"; $st_ver = $st_regs[2];}
    else if(eregi("(w3c_validator)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))    {$st_brows = "W3C"; $st_ver = $st_regs[2];}
    else if(eregi("(googlebot)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))        {$st_brows = "Google"; $st_ver = $st_regs[2];}
    else {$st_brows = ""; $st_ver = "";}

    if     (eregi("linux",$AGT))                                                     {$st_sys = "Linux";}
    else if(eregi("Win 9x 4.90",$AGT))                                               {$st_sys = "Windows Me";}
    else if(eregi("win32",$AGT))                                                     {$st_sys = "Windows ";}
    else if(eregi("windows 2000",$AGT))                                              {$st_sys = "Windows 2000";}
    else if((eregi("(win)([0-9]{2})",$AGT,$st_regs)) ||
            (eregi("(windows) ([0-9]{2})",$AGT,$st_regs)))                           {$st_sys = "Windows".$st_regs[2];}
    else if(eregi("(windows nt)( ){0,1}(5.0)",$AGT,$st_regs))                        {$st_sys = "Windows 2000";}
    else if(eregi("(windows nt)( ){0,1}(5.1)",$AGT,$st_regs))                        {$st_sys = "Windows XP";}
    else if(eregi("(windows nt)( ){0,1}(5.2)",$AGT,$st_regs))                        {$st_sys = "Windows 2003";}
    else if(eregi("(winnt)([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs))              {$st_sys = "WinNT".$st_regs[2];}
    else if(eregi("(windows nt)( ){0,1}([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs)) {$st_sys = "Windows NT".$st_regs[3];}
    else if(eregi("PPC",$AGT) || eregi("Mac_PowerPC",$AGT))                          {$st_sys = "MacPPC";}
    else if(eregi("mac",$AGT))                                                       {$st_sys = "Mac";}
    else if(eregi("(sunos) ([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs))             {$st_sys = "SunOS"; $st_sysver = $st_regs[2];}
    else if(eregi("(beos) r([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs))             {$st_sys = "BeOS"; $st_sysver = $st_regs[2];}
    else if(eregi("freebsd",$AGT))                                                   {$st_sys = "FreeBSD";}
    else if(eregi("openbsd",$AGT))                                                   {$st_sys = "OpenBSD";}
    else if(eregi("irix",$AGT))                                                      {$st_sys = "IRIX";}
    else if(eregi("os/2",$AGT))                                                      {$st_sys = "OS/2";}
    else if(eregi("plan9",$AGT))                                                     {$st_sys = "Plan9";}
    else if(eregi("unix",$AGT) || eregi("hp-ux",$AGT) )                              {$st_sys = "Unix";}
    else if(eregi("osf",$AGT))                                                       {$st_sys = "OSF";}
    else if(eregi("X11",$AGT) && !isset($st_sys))                                    {$st_sys = "Unix";}

    if ($st_brows != '' || $st_sys != '') {
        $new_agt[0] = $st_brows; // browser
        $new_agt[1] = $st_ver;   // version
        $new_agt[2] = $st_sys;   // system
    } else {
        $new_agt    = $AGT;
    }

    return($new_agt);
}
$agt = extract_agent($HTTP_USER_AGENT);
if(is_array($agt)) {
	$browser = $agt[0];
	$version = $agt[1];
	$system  = $agt[2];
} else {
	$browser = $agt;
}
// Call the function like this...
// echo "Browser:" . $browser . " v." . $version . " OS:" . $system;

// Display size of mySQL database...

function getdbsize($db_name) {
global $db_server, $db_user_login, $db_user_pass;
$db = mysql_connect($db_server, $db_user_login, $db_user_pass) or die ("Error connecting to MySQL Server!\n");
mysql_select_db($db_name, $db);

$sql_result = "SHOW TABLE STATUS FROM " . $db_name;
$result = mysql_query($sql_result);
mysql_close($db);

if($result) {
    $size = 0;
    while ($data = mysql_fetch_array($result)) {
        $size = $size + $data["Data_length"] + $data["Index_length"];
        }
        if( $size >= 1048576 )
        {
        return sprintf("%.2f MB", ( $size / 1048576 ));
        }
        else if( $size >= 1024 )
        {
        return sprintf("%.2f KB", ( $size / 1024 ));
        }
        else
        {
        return sprintf("%.2f Bytes", $size);
        }
    }
    else {
        return FALSE;
    }
}

// Displays visitors IP and ISP (host)...
function ip_isp_info()
{
    if (getenv(HTTP_X_FORWARDED_FOR)){
    $ip=getenv(HTTP_X_FORWARDED_FOR);
    }
    else {
    $ip=getenv(REMOTE_ADDR);
    }
    $client = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    $str = preg_split("/\./", $client);
    $i = count($str);
    $x = $i - 1;
    $n = $i - 2;
    $isp = $str[$n] . "." . $str[$x];
//  return $ip.' @ '.$isp;
    return $isp;
}

// Display time and date in your timezone...
function gTDate($off, $hrs, $mn, $zn)
{
$offset=$off*(($hrs*60+$mn)*60);
   $oslo = gmdate('d F Y | H:i',date('U') + $offset)."$zn";
   return $oslo;
}

/******************************* ECMS SYSTEM FUNCTIONS END *************************************/

?>
