<?php

// ***************************************************************************
// * Copyright  2003 - Thomas Egtvedt - www.evaria.com - thomas@evaria.com  *
// *                                                                         *
// *      ECMS - Content Management System - Support: forum.evaria.com       *
// *                                                                         *
// * This program is commercial software; you can not redistribute/reproduce *
// * it and/or sell it without the prior written consent of www.evaria.com   *
// *                                                                         *
// * This program is distributed in the hope that it will be useful,         *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
// ***************************************************************************
//
// This is the Download Manager for the ECMS, please review readme.txt before
// installing it on your server. Files needed = 5
//

//-------------------- EVARIA Download Manager settings ---

// Path from root (URL) to download directory
$dl_dir = '/udloads/';

// The variables below should be created automatically.
// NOTE: May not work for subdomains!
// $script_url should be full url to $dl_dir.
// $dl_path should be internal directory path to $dl_dir
$dl_path = $_SERVER['DOCUMENT_ROOT'] . $dl_dir;
$script_url = 'http://' . $_SERVER['HTTP_HOST'] . $dl_dir;

// Specify file containing the download information
// NOTE: Must be inside the download directory.
$logfile = $dl_path . 'stats.txt'; 
$fileinfo = file($logfile);

//-------------------- Load all data into the array ---
$downloads;
for ($i=0; $i<count($fileinfo); $i++)
	$downloads[$i] = explode("|", trim($fileinfo[$i]));

//-------------------- Creating download table ---
function ListDownloads(&$downloads, &$dl_path, &$params, &$request_url, &$filedir) {
	for ($Row=0; $Row<count($downloads); $Row++) {
		echo "<TABLE align=\"center\" class=\"dlborder\" width=\"90%\" cellspacing=\"1\" cellpadding=\"2\" border=\"0\">\n";
		echo "  <TR>\n";
		echo "    <TD align=\"left\" colspan=\"5\" class=\"dlheader\">" . $downloads[$Row][2] . "</TD>\n";
		echo "  </TR>\n  <TR>\n";
		echo "    <TD colspan=\"5\" valign=\"top\" class=\"dldesc\"><b>Description </b><br>\n";
		echo "    " . $downloads[$Row][3] . "</TD>\n";
		echo "  </TR>\n  <TR>\n";		
		echo "    <TD align=\"center\" class=\"dlfoot\"><b>Added:</b> " . $downloads[$Row][1] . "</TD>\n";
		echo "    <TD align=\"center\" class=\"dlfoot\"><b>Size:</b> " . round(filesize($dl_path . $downloads[$Row][5]) / 1024,2) . "KB</TD>\n";		
		if ($downloads[$Row][6] != $null)
			echo "    <TD align=\"center\" class=\"dlfoot\"><a class=\"dllink\" href=\"" . $downloads[$Row][6] . "\"><b>Demo</b></a></TD>\n";
		else
			echo "    <TD align=\"center\" class=\"dlfoot\"><b><strike>Demo</strike></b></TD>\n";
		if ($downloads[$Row][4] != $null)
			echo "    <TD align=\"center\" class=\"dlfoot\"><a class=\"dllink\" href=\"" . $downloads[$Row][4] . "\" target=\"_blank\"><b>Support</b></a></TD>\n";
		else
			echo "    <TD align=\"center\" class=\"dlfoot\"><b><strike>Support</strike></b></TD>\n";				
		if ($params != $null)
			echo"    <TD align=\"center\" class=\"dlfoot\"><a class=\"dllink\" href=\"" . $request_url . "&dload=" . $downloads[$Row][0] . "\"><b>Download</b></a> <b>[</b>" . $downloads[$Row][7] . "<b>]</b></TD>\n";
		else
			echo "    <TD align=\"center\" class=\"dlfoot\"><a class=\"dllink\" href=\"" . $request_url . "?dload=" . $downloads[$Row][0] . "\"><b>Download</b></a> <b>[</b>" . $downloads[$Row][7] . "<b>]</b></TD>\n";
		echo "  </TR>\n</TABLE>\n";
		echo "  <br>\n";
	}
	for ($i=0; $i<count($downloads); $i++)
		$total += $downloads[$i][7];
	echo "<TABLE align\"center\" width=\"90%\" cellspacing=\"1\" cellpadding=\"2\" border=\"0\">\n";	
	echo "  <TR>\n    <TD align=\"left\"><b>Total downloads&raquo;</b>" . $total . "<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Average&raquo;</b>" . round($total/count($downloads),2) . "</TD>\n";
	echo "  </TR>\n</TABLE>\n";
}

//-------------------- Retrieving requested file for download ---
function GetFile(&$downloads, &$dload, &$logfile, &$filedir){
	$downloads[$dload-1][7]++;
	if (is_writeable($logfile)){
		$file= fopen($logfile, 'w');
		for ($Row=0; $Row<count($downloads); $Row++){			
		for ($Col=0; $Col<count($downloads[$Row]); $Col++) {
				fwrite($file, $downloads[$Row][$Col]);
				if ($Col != count($downloads[$Row])-1)
					fwrite($file, '|');
			}
			if ($Row != count($downloads)-1)
				fwrite($file, "\r\n");
		}
		fclose($file);
		header("Location: " . $filedir . $downloads[$dload-1][5]);
		exit;
	}
	else
		die("Please CHMOD your stat.txt file to 666 or 777.");
}

function RetrieveDownloads() 
{
	$stat = $_GET['stat'];
	global $dl_path, $script_url, $logfile, $fileinfo, $downloads;
	ListDownloads($downloads, $dl_path, $_SERVER['QUERY_STRING'], $_SERVER['REQUEST_URI'], $script_url);
}

$dload = $_GET['dload'];
if ($dload != $null)
	if (($dload > 0) && ($dload <= count($downloads)))
		GetFile($downloads, $dload, $logfile, $script_url);
	else
		die("File Does Not Exist.");
?>