<%*
    Default display template

    Used when displaying lowres/highres picture

    Layout
      - Navigation bar (Using an include of navbar.tpl)
      - Title & rating
      - Picture
      - Metadata
      - Comments

*%>

<%* !! Navigation bar !! *%>

<% include file="navbar.tpl" %>


<%* !! Title & Rating !! *%>
<%*
    Picture properties
        $picture[name]              - Real filename (without directory path)
        $picture[title]             - Title
        $picture[url]               - URL of the picture/file (to use within img)
        $picture[path]              - Full path of the picture (directory + filename)
        $picture[link]              - URL when clicking on the picture (to use with ahref)
        $picture[metadata_found]    - Set to 1 if the picture does contains IPTC metadata
        $rating                     - An array dedicated to the rating module

*%>

<div id="displaypicture">
    <div id="pictitle">
    <span class="big"><% $picture[title] %></span>
    <% if $config[use_iptc] %>
        <span id="metadataicon">
        <% if $picture[metadata_found] %>
            <img src="<% $base_images_dir %>metadata_on.gif" alt="<% $txt[Found_IPTC_metadata] %>" title="<% $txt[Found_IPTC_metadata] %>" />
        <% else %>
            <img src="<% $base_images_dir %>metadata_off.gif" alt="<% $txt[No_IPTC_metadata_found] %>" title="<% $txt[No_IPTC_metadata_found] %>" />
        <% /if %>
        </span>
    <% /if %>
    </div><!--//pictitle-->
    <div id="picnav">
        <% $picnavbar %>
    </div><!--//picnav-->
    <%* Pictures settings [admin only] *%>
    <% if $admin %>
        <% $adminpicturebox %>
    <% /if %>

    <% if $config[use_rating] %>
        <div id="currentrating">
        <% if $rating[current_rating_raw] %>
            <% $txt[pic_rating] %> <% $rating[current_rating_formatted] %>
        <% else %>
            <% $txt[no_rating] %>
        <% /if %>
        <% if ! $rating[already_rated] %>
            <form id="picrating" action="<% $script_name %>" method="post">
            <input type="hidden" name="display" value="<% $display %>" />
            <select name="rating" onchange='document.location.href="<% $rating[form_url] %>" + this.options[this.selectedIndex].value'>
                <option value='null'><% $txt[option_rating] %></option>
            <% foreach value=option_rating from=$rating[select_options] %>
                <option value="<% $option_rating[value] %>"><% $option_rating[text] %></option>
            <% /foreach %>
            </select>
            <noscript><button type="submit"><% $txt[rate] %></button></noscript>
            </form><!--picrating-->
        <% /if %>
        </div>
    <% /if %>

    <% if $picture[link] %>
        <a href="<% $picture[link] %>" title="<% $picture[link_title] %>">
    <% /if %>
    <img src="<% $picture[url] %>" alt="<% $picture[title] %>" class="picture" />
    <% if $picture[link] %></a><% /if %>

    <% if $config[use_exif] && $picture[formatted_exif_metadata] %>
        <div class="exifmetadata">
        <% $picture[formatted_exif_metadata] %>
        </div>
    <% /if %>
    <% if $config[use_iptc] && $picture[formatted_iptc_metadata] %>
        <div class="iptcmetadata">
        <% $picture[formatted_iptc_metadata] %>
        </div>
    <% /if %>
    <% if ($config[use_iptc] || $config[use_exif]) && $picture[metadata_array] %>
        <div style="text-align: center">
            <a href="javascript:switch_display('metadatadiv')"><% $txt[show_me_more] %></a>
        </div>
        <div id="metadatadiv" style="display:none">
          <table class="metadatatable">
          <% foreach key=key value=value from=$picture[metadata_array] %>
          <tr class="<% cycle values="rowbgcolor1, rowbgcolor2" %>"><td align="left"><% $key %></td><td><% $value %></td></tr>
          <% /foreach %>
          </table>
        </div><!--//metadatadiv-->
    <% /if %>

    <% if $config[use_comments] %>
    <div id="comments">
    <span id="commentstitle"><% $txt[comments] %></span>
    <% if $picture[user_can_post_comments] %>
        <span id="addcomment"><a href="#" onclick="enterWindow=window.open('?picname=<% $picture[path] %>&amp;addcomment=1&amp;popup=1','commentadd','width=400,height=260,top=250,left=500'); return false"><% $txt[add_comment] %></a></span>
    <% /if %>
    <% if $comments %>
        <% foreach value=comment from=$comments %>
        <div class="small commentfrom"><% $txt[comment_from] %><b><% $comment[user] %></b><% $txt[comment_on] %> <% $comment[datetime] %>
        <% if $admin %>
             | <a href="?display=<% $picture[path] %>&amp;delcom=<% $comment[id] %>"><% $txt[del_comment] %></a>
        <% /if %>
        </div>
        <div class="usercomment"><% $comment[text] %></div>
        <% /foreach %>
    <% /if %>
    </div><!--//comments-->
    <% /if %>

</div><!--//displaypicture-->
