-- ========================================================================
-- Copyright (C) 2010 Regis Houssin  <regis@dolibarr.fr>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- $Id: llx_c_field_list.sql,v 1.3 2010/03/26 15:43:18 hregis Exp $
-- ========================================================================

create table llx_c_field_list
(
  rowid			integer  AUTO_INCREMENT PRIMARY KEY,
  tms			timestamp,
  element		varchar(64)        			NOT NULL,		-- name of element list
  entity		integer			DEFAULT 1 	NOT NULL,		-- entity id
  name			varchar(32)        			NOT NULL,		-- name of field with table alias (ex: p.ref)
  alias			varchar(32)					NOT NULL,		-- alias of field (ex: ref)
  title			varchar(32)        			NOT NULL,		-- title (translation) of field (ex: Ref)
  align			varchar(6)		DEFAULT 'left',				-- align (left,center,right)
  sort			tinyint 		DEFAULT 1  	NOT NULL,		-- add sort field
  search		tinyint 		DEFAULT 0  	NOT NULL,		-- add search field
  enabled       varchar(255)	DEFAULT 1,					-- Condition to show or hide
  rang      	integer 		DEFAULT 0
  
)type=innodb;
