/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DistObj
extends PolyObj {
    protected final String kstrToken = "%s";
    protected final String kstrPixelSizeParam = "PIXEL_SIZE";
    protected final String kstrDistanceMsgParam = "DIST_MSG";
    protected final String kstrDistPrecisionParam = "DIST_PRECISION";
    protected int m_nPrecision = 3;
    protected double m_fPixelSize = 0.0;
    protected double m_fCurrentDistance = 0.0;
    protected String m_strMsg = null;
    protected Rosa2000 m_applet;

    public DistObj(Map parent, Rosa2000 applet) {
        super(parent, applet);
        this.m_applet = applet;
        this.readPararam();
    }

    protected void readPararam() {
        this.m_strMsg = this.m_applet.getParameter("DIST_MSG");
        String strPrecision = this.m_applet.getParameter("DIST_PRECISION");
        double dfPixelSize = this.m_applet.GetPixelSize();
        if (dfPixelSize > 0.0) {
            try {
                if (strPrecision != null) {
                    this.m_nPrecision = Integer.valueOf(strPrecision);
                }
                this.m_fPixelSize = dfPixelSize;
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid value " + strPrecision + " in the parameter ");
            }
        }
    }

    public String getSubmitValue() {
        String strRetVal = new String();
        return strRetVal;
    }

    public double getDistance(Point pt1, Point pt2) {
        double dfDelta = Math.pow(pt2.x - pt1.x, 2.0) + Math.pow(pt2.y - pt1.y, 2.0);
        return Math.sqrt(dfDelta) * this.m_fPixelSize;
    }

    protected String getValueString(double fValue) {
        double dfTmp = Math.pow(10.0, this.m_nPrecision) * fValue;
        dfTmp = Math.ceil(dfTmp);
        double dfNewValue = dfTmp / Math.pow(10.0, this.m_nPrecision);
        return Double.toString(dfNewValue);
    }

    public String getDistanceStringMsg(double fValue) {
        String strVal = new String();
        if (this.m_strMsg != null) {
            int nIndex = this.m_strMsg.indexOf("%s");
            if (nIndex != -1) {
                strVal = this.m_strMsg.substring(0, nIndex);
                strVal = strVal + this.getValueString(fValue);
                if (this.m_strMsg.length() > nIndex + 2) {
                    strVal = strVal + this.m_strMsg.substring(nIndex + 2);
                }
            }
        } else {
            strVal = this.getValueString(fValue);
        }
        return strVal;
    }

    public void mouseMoved(MouseEvent evt) {
        if (this.m_poly.npoints > 0) {
            Point ptLastPt = new Point(this.m_poly.xpoints[this.m_poly.npoints - 1], this.m_poly.ypoints[this.m_poly.npoints - 1]);
            double fDist = this.getDistance(ptLastPt, evt.getPoint());
            double dist = fDist + this.m_fCurrentDistance;
            this.m_applet.showText(this.getDistanceStringMsg(fDist + this.m_fCurrentDistance));
        }
        super.mouseMoved(evt);
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.endProcessing();
            this.m_fCurrentDistance = 0.0;
        } else {
            if (this.m_poly.npoints > 0) {
                Point ptLastPt = new Point(this.m_poly.xpoints[this.m_poly.npoints - 1], this.m_poly.ypoints[this.m_poly.npoints - 1]);
                this.m_fCurrentDistance += this.getDistance(ptLastPt, evt.getPoint());
                this.m_applet.showText(this.getDistanceStringMsg(this.m_fCurrentDistance));
            }
            super.mousePressed(evt);
        }
    }

    public void destroyEvent() {
        this.m_applet.showText("");
        this.m_fCurrentDistance = 0.0;
        super.destroyEvent();
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.m_poly.npoints > 0) {
            Point ptLastPt = new Point(this.m_poly.xpoints[this.m_poly.npoints - 1], this.m_poly.ypoints[this.m_poly.npoints - 1]);
            this.m_fCurrentDistance += this.getDistance(ptLastPt, evt.getPoint());
            this.m_applet.showText(this.getDistanceStringMsg(this.m_fCurrentDistance));
        }
        super.mouseReleased(evt);
    }
}

