/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import java.util.Vector;

public class LegendObj
extends PointObj
implements KeyListener {
    private final String kstrLegendParam = "DYN_LEGEND";
    protected int m_alpha = 0;
    protected int m_red = 0;
    protected int m_green = 0;
    protected int m_blue = 0;
    protected Vector m_astrDesc = new Vector(5, 5);
    protected Vector m_anColor = new Vector(5, 5);
    protected Rosa2000 m_applet;

    public LegendObj(Map parent, Rosa2000 applet) {
        super(parent);
        this.m_applet = applet;
        this.m_applet.addKeyListener(this);
        this.initLookupTable(applet);
    }

    protected void initLookupTable(Rosa2000 applet) {
        String strParamList = applet.getParameter("DYN_LEGEND");
        String strItem = new String();
        if (strParamList != null) {
            int nIndex = 0;
            int nPreviousIndex = 0;
            while ((nIndex = strParamList.indexOf("|", nIndex++)) != -1) {
                strItem = strParamList.substring(nPreviousIndex, nIndex);
                nPreviousIndex = ++nIndex;
                this.addItemInLookup(strItem);
            }
            if (nPreviousIndex < strParamList.length() - 1) {
                strItem = strParamList.substring(nPreviousIndex);
                this.addItemInLookup(strItem);
            }
        }
    }

    protected void addItemInLookup(String strItem) {
        Integer color = null;
        String strDesc = null;
        boolean bError = true;
        String strValue = null;
        int nIndex = 0;
        int nPreviousIndex = 0;
        if ((nIndex = strItem.indexOf("=", nIndex++)) != -1) {
            strValue = strItem.substring(nPreviousIndex, nIndex);
            nPreviousIndex = ++nIndex;
            try {
                int nColorValue = Integer.valueOf(strValue, 16) + -16777216;
                color = new Integer(nColorValue);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid color: " + strValue);
                return;
            }
            if (nPreviousIndex < strItem.length() - 1) {
                strDesc = strItem.substring(nPreviousIndex);
            }
            if (color != null && strDesc != null) {
                this.m_astrDesc.addElement(strDesc);
                this.m_anColor.addElement(color);
                bError = false;
            }
        }
        if (bError) {
            System.err.println("Invalid item " + strItem + " in the parameter " + "DYN_LEGEND");
        }
    }

    public String getSubmitValue() {
        return new String();
    }

    private void handleSinglePixel(int pixel) {
        this.m_alpha = pixel >> 24 & 0xFF;
        this.m_red = pixel >> 16 & 0xFF;
        this.m_green = pixel >> 8 & 0xFF;
        this.m_blue = pixel & 0xFF;
        if (Rosa2000.isDebugMode()) {
            System.out.println("Alpha = " + this.m_alpha + " Red = " + this.m_red + " green = " + this.m_green + " Blue = " + this.m_blue + " pixel = " + pixel);
        }
    }

    public int getPixels(Image img, int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted  waiting  for  pixels!");
            return 0;
        }
        if ((pg.status() & 0x80) != 0) {
            System.err.println("image  fetch  aborted  or  errored");
            return 0;
        }
        int j = 0;
        while (j < h) {
            int i = 0;
            if (i < w) {
                return pixels[0];
            }
            ++j;
        }
        return 0;
    }

    public void mouseReleased(MouseEvent evt) {
        this.x = evt.getPoint().x;
        this.y = evt.getPoint().y;
        int nColorPixel = this.getPixels(this.m_map.getImage(), this.x, this.y, 1, 1);
        String strDesc = this.getLookupString(new Integer(nColorPixel));
        if (strDesc != null) {
            this.m_applet.showText(strDesc);
        }
    }

    protected String getLookupString(Integer color) {
        int nIndex = this.m_anColor.indexOf(color);
        if (nIndex != -1) {
            return (String)this.m_astrDesc.elementAt(nIndex);
        }
        return null;
    }

    public void destroyEvent() {
        this.m_map.removeMouseListener(this);
        this.m_applet.addKeyListener(this);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.destroyEvent();
            this.m_map.commitOperation();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

