/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import netscape.javascript.JSObject;

public class Map
extends Component
implements ActionListener {
    private final String kstrRect = "rect";
    private final String kstrPoint = "point";
    private final String kstrEllipse = "ellipse";
    private final String kstrPoly = "poly";
    private final String kstrLegend = "legend";
    private final String kstrDistance = "dist";
    private final String kstrSubmit = "submit";
    private final String kstrAutoMode = "auto_";
    private final String kstrFormParam = "INP_FORM_NAME";
    private final String kstrTypeParam = "INP_TYPE_NAME";
    private final String kstrCoordParam = "INP_COORD_NAME";
    private final String kstrMapCoordParam = "IMG_XY";
    private Image m_ImagMap = null;
    private DrawObj m_curDrawObj = null;
    private DrawObj m_RectDrawObj = null;
    private DrawObj m_PointDrawObj = null;
    private DrawObj m_EllipseDrawObj = null;
    private DrawObj m_PolyDrawObj = null;
    private DrawObj m_LegendDrawObj = null;
    private DrawObj m_DistDrawObj = null;
    private ButtonCtrl m_curButton = null;
    private Point m_coord = null;
    private boolean m_bAlreadyUsed = false;
    private String m_strFormName = null;
    private String m_strTypeName = null;
    private String m_strCoordName = null;
    private Rosa2000 m_parent;
    protected Image m_offScreenImage = null;
    protected Graphics m_offScreenGraphics = null;

    public Map(Rosa2000 applet, Image map, int nWidth, int nHeight) {
        this.setVisible(false);
        this.m_ImagMap = map;
        this.m_parent = applet;
        this.setSize(nWidth, nHeight);
        this.readSubmitParams();
        this.readLocation();
        Dimension appletDim = this.m_parent.getSize();
        this.m_offScreenImage = this.m_parent.createImage(appletDim.width, appletDim.height);
        this.m_offScreenGraphics = this.m_offScreenImage.getGraphics();
    }

    public void setObjectDrawer(DrawObj drawObj) {
        this.m_curDrawObj = drawObj;
    }

    public DrawObj getObjectDrawer() {
        return this.m_curDrawObj;
    }

    public Image getImage() {
        return this.m_ImagMap;
    }

    public Rosa2000 getApplet() {
        return this.m_parent;
    }

    public boolean isAutoMode() {
        String strCmd;
        if (this.m_curButton != null && (strCmd = this.m_curButton.getActionCommand()) != null) {
            return strCmd.startsWith("auto_");
        }
        return false;
    }

    public Graphics getGraphics() {
        return this.m_offScreenGraphics;
    }

    public void paint(Graphics g) {
        if (this.m_offScreenGraphics != null) {
            this.m_offScreenGraphics.drawImage(this.m_ImagMap, 0, 0, this);
            if (this.getObjectDrawer() != null) {
                this.getObjectDrawer().draw();
            }
            g.drawImage(this.m_offScreenImage, 0, 0, this);
        }
    }

    public void redraw() {
        Graphics g = this.m_parent.getGraphics();
        if (g != null) {
            this.paint(g);
        }
    }

    public void printAll(Graphics g) {
        this.print(g);
    }

    public void print(Graphics g) {
        double scale = 0.75;
        try {
            Class.forName("netscape.applet.MozillaAppletContext");
        }
        catch (ClassNotFoundException e) {
            scale = 1.0;
        }
        if (this.m_offScreenGraphics != null) {
            this.m_offScreenGraphics.drawImage(this.m_ImagMap, 0, 0, this);
            if (this.getObjectDrawer() != null) {
                this.getObjectDrawer().draw();
            }
            g.drawImage(this.m_offScreenImage, 0, 0, (int)((double)this.size().width * scale), (int)((double)this.size().height * scale), this);
        }
    }

    public void commitOperation() {
        block11: {
            if (this.m_strTypeName != null && this.m_strCoordName != null && this.m_curButton.getButtonActionName() != null && this.m_curButton.getButtonActionValue() != null && this.m_curButton.getActionCommand() != null) {
                try {
                    JSObject window = JSObject.getWindow((Applet)this.m_parent);
                    JSObject doc = (JSObject)window.getMember("document");
                    JSObject form = null;
                    if (this.m_strFormName != null) {
                        form = (JSObject)doc.getMember(this.m_strFormName);
                    } else {
                        form = (JSObject)doc.getMember("forms");
                        if (form != null) {
                            form = (JSObject)form.getSlot(0);
                        }
                    }
                    if (form == null) break block11;
                    JSObject jsInputType = (JSObject)form.getMember(this.m_strTypeName);
                    jsInputType.setMember("value", this.m_curButton.getActionCommand());
                    if (this.m_curDrawObj != null) {
                        JSObject jsCoordinate = (JSObject)form.getMember(this.m_strCoordName);
                        jsCoordinate.setMember("value", this.m_curDrawObj.getSubmitValue());
                    }
                    JSObject jsButtonAction = (JSObject)form.getMember(this.m_curButton.getButtonActionName());
                    jsButtonAction.setMember("value", this.m_curButton.getButtonActionValue());
                    if (this.isAutoMode() || this.m_curButton.getActionCommand().equals("submit")) {
                        if (this.m_curButton.getJSAction() != null && this.m_curButton.getJSAction().length() != 0) {
                            JSObject.getWindow((Applet)this.m_parent).eval(this.m_curButton.getJSAction());
                            return;
                        }
                        if (this.m_curButton.getTarget() != null && this.m_curButton.getTarget().length() != 0) {
                            form.setMember("target", this.m_curButton.getTarget());
                        }
                        this.submitData(form);
                        break block11;
                    }
                    this.m_curButton.setPressed(false);
                }
                catch (ClassCastException ex) {
                    System.err.println("A parameter is not found. Cannot submit to the server");
                }
            } else {
                this.m_bAlreadyUsed = true;
                this.startAction(this.m_curButton, true);
                return;
            }
        }
        this.m_bAlreadyUsed = true;
    }

    protected void destroyCommand() {
        if (this.getObjectDrawer() != null) {
            this.getObjectDrawer().destroyEvent();
        }
        this.m_curDrawObj = null;
        this.m_curButton = null;
    }

    public void submitData(JSObject form) {
        Object[] args = new Object[]{};
        form.call("submit", args);
    }

    public void actionPerformed(ActionEvent e) {
        this.startAction((ButtonCtrl)e.getSource(), false);
    }

    public void startAction(ButtonCtrl buttonPress, boolean bIgnoreSubmit) {
        if (this.getObjectDrawer() != null) {
            this.getObjectDrawer().disable_object();
        }
        if (this.m_bAlreadyUsed) {
            this.repaint();
        }
        if (buttonPress.isPressed()) {
            this.m_parent.getTB().setButtonPress(buttonPress);
            String strName = buttonPress.toString();
            this.m_curButton = buttonPress;
            String strCmd = this.m_curButton.getActionCommand();
            String strValidCmd = new String();
            if (this.isAutoMode()) {
                strValidCmd = "auto_";
            }
            if (strCmd == null) {
                strCmd = "null";
            }
            if (strCmd.equals(strValidCmd + "rect")) {
                if (this.m_RectDrawObj == null) {
                    this.m_RectDrawObj = new RectObj(this);
                } else {
                    this.m_RectDrawObj.enable_object();
                }
                this.m_curDrawObj = this.m_RectDrawObj;
            } else if (strCmd.equals(strValidCmd + "point")) {
                if (this.m_PointDrawObj == null) {
                    this.m_PointDrawObj = new PointObj(this);
                } else {
                    this.m_PointDrawObj.enable_object();
                }
                this.m_curDrawObj = this.m_PointDrawObj;
            } else if (strCmd.equals(strValidCmd + "ellipse")) {
                if (this.m_EllipseDrawObj == null) {
                    this.m_EllipseDrawObj = new EllipseObj(this);
                } else {
                    this.m_EllipseDrawObj.enable_object();
                }
                this.m_curDrawObj = this.m_EllipseDrawObj;
            } else if (strCmd.equals(strValidCmd + "poly")) {
                if (this.m_PolyDrawObj == null) {
                    this.m_PolyDrawObj = new PolyObj(this, this.m_parent);
                } else {
                    this.m_PolyDrawObj.enable_object();
                }
                this.m_curDrawObj = this.m_PolyDrawObj;
            } else if (strCmd.equals("legend")) {
                if (this.m_LegendDrawObj == null) {
                    this.m_LegendDrawObj = new LegendObj(this, this.m_parent);
                } else {
                    this.m_LegendDrawObj.enable_object();
                }
                this.m_curDrawObj = this.m_LegendDrawObj;
            } else if (strCmd.equals("dist")) {
                if (this.m_DistDrawObj == null) {
                    this.m_DistDrawObj = new DistObj(this, this.m_parent);
                } else {
                    this.m_DistDrawObj.enable_object();
                }
                this.m_curDrawObj = this.m_DistDrawObj;
            } else if (strCmd.equals("submit")) {
                if (!bIgnoreSubmit) {
                    this.commitOperation();
                }
            } else {
                System.err.println("Command " + strCmd + " not supported");
            }
        }
    }

    protected void readLocation() {
        String strLocation = this.m_parent.getParameter("IMG_XY");
        if (strLocation != null) {
            boolean bError = true;
            String strCoor = new String();
            int nX = 0;
            int nY = 0;
            int nIndex = 0;
            if ((nIndex = strLocation.indexOf(",", nIndex++)) != -1) {
                strCoor = strLocation.substring(0, nIndex);
                try {
                    nX = Integer.valueOf(strCoor, 10);
                    if (nIndex < strLocation.length() - 1 && (strCoor = strLocation.substring(nIndex + 1)) != null) {
                        nY = Integer.valueOf(strCoor, 10);
                        bError = false;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (!bError) {
                this.m_coord = new Point(nX, nY);
                this.setLocation(this.m_coord);
            } else {
                System.err.println("Invalid coordinate parameter: " + strLocation + " for the Map.");
            }
        } else {
            this.centerMap();
        }
    }

    protected void centerMap() {
        Dimension mapSize = this.getSize();
        Dimension parentSize = this.m_parent.getSize();
        this.m_coord = new Point((parentSize.width - mapSize.width) / 2, (parentSize.height - mapSize.height) / 2);
        this.setLocation(this.m_coord);
    }

    protected void readSubmitParams() {
        this.m_strFormName = this.m_parent.getParameter("INP_FORM_NAME");
        this.m_strTypeName = this.m_parent.getParameter("INP_TYPE_NAME");
        if (this.m_strTypeName == null) {
            System.err.println("The parameter INP_TYPE_NAME is missing.  The submit command will be disabled.");
        }
        this.m_strCoordName = this.m_parent.getParameter("INP_COORD_NAME");
        if (this.m_strCoordName == null) {
            System.err.println("The parameter INP_COORD_NAME is missing.  The submit command will be disabled.");
        }
    }
}

