/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class PolyObj
extends DrawObj
implements MouseMotionListener,
MouseListener,
KeyListener {
    protected Point pAnchor;
    protected Point pMoveAnchor;
    protected Polygon m_poly = new Polygon();
    protected Map m_map;
    Rosa2000 m_applet;

    public PolyObj(Map parent, Rosa2000 applet) {
        this.m_applet = applet;
        this.m_map = parent;
        this.g = parent.getGraphics();
        this.addEvent();
    }

    public String getSubmitValue() {
        String strRetVal = new String();
        int i = 0;
        while (i < this.m_poly.npoints) {
            strRetVal = strRetVal + Integer.toString(this.m_poly.xpoints[i]) + "," + Integer.toString(this.m_poly.ypoints[i]);
            if (i < this.m_poly.npoints - 1) {
                strRetVal = strRetVal + ";";
            }
            ++i;
        }
        return strRetVal;
    }

    public void draw() {
        if (this.g != null && this.m_poly.npoints > 0) {
            Color colorCurrent = this.g.getColor();
            this.g.setColor(this.getColor());
            this.g.drawPolyline(this.m_poly.xpoints, this.m_poly.ypoints, this.m_poly.npoints);
            this.g.setColor(colorCurrent);
            this.drawLine();
        }
    }

    public void drawLine() {
        if (this.g != null && this.m_poly.npoints > 0) {
            Color colorCurrent = this.g.getColor();
            this.g.setColor(this.getColor());
            this.g.drawLine(this.pAnchor.x, this.pAnchor.y, this.pMoveAnchor.x, this.pMoveAnchor.y);
            this.g.setColor(colorCurrent);
        }
    }

    public void initPaint() {
        Graphics g = this.m_map.getGraphics();
        if (g != null) {
            this.m_map.redraw();
        }
    }

    public void mouseMoved(MouseEvent evt) {
        Graphics g = this.m_map.getGraphics();
        if (g != null && this.m_poly.npoints > 0) {
            this.pMoveAnchor = evt.getPoint();
            this.initPaint();
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.endProcessing();
        } else {
            this.m_poly.addPoint(evt.getX(), evt.getY());
            this.pMoveAnchor = this.pAnchor = evt.getPoint();
            this.m_map.redraw();
        }
    }

    public void destroyEvent() {
        this.m_map.removeMouseListener(this);
        this.m_map.removeMouseMotionListener(this);
        this.m_applet.removeKeyListener(this);
    }

    public void addEvent() {
        this.m_map.addMouseListener(this);
        this.m_map.addMouseMotionListener(this);
        this.m_applet.addKeyListener(this);
    }

    public void endProcessing() {
        this.destroyEvent();
        this.m_map.commitOperation();
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
            this.endProcessing();
        } else if (e.getKeyCode() == 27) {
            this.m_poly = new Polygon();
            this.endProcessing();
        }
    }

    public void reset_object() {
        this.m_poly = new Polygon();
    }

    public void resize(Point p) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

