/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;

public class Rosa2000
extends Applet {
    private final String kstrTbSelectedButton = "TB_SELECTED_BUTTON";
    private final String kstrTbPositionName = "TB_POSITION";
    private final String kstrTbLocationName = "TB_LOCATION";
    private final String kstrTbAlignName = "TB_ALIGN";
    private final String kstrImgListName = "IMG_URL";
    private final String kstrXScaleName = "X_SCALE";
    private final String kstrYcaleName = "Y_SCALE";
    private final String kstrBkColorName = "BG_COLOR";
    private final String kstrButtonDefName = "TB_BUTTONS";
    private final String kstrDebugModeName = "DEBUG";
    private final String kstrFormParam = "INP_FORM_NAME";
    private final String kstrLoadingMsg = "LOADING_MSG";
    private final String kstrDefaultLoadingMsg;
    public int m_gBufferSizeForStream = 5000;
    public static boolean m_bIsDebug = false;
    private int m_nWidthOfLoadingWnd = 400;
    private int m_nHeightOfLoadingWnd = 100;
    private double mdfPixelSize = 0.0;
    ToolbarPanel m_toolbar = null;
    Map m_map = null;
    private String m_strLoadingString = null;
    boolean m_bLoad = false;
    Frame m_Frame = null;
    Label m_status = null;

    public Rosa2000() {
        this.kstrDefaultLoadingMsg = null;
    }

    public void init() {
        this.readDebugParam();
        this.m_strLoadingString = this.getParameter("LOADING_MSG");
        if (this.m_strLoadingString == null) {
            this.m_strLoadingString = "Loading map... Please wait.";
        }
        this.setLayout(null);
        this.loadBackground();
        this.setVisible(true);
        this.paint(this.getGraphics());
        this.setLoadingMsg("Loading Map...");
        this.loadMap(null);
        String strPixelSize = this.getParameter("PIXEL_SIZE");
        if (strPixelSize != null) {
            try {
                this.mdfPixelSize = Double.valueOf(strPixelSize);
            }
            catch (NumberFormatException e) {
                this.mdfPixelSize = 1.0;
            }
        } else {
            this.mdfPixelSize = 1.0;
        }
        System.out.println("init");
    }

    public static boolean isDebugMode() {
        return m_bIsDebug;
    }

    public ToolbarPanel getTB() {
        return this.m_toolbar;
    }

    public Map getMapObj() {
        return this.m_map;
    }

    public void stop() {
        this.m_map.destroyCommand();
        this.m_toolbar.setButtonPress(null);
        this.m_toolbar.cleanUp();
        System.out.println("stop");
    }

    public void start() {
        this.setSelectedButton();
        System.out.println("start : Development Version 2001-09-11");
    }

    protected void loadBackground() {
        String strColorName = this.getParameter("BG_COLOR");
        int nColor = 0xFFFFFF;
        if (strColorName != null) {
            try {
                if (strColorName.startsWith("#")) {
                    strColorName = strColorName.substring(1);
                }
                nColor = Integer.valueOf(strColorName, 16);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid background color: " + strColorName);
                return;
            }
        }
        this.setBackground(new Color(nColor));
    }

    protected void readDebugParam() {
        String strDebug = this.getParameter("DEBUG");
        if (strDebug != null) {
            try {
                m_bIsDebug = Integer.valueOf(strDebug, 10) == 1;
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid debug info: " + strDebug);
                return;
            }
        }
    }

    public void loadMap(String strMap) {
        String strCurrentButtonName = null;
        if (this.m_toolbar != null && this.m_toolbar.getCurrentButton() != null) {
            strCurrentButtonName = this.m_toolbar.getCurrentButton().getButtonName();
        }
        this.m_bLoad = false;
        if (this.m_map != null) {
            this.remove(this.m_map);
        }
        this.m_map = null;
        if (this.m_toolbar != null) {
            this.remove(this.m_toolbar);
        }
        this.m_toolbar = null;
        this.paint(this.getGraphics());
        this.loadImage(strMap);
        this.setLoadingMsg("Loading toolbar...");
        this.readToolbarParam();
        this.add(this.m_map);
        this.add(this.m_toolbar);
        this.m_toolbar.automaticPlace();
        this.m_bLoad = true;
        this.destroyLoadingMsg();
        this.repaint();
        this.m_map.setVisible(true);
        this.m_toolbar.setVisible(true);
        if (strCurrentButtonName != null && this.m_toolbar != null) {
            this.setButtonPress(strCurrentButtonName);
        }
    }

    protected void loadImage(String strMap) {
        if (Rosa2000.isDebugMode()) {
            System.out.println("loadimage = " + strMap);
        }
        String strMapName = null;
        this.m_bLoad = false;
        strMapName = strMap == null ? this.getParameter("IMG_URL") : strMap;
        if (strMap != null) {
            this.repaint();
        }
        try {
            Image mapImg = null;
            URL url = null;
            try {
                url = new URL(strMapName);
                mapImg = this.getImage(url);
            }
            catch (MalformedURLException e) {
                System.out.println("1st");
                try {
                    url = this.getDocumentBase();
                    mapImg = this.getImage(url, strMapName);
                    int nWidth = mapImg.getWidth(this);
                    System.out.println(nWidth);
                }
                catch (Exception ex) {
                    System.out.println("2nd");
                }
            }
            MediaTracker theTracker = new MediaTracker(this);
            theTracker.addImage(mapImg, 0);
            theTracker.waitForAll();
            while (this.getBounds().width <= 0) {
            }
            if (this.m_map != null) {
                this.remove(this.m_map);
            }
            this.m_map = new Map(this, mapImg, mapImg.getWidth(this), mapImg.getHeight(this));
        }
        catch (Exception e) {
            System.err.println("Error loading image.");
            System.exit(1);
        }
    }

    protected void readToolbarParam() {
        String strToolbarPosition = this.getParameter("TB_POSITION");
        if (strToolbarPosition == null) {
            strToolbarPosition = "right";
        }
        String strToolbarAlignment = this.getParameter("TB_ALIGN");
        this.m_toolbar = new ToolbarPanel(this, this.m_map, strToolbarPosition, strToolbarAlignment);
        this.readButton();
    }

    protected int readButton() {
        int nRetButtonValue = 0;
        if (this.m_toolbar != null) {
            String strButtonList = this.getParameter("TB_BUTTONS");
            String strButton = new String();
            if (strButtonList != null) {
                int nIndex = 0;
                int nPreviousIndex = 0;
                while ((nIndex = strButtonList.indexOf("|", nIndex++)) != -1) {
                    strButton = strButtonList.substring(nPreviousIndex, nIndex);
                    ++nRetButtonValue;
                    nPreviousIndex = ++nIndex;
                    this.m_toolbar.createButton(strButton);
                }
                if (nPreviousIndex < strButtonList.length() - 1) {
                    strButton = strButtonList.substring(nPreviousIndex);
                    ++nRetButtonValue;
                    this.m_toolbar.createButton(strButton);
                }
            }
        }
        return nRetButtonValue;
    }

    protected void setSelectedButton() {
        ButtonCtrl defBut;
        String strDefaultButton = this.getParameter("TB_SELECTED_BUTTON");
        if (strDefaultButton != null && this.m_toolbar != null && (defBut = this.m_toolbar.getButton(strDefaultButton)) != null) {
            defBut.setPressed(true);
            defBut.setCursorType();
            this.m_map.startAction(defBut, true);
        }
    }

    public void showText(String strText) {
        this.showStatus(strText);
    }

    public void paint(Graphics g) {
        if (!this.m_bLoad && this.m_strLoadingString != null) {
            Dimension appletDim = this.getSize();
            int nX = (appletDim.width - g.getFontMetrics().stringWidth(this.m_strLoadingString)) / 2;
            g.setColor(new Color(255, 255, 255));
            g.fillRect(nX - 2, appletDim.height / 2 - g.getFontMetrics().getHeight(), g.getFontMetrics().stringWidth(this.m_strLoadingString) + 2, g.getFontMetrics().getHeight() + 4);
            g.setColor(new Color(0, 0, 0));
            g.drawString(this.m_strLoadingString, nX, appletDim.height / 2);
        } else {
            super.paint(g);
        }
    }

    public void printAll(Graphics g) {
        boolean bIsNetscape = true;
        try {
            Class.forName("netscape.applet.MozillaAppletContext");
        }
        catch (ClassNotFoundException e) {
            bIsNetscape = false;
        }
        if (bIsNetscape) {
            this.m_map.print(g);
        } else {
            super.printAll(g);
        }
    }

    void showLoadingMessage() {
        if (this.m_Frame == null && this.m_strLoadingString != null) {
            this.m_Frame = new Frame();
            this.m_Frame.setLayout(null);
            ((Component)this.m_Frame).setSize(this.m_nWidthOfLoadingWnd, this.m_nHeightOfLoadingWnd);
            this.m_Frame.setTitle(this.m_strLoadingString);
            Rosa2000.center(this.m_Frame);
            this.m_Frame.toFront();
            this.m_status = new Label("");
            this.m_status.setSize(this.m_nWidthOfLoadingWnd, this.m_nHeightOfLoadingWnd);
            this.m_status.setAlignment(1);
            this.m_Frame.add(this.m_status);
            this.m_Frame.setResizable(false);
            this.m_status.setForeground(Color.blue);
            this.setLoadingMsg("");
            ((Component)this.m_Frame).setVisible(true);
        }
    }

    protected void setLoadingMsg(String strMsg) {
        if (this.m_status != null) {
            this.m_status.setText(strMsg);
        }
    }

    protected void destroyLoadingMsg() {
        if (this.m_Frame != null) {
            ((Component)this.m_Frame).setVisible(false);
            this.m_Frame.dispose();
            this.m_Frame = null;
            this.m_status = null;
        }
    }

    public static void center(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = w.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)w).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void SetMapInformations(String strURL) {
        System.out.println("SetMapInformations " + strURL);
        Object oObject = null;
        InputStream oStream = null;
        String retval = "";
        if (strURL != null) {
            try {
                URL url = null;
                URL urlbase = this.getDocumentBase();
                try {
                    url = new URL(urlbase.getProtocol(), urlbase.getHost(), urlbase.getPort(), strURL);
                }
                catch (Exception e) {
                    System.err.println("Error in SetMapInformations : url could not be created : " + url.toString());
                    System.exit(1);
                }
                oStream = url.openStream();
            }
            catch (Exception e) {
                System.err.println("Error in SetMapInformations");
                System.exit(1);
            }
        }
        if (oStream != null) {
            try {
                int nbytes = 0;
                int nSizeofBuffer = this.m_gBufferSizeForStream;
                byte[] buf = new byte[nSizeofBuffer];
                while ((nbytes = oStream.read(buf, 0, nSizeofBuffer)) != -1) {
                    retval = retval + new String(buf);
                }
                oStream.close();
            }
            catch (Exception e) {
                System.err.println("Error in SetMapInformations read");
                System.exit(1);
            }
            if (Rosa2000.isDebugMode()) {
                System.out.println("SetMapInformations : stream value " + retval);
            }
            StringTokenizer st = new StringTokenizer(retval, "\n");
            boolean i = false;
            boolean bFormParm = false;
            boolean bJavaScript = false;
            while (st.hasMoreTokens()) {
                StringTokenizer stTmp;
                String sToken = st.nextToken();
                if (Rosa2000.isDebugMode()) {
                    System.out.println("Token = " + sToken);
                }
                if (sToken.equalsIgnoreCase(new String("FORMPARAMS"))) {
                    bFormParm = true;
                    continue;
                }
                if (sToken.equalsIgnoreCase(new String("JAVASCRIPT"))) {
                    bJavaScript = true;
                    continue;
                }
                if (sToken.equalsIgnoreCase(new String("END"))) {
                    bFormParm = false;
                    bJavaScript = false;
                    continue;
                }
                if (sToken.regionMatches(true, 0, new String("MAPURL"), 0, 6) && (stTmp = new StringTokenizer(sToken, "=")).countTokens() == 2) {
                    stTmp.nextToken();
                    String strNewURL = stTmp.nextToken();
                    this.loadMap(strNewURL);
                    continue;
                }
                if (bFormParm) {
                    String strParam = null;
                    String strValue = null;
                    StringTokenizer stForm = new StringTokenizer(sToken, "=");
                    if (stForm.countTokens() == 2) {
                        strParam = stForm.nextToken();
                        strValue = stForm.nextToken();
                        this.setFormParameter(strParam, strValue);
                    }
                }
                if (!bJavaScript) continue;
                JSObject.getWindow((Applet)this).eval(sToken);
            }
        }
    }

    protected void setFormParameter(String sParamName, String sValue) {
        if (Rosa2000.isDebugMode()) {
            System.out.println("Setform param :" + sParamName + "=" + sValue);
        }
        if (sParamName != null && sValue != null) {
            try {
                JSObject form;
                String strFormName;
                JSObject window = JSObject.getWindow((Applet)this);
                JSObject doc = (JSObject)window.getMember("document");
                if (doc != null && (strFormName = this.getParameter("INP_FORM_NAME")) != null && (form = (JSObject)doc.getMember(strFormName)) != null) {
                    JSObject jsParam = (JSObject)form.getMember(sParamName);
                    if (jsParam != null) {
                        jsParam.setMember("value", sValue);
                    } else {
                        System.out.println("param not found");
                    }
                }
            }
            catch (ClassCastException ex) {
                System.err.println("A parameter is not found");
            }
        }
    }

    public void setButtonPress(String strButton) {
        ButtonCtrl oButton = this.getButton(strButton);
        if (oButton != null && this.m_toolbar != null) {
            this.m_toolbar.setButtonPress(oButton);
            this.m_map.startAction(oButton, true);
        }
    }

    public ButtonCtrl getButton(String strButton) {
        if (this.m_toolbar != null) {
            return this.m_toolbar.getButton(strButton);
        }
        return null;
    }

    public void SetImageURL(String sURL) {
        System.out.println("SetImageURL " + sURL);
        if (sURL != null) {
            this.loadMap(sURL);
        }
    }

    public void SetPixelSize(double dfPixelSize) {
        this.mdfPixelSize = dfPixelSize;
    }

    public double GetPixelSize() {
        return this.mdfPixelSize;
    }
}

