/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ToolTipButton
extends Container
implements MouseListener {
    protected ButtonCtrl m_parent = null;
    protected Rosa2000 m_applet = null;
    private Point m_Position = new Point(0, 0);
    protected Image m_offScreenImage = null;
    protected Graphics m_offScreenGraphics = null;
    private Dimension m_dimension = new Dimension(-1, -1);
    private Vector m_aStrings = new Vector();
    public DelayThread delayThread = new DelayThread();
    Font hintFont;

    public ToolTipButton(Rosa2000 applet, ButtonCtrl parent) {
        this.m_parent = parent;
        this.m_applet = applet;
        this.hintFont = new Font("Courier", 0, 12);
        this.delayThread.start();
    }

    public String getToolTip(MouseEvent e) {
        return this.m_parent.getHint();
    }

    public synchronized void mouseEntered(MouseEvent e) {
        if (this.m_parent.getHint() != null) {
            this.determineSize();
            this.m_Position = this.m_parent.getHintPosition();
            this.delayThread.arm();
        }
    }

    public synchronized void mouseExited(MouseEvent e) {
        if (this.m_parent.getHint() != null) {
            this.delayThread.disarm();
            this.hideToolTip();
        }
    }

    public synchronized void mousePressed(MouseEvent evt) {
        if (this.m_parent.getHint() != null) {
            this.delayThread.disarm();
            this.hideToolTip();
        }
    }

    public void paint(Graphics g) {
        if (this.m_parent.getHint() != null) {
            Dimension oSize = this.getSize();
            if (this.m_offScreenImage == null) {
                this.m_offScreenImage = this.m_applet.createImage(oSize.width, oSize.height);
                this.m_offScreenGraphics = this.m_offScreenImage.getGraphics();
            }
            this.m_offScreenGraphics.setColor(new Color(255, 255, 204));
            this.m_offScreenGraphics.fillRect(0, 0, oSize.width, oSize.height);
            this.m_offScreenGraphics.setColor(new Color(0, 0, 0));
            this.m_offScreenGraphics.drawRect(0, 0, oSize.width - 1, oSize.height - 1);
            this.m_offScreenGraphics.setColor(new Color(0, 0, 0));
            this.m_offScreenGraphics.setFont(this.hintFont);
            Enumeration enumeration = this.m_aStrings.elements();
            double i = 1.0;
            double dfTotal = this.m_aStrings.size();
            while (enumeration.hasMoreElements()) {
                int nHeight = (int)((double)oSize.height * (i / dfTotal) - 4.0);
                this.m_offScreenGraphics.drawString((String)enumeration.nextElement(), 2, nHeight);
                i += 1.0;
            }
            g.drawImage(this.m_offScreenImage, this.m_Position.x, this.m_Position.y, this);
        }
    }

    private void determineSize() {
        Object result = null;
        int nWidth = 0;
        int nHeight = 0;
        String sHint = null;
        int nMaxWidth = -1;
        if (this.m_dimension.width < 0 || this.m_dimension.height < 0) {
            sHint = this.m_parent.getHint();
            if (sHint != null) {
                StringTokenizer st = new StringTokenizer(sHint, "|");
                while (st.hasMoreTokens()) {
                    String sTmp = st.nextToken();
                    this.m_aStrings.addElement(new String(sTmp));
                }
                Enumeration enumeration = this.m_aStrings.elements();
                while (enumeration.hasMoreElements()) {
                    String sTmp = (String)enumeration.nextElement();
                    nWidth = this.m_applet.getGraphics().getFontMetrics(this.hintFont).stringWidth(sTmp);
                    if (nWidth <= nMaxWidth) continue;
                    nMaxWidth = nWidth;
                }
                nMaxWidth += 4;
                nHeight = this.m_applet.getGraphics().getFontMetrics(this.hintFont).getHeight() * this.m_aStrings.size();
            }
            this.m_dimension.width = nMaxWidth;
            this.m_dimension.height = nHeight;
            this.setSize(this.m_dimension);
        }
    }

    public Dimension getSize() {
        if (this.m_dimension.width <= 0 || this.m_dimension.height <= 0) {
            this.determineSize();
        }
        return this.m_dimension;
    }

    private void showToolTip() {
        this.paint(this.m_applet.getGraphics());
    }

    private void hideToolTip() {
        this.m_applet.repaint(this.m_Position.x, this.m_Position.y, this.getSize().width, this.getSize().height);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void cleanUp() {
        if (this.delayThread != null) {
            this.delayThread.bStopRuning = true;
        }
    }

    class DelayThread
    extends Thread {
        boolean armed = false;
        boolean reset = false;
        public boolean bStopRuning = false;

        DelayThread() {
        }

        public void run() {
            while (!this.bStopRuning) {
                if (this.armed) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.armed && !this.reset) {
                        this.armed = false;
                        this.fire();
                    }
                    this.reset = false;
                    continue;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        protected void arm() {
            this.armed = true;
            this.reset = true;
            this.interrupt();
        }

        protected void disarm() {
            this.armed = false;
            this.interrupt();
        }

        protected void reset() {
            this.reset = true;
            this.interrupt();
        }

        protected void fire() {
            ToolTipButton.this.showToolTip();
        }
    }
}

