/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;

public class ToolbarPanel
extends Panel {
    public final String kstrTop = "top";
    public final String kstrBottom = "bottom";
    public final String kstrLeft = "left";
    public final String kstrRight = "right";
    protected final String kstrDefImageParam = "_IMG";
    protected final String kstrImagePressParam = "_IMG_PR";
    private final String kstrTopAling = "top";
    private final String kstrBottomAling = "bottom";
    private final String kstrMiddleAling = "middle";
    private final String kstrCenterAling = "center";
    private final String kstrLeftAling = "left";
    private final String kstrRightAling = "right";
    private int m_nNbrButton = 0;
    private boolean m_bIsVertical = false;
    private String m_strAlign = null;
    private String m_strLocation = null;
    private Map m_buttonListener = null;
    private Rosa2000 m_parent = null;
    private Point m_ptLocation;

    ToolbarPanel(Rosa2000 parent, Map listener, String strLocation, String strAlignment) {
        this.setVisible(false);
        this.m_buttonListener = listener;
        this.m_parent = parent;
        this.m_ptLocation = new Point(0, 0);
        this.setLocation(strLocation);
        this.setAlignment(strAlignment);
        this.setLayout(null);
        if (Rosa2000.isDebugMode()) {
            System.out.println("ToolbarPanel Constructor param Location =  " + strLocation + "Alignment = " + strAlignment);
        }
    }

    public void setLocation(String strLocation) {
        boolean bError = false;
        this.m_strLocation = strLocation;
        if (strLocation != null) {
            if (strLocation.equals("top") || strLocation.equals("bottom")) {
                this.m_bIsVertical = false;
            } else if (strLocation.equals("left") || strLocation.equals("right")) {
                this.m_bIsVertical = true;
            } else {
                bError = true;
            }
        } else {
            bError = true;
        }
        if (bError) {
            System.err.println("Invalid toolbar Location: " + strLocation);
            this.m_strLocation = "top";
        }
    }

    public String getAligment() {
        return this.m_strAlign;
    }

    public String getTbLocation() {
        return this.m_strLocation;
    }

    public void setButtonPress(ButtonCtrl button) {
        int i = 0;
        while (i < this.getComponentCount()) {
            ButtonCtrl buttonItem;
            buttonItem.setPressed((buttonItem = (ButtonCtrl)this.getComponent(i)) == button);
            ++i;
        }
    }

    public void cleanUp() {
        int i = 0;
        while (i < this.getComponentCount()) {
            ButtonCtrl buttonItem = (ButtonCtrl)this.getComponent(i);
            if (buttonItem != null) {
                buttonItem.cleanUp();
            }
            ++i;
        }
    }

    public void setAlignment(String strAlignment) {
        boolean bError = false;
        this.m_strAlign = strAlignment;
        if (this.m_bIsVertical) {
            if (!(strAlignment != null && (strAlignment.equals("top") || strAlignment.equals("bottom") || strAlignment.equals("middle")))) {
                bError = true;
                this.m_strAlign = "top";
            }
        } else if (!(strAlignment != null && (strAlignment.equals("right") || strAlignment.equals("center") || strAlignment.equals("left")))) {
            bError = true;
            this.m_strAlign = "left";
        }
        if (bError) {
            System.err.println("Invalid toolbar alignment " + strAlignment + ". The default value " + this.m_strAlign + " will be assing. ");
        }
    }

    public boolean createButton(String strButtonName) {
        if (Rosa2000.isDebugMode()) {
            System.out.println("ToolbarPanel::createButton( " + strButtonName + " ) ");
        }
        if (!strButtonName.startsWith("space_")) {
            String strImageParam = ButtonCtrl.getPrefixButtonParam() + strButtonName;
            String strImageDef = strImageParam + "_IMG";
            String strImagePress = strImageParam + "_IMG_PR";
            Image buttonDefImage = this.readButtonImage(strImageDef);
            Image buttonPressImage = this.readButtonImage(strImagePress);
            if (buttonDefImage != null) {
                if (buttonPressImage == null) {
                    RectButton button = new RectButton(strButtonName, buttonDefImage, false, this.m_parent);
                    this.addButton(button);
                } else {
                    RoundButton button = new RoundButton(strButtonName, buttonDefImage, buttonPressImage, false, this.m_parent);
                    this.addButton(button);
                }
                return true;
            }
            return false;
        }
        SpacingButton button = new SpacingButton(strButtonName, this.m_bIsVertical);
        this.addButton(button);
        return true;
    }

    private Image readButtonImage(String strNameParam) {
        String strDefaultValue;
        if (Rosa2000.isDebugMode()) {
            System.out.println("ToolbarPanel::readButtonImage( String strNameParam )");
        }
        if ((strDefaultValue = this.m_parent.getParameter(strNameParam)) != null) {
            MediaTracker tracker = new MediaTracker(this);
            Image buttonImage = this.m_parent.getImage(this.m_parent.getDocumentBase(), strDefaultValue);
            tracker.addImage(buttonImage, 0);
            try {
                tracker.waitForID(0);
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                return null;
            }
            if (buttonImage == null) {
                System.err.println("ToolbarPanel::readButtonImage error reading image");
            }
            return buttonImage;
        }
        return null;
    }

    public void addButton(ButtonCtrl button) {
        if (Rosa2000.isDebugMode()) {
            System.out.println("ButtonCtrl button");
        }
        if (button.isAutoPlacement()) {
            this.autoPlace(this.m_nNbrButton, button);
            ++this.m_nNbrButton;
            this.add(button);
            Dimension tbSize = this.getCurrentSize();
            this.setSize(tbSize.width, tbSize.height);
        } else {
            this.m_parent.add(button);
        }
        button.addActionListener(this.m_buttonListener);
    }

    public Dimension getCurrentSize() {
        if (this.m_bIsVertical) {
            int nXMax = 0;
            int nYSize = 0;
            Component[] aComponent = this.getComponents();
            int i = 0;
            while (i < this.getComponentCount()) {
                Dimension dim = aComponent[i].getPreferredSize();
                if (dim.width > nXMax) {
                    nXMax = dim.width;
                }
                nYSize += dim.height;
                ++i;
            }
            return new Dimension(nXMax, nYSize);
        }
        int nYMax = 0;
        int nXSize = 0;
        Component[] aComponent = this.getComponents();
        int i = 0;
        while (i < this.getComponentCount()) {
            Dimension dim = aComponent[i].getPreferredSize();
            if (dim.height > nYMax) {
                nYMax = dim.width;
            }
            nXSize += dim.width;
            ++i;
        }
        return new Dimension(nXSize, nYMax);
    }

    protected ButtonCtrl getButton(String strButtonName) {
        int i = 0;
        while (i < this.getComponentCount()) {
            ButtonCtrl currentButton;
            if (this.getComponent(i).getClass().getSuperclass().getName().equals("ButtonCtrl") && (currentButton = (ButtonCtrl)this.getComponent(i)).getButtonName() != null && currentButton.getButtonName().equals(strButtonName)) {
                return currentButton;
            }
            ++i;
        }
        return null;
    }

    public ButtonCtrl getCurrentButton() {
        int i = 0;
        while (i < this.getComponentCount()) {
            ButtonCtrl buttonItem = (ButtonCtrl)this.getComponent(i);
            if (buttonItem.isPressed()) {
                return buttonItem;
            }
            ++i;
        }
        return null;
    }

    protected void autoPlace(int nIndex, ButtonCtrl button) {
        if (Rosa2000.isDebugMode()) {
            System.out.println("autoPlace( " + nIndex + " )");
        }
        if (button.isAutoPlacement()) {
            ButtonCtrl prevButton = null;
            if (nIndex > 0 && nIndex <= this.getComponentCount()) {
                prevButton = (ButtonCtrl)this.getComponent(nIndex - 1);
            }
            Point ptCurLoc = new Point(0, 0);
            if (prevButton != null) {
                if (this.m_bIsVertical) {
                    ptCurLoc = prevButton.getLocation();
                    ptCurLoc.y += prevButton.getPreferredSize().height;
                } else {
                    ptCurLoc = prevButton.getLocation();
                    ptCurLoc.x += prevButton.getPreferredSize().width;
                }
            }
            if (Rosa2000.isDebugMode()) {
                System.out.println("Button location at: " + ptCurLoc.x + ", " + ptCurLoc.y);
            }
            button.setLocation(ptCurLoc);
        }
    }

    public void moveTB(int nX, int nY) {
        this.m_ptLocation = new Point(nX, nY);
        this.setLocation(this.m_ptLocation);
    }

    public void automaticPlace() {
        if (this.m_bIsVertical) {
            this.placeTbVertical();
        } else {
            this.placeTbHorizontal();
        }
    }

    protected void placeTbVertical() {
        if (Rosa2000.isDebugMode()) {
            System.out.println("ToolbarPanel::placeTbVertical()");
        }
        Dimension mapDim = this.m_buttonListener.getSize();
        Point mapLocation = this.m_buttonListener.getLocation();
        Dimension tbDim = this.getSize();
        int nYPosition = mapLocation.y;
        if (this.m_strAlign.equals("middle")) {
            nYPosition += (mapDim.height - tbDim.height) / 2;
        } else if (this.m_strAlign.equals("bottom")) {
            nYPosition += mapDim.height - tbDim.height;
        }
        int nXPosition = 0;
        nXPosition = this.m_strLocation.equals("left") ? mapLocation.x - tbDim.width : mapLocation.x + mapDim.width;
        if (nXPosition < 0) {
            nXPosition = 0;
        } else if (nXPosition + tbDim.width > mapDim.width) {
            nXPosition = mapDim.width - tbDim.width;
        }
        this.setLocation(nXPosition, nYPosition);
    }

    protected void placeTbHorizontal() {
        if (Rosa2000.isDebugMode()) {
            System.out.println("ToolbarPanel::placeTbHorizontal()");
        }
        Dimension mapDim = this.m_buttonListener.getSize();
        Point mapLocation = this.m_buttonListener.getLocation();
        Dimension tbDim = this.getSize();
        int nXPosition = mapLocation.x;
        if (this.m_strAlign.equals("center")) {
            nXPosition += (mapDim.width - tbDim.width) / 2;
        } else if (this.m_strAlign.equals("right")) {
            nXPosition += mapDim.width - tbDim.width;
        }
        int nYPosition = 0;
        nYPosition = this.m_strLocation.equals("top") ? mapLocation.y - tbDim.height : mapLocation.y + mapDim.height;
        if (nYPosition < 0) {
            nYPosition = 0;
        } else if (nYPosition + tbDim.height > mapDim.height) {
            nYPosition = mapDim.height - tbDim.height;
        }
        this.setLocation(nXPosition, nYPosition);
    }

    public boolean IsVertical() {
        return this.m_bIsVertical;
    }

    public boolean IsTop() {
        return this.m_strLocation.equals("top");
    }

    public boolean IsLeft() {
        return this.m_strLocation.equals("left");
    }

    public void printAll(Graphics g) {
        super.printAll(g);
    }
}

