<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	$time_start = getmicrotime();

	# Program: admin_display.php
	# Version: 09 July 2004
	# Author: Calvin Martini
	# Description: This script provides editing of new and existing user and type records.

	session_start(); 

	# Set client variables
	$client_vars=array(
		'report',
		'filter',
		'province',
		'action'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");
	require("lib_js.php");
	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_members");

	# Check to ensure proper access level to edit record
	if ($a_admin != 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	$teams=get_teams();
	$provinces=get_provinces();

	# If user changed display or filter modes, set the session variables
	if ($report){$sa_report=$report;$_SESSION['sa_report']=$report;}
	if ($sa_report != "users"){$filter="All"; $province="All";}
	if (ISSET($filter) && $filter!=$sa_filter){$sa_filter=$filter;}
	if (ISSET($province) && $province!=$sa_province){$sa_province=$province;}

	if ($action == "print"){
		head("print");
		#echo "<HTML><BODY><a class=BodyLink href=$PHP_SELF".SIDPRINT.">".$l['return_previous']."</a><br><br>";
	}else{
		head("admin");
	}

	echo "<SCRIPT LANGUAGE=\"JavaScript\">";
	team_js("",1,0);
	echo "</SCRIPT>";

	# Change display mode (report)
	# First check for access based on type of report, then process the command
	# Note: The team, instruction and stats summary don't require specific access
	if (( preg_match("/^types/i",$sa_report) || $sa_report=="users" ) && $a_admin == 1) {


		#/////////////////////////////////// 
		#/// Setup query
		#///////////////////////////////////

		switch (true) {

			#/////////////////////////////////// 
			#/// Type Reports (Common Format)
			#///////////////////////////////////
			case (
				$sa_report=="types_techniques" 
				|| $sa_report=="types_experience" 
				|| $sa_report=="types_equipment" 
				|| $sa_report=="types_events"
				|| $sa_report=="types_cal_events"
				|| $sa_report=="types_resources"
				|| $sa_report=="types_reason"
				|| $sa_report=="types_condition"
				|| $sa_report=="types_outcome"
				|| $sa_report=="types_environment"
				|| $sa_report=="types_position"
				|| $sa_report=="types_weather"
				|| $sa_report=="types_activity"
				|| $sa_report=="types_environment"
				|| $sa_report=="types_province"
				|| $sa_report=="types_position"
			):

				# Set the edit/detail link
				$link="<a class=BodyLink href=\"admin_edit.php?mode=update&s_id=[recno]".SIDAND."\">[rectext]</a>";

				# Set column headings and data fields
				for ($x = 1; $x <= $maxLang; $x++){
					$col[]=$l['type'.$x]; $col[]=$l['desc'.$x];
					$dat[]="type$x"; $dat[]="desc_type$x";
				}
				# Set DB query
				$query="
					SELECT *
					FROM $sa_report
					".($sa_filter && $sa_filter!="All" ? "WHERE (type$lang LIKE '%$sa_filter%' OR desc_type$lang LIKE '%$sa_filter%')" : "")." 
					ORDER BY id_record
					";
				
				break 1;

			#/////////////////////////////////// 
			#/// Types Variable Fields
			#///////////////////////////////////
			case ($sa_report=="types_vars"):

				# Set the edit/detail link
				$link="<a class=BodyLink href=\"admin_edit.php?mode=update&s_id=[recno]".SIDAND."\">[rectext]</a>";

				# Set column headings and data fields
				$col[]=$l['field_type']; $dat[]="var_type";
				$col[]=$l['enabled']; $dat[]="yesno";
				for ($x = 1; $x <= $maxLang; $x++){
					 $col[]=$l['desc'.$x];
					 $dat[]="field_desc$x";
				}
				# Set DB query
				$query="
					SELECT *,
					IF (enabled, '".$l['yes']."','".$l['no']."') AS yesno,
					CASE id_type WHEN 1 THEN '".$l['var_type1']."' END AS var_type
					FROM $sa_report
					".($sa_filter && $sa_filter!="All" ? "WHERE (type$lang LIKE '%$sa_filter%' OR desc_type$lang LIKE '%$sa_filter%')" : "")." 
					ORDER BY id_record
					";
				
				break 1;

			#/////////////////////////////////// 
			#/// Types Agencies
			#///////////////////////////////////
			case ($sa_report=="types_agencies"):

				# Set the edit/detail link
				$link="<a class=BodyLink href=\"admin_edit.php?mode=update&s_id=[recno]".SIDAND."\">[rectext]</a>";

				# Set column headings and data fields
				for ($x = 1; $x <= $maxLang; $x++){
					$col[]=$l['desc'.$x];
					$dat[]="agency_desc$x";
				}

				$col[]=$l['address']; $col[]=$l['phone_1']; $col[]=$l['phone_fax']; $col[]=$l['email']; $col[]=$l['website'];
				$dat[]="address"; $dat[]="agency_phone"; $dat[]="agency_fax"; $dat[]="agency_email"; $dat[]="agency_website";

				# Set DB query
				$query="
					SELECT *,
					types_agencies.id_record as id_record,
					types_province.id_record as province,
					if(agency_province=9999,'".$l['all']."',CONCAT(agency_address,IF((agency_address!='' AND agency_city!=''),', ',''),agency_city,IF((agency_city!='' AND types_province.type$lang!=''),', ',''),types_province.type$lang,IF((agency_province!='' AND agency_pcode!=''),', ',''),agency_pcode)) AS address
					FROM $sa_report
					LEFT JOIN types_province ON types_province.id_record=types_agencies.agency_province
					".($sa_filter && $sa_filter!="All" ? "WHERE (agency_desc$lang LIKE '%$sa_filter%' OR agency_address LIKE '%$sa_filter%' OR agency_city LIKE '%$sa_filter%' OR types_province.type$lang LIKE '%$sa_filter%' OR agency_pcode LIKE '%$sa_filter%' OR agency_phone LIKE '%$sa_filter%' OR agency_fax LIKE '%$sa_filter%' OR agency_email LIKE '%$sa_filter%' OR agency_website LIKE '%$sa_filter%')" : "")." 
					ORDER BY types_agencies.id_record
					";
				
				break 1;

			#/////////////////////////////////// 
			#/// Types Certifying Agencies
			#///////////////////////////////////
			case ($sa_report=="types_cert_agencies"):

				# Set the edit/detail link
				$link="<a class=BodyLink href=\"admin_edit.php?mode=update&s_id=[recno]\">[rectext]</a>";

				# Set column headings and data fields
				for ($x = 1; $x <= $maxLang; $x++){
					$col[]=$l['desc'.$x];
					$dat[]="agency_desc$x";
				}
				$col[]=$l['address']; $col[]=$l['phone_1']; $col[]=$l['phone_fax']; $col[]=$l['email']; $col[]=$l['website'];
				$dat[]="address"; $dat[]="agency_phone"; $dat[]="agency_fax"; $dat[]="agency_email"; $dat[]="agency_website";

				# Set DB query
				$query="
					SELECT *,
					types_cert_agencies.id_record as id_record,
					types_province.id_record as province,
					if(agency_province=9999,'".$l['all']."',CONCAT(agency_address,IF((agency_address!='' AND agency_city!=''),', ',''),agency_city,IF((agency_city!='' AND types_province.type$lang!=''),', ',''),types_province.type$lang,IF((agency_province!='' AND agency_pcode!=''),', ',''),agency_pcode)) AS address
					FROM types_cert_agencies
					LEFT JOIN types_province ON types_province.id_record=types_cert_agencies.agency_province
					".($sa_filter && $sa_filter!="All" ? "WHERE (agency_desc$lang LIKE '%$sa_filter%' OR agency_address LIKE '%$sa_filter%' OR agency_city LIKE '%$sa_filter%' OR types_province.type$lang LIKE '%$sa_filter%' OR agency_pcode LIKE '%$sa_filter%' OR agency_phone LIKE '%$sa_filter%' OR agency_fax LIKE '%$sa_filter%' OR agency_email LIKE '%$sa_filter%' OR agency_website LIKE '%$sa_filter%')" : "")." 
					ORDER BY types_cert_agencies.id_record
					";
				
				break 1;

			#/////////////////////////////////// 
			#/// Types Places
			#///////////////////////////////////
			case ($sa_report=="types_places"):

				# Set the edit/detail link
				$link="<a class=BodyLink href=\"admin_edit.php?mode=update&s_id=[recno]".SIDAND."\">[rectext]</a>";

				# Set column headings and data fields
				for ($x = 1; $x <= $maxLang; $x++){
					$col[]=$l['type'.$x];
					$dat[]="type$x";
				}
				$col[]=$l['lat']; $col[]=$l['long'];
				$dat[]="lat_coords"; $dat[]="long_coords";

				# Set DB query
				$query="
					SELECT *
					FROM $sa_report
					".($sa_filter && $sa_filter!="All" ? "WHERE (type LIKE '%$sa_filter%' OR lat_coords LIKE '%$sa_filter%' OR long_coords LIKE '%$sa_filter%')" : "")." 
					ORDER BY id_record
					";
				
				break 1;

			#/////////////////////////////////// 
			#/// Users
			#///////////////////////////////////
			case ($sa_report=="users"):

				# Set the edit/detail link
				$link="<a class=BodyLink href=\"admin_edit.php?mode=update&s_id=[recno]".SIDAND."\">[rectext]</a>";

				# Set column headings and data fields
				$col[]=$l['user_id']; $col[]=$l['full_name']; $col[]=$l['phone_1']; $col[]=$l['email']; $col[]=$l['expires']; $col[]=$l['dir-alt']; $col[]=$l['admin2'];
				$dat[]="user_id"; $dat[]="full_name"; $dat[]="phone"; $dat[]="email"; $dat[]="when_expires"; $dat[]="a_diralt"; $dat[]="a_admin";

				# Set DB query
				$query_BAK="
					SELECT *,
					IF(flag_all_teams,'Y','N') AS a_all_teams,
					IF(flag_admin,'Y','N') AS a_admin,
					IF(flag_diralt,'Y','N') AS a_diralt,
					IF(access_searches=0,'None',IF(access_searches=1,'Read',IF(access_searches=2,'Write',IF(access_searches=4,'Delete',IF(access_searches=128,'Admin',''))))) AS a_search,
					IF(access_members=0,'None',IF(access_members=1,'Read',IF(access_members=2,'Write',IF(access_members=4,'Delete',IF(access_members=128,'Admin',''))))) AS a_memb,
					IF(access_training=0,'None',IF(access_training=1,'Read',IF(access_training=2,'Write',IF(access_training=4,'Delete',IF(access_training=128,'Admin',''))))) AS a_train,
					IF(access_certifications=0,'None',IF(access_certifications=1,'Read',IF(access_certifications=2,'Write',IF(access_certifications=4,'Delete',IF(access_certifications=128,'Admin',''))))) AS a_cert
					FROM $sa_report
					".($sa_filter && $sa_filter!="All" ? "WHERE (user_id LIKE '%$sa_filter%' OR full_name LIKE '%$sa_filter%' OR phone LIKE '%$sa_filter%' OR email LIKE '%$sa_filter%' OR when_expires LIKE '%$sa_filter%')" : "WHERE 1=1")." 
					".($sa_province  && $sa_province!="All" ? " AND (auth_province='%$sa_province%')" : "")." 
					ORDER BY id_record
					";
				$query="
					SELECT users.*,
					IF(flag_admin,'Y','N') AS a_admin,
					IF(flag_diralt,'Y','N') AS a_diralt
					FROM $sa_report
					LEFT JOIN team_access ON team_access.id_users=users.id_record 
					".($sa_filter && $sa_filter!="All" ? "WHERE team_access.id_teams='$sa_filter' OR team_access.id_teams=9999 OR users.flag_admin=1" : "WHERE 1=1")." 
					".($sa_province  && $sa_province!="All" ? " AND (auth_province='$sa_province')" : "")." 
					GROUP BY users.id_record
					ORDER BY users.full_name
					";
				
				break 1;

			#/////////////////////////////////// 
			#/// Default (No Match)
			#///////////////////////////////////
			default:
				echo $l['no_results'];
				foot();
				exit;
				
		}

		#/////////////////////////////////// 
		#/// Perform the query
		#///////////////////////////////////
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		$row_count = mysql_num_rows($result); 

		# Display the results/report

		# Set the table data full span width for colspan parameter
		$fullspan=(count($col)+count($sub_col));
		
		if (mysql_num_rows($result)) {
			echo "<p class=BodyH2>$l[$sa_report]</p>";
			if($sa_report=="users"){
				echo "<p class=BodyTxt>".($sa_province && $sa_province!="All" ? $provinces[$sa_province] : $l['all']).", ".($sa_filter && $sa_filter!="All" ? $teams[$sa_filter] : $l['all'])."</p>";
			}
			
			echo "<table class=BodyRepTbl cellpadding=2 cellspacing=0>";

			# Display column headings
			echo "<tr>";
			foreach ($col as $column){
				echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
			}	
			if ($query2){
				foreach ($sub_col as $column){
					echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
				}
			}
			echo "</tr>";

			# Display the table data
			while ($r = mysql_fetch_array($result)) {
				# Set the email link
				if (isset($r['email']) && $r['email'] != ""){ 
					if(isset($mailto) && $mailto!="") {
						$mailto.=",".$r['email'];
					}else{
						$mailto.=$r['email'];
					}
				}elseif (isset($r['agency_email']) && $r['agency_email'] != ""){
					if(isset($mailto) && $mailto!="") {
						$mailto.=",".$r['agency_email'];
					}else{
						$mailto.=$r['agency_email'];
					}
				}
				$flag=0;				
				echo "<tr>";
				foreach ($dat as $data){
					if (! $flag){					
						$flag=1;
						echo "<td class=BodyRepTd><p class=BodyRepTxt>".ereg_replace("\[rectext\]",$r[$data],ereg_replace("\[recno\]",$r['id_record'],$link))."</p></td>";
					}else{
						echo "<td class=BodyRepTd><p class=BodyRepTxt>$r[$data]&nbsp;</p></td>";
					}
				}
				echo "</tr>";
			}
			if ($mailto!=""){ echo "<tr><td class=BodyRepTd colspan=$fullspan><a class=BodyLink href=\"mailto:$mailto\">".$l['email_all']."</a></td></tr>"; }
			$time_end = getmicrotime();
			$time = $time_end - $time_start;
			echo "</table>
					<br><p class=BodyFootTxt>".$l['total_execution_time'].": ".round($time,3)." ".$l['seconds']."&nbsp;&nbsp;&nbsp;&nbsp;".$l['records_displayed'].": $row_count&nbsp;&nbsp;&nbsp;&nbsp;".date("D M j G:i:s T Y")."</p>";
		}else{
			# Nothing matched the query
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
		}

		#/////////////////////////////////// 
		#/// Finish Page
		#///////////////////////////////////
		if ($action == "print"){
			echo "</BODY></HTML>";
		}else{
			foot();
		}

		
		#DEBUG
		if (preg_match("/$debug_addr/",$_SERVER["REMOTE_ADDR"])){
			echo "<html><body><br><hr>
					<br><h2>Debug Information</h2><br>
					<b><big>Total Execution Time:</big></b><br>$time seconds<br><br>
					<b><big>Versions:</big></b><br>Php: ".phpversion()."<br>MySQL: ".mysql_get_server_info()."<br><br>
					<b><big>Query Status:</big></b><br>".mysql_errno().": ".mysql_error()."<br><br>
					<b><big>Query:</big></b><br>$query<br><br>
					<b><big>User:</big></b><br> $id_recno,$id_user.<br><br>
					<b><big>Variables:</big></b><br> lang=$lang,a_search=$a_search,a_memb=$a_memb,a_train=$a_train,a_cert=$a_cert,a_exp=$a_exp,a_diralt=$a_diralt,a_admin=$a_admin<br>
					report=$report,sa_report=$sa_report,sa_filter=$sa_filter,sa_province=$sa_province<br><br>
					<br>
					</body></html>";

		}
	}else{
			bad_access($_SERVER['QUERY_STRING']);
	}

function getmicrotime(){ 
    list($usec, $sec) = explode(" ",microtime()); 
    return ((float)$usec + (float)$sec); 
    } 

?>
