<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: admin_edit.php
	# Version: 14 September 2004
	# Author: Calvin Martini
	# Description: This script provides editing of new and existing type and user records.

	session_start();

	# Set client variables
	$client_vars=array(
		'report',
		'e_all_teams',
		'mode',
		's_id'
	);
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL;
	}

	require("globals.php");
	require("lib_js.php");
	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_members");

	# Check to ensure proper access level to edit record
	if ($a_admin != 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	head("admin_edit");

	echo "<SCRIPT LANGUAGE=\"JavaScript\">";
	team_js("",1,0);
	echo "</SCRIPT>";

	# Get the number of teams
	$query = "SELECT COUNT(*) AS count_teams FROM teams";
	$result = mysql_query($query)  or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$num_rows = mysql_num_rows($result);
	if ($num_rows) {
		$r = mysql_fetch_array($result);
		$count_teams = $r['count_teams'];
	}

	# Intitialize form input values
	if ($mode == "update") {
		$query = "
			SELECT *
			FROM $sa_report
			WHERE id_record='$s_id'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);
		}else{
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
			foot();
			exit;
		}

	}

	switch (true) {

		case ($sa_report=="types_techniques"
			|| $sa_report=="types_experience"
			|| $sa_report=="types_equipment"
			|| $sa_report=="types_events"
			|| $sa_report=="types_cal_events"
			|| $sa_report=="types_resources"
			|| $sa_report=="types_reason"
			|| $sa_report=="types_condition"
			|| $sa_report=="types_outcome"
			|| $sa_report=="types_environment"
			|| $sa_report=="types_position"
			|| $sa_report=="types_weather"
			|| $sa_report=="types_activity"
			|| $sa_report=="types_environment"
			|| $sa_report=="types_categories"
			|| $sa_report=="types_position"):

			top();

			for ($x = 1; $x <= $maxLang; $x++){
				echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['type']." (".$l['lang'.$x].")</p></td>
					<td><input class=BodyInp type=text name=type$x size=50 value=\"".$r['type'.$x]."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['desc']." (".$l['lang'.$x].")</p></td>
					<td class=BodyInputTd><textarea class=BodyInp name=desc_type$x cols=80 rows=8>".$r['desc_type'.$x]."</textarea></td>
					</tr>";
			}
			bottom();

			break 1;

		case ($sa_report=="types_agencies" || $sa_report=="types_cert_agencies"):

			top();
			for ($x = 1; $x <= $maxLang; $x++){
				echo "<tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['desc']." (".$l['lang'.$x].")</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_desc$x size=30 maxlength=75 value=\"".$r['agency_desc'.$x]."\"></td>
					</tr>";
			}
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['address']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_address size=30 maxlength=50 value=\"".$r['agency_address']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['city']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_city size=30 maxlength=50 value=\"".$r['agency_city']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
					<td class=BodyInputTd>";
					connect_db();
					$query2 = "SELECT * FROM types_province ORDER BY type$lang";
					$result2 = mysql_query($query2) or die ($l['query_failed'].":$query2");
					if (mysql_num_rows($result2)) {
						echo "<select class=BodyInp name=agency_province size=1>
								<option value=\"\">
								<option value=\"9999\"".($r['agency_province']==9999 ? " selected" : "").">".$l['all'];
						while ($r2 = mysql_fetch_array($result2)) {
								echo "<option value=".$r2['id_record'].($r['agency_province']==$r2['id_record'] ? " selected" : "").">".$r2['type'.$lang];
						}
						echo "</select>";
					}else{
						# Nothing matched the query
						echo "<p class=BodyTxt>".$l['no_results']."</p>";
					}
			echo "</td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['postal_code']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_pcode size=7 maxlength=7 value=\"".$r['agency_pcode']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_1']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_phone size=12 maxlength=12 value=\"".$r['agency_phone']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_fax']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_fax size=12 maxlength=12 value=\"".$r['agency_fax']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['email']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_email size=30 maxlength=100 value=\"".$r['agency_email']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['website']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=agency_website size=30 maxlength=100 value=\"".$r['agency_website']."\"></td>
					</tr>
					";
			bottom();

			break 1;

		case ($sa_report=="types_province"):

			top();
			for ($x = 1; $x <= $maxLang; $x++){
				echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['type']." (".$l['lang'.$x].")</p></td>
					<td><input class=BodyInp type=text name=type$x size=50 value=\"".$r['type'.$x]."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['desc']." (".$l['lang'.$x].")</p></td>
					<td class=BodyInputTd><textarea class=BodyInp name=desc_type$x cols=80 rows=8>".$r['desc_type'.$x]."</textarea></td>
					</tr>";
			}
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['extent']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=extent size=100 value=\"".$r['extent']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['prefix']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=prefix size=9 value=\"".$r['prefix']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['logo_file']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=logo_file size=75 value=\"".$r['logo_file']."\"></td>
					</tr>";
			for ($x = 1; $x <= $maxLang; $x++){
				echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['association']." (".$l['lang'.$x].")</p></td>
					<td><input class=BodyInp type=text name=assoc$x size=75 value=\"".$r['assoc'.$x]."\"></td>
					</tr>";
			}

			bottom();

			break 1;


		case ($sa_report=="types_places"):

			top();
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['type']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=type size=30 maxlength=50 value=\"".$r['type']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['lat']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=lat_coords size=30 maxlength=50 value=\"".$r['lat_coords']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['long']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=long_coords size=30 maxlength=50 value=\"".$r['long_coords']."\"></td>
					</tr>
					";
			bottom();

			break 1;

		case ($sa_report=="types_vars"):

			top();
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['type']."</p></td>
					<td class=BodyInputTd><p class=BodyInp>".$l['var_type1']."<input class=BodyInp type=hidden name=id_type value=1></td>
					</tr>";
			for ($x = 1; $x <= $maxLang; $x++){
				echo "<tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['desc']." (".$l['lang'.$x].")</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=field_desc$x size=20 maxlength=20 value=\"".$r['field_desc'.$x]."\"></td>
					</tr>";
			}
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['enabled']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=checkbox name=enabled value=1 " . ($r['enabled'] == "1" ? "checked" : "") . "></td>
					</tr>
					";
			bottom();

			break 1;

		case ($sa_report=="users"):
			top();

			echo "<tr>
					<td class=BodyInputTd colspan=2><p class=BodyH3>1. ".$l['general_information']."</p></td>
					</tr><tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['user_id']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=user_id size=20 value=\"".$r['user_id']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['full_name']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=full_name size=30 maxlength=50 value=\"".$r['full_name']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_1']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=phone size=12 value=\"".$r['phone']."\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['email']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=email size=30 maxlength=100 value=\"".$r['email']."\"></td>
					</tr>";
			list($year,$month,$day) = input_date(when_expires,$r['when_expires'],5,20);
			echo	"<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['expires']."</p></td>
					<td class=BodyInputTd><p class=BodyTxt>$year $month $day<small><small>".$l['yyyy_mm_dd']."</small></small></p></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['a_diralt']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=checkbox name=flag_diralt value=1 " . ($r['flag_diralt'] == "1" ? "checked" : "") . "></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['a_admin']."</p></td>
					<td class=BodyInputTd><input class=BodyInp class=BodyInp type=checkbox name=flag_admin value=1 " . ($r['flag_admin'] == "1" ? "checked" : "") . "></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['enter_new_password']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=password name=e_passwd size=20 value=\"\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['reenter_new_password']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=password name=e_repasswd size=20 value=\"\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
					<td class=BodyInputTd>";
					connect_db();
					$query2 = "SELECT * FROM types_province ORDER BY type$lang";
					$result2 = mysql_query($query2) or die ($l['query_failed'].":$query2");
					if (mysql_num_rows($result2)) {
						echo "<select class=BodyInp name=e_province size=1>
								<option value=9999>All";
						while ($r2 = mysql_fetch_array($result2)) {
								echo "<option value=".$r2['id_record'].($r['auth_province']==$r2['id_record'] ? " selected" : "").">".$r2['type'.$lang];
						}
						echo "</select>";
					}else{
						# Nothing matched the query
						echo "<p class=BodyTxt>".$l['no_results']."</p>";
					}
			echo "</td>
					</tr>";

			#### SECTION: Team Access
			echo "<tr>
					<td class=BodyInputTd colspan=2><hr></td>
					</tr>
					<tr>
					<td class=BodyInputTd colspan=2><p class=BodyH3>2. ".$l['team_access']."</p></td>
					</tr>";
			$flag_any_access=0;
			if ($mode == "update") {
				echo "<tr>";
				$query2 = "SELECT team_access.*, teams.team_name FROM team_access LEFT JOIN teams ON teams.id_record=team_access.id_teams WHERE team_access.id_users='$s_id'";
				$result2 = mysql_query($query2)  or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
				if (mysql_num_rows($result2)) {

					# Display table headings
					echo "<td colspan=2>
							<table>
							<tr>
							<td class=BodyInputTd><p class=BodyH3>".$l['select']."</p></td>
							<td class=BodyInputTd><p class=BodyH3>".$l['team']."</p></td>
							<td class=BodyInputTd><p class=BodyH3>A_search</p></td>
							<td class=BodyInputTd><p class=BodyH3>A_memb</p></td>
							<td class=BodyInputTd><p class=BodyH3>A_cert</p></td>
							<td class=BodyInputTd><p class=BodyH3>A_train</p></td>
							<td class=BodyInputTd></td>
							</tr>";

					# Display table data
					$e_all_teams=0;
					$flag_any_access=1;
					$i=0;
					while ($r2 = mysql_fetch_array($result2)) {
						if ($r2['id_teams']=="9999") { $e_all_teams=1;}
						$team_names[]=$r2['team_name'];
						echo "<tr>";
						echo "<td class=BodyInputTd><input type=hidden name=\"e_id_record[$i]\" value=\"".$r2['id_record']."\">
							<input type=hidden name=\"e_id_teams[$i]\" value=\"".$r2['id_teams']."\">
								<input class=BodyChk type=checkbox name=e_box[$i] value=1></td>";
						echo "<td class=BodyInputTd><p class=BodyTxt>".($r2['id_teams']=="9999" ? $l['all_teams'] : $r2['team_name'])."</p></td>
								<td class=BodyInputTd><select class=BodyInp name=\"e_access_searches[$i]\" value=\"".$r2['access_searches']."\">
								<option value=0" . ($r2['access_searches'] == 0 ? " selected" : "")  . ">".$l['none']."
								<option value=1" . ($r2['access_searches'] == 1 ? " selected" : "")  . ">".$l['read']."
								<option value=2" . ($r2['access_searches'] == 2 ? " selected" : "")  . ">".$l['write']."
								<option value=4" . ($r2['access_searches'] == 4 ? " selected" : "")  . ">".$l['delete']."
								<option value=128" . ($r2['access_searches'] == 128 ? " selected" : "")  . ">".$l['admin']."
								</select></td>
								<td class=BodyInputTd><select class=BodyInp name=\"e_access_members[$i]\" value=\"".$r2['access_members']."\">
								<option value=0" . ($r2['access_members'] == 0 ? " selected" : "")  . ">".$l['none']."
								<option value=1" . ($r2['access_members'] == 1 ? " selected" : "")  . ">".$l['read']."
								<option value=2" . ($r2['access_members'] == 2 ? " selected" : "")  . ">".$l['write']."
								<option value=4" . ($r2['access_members'] == 4 ? " selected" : "")  . ">".$l['delete']."
								<option value=128" . ($r2['access_members'] == 128 ? " selected" : "")  . ">".$l['admin']."
								</select></td>
								<td class=BodyInputTd><select class=BodyInp name=\"e_access_certifications[$i]\" value=\"".$r2['access_certifications']."\">
								<option value=0" . ($r2['access_certifications'] == 0 ? " selected" : "")  . ">".$l['none']."
								<option value=1" . ($r2['access_certifications'] == 1 ? " selected" : "")  . ">".$l['read']."
								<option value=2" . ($r2['access_certifications'] == 2 ? " selected" : "")  . ">".$l['write']."
								<option value=4" . ($r2['access_certifications'] == 4 ? " selected" : "")  . ">".$l['delete']."
								<option value=128" . ($r2['access_certifications'] == 128 ? " selected" : "")  . ">".$l['admin']."
								</select></td>
								<td class=BodyInputTd><select class=BodyInp name=\"e_access_training[$i]\" value=\"".$r2['access_training']."\">
								<option value=0" . ($r2['access_training'] == 0 ? " selected" : "")  . ">".$l['none']."
								<option value=1" . ($r2['access_training'] == 1 ? " selected" : "")  . ">".$l['read']."
								<option value=2" . ($r2['access_training'] == 2 ? " selected" : "")  . ">".$l['write']."
								<option value=4" . ($r2['access_training'] == 4 ? " selected" : "")  . ">".$l['delete']."
								<option value=128" . ($r2['access_training'] == 128 ? " selected" : "")  . ">".$l['admin']."
								</select></td>
								</tr>";
						$i++;
					}
					echo "</table>";
					# Delete Column
					echo "<tr><td class=BodyInputTd colspan=2><input class=BodyBut type=submit name=action value=\"".$l['save_updates']."\">&nbsp;<input class=BodyBut type=submit name=action value=\"".$l['delete_selected']."\"></td></tr>";
				}


				echo "</tr>";
			}

			## SECTION : Add New Team Access

			if ($e_all_teams != 1){
				echo "<tr><td class=BodyInputTd colspan=2><br><p class=BodyH3>".$l['add_team']."</p><td></tr>";

				# Element: Team
				echo "<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['team']."</p></td>
						<td class=BodyInputTd>";
						$query2 = "
							SELECT
							teams.id_record,
							teams.team_name
							FROM teams
							LEFT JOIN team_access ON team_access.id_users = 's_id' AND team_access.id_teams != teams.id_record
							ORDER BY teams.team_name
							";
						$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
						if (mysql_num_rows($result2)) {
							echo "<select class=BodyInp name=\"e_team\">";
							if ($flag_any_access==0){echo "<option value=9999>".$l['all_teams'];}
							while ($r2 = mysql_fetch_array($result2)) {
									if ( (is_array($team_names) && ! in_array($r2['team_name'],$team_names)) || ! is_array($team_names)){
										echo "<option value=".$r2['id_record'].">".$r2['team_name'];
									}

							}
							echo "</select>";
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>";

				# Elements: Access Levels
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['access_searches']."</p></td>
						<td class=BodyInputTd><select class=BodyInp name=e_a_searches>
						<option value=0>".$l['none']."
						<option value=1>".$l['read']."
						<option value=2>".$l['write']."
						<option value=4>".$l['delete']."
						<option value=128>".$l['admin']."
						</select></td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['access_members']."</p></td>
						<td class=BodyInputTd><select class=BodyInp name=e_a_members>
						<option value=0>".$l['none']."
						<option value=1>".$l['read']."
						<option value=2>".$l['write']."
						<option value=4>".$l['delete']."
						<option value=128>".$l['admin']."
						</select></td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['access_certifications']."</p></td>
						<td class=BodyInputTd><select class=BodyInp name=e_a_certifications>
						<option value=0>".$l['none']."
						<option value=1>".$l['read']."
						<option value=2>".$l['write']."
						<option value=4>".$l['delete']."
						<option value=128>".$l['admin']."
						</select></td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['access_training']."</p></td>
						<td class=BodyInputTd><select class=BodyInp name=e_a_training>
						<option value=0>".$l['none']."
						<option value=1>".$l['read']."
						<option value=2>".$l['write']."
						<option value=4>".$l['delete']."
						<option value=128>".$l['admin']."
						</select></td>
						</tr>";

				# Add Column
				echo "<tr><td class=BodyInputTd colspan=2><input class=BodyBut type=submit name=action value=".$l['add']."></td></tr>";
			}

			echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>";

			bottom();

			break 1;

		default:
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
			foot();
			exit;
	}

	foot();

	function top(){
			global $mode,$s_id,$l,$sa_report;
			echo "<form method=POST action=admin_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm>".SIDHIDDEN."<input type=hidden name=mode value=\"$mode\">
					".($s_id ? "<input type=hidden name=s_id value=\"$s_id\">" : "")."
					<table class=BodyTbl width=100% border=0>
					<table class=BodyTbl width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
					<tr>
					<td class=BodyTd align=left colspan=2><p class=BodyH2>";

			if ($mode == "update"){echo $l['edit']." $sa_report";}elseif($mode == "new"){echo $l['new']." $sa_report";}

			echo "</p></td></tr>
					<tr>
					<td class=BodyTd colspan=2><hr></td>
					</tr>";
	}

	function bottom(){
		global $mode,$l;
		echo "</table>
				<input class=BodyBut type=submit name=action value=".$l['save'].">&nbsp;
				".($mode=="update" ? "<input class=BodyBut type=submit name=action value=".$l['delete'].">" : "")."
				<input class=BodyBut type=reset value=".$l['reset'].">
				<input class=BodyBut type=submit name=action value=".$l['cancel'].">
				</form>";

	}


?>
