<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: base_searches.php
	# Version: 06 May 2004
	# Author: Calvin Martini
	# Description: Base search summary report display page.

	if (function_exists('head')) {
		# Set client variables
		$client_vars=array(
			'period',
			's_filter'
		); 
		foreach ($client_vars as $formvar){
		    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
		}
	}else{
		# Script is being called directly
		require("globals.php");
	}
	
	connect_db();

	#/////////////////////////////////// 
	#/// Search Summary
	#///////////////////////////////////

	# Set column headings and data fields
	$col[]=$l['date']; $col[]=$l['file_id']; $col[]=$l['team']; $col[]=$l['type_normal']; $col[]=$l['activity']; $col[]=$l['total_hours'];
	$dat[]="when_alerted"; $dat[]="gsar_file_id"; $dat[]="team_name"; $dat[]="event"; $dat[]="activity"; $dat[]="hours_total";

	# Set DB query
	$query="
		SELECT team_search.id_record, 
		DATE_FORMAT(team_search.when_alerted,'%Y-%m-%d') AS when_alerted,
		team_search.description,
		IF(team_search.flag_complete,CONCAT('<font color=green>NBGSARA',team_search.id_search,'-',team_search.gsar_sub_id,'</font>'),CONCAT('<font color=red>NBGSARA',team_search.id_search,'-',team_search.gsar_sub_id,'</font>')) AS gsar_file_id,
		search.police_file_id,
		search.name_ic,
		subjects.subject_name,
		types_events.type$lang AS event,
		types_activity.type$lang AS activity,
		types_environment.type$lang AS environment,
		types_reason.type$lang AS reason,
		team_search.id_teams AS team,
		teams.team_name AS team_name,
		team_search.cost_total ,
		team_search.hours_total
		FROM team_search
		LEFT JOIN search ON team_search.id_search=search.id_record
		LEFT JOIN teams ON team_search.id_teams=teams.id_record
		LEFT JOIN types_events ON search.id_types_events=types_events.id_record
		LEFT JOIN types_activity ON search.id_types_activity=types_activity.id_record
		LEFT JOIN subjects ON search.id_record=subjects.id_search
		LEFT JOIN types_weather ON search.id_weather=types_weather.id_record
		LEFT JOIN types_environment ON search.id_types_environment=types_environment.id_record
		LEFT JOIN types_reason ON search.id_types_reason_1=types_reason.id_record AND search.id_types_reason_2=types_reason.id_record
		WHERE 1=1
		$search_filter
		".($period ? period_filter($period,"team_search.when_alerted") : "" )."
		".($s_filter && $s_filter != "All" && $s_filter != "None" ? " AND team_search.id_teams='$s_filter'" : "")."				
		GROUP BY gsar_file_id
		ORDER BY when_alerted
		";

	#/////////////////////////////////// 
	#/// Perform the query
	#///////////////////////////////////
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$row_count = mysql_num_rows($result); 

	# Display the results/report

	# Set the table data full span width for colspan parameter
	$fullspan=(count($col)+count($sub_col));

	if (mysql_num_rows($result)) {
		echo "<h2 class=normal>Search Summary".($period=="current_year" ? " for ".date("Y"):"")."</h2>
				<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\">";

		if (substr($s_report,0,1)!="c"){
				# Display column headings
				echo "<tr>";
				foreach ($col as $column){
					echo "<td class=\"h1\"><h3 class=\"inverse\">$column</h3></td>";
				}	
				if ($query2){
					foreach ($sub_col as $column){
						echo "<td class=\"h1\"><h3 class=\"inverse\">$column</h3></td>";
					}
				}
				echo "</tr>";
		}

		# Display the table data
		while ($r = mysql_fetch_array($result)) {
			echo "<tr>";
			foreach ($dat as $data){
				echo "<td>$r[$data]&nbsp;</td>";
			}
			echo "</tr>";
		}
		echo "</table>";
	}else{
		# Nothing matched the query
		echo "<h2 class=normal>$l[$s_report]</h2><br>";
		echo $l['no_results'];
	}
?>
