<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: base_summary.php
	# Version: 02 July 2004
	# Author: Calvin Martini
	# Description: Generates an html report containing a statistical summary by period

	$labour_value=35;

	if (function_exists('head')==FALSE) {
		# Script is being called directly
		# Set client variables
		$client_vars=array(
			'period',
			'filter',
			'search_scope',
			'province',
			's_filter',
			's_period',
			's_province',
			'year'
		); 
		foreach ($client_vars as $formvar){
		    if (isset($_REQUEST[$formvar])){
		    	$$formvar = $_REQUEST[$formvar];
		    }elseif(!isset($$formvar)){
		    	$$formvar = NULL;
		    }
		}
		require("globals.php");
	}

# Section 1, General: total searches (inc. breakdown by agency), Cost, searchers responding, manhours

		$query = "SELECT 
						COUNT(*) AS totalsearches,
						SUM(team_search.cost_total) AS totalcost,
						SUM(team_search.hours_total) AS totalhours,
						ROUND(AVG(team_search.members_total),1) AS avgsearchers,
						MIN(team_search.members_total) AS minsearchers,
						MAX(team_search.members_total) AS maxsearchers,
						ROUND(AVG(team_search.hours_total)) AS avghours,
						MIN(team_search.hours_total) AS minhours,
						MAX(team_search.hours_total) AS maxhours,
						ROUND(AVG(team_search.cost_total)) AS avgcost,
						MIN(team_search.cost_total) AS mincost,
						MAX(team_search.cost_total) AS maxcost,
						ROUND(AVG(search.distance_from_pls)) AS avgdistance_from_pls,
						MIN(search.distance_from_pls) AS mindistance_from_pls,
						MAX(search.distance_from_pls) AS maxdistance_from_pls,
						MIN(team_search.when_alerted) AS period_start,
						MAX(team_search.when_alerted) AS period_end,
						AVG((UNIX_TIMESTAMP(search.when_concluded)-UNIX_TIMESTAMP(when_alerted))/60/60/24) AS avgduration,
						MIN((UNIX_TIMESTAMP(search.when_concluded)-UNIX_TIMESTAMP(when_alerted))/60/60/24) AS minduration,
						MAX((UNIX_TIMESTAMP(search.when_concluded)-UNIX_TIMESTAMP(when_alerted))/60/60/24) AS maxduration,
						AVG((UNIX_TIMESTAMP(team_search.when_arrived)-UNIX_TIMESTAMP(when_activated))/60/60/24) AS avgresponse,
						MIN((UNIX_TIMESTAMP(team_search.when_arrived)-UNIX_TIMESTAMP(when_activated))/60/60/24) AS minresponse,
						MAX((UNIX_TIMESTAMP(team_search.when_arrived)-UNIX_TIMESTAMP(when_activated))/60/60/24) AS maxresponse,
						SUM(weather_factor) AS totalweather_factor
						FROM search
						LEFT JOIN team_search ON team_search.id_search=search.id_record
						WHERE 1=1
						".($s_period ? period_filter($s_period,"team_search.when_alerted") : "" )."
						".($s_filter && $s_filter!="All" ? " AND team_search.id_teams='$s_filter'" : "")."
						".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "");

#						".($year ? " WHERE YEAR(when_activated)='$year'" : ""); 

		connect_db();

	if (! $provinces) {
		# Script is being called directly
		$provinces=get_provinces();

	}


		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);
			$r_total_searches=$r['totalsearches'];
			$r_total_cost=$r['totalcost'];
			$r_total_hours=$r['totalhours'];
			$r_avg_searchers=$r['avgsearchers'];
			$r_min_searchers=$r['minsearchers'];
			$r_max_searchers=$r['maxsearchers'];
			$r_avg_hours=$r['avghours'];
			$r_min_hours=$r['minhours'];
			$r_max_hours=$r['maxhours'];
			$r_avg_cost=$r['avgcost'];
			$r_min_cost=$r['mincost'];
			$r_max_cost=$r['maxcost'];
			$r_avg_duration=$r['avgduration'];
			$r_min_duration=$r['minduration'];
			$r_max_duration=$r['maxduration'];
			$r_avg_response=$r['avgresponse'];
			$r_min_response=$r['minresponse'];
			$r_max_response=$r['maxresponse'];
			$r_avg_distance_from_pls=$r['avgdistance_from_pls'];
			$r_min_distance_from_pls=$r['mindistance_from_pls'];
			$r_max_distance_from_pls=$r['maxdistance_from_pls'];
			$r_total_weather_factor=$r['totalweather_factor'];
		}else{
			echo $l['no_results'];
		}

	if ($r_total_searches > 0){
		echo "<table width=100% border=0>
				<table width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=normal align=left colspan=2><h2 class=normal>".$l['statistical_summary']."</h2></td>
				</tr>
				<tr>
				<td class=normal align=left colspan=2><p class=BodyTxt>".($s_province && $s_province!="All" ? $provinces[$s_province] : $l['all']).", ".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>
				<br><p>".$l['for_period']." ".$r['period_start']." ".$l['through']." ".$r['period_end']."</p>
				</td>
				</tr>
				<tr>
				<td colspan=2><hr></td>
				</tr>
				<tr>
				<td colspan=2><h3 class=normal>1. ".$l['general_search_summary']."</h3></td>
				</tr>
				<tr>
				<td width=200><p>".$l['total_searches']."</p></td>
				<td width=200><p>$r_total_searches</p></td>
				</tr>
				<tr>
				<td><p>".$l['total_direct_cost']."</p></td>
				<td><p>".sprintf ("$ %01.2f", $r_total_cost)."</p></td>
				</tr>
				<tr>
				<td><p>".$l['total_hours']."</p></td>
				<td><p>$r_total_hours</p></td>
				</tr>
				<tr>
				<td><p>".$l['labour_value']." (@\$".$labour_value."/h)</p></td>
				<td><p>".sprintf ("$ %01.2f", ($r_total_cost*$labour_value))."</p></td>
				</tr>
				<tr>
				<td colspan=2><hr></td>
				</tr>";

	# Section 2, Breakdown of searches by team		
		echo	"<tr>
				<td colspan=2><h3 class=normal>2. ".$l['breakdown_by_team']."</h3></td>
				</tr>";
		$query = "SELECT teams.team_name AS team_name, 
						COUNT(*) AS total_searches
						FROM team_search, teams 
						WHERE team_search.id_teams=teams.id_record
						".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
						".($s_period ? period_filter($s_period,"when_alerted") : "" )."
						".($s_province && $s_province!="All" ? " AND teams.id_address_province='$s_province'" : "")."
						GROUP BY team_search.id_teams
						ORDER BY total_searches";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			while ($r = mysql_fetch_array($result)) {
				echo "<tr>
						<td width=150><p>".$r['team_name']."</p></td>
						<td><p>".$r['total_searches']."</p></td>
						</tr>";
			}
		}else{
			echo "<tr><td colspan=2><p>".$l['no_results']."</p></td></tr>";
		}

	# Section 3, Breakdown of searches by agency			
		echo	"<tr><td colspan=2><hr></td></tr>
				<tr>
				<td colspan=2><h3 class=normal>3. ".$l['breakdown_by_agency']."</h3></td>
				</tr>";
		$query = "SELECT types_agencies.agency_desc1, 
						types_agencies.agency_desc2,
						types_agencies.agency_desc3,
						types_agencies.agency_desc4,
						types_agencies.agency_desc5,
						COUNT(*) AS total_searches
						FROM search, types_agencies
						LEFT JOIN team_search ON team_search.id_search=search.id_record
						WHERE search.id_agency=types_agencies.id_record
						".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
						".($s_period ? period_filter($s_period,"when_alerted") : "" )."
						".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "")."
						GROUP BY search.id_agency
						ORDER BY total_searches";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			while ($r = mysql_fetch_array($result)) {
				echo "<tr>
						<td width=150><p>".$r['agency_desc'.$lang]."</p></td>
						<td><p>".$r['total_searches']."</p></td>
						</tr>";
			}
		}else{
			echo "<tr><td colspan=2><p>".$l['no_results']."</p></td></tr>";
		}

	# Section 4, Operational data: tactics, resources, weather was a factor, weather, environment
		echo	"<tr>
				<td colspan=2><hr></td>
				</tr>
				<tr>
				<td colspan=2><h3 class=normal>4. ".$l['operational_summary']."</h3></td>
				</tr>";
		echo"	<tr>
				<td><p>".$l['was_weather_factor']."</p></td>
				<td><p>$r_total_weather_factor</p></td>
				</tr>";
		# Search Tactics
		$query = "SELECT types_techniques.type1, 
						types_techniques.type2,
						types_techniques.type3,
						types_techniques.type4,
						types_techniques.type5,
						COUNT(*) AS total_searches
						FROM techniques, types_techniques 
						LEFT JOIN search ON search.id_record=techniques.id_search
						LEFT JOIN team_search ON team_search.id_search=search.id_record
						WHERE techniques.id_types_techniques=types_techniques.id_record
						".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
						".($s_period ? period_filter($s_period,"when_alerted") : "" )."
						".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "")."
						GROUP BY techniques.id_types_techniques
						ORDER BY total_searches";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			echo "<tr><td colspan=2><BR><h3 class=italic>a. ".$l['tactics_used']."</h3></td></tr>";
			while ($r = mysql_fetch_array($result)) {
				echo "<tr>
						<td width=150><p>".$r['type'.$lang]."</p></td>
						<td><p>".$r['total_searches']."</p></td>
						</tr>";
			}
		}else{
			echo "<tr><td colspan=2><p>".$l['no_results']."</p></td></tr>";
		}

	# Section 5, Subject information: age, gender, outcome, behaviour, categories, experience, equipment, medical information, distance

		echo	"<tr>
				<td colspan=2><hr></td>
				</tr>
				<tr>
				<td colspan=2><h3 class=normal>5. ".$l['subject_summary']."</h3></td>
				</tr>
				<tr>";
		# PLS Breakdown
		$query = "SELECT
						COUNT(*) AS total_searches,
						MAX(search.distance_from_pls) AS max_dist,
						MIN(search.distance_from_pls) AS min_dist,
						ROUND(AVG(search.distance_from_pls)) AS avg_dist
						FROM search
						LEFT JOIN team_search ON team_search.id_search=search.id_record
						WHERE search.distance_from_pls!=0
						".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
						".($s_period ? period_filter($s_period,"when_alerted") : "" )."
						".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "");
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$r_count_w_pls=$r['total_searches'];
			echo "<tr><td colspan=2><h3 class=italic>a. ".$l['distance_from_pls']."</h3></td></tr>
					<td><p>".$l['average']."</p></td>
					<td><p>".$r['avg_dist']." ".$l['meters']."</p></td>
					</tr>
					<tr>
					<td><p>".$l['minimum']."</p></td>
					<td><p>".$r['min_dist']." ".$l['meters']."</p></td>
					</tr>
					<tr>
					<td><p>".$l['maximum']."</p></td>
					<td><p>".$r['max_dist']." ".$l['meters']."</p></td>
					</tr>";
		}else{
			echo "<tr><td colspan=2><p>".$l['no_results']."</p></td></tr>";
		}
			
		# Outcome Breakdown
		$query = "SELECT
						types_outcome.type1, types_outcome.type2, types_outcome.type3, types_outcome.type4, types_outcome.type5,
						COUNT(*) AS total_searches
						FROM subjects, types_outcome 
						LEFT JOIN search ON subjects.id_search=search.id_record
						LEFT JOIN team_search ON team_search.id_search=search.id_record
						WHERE subjects.id_types_outcome=types_outcome.id_record
						".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
						".($s_period ? period_filter($s_period,"when_alerted") : "" )."
						".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "")."
						GROUP BY subjects.id_types_outcome
						ORDER BY total_searches";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		echo "<tr><td colspan=2><BR><h3 class=italic>b. ".$l['outcome']."</h3></td></tr>";
		if (mysql_num_rows($result)) {
			while ($r = mysql_fetch_array($result)) {
				echo "<tr>
						<td width=150><p>".$r['type'.$lang]."</p></td>
						<td><p>".$r['total_searches']."</p></td>
						</tr>";
			}
		}else{
			echo "<tr><td colspan=2><p>".$l['no_results']."</p></td></tr>";
		}

		# Equipment Breakdown
		$query = "SELECT
						types_equipment.type1, types_equipment.type2, types_equipment.type3, types_equipment.type4, types_equipment.type5,
						COUNT(*) AS total_searches
						FROM subjects, types_equipment 
						LEFT JOIN search ON subjects.id_search=search.id_record
						LEFT JOIN team_search ON team_search.id_search=search.id_record
						WHERE subjects.id_equipment=types_equipment.id_record
						".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
						".($s_period ? period_filter($s_period,"when_alerted") : "" )."
						".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "")."
						GROUP BY subjects.id_equipment
						ORDER BY total_searches";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		echo "<tr><td colspan=2><BR><h3 class=italic>c. ".$l['equipment']."</h3></td></tr>";
		if (mysql_num_rows($result)) {
			while ($r = mysql_fetch_array($result)) {
				echo "<tr>
						<td width=150><p>".$r['type'.$lang]."</p></td>
						<td><p>".$r['total_searches']."</p></td>
						</tr>";
			}
		}else{
			echo "<tr><td colspan=2><p>".$l['no_results']."</p></td></tr>";
		}

		# Category Breakdown
		echo "<tr><td colspan=2><BR><h3 class=italic>d. ".$l['activity']."</h3></td></tr>";
		echo "<tr><td colspan=2><table>";
		$query = "SELECT
						search.id_types_activity,
						types_activity.type1,
						types_activity.type2,
						types_activity.type3,
						types_activity.type4,
						types_activity.type5
						FROM search
						LEFT JOIN team_search ON team_search.id_search=search.id_record
						LEFT JOIN types_activity ON search.id_types_activity=types_activity.id_record
						WHERE 1=1
						".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
						".($s_period ? period_filter($s_period,"when_alerted") : "" )." 
						".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "")."
						GROUP BY search.id_types_activity";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			echo "<tr>
					<td width=30%><p><strong>".$l['category']."</strong></p></td>
					<td width=10%><p><strong>#</strong></p></td>
					<td width=20%><p><strong>".$l['age']."</strong></p></td>
					<td width=20%><p><strong>".$l['distance']."</strong></p></td>
					<td width=20%><p><strong>".$l['median']."</strong></p></td>
					</tr>";
			while ($r = mysql_fetch_array($result)) {

				$query2 = "SELECT
								COUNT(subjects.id_record) AS total_searches,
								MAX(subjects.subject_age) AS max_age,
								MIN(subjects.subject_age) AS min_age,
								MAX(search.distance_from_pls) AS max_dist,
								MIN(search.distance_from_pls) AS min_dist
								FROM search
								LEFT JOIN subjects ON subjects.id_search=search.id_record  
								LEFT JOIN team_search ON team_search.id_search=search.id_record
								WHERE search.id_types_activity='".$r['id_types_activity']."'
								".($s_filter && $s_filter!="All" ? "AND team_search.id_teams='$s_filter'" : "")."
								".($s_period ? period_filter($s_period,"when_alerted") : "" )." 
								".($s_province && $s_province!="All" ? " AND search.id_province='$s_province'" : "");
				$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
				if (mysql_num_rows($result2)) {
					$r2 = mysql_fetch_array($result2);
					echo "<tr>
							<td width=150><p>".$r['type'.$lang]."</p></td>
							<td><p>".$r2['total_searches']."</p></td>
							<td><p>".$r2['min_age']."-".$r2['max_age']."</p></td>
							<td><p>".$r2['min_dist']."-".$r2['max_dist']." m</p></td>
							<td><p>".round(($r2['max_dist']-$r2['min_dist'])/2+$r2['min_dist'],2)." m</p></td>
							</tr>";
				}
			}
		}else{
			echo "<tr><td colspan=2><p>".$l['no_results']."</p></td></tr>";
		}
		echo "</table></td></tr>";


	# Section 6, Members: total, age, length of service
		echo	"<tr>
				<td colspan=2><hr></td>
				</tr>
				<tr>
				<td colspan=2><h3 class=normal>6. ".$l['membership_summary']."</h3></td>
				</tr>";

		$query = "SELECT
						COUNT(DISTINCT members.id_record) AS total_members,
						SUM(STRCMP(date_of_birth,'0000-00-00')) AS count_age,
						ROUND(AVG((TO_DAYS(CURDATE())-TO_DAYS(date_of_birth))/365),0) AS avg_age,
						ROUND(MIN((TO_DAYS(CURDATE())-TO_DAYS(date_of_birth))/365),0) AS min_age,
						ROUND(MAX((TO_DAYS(CURDATE())-TO_DAYS(date_of_birth))/365),0) AS max_age
						FROM members
						LEFT JOIN teams_members ON teams_members.id_members=members.id_record
						LEFT JOIN teams ON teams_members.id_teams = teams.id_record
						WHERE 1=1
						AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
						".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
						".($s_province && $s_province!="All" ? " AND teams.id_address_province='$s_province'" : "");

	/*					MIN((UNIX_TIMESTAMP()-UNIX_TIMESTAMP(date_of_birth))/60/60/24/365) AS min_age,
						MAX((UNIX_TIMESTAMP()-UNIX_TIMESTAMP(date_of_birth))/60/60/24/365) AS max_age,
						DATE_FORMAT(TRUNCATE(AVG(date_of_birth),0),'%Y-%m-%d') AS avg_age,
						COUNT(((UNIX_TIMESTAMP()-UNIX_TIMESTAMP(date_of_birth))/60/60/24/365)<=50) AS age4,
						COUNT(((UNIX_TIMESTAMP()-UNIX_TIMESTAMP(date_of_birth))/60/60/24/365)<=60) AS age5,
						COUNT(((UNIX_TIMESTAMP()-UNIX_TIMESTAMP(date_of_birth))/60/60/24/365)<=70) AS age6,
						COUNT(((UNIX_TIMESTAMP()-UNIX_TIMESTAMP(date_of_birth))/60/60/24/365)<=80) AS age7
	*/

		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$r=mysql_fetch_array($result);
				echo "<tr>
						<td><p>".$l['total_members']."</p></td>
						<td><p>".$r['total_members']."</p></td>
						</tr>";
				echo "<tr><td colspan=2><BR><h3 class=italic>a. ".$l['age']." (".$r['count_age']." ".$l['reporting'].")</h3></td></tr>";
				echo "<tr>
						<td><p>".$l['average']."</p></td>
						<td><p>".$r['avg_age']."</p></td>
						</tr>";
				echo "<tr>
						<td><p>".$l['maximum']."</p></td>
						<td><p>".$r['max_age']."</p></td>
						</tr>";
				echo "<tr>
						<td><p>".$l['minimum']."</p></td>
						<td><p>".$r['min_age']."</p></td>
						</tr>";
			}else{
				echo $l['no_results'];
			}


		echo		"</table>";
	
	}else{
		echo "<h2 class=normal>".$l['statistical_summary']."</h2><br>";
		echo $l['no_results'];
	}

?>
