#!/usr/local/bin/php -q
<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: build_shp.php
	# Version: 12 September 2004
	# Author: Calvin Martini
	# Description: Build ESRI shapefile from search data.

	# Set client variables
	$client_vars=array(
		'm_filter',
		'm_period',
		'm_prov'
	);
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL;
	}

	require("globals.php");

	# Load mapscript library
	if (PHP_OS == "WINNT" || PHP_OS == "WIN32"){
		dl("php_mapscript.dll");
	}else{
		dl("php_mapscript.so");
	}

	# Open DB
	connect_db();

	$s_province=2; # Set New Brunswick
	$s_period=date("Y"); # Set year

	if ($s_province) {
		$query = "SELECT id_record, extent, type$lang AS province FROM types_province WHERE id_record='$s_province'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$ViewRegion=$r['extent'];
		}
	}else{
		$ViewRegion="";
	}

	$out_file="data/map".$s_province.".png";

	# Open mapfile
	$Map = ms_newMapObj("$mapData/map.map");

// Create the shapefile
  $shpFname = "$mapData/data/searches";
  $shpFile = ms_newShapeFileObj($shpFname, MS_SHP_POINT);
  $def = array(
		array("PROG_ID", "N", 5, 0),
      array("idteam","N",5,0),
		array("nameteam","C",75),
      array("year","N",4,0),
      array("dstart","D"),
      array("hours","N",5,0),
      array("members","N",5,0),
      array("event1","C",50),
      array("event2","C",50),
      array("event3","C",50),
      array("event4","C",50),
      array("event5","C",50),
      array("activity1","C",50),
      array("activity2","C",50),
      array("activity3","C",50),
      array("activity4","C",50),
      array("activity5","C",50),
      array("outcome1","C",50),
      array("outcome2","C",50),
      array("outcome3","C",50),
      array("outcome4","C",50),
      array("outcome5","C",50)
		);
  $dbfFile = dbase_create($shpFname . ".dbf", $def);

// Read the data
		# Select all searches - get Team and PLS Lat/Long (DD MM)
		$query="SELECT search.id_record,
			search.lat_coords_pls,
			search.long_coords_pls,
			types_events.type1 AS event1,
			types_events.type2 AS event2,
			types_events.type3 AS event3,
			types_events.type4 AS event4,
			types_events.type5 AS event5,
			types_outcome.type1 AS outcome1,
			types_outcome.type2 AS outcome2,
			types_outcome.type3 AS outcome3,
			types_outcome.type4 AS outcome4,
			types_outcome.type5 AS outcome5,
			types_activity.type1 AS activity1,
			types_activity.type2 AS activity2,
			types_activity.type3 AS activity3,
			types_activity.type4 AS activity4,
			types_activity.type5 AS activity5
			FROM search
			LEFT JOIN team_search ON team_search.id_search=search.id_record
			LEFT JOIN types_activity ON search.id_types_activity=types_activity.id_record
			LEFT JOIN types_events ON search.id_types_events=types_events.id_record
			LEFT JOIN subjects ON subjects.id_search=search.id_record
			LEFT JOIN types_outcome ON subjects.id_types_outcome=types_outcome.id_record
			WHERE 1=1
			".($m_period ? period_filter($m_period,"search.when_concluded") : "" )."
			".($m_filter && $m_filter!="All" ? "AND team_search.id_teams='$m_filter'" : "")."
			".($m_prov ? "AND search.id_province='$m_prov'" : "")."
			GROUP BY search.id_record";

		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");

		# Process each row returned by Query
		if (mysql_num_rows($result)) {
			while ($r = mysql_fetch_array($result)) {

				# Retrieve the DD MM lat/long coordinates
				#list($lat_dd,$lat_mm)=split(" ",$r['lat_coords_pls']);
				#list($long_dd,$long_mm)=split(" ",$r['long_coords_pls']);

				# Convert DD MM to decimal degrees
				#$dd_lat =  round($lat_dd + ($lat_mm / 60),4);
				#$dd_long = 0 - round($long_dd + ($long_mm / 60),4);

				$dd_lat =  $r['lat_coords_pls'];
				$dd_long = $r['long_coords_pls'];

				// Select all teams for a given search - each will be a point
				$query2 = "SELECT team_search.id_record as id_record,
							teams.team_name AS team,
							teams.id_record as id_team,
							team_search.hours_total,
							team_search.members_total,
							DATE_FORMAT(team_search.when_alerted,'%Y%m%d') AS when_alerted,
							DATE_FORMAT(team_search.when_alerted,'%Y') AS year,
							team_search.cost_total
							FROM team_search
							LEFT JOIN teams ON teams.id_record=team_search.id_teams
							WHERE team_search.id_search='".$r['id_record']."'";
				$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
				$r2_count = mysql_num_rows($result2);
				while ($r2 = mysql_fetch_array($result2)) {
					$annotation =
						array(
							$r2['id_record'],
							$r2['id_team'],
							$r2['team'],
							$r2['year'],
							$r2['when_alerted'],
							$r2['hours_total'],
							$r2['members_total'],
							$r['event1'],
							$r['event2'],
							$r['event3'],
							$r['event4'],
							$r['event5'],
							$r['activity1'],
							$r['activity2'],
							$r['activity3'],
							$r['activity4'],
							$r['activity5'],
							$r['outcome1'],
							$r['outcome2'],
							$r['outcome3'],
							$r['outcome4'],
							$r['outcome5']
						);
					createPoint( $dd_long, $dd_lat, $annotation);
				}
			}
  		}

// done... cleanup
	$shpFile->free();
	dbase_close($dbfFile);

// Select new map layer and turn it on
//	$Dummylayer = ms_newLayerObj($Map);  // a new layerobject
//	$Dummylayer = $Map->getLayerByName("searches");
//	$Dummylayer->set("status", 1);	       // Turn it on
//	$Dummylayer->set("data", $shpFname);       // Add your created

  $poLayer = $Map->getlayerbyname(road);
		$poLayer->set("status", 1);

	$poLayer = $Map->getlayerbyname(rail);
		$poLayer->set("status", 1);

  $poLayer = $Map->getlayerbyname(popplace);
		$poLayer->set("status", 1);

  $poLayer = $Map->getlayerbyname(teams);
		$poLayer->set("status", 1);

  $poLayer = $Map->getlayerbyname(searches);
		$poLayer->set("status", 1);


// Set the extent
    if ($ViewRegion)
    {
        if (ereg("(-?[0-9]+),(-?[0-9]+),(-?[0-9]+),(-?[0-9]+)",$ViewRegion, $ProvExtents))
        {
            $dfMinX = doubleval($ProvExtents[1]);
            $dfMinY = doubleval($ProvExtents[2]);
            $dfMaxX = doubleval($ProvExtents[3]);
            $dfMaxY = doubleval($ProvExtents[4]);
       # echo "$dfMinX, $dfMinY, $dfMaxX, $dfMaxY";

				$Map->setExtent($dfMinX, $dfMinY, $dfMaxX, $dfMaxY);
        }
    }

  $poLayer = $Map->getlayerbyname(searches);
  $class = $poLayer->getClass(0);
  if ($s_period && $s_period!="All"){
		$class->setExpression("([year] = $s_period)");
  }
// Draw the map
	$ImgMap = $Map->draw();

// Save the image to a file
	$Save_result=$ImgMap->saveImage($out_file,MS_PNG,1,1,0);
#	$image_url=$ImgMap->saveWebImage(MS_PNG,1,1,0);

$run_date=date("Y-m-d");

echo "$run_date\tCreated $out_file. $ViewRegion\t$[year] = $s_period\n";

//function createPoint($x, $y, $name){
//    GLOBAL $shpFile, $dbfFile;
//    // Create shape
//    $oShp = ms_newShapeObj(MS_SHP_POINT);
//    $oLine = ms_newLineObj();
//    $oLine->addXY($x, $y);
//    $oShp->add( $oLine );
//    $shpFile->addShape($oShp);
//  // Write attribute record
//    dbase_add_record($dbfFile, $name);
//}

function createPoint($x, $y, $name){
    GLOBAL $shpFile, $dbfFile;

    // Create shape
	$pointobj = ms_newPointObj();
	$pointobj->setXY($x,$y,1);
	$shpFile->addPoint($pointobj);
	$pointobj->free();

  // Write attribute record
    dbase_add_record($dbfFile, $name);
}

/* <!--HTML>
	<HEAD>
		<TITLE>Mapserver Map</TITLE>
 	</HEAD>
 	<BODY>
 		<IMG SRC=<?php echo $image_url; ?> >
 	</BODY>
</HTML-->
*/
?>