<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: callout.php
	# Version: 22 October 2004
	# Author: Calvin Martini
	# Description: Displays a PDF formatted callout list from the shell

	# Set client variables
	$client_vars=array(
		'team'
	);
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL;
	}

$team=6;

	require("globals.php");
	connect_db();

	$teams=get_teams();
	$provinces=get_provinces();

	# Main Query: Set column headings and data fields
	$currentGroup=""; // Used to track the groupings for pagination
	$col[]=$l['full_name']; $col[]=$l['title']; $col[]=$l['phone_work']; $col[]=$l['phone_home']; $col[]=$l['phone_cell']; $col[]=$l['phone_pager']; $col[]=$l['phone_other']; $col[]=$l['email'];
	$dat[]="full_name"; $dat[]="title"; $dat[]="phone_work"; $dat[]="phone_home"; $dat[]="phone_cell"; $dat[]="phone_pager"; $dat[]="phone_other"; $dat[]="email";
	$group[1]="A"; $group[2]="B"; $group[3]="C"; # Titles for high, medium and low display priority
	$query="
		SELECT members.id_record AS id_record,
		members.name_first,
		members.name_last,
		members.title AS title,
		IF(teams_members.id_teams,teams_members.id_teams,9999) AS team,
		members.display_priority,
		members.team_province AS province,
		teams.team_name,
		members.phone_work,
		members.phone_home,
		members.phone_cell,
		members.phone_fax,
		members.phone_pager,
		members.phone_other,
		members.email
		FROM teams_members
		LEFT JOIN teams ON teams.id_record=teams_members.id_teams
		LEFT JOIN members ON teams_members.id_members=members.id_record
		WHERE 1=1
		".($team && $team!="All" ? "AND teams_members.id_teams='$team'" : "")."
		$cont_filter
		AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
		$search_filter
		GROUP BY teams_members.id_record
		ORDER BY team_name, members.display_priority, members.name_last
		";

	# Perform the query and build the array
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$row_count = mysql_num_rows($result);
	if (mysql_num_rows($result)) {
		while ($r = mysql_fetch_array($result)) {
			$priority = $r['display_priority'];
			$member = $group[$priority].$r['id_record'];
			$data[$priority][] = array('Member'=>$member,
											'Last'=>$r['name_last'],
											'First'=>$r['name_first'],
											'Responding'=>'',
											'Notes'=>'',
											'YN_Callout'=>'',
											'YN_Extraction'=>'',
											'YN_CP_Driver'=>'',
											'P_Home'=>fmtPhone($r['phone_home']),
											'P_Work'=>fmtPhone($r['phone_work']),
											'P_Cell'=>fmtPhone($r['phone_cell']).$newPage);     
		}
	}

	# Build the PDF document
  require "./classes/ezpdf/class.ezpdf.php";
  $pdf =& new Cezpdf('letter','portrait');
	$pdf -> ezSetMargins(50,70,50,50);
	$pdf->selectFont('./classes/ezpdf/fonts/Helvetica.afm');
	$pdf->ezStartPageNumbers(500,18,10,'','{PAGENUM}/{TOTALPAGENUM}',1);
  $columns = array("Member" => "ID", "Last" => "LAST", "First" => "FIRST", "Responding" => "RESP", "Notes" => "NOTES", "YN_Callout" => "CO", "YN_Extract" => "EX", "YN_CP_Driver" => "CP", "P_Home" => "HOME", "P_Work" => "WORK", "P_Cell" => "CELL");
  $options = array(
  				'fontSize'=>8,
  				'titleFontSize'=>12,
  				'columns' => array('Member' => array('width'=>35, 'justification' => 'left'),
							'Last' => array('width'=>100, 'justification' => 'left'),
							'First' => array('width'=>100, 'justification' => 'left'),
							'Responding' => array('width'=>35, 'justification' => 'left'),
							'Notes' => array('width'=>400, 'justification' => 'left'),
							'YN_Callout' => array('width'=>35, 'justification' => 'left'),
							'YN_Extraction' => array('width'=>35, 'justification' => 'left'),
							'YN_CP_Driver' => array('width'=>35, 'justification' => 'left'),
							'P_Home' => array('width'=>50, 'justification' => 'left'),
							'P_Work' => array('width'=>50, 'justification' => 'left'),
							'P_Cell' => array('width'=>50, 'justification' => 'left')
         )
    );
  $pdf->ezTable($data[1], $columns, "Search Manager Callout List - ".$teams[$team], $options);
	$pdf->ezNewPage();
	$pdf->ezTable($data[2], $columns, "Primary Callout List - ".$teams[$team], $options);
	$pdf->ezNewPage();
  $pdf->ezTable($data[3], $columns, "Secondary Callout List - ".$teams[$team], $options);
  $pdf->ezStream();

function fmtPhone($PhoneNumber){
			# Clean up phone numbers
			# Return phone number without whitespace or punctuation
			$PhoneNumber = ereg_replace( "[^0-9]", "", $PhoneNumber ); // Strip out non-numerics     
        if( strlen($PhoneNumber)==10 && ereg( "^([0-9]{3})([0-9]{3})([0-9]{4})$", $PhoneNumber, $NumberParts ) ) {                                   
					return $NumberParts[2] . "-" . $NumberParts[3]; 
#					return "(" . $NumberParts[1] . ") " . $NumberParts[2] . "-" . $NumberParts[3]; 
        }elseif ( strlen($PhoneNumber)==7 && ereg( "^([0-9]{3})([0-9]{4})$", $PhoneNumber, $NumberParts ) ) {                                  
					return $NumberParts[1] . "-" . $NumberParts[2]; 
        }elseif ( strlen($PhoneNumber)==14 && ereg( "^([0-9]{3})([0-9]{4})([0-9]{3})([0-9]{4})$", $PhoneNumber, $NumberParts ) ) {                                  
					return $NumberParts[1] . "-" . $NumberParts[2] . "\n".$NumberParts[3] . "-" . $NumberParts[4]; 
        }else{
        	return $PhoneNumber;
        }
}

?>
