#!/usr/local/bin/php -q
<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: callout.php
	# Version: 28 January 2005
	# Author: Calvin Martini
	# Description: Displays a PDF formatted callout list from the shell

	# Set client variables
	$client_vars=array(
		'team',		// Team record number
		'message'	// Custom message to display in footer
	);
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL;
	}
	
	# Parse the configuration file
	$ini_array = parse_ini_file("callout.ini", TRUE);

	# User definable values
	if($_SERVER['argv'][1]){
		$team=$_SERVER['argv'][1];
	}
	if($_SERVER['argv'][2]){
		$message=$_SERVER['argv'][2];
	}

	$team_section = "Team$team";

	if (is_array($ini_array[$team_section])){
		# $message = "COMMAND POST CELL PHONE NUMBER IS 852-1668 | P.M.C.C. PHONE NUMBER IS 506-453-7171 | Search Coordinator Cell 863-5587 Pager 852-8511 (cap code 1301330)";
		$title[1]="Search Manager Callout"; $title[2]="Primary Callout"; $title[3]="Secondary Callout"; $title[4]="Auxiliary";  $title[5]="Not Used"; # Table titles for high, medium and low display priority
		$group[1]="A"; $group[2]="B"; $group[3]="C"; $group[4]="D"; $group[5]="E";# Member ID Prefixes for high, medium and low display priority
		$file="calloutinfo_$team.".txt; # File name for appendix

		if (isset($ini_array[$team_section]['display_priority']) && $ini_array[$team_section]['display_priority']){
			$category_field="display_priority";
			$category_order="ORDER BY team_name, members.display_priority, members.name_last";
		}else{
			$category_field="OptField2";
			$category_order="ORDER BY team_name, members.OptField2, members.display_priority, members.name_last";
		}

		# Connect to the database and build query
		require("globals.php");
		connect_db();
		$query="
			SELECT members.id_record AS id_record,
			members.name_first,
			members.name_last,
			members.title AS title,
			IF(teams_members.id_teams,teams_members.id_teams,9999) AS team,
			members.display_priority,
			members.OptField1,
			members.OptField2,
			members.team_province AS province,
			teams.team_name,
			members.phone_work,
			members.phone_home,
			members.phone_cell,
			members.phone_fax,
			members.phone_pager,
			members.phone_other,
			members.email
			FROM teams_members
			LEFT JOIN teams ON teams.id_record=teams_members.id_teams
			LEFT JOIN members ON teams_members.id_members=members.id_record
			WHERE (members.flag_inactive='0' OR members.flag_inactive IS NULL)
			".($team && $team!="All" ? "AND teams_members.id_teams='$team'" : "")."
			GROUP BY teams_members.id_record
			$category_order
			";
			
		# Perform the query and build the array
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		$row_count = mysql_num_rows($result);
		$row = 0;
		if (mysql_num_rows($result)) {
			while ($r = mysql_fetch_array($result)) {
				$row++;
				if(!$team_name){$team_name=$r['team_name'];}
				if ($section != $r[$category_field] && $ini_array[$team_section]['bold_first']){$b_on="<b>";$b_off="</b>";}else{$b_on="";$b_off="";}
				$section = $r[$category_field];
				if (isset($ini_array[$team_section]['use_id']) && $ini_array[$team_section]['use_id']){
					$member = $group[$section].$r['id_record'];
				}else{
					$member = $row;
				}
				$sectionFlag[$section]=$section;
				if ($ini_array[$team_section]['use_optfield1']){
					list($YN_Callout,$YN_Extraction,$YN_CP_Driver) = chunk_split(ereg_replace("[Nn]"," ",$r['OptField1']),1,"");
					$data[$section][] = array('Member'=>$b_on.$member.$b_off,
													'Last'=>$b_on.$r['name_last'].$b_off,
													'First'=>$b_on.$r['name_first'].$b_off,
													'Responding'=>$b_on.''.$b_off,
													'Notes'=>$b_on.'                           '.$b_off,
													'YN_Callout'=>$b_on.$YN_Callout.$b_off,
													'YN_Extraction'=>$b_on.$YN_Extraction.$b_off,
													'YN_CP_Driver'=>$b_on.$YN_CP_Driver.$b_off,
													'P_Pager'=>$b_on.fmtPhone($r['phone_pager']).$b_off,
													'P_Home'=>$b_on.fmtPhone($r['phone_home']).$b_off,
													'P_Work'=>$b_on.fmtPhone($r['phone_work']).$b_off,
													'P_Cell'=>$b_on.fmtPhone($r['phone_cell']).$b_off.$newPage);
					$columns = array("Member" => "ID", "Last" => "LAST", "First" => "FIRST", "Responding" => "Y/N", "Notes" => "NOTES", "YN_Callout" => "CO", "YN_Extraction" => "EX", "YN_CP_Driver" => "CP", "P_Pager" => "PAGER", "P_Home" => "HOME", "P_Work" => "WORK", "P_Cell" => "CELL");
					$options = array(
						'fontSize'=>10,
						'titleFontSize'=>13,
						'rowGap'=>13,
						'showLines'=>2,
						'columns' => array(
							'Member' => array('width'=>35, 'justification' => 'left'),
							'Last' => array('width'=>100, 'justification' => 'left'),
							'First' => array('width'=>100, 'justification' => 'left'),
							'Responding' => array('width'=>35, 'justification' => 'left'),
							'Notes' => array('width'=>100, 'justification' => 'left'),
							'YN_Callout' => array('width'=>35, 'justification' => 'left'),
							'YN_Extraction' => array('width'=>35, 'justification' => 'left'),
							'YN_CP_Driver' => array('width'=>35, 'justification' => 'left'),
							'P_Pager' => array('width'=>50, 'justification' => 'left'),
							'P_Home' => array('width'=>50, 'justification' => 'left'),
							'P_Work' => array('width'=>50, 'justification' => 'left'),
							'P_Cell' => array('width'=>50, 'justification' => 'left')
							)
						);
				}else{
					$data[$section][] = array('Member'=>$b_on.$member.$b_off,
													'Last'=>$b_on.$r['name_last'].$b_off,
													'First'=>$b_on.$r['name_first'].$b_off,
													'Responding'=>$b_on.''.$b_off,
													'Notes'=>$b_on.'                           '.$b_off,
													'P_Pager'=>$b_on.fmtPhone($r['phone_pager']).$b_off,
													'P_Home'=>$b_on.fmtPhone($r['phone_home']).$b_off,
													'P_Work'=>$b_on.fmtPhone($r['phone_work']).$b_off,
													'P_Cell'=>$b_on.fmtPhone($r['phone_cell']).$b_off.$newPage);
					$columns = array("Member" => "ID", "Last" => "LAST", "First" => "FIRST", "Responding" => "Y/N", "Notes" => "NOTES", "P_Pager" => "PAGER", "P_Home" => "HOME", "P_Work" => "WORK", "P_Cell" => "CELL");
					$options = array(
						'fontSize'=>10,
						'titleFontSize'=>13,
						'rowGap'=>13,
						'showLines'=>2,
						'columns' => array(
							'Member' => array('width'=>35, 'justification' => 'left'),
							'Last' => array('width'=>100, 'justification' => 'left'),
							'First' => array('width'=>100, 'justification' => 'left'),
							'Responding' => array('width'=>35, 'justification' => 'left'),
							'Notes' => array('width'=>100, 'justification' => 'left'),
							'P_Pager' => array('width'=>50, 'justification' => 'left'),
							'P_Home' => array('width'=>50, 'justification' => 'left'),
							'P_Work' => array('width'=>50, 'justification' => 'left'),
							'P_Cell' => array('width'=>50, 'justification' => 'left')
							)
						);
				}
			}
		}

		# Build the PDF document
		require "./classes/ezpdf/class.ezpdf.php";
		$pdf =& new Cezpdf('letter','portrait');
		$pdf -> ezSetMargins(50,70,50,50);
		$pdf->selectFont('./classes/ezpdf/fonts/Helvetica.afm');
		$pdf->ezStartPageNumbers(570,40,10,'','',1);

		// Build header and footer blocks
		$all = $pdf->openObject();
		$pdf->saveState();
		$pdf->setStrokeColor(0,0,0,1);
		$pdf->line(20,60,578,60);
		$pdf->line(20,750,578,750);
		$pdf->addText(50,755,11,$team_name);
		$pdf->addText(420,755,11,strftime("%a %b %d %R %Z %Y"));
		if ($message){$pdf->addText(50,40,8,$message);}
		$pdf->restoreState();
		$pdf->closeObject();
		// note that object can be told to appear on just odd or even pages by changing 'all' to 'odd'
		// or 'even'.
		$pdf->addObject($all,'all');

		if ($ini_array[$team_section]['use_optfield1']){
			$columns = array("Member" => "ID", "Last" => "LAST", "First" => "FIRST", "Responding" => "Y/N", "Notes" => "NOTES", "YN_Callout" => "CO", "YN_Extraction" => "EX", "YN_CP_Driver" => "CP", "P_Pager" => "PAGER", "P_Home" => "HOME", "P_Work" => "WORK", "P_Cell" => "CELL");
			$options = array(
				'fontSize'=>10,
				'titleFontSize'=>13,
				'rowGap'=>13,
				'showLines'=>2,
				'columns' => array(
					'Member' => array('width'=>35, 'justification' => 'left'),
					'Last' => array('width'=>100, 'justification' => 'left'),
					'First' => array('width'=>100, 'justification' => 'left'),
					'Responding' => array('width'=>35, 'justification' => 'left'),
					'Notes' => array('width'=>100, 'justification' => 'left'),
					'YN_Callout' => array('width'=>35, 'justification' => 'left'),
					'YN_Extraction' => array('width'=>35, 'justification' => 'left'),
					'YN_CP_Driver' => array('width'=>35, 'justification' => 'left'),
					'P_Pager' => array('width'=>50, 'justification' => 'left'),
					'P_Home' => array('width'=>50, 'justification' => 'left'),
					'P_Work' => array('width'=>50, 'justification' => 'left'),
					'P_Cell' => array('width'=>50, 'justification' => 'left')
					)
				);
		}else{
			$options = array(
				'fontSize'=>10,
				'titleFontSize'=>13,
				'rowGap'=>13,
				'showLines'=>2,
				'columns' => array(
					'Member' => array('width'=>35, 'justification' => 'left'),
					'Last' => array('width'=>100, 'justification' => 'left'),
					'First' => array('width'=>100, 'justification' => 'left'),
					'Responding' => array('width'=>35, 'justification' => 'left'),
					'Notes' => array('width'=>100, 'justification' => 'left'),
					'P_Pager' => array('width'=>50, 'justification' => 'left'),
					'P_Home' => array('width'=>50, 'justification' => 'left'),
					'P_Work' => array('width'=>50, 'justification' => 'left'),
					'P_Cell' => array('width'=>50, 'justification' => 'left')
					)
				);
		}

		$count=1;
		while (isset($ini_array[$team_section]['group'.$count])){
			if (is_array($data[$count]) && isset($data[$count][0]['Member'])){
				if ($count != 1){$pdf->ezNewPage();}
				$pdf->ezTable($data[$count], $columns, $ini_array[$team_section]['group'.$count], $options);
			}
			$count++;
		}

		# Add the notes page
		if (is_readable($file)){
			$pageText = implode(file($file));
			$pdf->ezNewPage();
			$pdf->ezText($pageText);
		}

		# Output the completed PDF document
		$pdf->ezStream();
		#$pdf->ezOutput();
	}else{
#		header("Location: display.php".SIDPRINT."\n\n");
		echo "Error: No team specified";
		exit;
	}

	function fmtPhone($PhoneNumber){
		# Clean up phone numbers - remove non-numeric, strip off area code, format multiple number (e.g. "455-6666 or 455-9999") as multi-line
		$PhoneNumber = ereg_replace( "[^0-9]", "", $PhoneNumber ); // Strip out non-numerics     
		if( strlen($PhoneNumber)==10 && ereg( "^([0-9]{3})([0-9]{3})([0-9]{4})$", $PhoneNumber, $NumberParts ) ) {                                   
			return $NumberParts[2] . "-" . $NumberParts[3]; 
		}elseif ( strlen($PhoneNumber)==12 && ereg( "^([0-9]{3})([0-9]{3})([0-9]{4})([0-9]{2})$", $PhoneNumber, $NumberParts ) ) {                                  
			return $NumberParts[2] . "-" . $NumberParts[3]. "-" . $NumberParts[4]; 
		}elseif ( strlen($PhoneNumber)==9 && ereg( "^([0-9]{3})([0-9]{4})([0-9]{2})$", $PhoneNumber, $NumberParts ) ) {                                  
			return $NumberParts[1] . "-" . $NumberParts[2]. "-" . $NumberParts[3]; 
		}elseif ( strlen($PhoneNumber)==7 && ereg( "^([0-9]{3})([0-9]{4})$", $PhoneNumber, $NumberParts ) ) {                                  
			return $NumberParts[1] . "-" . $NumberParts[2]; 
		}elseif ( strlen($PhoneNumber)==14 && ereg( "^([0-9]{3})([0-9]{4})([0-9]{3})([0-9]{4})$", $PhoneNumber, $NumberParts ) ) {                                  
			return $NumberParts[1] . "-" . $NumberParts[2] . "\n".$NumberParts[3] . "-" . $NumberParts[4]; 
		}else{
			return $PhoneNumber;
		}
	}

?>
