<?php
# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Program: class_transfer_server.php
# Version: 16 August 2004
# Author: Calvin Martini
# Description: Transfer class for E-GADS

require_once('class_login.php');
require_once('eMySQLXML.php');

class transfer{
    // Stores instance of PEAR::SOAP Server
    var $soapServer;
    var $user;
    var $password;
    var $team;
    var $id_recno;
    var $a_diralt;
    var $a_admin;
    var $a_prov;
    var $dbhostname;
    var $dbusername;
    var $dbpassword;
    var $dbname;

    // Constructor builds PEAR::SOAP Server
    function transfer ($dbhostname,$dbusername,$dbpassword,$dbname,$namespace) {
        // Set DB connection Information
        $this->dbhostname = $dbhostname;
        $this->dbusername = $dbusername;
        $this->dbpassword = $dbpassword;
        $this->dbname = $dbname;

        // Switch off notices to all GET
        error_reporting(E_ALL ^ E_NOTICE);

        // Instantiate PEAR::SOAP SOAP_Server
        $this->soapServer=new SOAP_Server;

        // Build the object map (using this instance) + add a namespace
        $this->soapServer->addObjectMap($this,$namespace);

        // Turn on the server
        $this->soapServer->service($GLOBALS['HTTP_RAW_POST_DATA']);
    }

    function serverTimestamp() {
        return time();
    }

    function authenticate($user,$password){
		list($this->id_recno,$this->a_diralt,$this->a_admin,$this->a_prov) = login::authenticate($this->dbhostname,$this->dbusername,$this->dbpassword,$this->dbname,$user,$password);
		return ($this->id_recno > 0 ? true : false);
	 }

    function get_table($user,$password,$team,$table){
		if ($this->authenticate($user,$password)){
			list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name) = login::team_access('access_members');
			if (($a_all_teams && $a_memb[9999] >1) || $a_memb[$team]>=1){
				$mx = new eMySQLXML($this->dbhostname,$this->dbname,$this->dbusername,$this->dbpassword);
				switch ($table) {
					case "members":
						$query = "SELECT members.*
							FROM members
							LEFT JOIN teams_members ON teams_members.id_members=members.id_record
							LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
							WHERE teams_members.id_teams='$team'
							".($a_all_teams && $this->a_prov==-1 ? "" : "AND team_access.id_users='$this->id_recno' AND team_access.access_members >= 1")."
							GROUP BY members.id_record";
						break 1;
					case "certifications":
						$query = "SELECT certifications.*
							FROM certifications
							LEFT JOIN teams_members ON teams_members.id_members=certifications.id_members
							LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
							WHERE teams_members.id_teams='$team'
							".($a_all_teams && $this->a_prov==-1 ? "" : "AND team_access.id_users='$this->id_recno' AND team_access.access_members >= 1")."
							GROUP BY certifications.id_record";
						break 1;
					case "teams_members":
						$query = "SELECT teams_members.*
							FROM $table
							LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
							WHERE teams_members.id_teams='$team'
							".($a_all_teams && $this->a_prov==-1 ? "" : "AND team_access.id_users='$this->id_recno' AND team_access.access_members >= 1")."
							GROUP BY $table.id_record";
						break 1;
					case "teams":
						$query = "SELECT teams.id_record,
							teams.id_users,
							teams.when_entered,
							teams.team_name,
							teams.team_address,
							teams.team_city,
							teams.team_pcode,
							teams.phone_1,
							teams.phone_2,
							teams.phone_pager,
							teams.phone_cell,
							teams.phone_fax,
							teams.email,
							teams.id_address_province,
							teams.date_established,
							teams.flag_ops
							FROM $table";
						break 1;
					case "types_certifications":
						$query = "SELECT types_certifications.id_record,
							types_certifications.type1,
							types_certifications.type3,
							types_certifications.type2,
							types_certifications.type4,
							types_certifications.type5,
							types_certifications.desc_type1,
							types_certifications.desc_type2,
							types_certifications.desc_type3,
							types_certifications.desc_type4,
							types_certifications.desc_type5,
							types_certifications.expires,
							types_certifications.id_province,
							types_certifications.id_teams,
							types_certifications.flag_cuser
							FROM $table";
						break 1;
					case (substr($table,0,6)=="types_"):
						$query = "SELECT * FROM $table";
						break 1;
				}
				$res = $mx->jBuildXMLString($query);
			}else{
				$res = -2; // User has no access to requested team
			}
		}else{
			$res = -1; // Invalid user or password
		}
		return $res;
    }
}
?>