<?php
/*
eMySQLXML - Version 1.3-E-gads!
MySQL Select to XML - XML to MySQL - E-GADS! version
Copyright (C) 2004 Calvin Martini

Adapted from jMySQLXML, by  F.J. De Klerk

This file is part of E-GADS!

E-GADS! is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

jMySQLXML by Johan De Klerk
johan@wisi.co.za
Many thanks to David Williams for his great ideas.
*/

require_once('ezxml.php');

class eMySQLXML {

	var $xml_str = '';
	var $field = array();
	var $field_def = array();
	var $data = array();
	var $include_pk = true;

	function eMySQLXML($hostname='', $dbname='', $username='', $password='') {
		$this->init($hostname, $dbname, $username, $password);
	}

	function init($hostname, $dbname, $username, $password='') {
		$conn = mysql_connect($hostname,$username,$password);
		mysql_select_db($dbname,$conn);
	}
    
	function getXMLString() {
	  return $this->xml_str;
	}

	function setXMLString($data) {
		$this->xml_str = $data;
	}
    
	function jBuildXMLString($query,$tablename='') {
		$this->xml_str = '';

		$result = mysql_query($query) or die(mysql_error());

		if ($tablename == '') {
			$tablename = mysql_field_table($result,1);
		}

		$i = 0;
		$num_fields = mysql_num_fields($result);

		$this->xml_str .= '<?xml version="1.0" ?>'."\n";
		$this->xml_str .= '<table name="'.$tablename.'">'."\n";

		while ($row = mysql_fetch_array($result)) {
			$this->xml_str .= "\t".'<row>'."\n";
			if ($this->include_pk) {
				$begin = 0;
			}else {
				$begin = 1;
			}

			for ($i = $begin; $i < $num_fields; $i++) {
				$fieldname = mysql_field_name($result,$i);
				$flags = explode(' ',mysql_field_flags($result,$i));
				$type = mysql_field_type($result,$i);
				$length = mysql_field_len($result,$i);

				$this->xml_str .= "\t\t".'<'.$fieldname.' type="'.$type.'" length="'.$length.'"';

				for ($j = 0; $j < count($flags); $j++) {
					if (!strcmp($flags[$j],'not_null')) {
						$this->xml_str .= ' null="'.$flags[$j].'"';
					}

					if (!strcmp($flags[$j],'primary_key')) {
						$this->xml_str .= ' pri_key="'.$flags[$j].'"';
					}
				}

				// Added htmlentities and str_replace to convert problematic text in data fields
				$this->xml_str .= '>'.str_replace('&quot;',"",htmlentities($row[$fieldname]));

				$this->xml_str .= '</'.$fieldname.'>'."\n";
			}

			$this->xml_str .= "\t".'</row>'."\n";
		}
		mysql_free_result($result);
		$this->xml_str .= '</table>';
		return $this->xml_str;
	}
    
    function jWriteXML($filename) {
	//	@chmod('jMySQLXML.php',777);
        $file = fopen($filename,'w');
        fwrite($file,$this->xml_str);
        fclose($file);
    }
    
    function jReadXML($xml) {

		if (file_exists($xml)) {
			$fh = fopen($xml,'r');
	        $this->xml_str = fread($fh,filesize($xml));
		    fclose($fh);
		}
		else {
			$this->xml_str = $xml;
		}
		
		//strip unwanted tags
		$this->_stripXML();
       
		$root = eZXML::domTree($this->xml_str, array( "TrimWhiteSpace" => true ));
        $i = 0;

        foreach($root->children as $document) {

            //get fields to be inserted
            foreach($document->children as $row) {

                if (!strcmp($row->name,'row')) {

                    $j = 0;

                    foreach($row->children as $element) {
                        $this->field[$j] = $element->name;
                        $this->field_def[$j] = ""; $flag = false;
								foreach($element->attributes as $element2) {
									switch ($element2->name) {
										case "length" :
											if ($flag) {
												$this->field_def[$j] .= "(".$element2->content.")";
												$flag = false;
											}
											break 1;
										case "type" :
											switch ($element2->content){
												case "date" :
													$this->field_def[$j] .= " date";
													break 1;
												case "timestamp" :
													$this->field_def[$j] .= " timestamp";
													$flag = true;
													break 1;
												case "int" :
													$this->field_def[$j] .= " int";
													$flag = true;
													break 1;
												case "string" :
													$this->field_def[$j] .= " varchar";
													$flag = true;
													break 1;
												case "blob" :
													$this->field_def[$j] .= " text";
													break 1;
											}
										case "null" :
											if ($element2->content == "not_null"){
												$this->field_def[$j] .= " NOT NULL";
											}
											break 1;
									}
									
								}

                        $j++;
                    }

                }
                else {
                    die('ERROR: No rows found!');
                }
                
                break;
            }
            
            //get data to be inserted
            foreach($document->children as $row) {

                if (!strcmp($row->name,'row')) {

                    foreach($row->children as $element) {
                        $this->data[$i] = get_contents($element);
                        $i++;
                    }

                }
                else {
                    die('ERROR: No rows found!');
                }
            }
        }
    }
	
	function jInsertXML($tablename) {

		$values = array();

		$i = 0;
		$r = 0;

		$skip = count($this->field);

		// Build the field list
		$setStr = ""; $createStr = "";
		for ($i=0; $i<$skip; $i++){
			$setStr .= $this->field[$i].($i==($skip-1)? '':',');
			// $createStr .= $this->field[$i]." ".$this->field_def[$i].($i==($skip-1)? '':',');
			$createStr .= $this->field[$i]." ".$this->field_def[$i].",";
		}

		// Create the table
		$query = "DROP TABLE IF EXISTS $tablename";
		mysql_query($query) or die(mysql_error()."<br>".$query);
		$query = "CREATE TABLE $tablename ($createStr PRIMARY KEY (id_record)) TYPE=MyISAM PACK_KEYS=1";
		mysql_query($query) or die(mysql_error()."<br>".$query);

		for ($i = 0; $i < count($this->data); $i+=$skip) {

			if ($this->include_pk) {
				$query = 'insert into '.$tablename.'('.$setStr.') values(';
			}else {
				$query = 'insert into '.$tablename.'('.$setStr.') values(null,';
			}

			for ($j = 0; $j < count($this->field); $j++) {
				if (strcmp($this->data[$i+$j],'null')) {
						 $query .= '"'.$this->data[$i+$j].'",';
				}
			}
			$query = substr($query,0,strlen($query)-1).')'."\n";
			mysql_query($query) or die(mysql_error()."<br>".$query);
			$r++;
		}
		return $r;
   }

	function _stripXML() {
		$chars = preg_split('//', $this->xml_str, -1, PREG_SPLIT_NO_EMPTY);

		$intable = false;
		$this->xml_str = '<?xml version="1.0"?>'."\n";

		for ($i = 0; $i < count($chars); $i++) {
			
			if (!$intable) {
				if ($chars[$i] == '<') {
					$tablename = $chars[$i+1].$chars[$i+2].$chars[$i+3].$chars[$i+4].$chars[$i+5];

					if ($tablename == 'table') {
						$intable = true;
						$i--;
						continue;
					}
				}
			}
			else {
				$this->xml_str .= $chars[$i];

				if ($chars[$i] == '>') {
					$tablename = $chars[$i-6].$chars[$i-5].$chars[$i-4].$chars[$i-3].$chars[$i-2].$chars[$i-1];

					if ($tablename == '/table') {
						$intable = false;
						break;
					}
				}
			}
		}

		return $this->xml_str;
	}
}
?>