<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: display.php
	# Version: 27 June 2005
	# Author: Calvin Martini
	# Description: Main report display page. Primary user interface to application.

	$time_start = getmicrotime();

	# Set client variables
	$client_vars=array(
		'filter',
		'mpopplace',
		'mroad',
		'mrail',
		'mteams',
		'minx',
		'miny',
		'maxx',
		'maxy',
		'imagewidth',
		'imageheight',
		'CMD',
		'INPUT_TYPE',
		'INPUT_COORD',
		'period',
		'province',
		'report',
		'search',
		'search_scope'
	);
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL;
	}

	session_start();

	# If user changed display or filter modes, set the session variables
	if ($report){$s_report=$report;$_SESSION['s_report']=$report;}
	if ($filter){$s_filter=$filter;$_SESSION['s_filter']=$filter;}
	if ($province){$s_province=$province;$_SESSION['s_province']=$province;}
	if ($period){$s_period=$period;$_SESSION['s_period']=$period;}
	if (($_REQUEST['navsubmit'])){
		$s_road=$mroad;
		$_SESSION['s_road']=$s_road;
		$s_rail=$mrail;
		$_SESSION['s_rail']=$s_rail;
		$s_popplace=$mpopplace;
		$_SESSION['s_popplace']=$s_popplace;
		$s_teams=$mteams;
		$_SESSION['s_teams']=$s_teams;
	}

	require("globals.php");

	# Test to ensure user is logged in
	if (isset($_SESSION['id_user'])==FALSE){
		fail_access($_SERVER['QUERY_STRING']);
	}

	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_members");

	$teams=get_teams();
	$provinces=get_provinces();

	if($s_report=="map" && ENABLEMAP){
		 if (PHP_OS == "WINNT" || PHP_OS == "WIN32"){
			dl("php_mapscript.dll");
		}else{
			dl("php_mapscript.so");
 		}
		if ($_REQUEST["MAP_NAME"])
			 $gpoMap = ms_newMapObj(strval($_REQUEST['MAP_NAME']));
		else
			$gpoMap = ms_newMapObj("$mapData/map.map");
		require("lib_map.php");
	}

	# Set the search filter
	if ($search_scope!=NULL && $search!=NULL){
#print_r($_SESSION); print session_id(); exit;
		switch ($search_scope) {
			case "contname":
				$s_report="contcall";
				$s_filter="All";
				$search_filter="AND CONCAT(members.name_first,' ',members.name_last) LIKE '%".$search."%'";
				break 1;
			case "contcontact":
				$s_report="contcall";
				$s_filter="All";
				$search_filter="AND (members.phone_pager LIKE '%".$search."%' OR members.phone_home LIKE '%".$search."%' OR members.phone_work LIKE '%".$search."%' OR members.phone_cell LIKE '%".$search."%' OR members.phone_fax LIKE '%".$search."%' OR members.email LIKE '%".$search."%')";
				break 1;
			case "contaddress";
				$s_report="contmail";
				$s_filter="All";
				$search_filter="AND (address_street LIKE '%".$search."%' OR address_city LIKE '%".$search."%' OR address_pcode LIKE '%".$search."%' OR types_province.type$lang LIKE '%".$search."%')";
				break 1;
			case "teamname";
				$s_report="tsum";
				$s_filter="All";
				$search_filter="AND team_name LIKE '%".$search."%'";
				break 1;
			case "teamaddress";
				$s_report="tsum";
				$s_filter="All";
				$search_filter="AND (team_address LIKE '%".$search."%' OR team_city LIKE '%".$search."%' OR team_pcode LIKE '%".$search."%')";
				break 1;
			case "expsearch";
				break 1;
			case "expname";
				break 1;
			case "sattendee";
				$s_report="sattend";
				$s_filter="All";
				$search_filter="AND CONCAT(members.name_first,' ',members.name_last) LIKE '%".$search."%'";
				break 1;
			case "sweather":
				$s_report="ssum";
				$s_filter="All";
				$search_filter="AND types_weather.type$lang LIKE '%".$search."%'";
				break 1;
			case "smanager":
				$s_report="ssum";
				$s_filter="All";
		#		$search_filter="AND (CONCAT(members.name_first,' ',members.name_last) LIKE '%".$search."%' OR name_ic LIKE '%".$search."%')";
				$search_filter="AND (name_ic LIKE '%".$search."%')";
				break 1;
			case "ssubject";
				$s_report="ssum";
				$s_filter="All";
				$search_filter="AND subjects.subject_name LIKE '%".$search."%'";
				break 1;
			case "sactivity";
				$s_report="ssum";
				$s_filter="All";
				$search_filter="AND types_activity.type$lang LIKE '%".$search."%'";
				break 1;
			case "senvironment";
				$s_report="ssum";
				$s_filter="All";
				$search_filter="AND types_environment.type$lang LIKE '%".$search."%'";
				break 1;
			case "sreason";
				$s_report="ssum";
				$s_filter="All";
				$search_filter="AND types_reason.type$lang LIKE '%".$search."%'";
				break 1;
			case "scourse":
				$s_report="trcourses";
				$s_filter="All";
				$search_filter="AND courses.title$lang LIKE '%".$search."%'";
				break 1;
			case "smodule";
				$s_report="trmodules";
				$s_filter="All";
				$search_filter="AND modules.title$lang LIKE '%".$search."%'";
				break 1;
			case "sclass";
				$s_report="trclasses";
				$s_filter="All";
				$search_filter="AND (classes.location LIKE '%$search%' OR classes.when_start LIKE '%".$search."%')";
				break 1;
			case "sstudent":
				$s_report="trstudents";
				$s_filter="All";
				$search_filter="AND CONCAT(members.name_first,' ',members.name_last) LIKE '%".$search."%'";
				break 1;

		}
	}

	# Change display mode (report)
	# First check for access based on type of report, then process the command
	# Note: The team, instruction and stats summary don't require specific access

	if ($s_report=="users" || $s_report=="info"|| (preg_match("/^c/i",$s_report) && $a_memb != 0) || preg_match("/^[tnxwm]/i",$s_report) ||(preg_match("/^e/i",$s_report) && $a_exp != 0) || (preg_match("/^s/i",$s_report) && $a_search != 0) || (preg_match("/^tr/i",$s_report) && $a_train != 0)) {

		if (isset($_REQUEST['action']) && $_REQUEST['action'] == "print"){
			head("print");
		}else{
			head("main");
#			echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js_teams.php".SIDAND."\"></SCRIPT>";
		}

		# Handle display filter of None
		if($s_report=="info" && $s_report!="xsum"){
			#echo "<h2 class=BodyH2>(".$l['no_filter_mode_selected'].")</h2><br>";
			readfile("$locale/message_$lang.html");
			foot();
			exit;
		}

		#///////////////////////////////////
		#/// Setup query
		#///////////////////////////////////

		switch (true) {

			#///////////////////////////////////
			#/// Statistical Summary
			#///////////////////////////////////
			case ($s_report=="xsum"):
				require("base_summary.php");
				foot();
				exit;
				break 1;

			#///////////////////////////////////
			#/// Search Map
			#///////////////////////////////////
			case ($s_report=="map" && ENABLEMAP):

				if ($_REQUEST['navsubmit']=="2" || $province) {
					$query = "SELECT id_record, extent, type$lang AS province FROM types_province WHERE id_record='$s_province'";
					$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
					if (mysql_num_rows($result)) {
						$r = mysql_fetch_array($result);
						$ViewRegion=$r['extent'];
					}
				}else{
					$ViewRegion="";
				}

				echo "<h2 class=BodyH2>$l[$s_report]</h2>";
				$query2 = "SELECT id_record, type$lang AS province FROM types_province ORDER BY province";
				$result2 = mysql_query($query2) or die ($l['query_failed']);
				if (mysql_num_rows($result2)) {
					echo "<form name=\"MapSelect\">
							<input type=hidden name=navsubmit value=1>
							<input type=hidden name=mroad value=\"\">
							<input type=hidden name=mrail value=\"\">
							<input type=hidden name=mpopplace value=\"\">
							<input type=hidden name=mteams value=\"\">
							<table><tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
							<td class=BodyInputTd>
							<select class=BodyInp name=province value=\"$e_team_province\" onchange=\"if(document.NAV.mroad.checked){document.MapSelect.mroad.value='Y';};if(document.NAV.mrail.checked){document.MapSelect.mrail.value='Y';};if(document.NAV.mpopplace.checked){document.MapSelect.mpopplace.value='Y';};if(document.NAV.mteams.checked){document.MapSelect.mteams.value='Y';};MapSelect.submit();\">
							<option value=\"\">
							<option value=\"9999\">".$l['all'];
					while ($r2 = mysql_fetch_array($result2)) {
						echo "<option value=\"".$r2['id_record']."\"".($s_province==$r2['id_record'] ? " selected" : "").">".substr($r2['province'],0,20)."\n";
					}
					echo "</select></td><td class=BodyInputTd><p class=BodyTxt>&nbsp;&nbsp;".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>
							</td></tr></table></form>";
				}
				echo "<!--input readonly name=extent value='$minx,$miny,$maxx,$maxy' size=100><br-->";

				/**********************************************************************
				 **********************************************************************
				 * Copyright (c) 2000-2002, DM Solutions Group
				 *
				 * Permission is hereby granted, free of charge, to any person obtaining a
				 * copy of this software and associated documentation files (the "Software"),
				 * to deal in the Software without restriction, including without limitation
				 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
				 * and/or sell copies of the Software, and to permit persons to whom the
				 * Software is furnished to do so, subject to the following conditions:
				 *
				 * The above copyright notice and this permission notice shall be included
				 * in all copies or substantial portions of the Software.
				 *
				 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
				 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
				 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
				 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
				 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
				 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
				 * DEALINGS IN THE SOFTWARE.
				 **********************************************************************/

				/************************************************************************/
				/*               GMap mapping engine (PHP/MapScript version)            */
				/*                                                                      */
				/*      This application uses the PHP/MapScript MapServer extension     */
				/*      to navigate through a dataset.                                  */
				/*                                                                      */
				/*      See Also:                                                       */
				/*        http://mapserver.gis.umn.edu/                                 */
				/*        http://www2.dmsolutions.ca/webtools/php_mapscript/            */
				/*        http://www2.dmsolutions.ca/webtools/rosa/                     */
				/*        http://www2.dmsolutions.ca/gmap/gmap75.phtml                  */
				/************************************************************************/


				/* -------------------------------------------------------------------- */
				/*      extents set in the .map file.                                   */
				/*                                                                      */
				/*      max extents are 10% of the map.                                 */
				/* -------------------------------------------------------------------- */
				$dfTmpDeltaX = ($gpoMap->extent->maxx - $gpoMap->extent->minx)/10;
				$dfTmpDeltaY = ($gpoMap->extent->maxy - $gpoMap->extent->miny)/10;
				// For now, we disable the 10% buffer until we get new data
				$dfTmpDeltaX = 0;
				$dfTmpDeltaY = 0;

				$dfMapExtMinX = $gpoMap->extent->minx;
				$dfMapExtMinY = $gpoMap->extent->miny;
				$dfMapExtMaxX = $gpoMap->extent->maxx;
				$dfMapExtMaxY = $gpoMap->extent->maxy;

				$dfMaxExtMinX = $gpoMap->extent->minx - $dfTmpDeltaX;
				$dfMaxExtMinY = $gpoMap->extent->miny - $dfTmpDeltaY;
				$dfMaxExtMaxX = $gpoMap->extent->maxx + $dfTmpDeltaX;
				$dfMaxExtMaxY = $gpoMap->extent->maxy + $dfTmpDeltaY;


				GMap75CheckClick();

				$gszCommand = $_REQUEST["CMD"];
				if ( sizeof($gszCommand) == 0)
				{
					 $gszCommand = "ZOOM_IN";
				}

				/* -------------------------------------------------------------------- */
				/*      switch between the rosa java applet and simple html for         */
				/*      zooming and querying.                                           */
				/* -------------------------------------------------------------------- */

				if (strlen($_REQUEST["PREVIOUS_MODE"])==0)
					 $gbIsHtmlMode = 0;  // Start with Java On by default
				else
					 $gbIsHtmlMode = intval($_REQUEST["PREVIOUS_MODE"]);

				if ($_REQUEST['JavaOn_x'])
				  $gbIsHtmlMode = 0;

				if ($_REQUEST['JavaOff_x'])
				  $gbIsHtmlMode = 1;


				function IsHtmlMode()
				{
					 GLOBAL $gbIsHtmlMode;
					 return $gbIsHtmlMode;
				}
				?>

				<FORM METHOD=GET NAME="myform">
				  <TABLE BORDER="0" CELLSPACING="5" CELLPADDING="0">
					 <TR>

						<TD VALIGN=TOP ALIGN="RIGHT">
						  <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0">
							 <TR>
								<TD><IMG SRC="images/corner_TL_LB.jpg" WIDTH="4" HEIGHT="4"></TD>
								<TD BGCOLOR="#E2EFF5"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD><IMG SRC="images/corner_TR_LB.jpg" WIDTH="4" HEIGHT="4"></TD>
							 </TR>
							  <TR>
								 <TD BGCOLOR="#999999"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="1"></TD>
								 <TD BGCOLOR="#999999"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="1"></TD>
								 <TD BGCOLOR="#999999"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="1"></TD>
							  </TR>
							 <TR>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
							 </TR>
							 <TR>
								<TD BGCOLOR="#C1D8E3">&nbsp;</TD>
								<TD BGCOLOR="#999999">
								  <TABLE WIDTH="400" BORDER="0" CELLSPACING="1" CELLPADDING="0" HEIGHT="300">
									 <TR BGCOLOR="FFFFFF" ALIGN="CENTER">
										<TD class="map"><?php GMapDrawMap() ?></TD>
									 </TR>
								  </TABLE>
								</TD>
								<TD BGCOLOR="#C1D8E3">&nbsp;</TD>
							 </TR>
							 <TR>
								<TD BGCOLOR="#C1D8E3">&nbsp;</TD>
								<TD BGCOLOR="#FFFFFF" ALIGN="CENTER"><?php GMapDrawScaleBar() ?></TD>
								<TD BGCOLOR="#C1D8E3">&nbsp;</TD>
							 </TR>
							 <TR>
								<TD><IMG SRC="images/corner_BL_DB.jpg" WIDTH="4" HEIGHT="4"></TD>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD><IMG SRC="images/corner_BR_DB.jpg" WIDTH="4" HEIGHT="4"></TD>
							 </TR>
						  </TABLE>

						</TD>
					 </TR>
					 <TR>
						<TD ALIGN="CENTER">

						  <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0">
							 <TR>
								<TD><IMG SRC="images/corner_TL_LB.jpg" WIDTH="4" HEIGHT="4"></TD>
								<TD BGCOLOR="#E2EFF5"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD><IMG SRC="images/corner_TR_LB.jpg" WIDTH="4" HEIGHT="4"></TD>
							 </TR>
							 <TR ALIGN="CENTER">
								<TD BGCOLOR="#E2EFF5">&nbsp;</TD>
										  <TD BGCOLOR="#E2EFF5"><FONT FACE="Arial, Helvetica, sans-serif" SIZE="2"><B>Information</B></FONT></TD>
								<TD BGCOLOR="#E2EFF5">&nbsp;</TD>
							 </TR>
							  <TR>
								 <TD BGCOLOR="#999999"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="1"></TD>
								 <TD BGCOLOR="#999999"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="1"></TD>
								 <TD BGCOLOR="#999999"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="1"></TD>
							  </TR>
								<TR>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
							 </TR>
							 <TR>
								<TD BGCOLOR="#C1D8E3">&nbsp;</TD>
								<TD WIDTH=<?php echo $gpoMap->width; ?>><?php GMapDumpQueryResults($lang); ?></TD>
								<TD BGCOLOR="#C1D8E3">&nbsp;</TD>
							 </TR>
							 <TR>
								<TD><IMG SRC="images/corner_BL_DB.jpg" WIDTH="4" HEIGHT="4"></TD>
								<TD BGCOLOR="#C1D8E3"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="4"></TD>
								<TD><IMG SRC="images/corner_BR_DB.jpg" WIDTH="4" HEIGHT="4"></TD>
							 </TR>
						  </TABLE>

						</TD>
					 </TR>
					 <TR>
						<TD COLSPAN="3">&nbsp;</TD>
					 </TR>
					 <TR>
						<TD COLSPAN="3" BGCOLOR="#E2EFF5"><IMG SRC="images/pixel.gif" WIDTH="1" HEIGHT="2"></TD>
					 </TR>
					 <TR>
						<TD COLSPAN="3">&nbsp;</TD>
					 </TR>
				  </TABLE>
						<?php if ($_REQUEST["MAP_NAME"])
						  printf("<INPUT TYPE=HIDDEN NAME=MAP_NAME VALUE=\"%s\">",strval($_REQUEST["MAP_NAME"])); ?>
				</FORM>
				<?php

				foot();
				exit;
				break 1;

			#///////////////////////////////////
			#/// Contact Reports (Common Format)
			#///////////////////////////////////
			case (($s_report=="contadmin" || $s_report=="contdir" || $s_report=="contcall" || $s_report=="contalt" || $s_report=="contem" || $s_report=="contin") && ($a_memb != 0 || $a_diralt)):

				# Set the filter based on the contact report type
				switch ($s_report) {
					case "contadmin":
						$cont_filter="AND members.flag_admin=1";
						break 1;
					case "contdir":
						$cont_filter="AND members.flag_director=1";
						break 1;
					case "contcall":
						$cont_filter="";
						break 1;
					case "contalt":
						$cont_filter="AND members.flag_alternate=1";
						break 1;
					case "contem":
						$cont_filter="AND members.flag_emergency=1 AND teams.flag_ops=1";
						break 1;
				}

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"member_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_memb;

				# Set the email field
				$e_field="email";

				# Main Query: Set column headings and data fields
				$col[]=$l['full_name']; $col[]=$l['title']; $col[]=$l['phone_work']; $col[]=$l['phone_home']; $col[]=$l['phone_cell']; $col[]=$l['phone_pager']; $col[]=$l['phone_other']; $col[]=$l['email'];
				$dat[]="full_name"; $dat[]="title"; $dat[]="phone_work"; $dat[]="phone_home"; $dat[]="phone_cell"; $dat[]="phone_pager"; $dat[]="phone_other"; $dat[]="email";

				# Main Query: Set DB query
/*				$query="
					SELECT members.id_record AS id_record,
					CONCAT(members.name_first,' ',members.name_last) AS full_name,
					members.title AS title,
					IF(teams_members.id_teams,teams_members.id_teams,9999) AS team,
					members.team_province AS province,
					teams.team_name,
					members.phone_work,
					members.phone_home,
					members.phone_cell,
					members.phone_fax,
					members.phone_pager,
					members.phone_other,
					members.email
					FROM members
					LEFT JOIN teams_members ON members.id_record=teams_members.id_members
					LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
					LEFT JOIN teams ON teams_members.id_teams=teams.id_record
					WHERE ".(($a_diralt == 1 && ($s_report == "contdir" || $s_report =="contalt")) || ($a_all_teams == 1 && $a_province==-1) || ($s_report == "contem") ? "1=1" : "team_access.id_users='$id_recno' AND team_access.access_members>=1" )."
					".($s_province && $s_province!="All" ? "AND members.team_province='$s_province'" : "")."
					".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
					$cont_filter
					".($s_report == "contin" ? "AND members.flag_inactive='1'" : "AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)")."
					".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
					$search_filter
					GROUP BY members.id_record
					ORDER BY team_name, members.display_priority, members.name_last, members.name_first
					"; */
				$query="
					SELECT members.id_record AS id_record,
					CONCAT(members.name_first,' ',members.name_last) AS full_name,
					members.title AS title,
					IF(teams_members.id_teams,teams_members.id_teams,9999) AS team,
					members.team_province AS province,
					teams.team_name,
					members.phone_work,
					members.phone_home,
					members.phone_cell,
					members.phone_fax,
					members.phone_pager,
					members.phone_other,
					members.email
					FROM teams_members
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					LEFT JOIN members ON teams_members.id_members=members.id_record
					LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
					WHERE ".(($a_diralt == 1 && ($s_report == "contdir" || $s_report =="contalt")) || ($a_all_teams == 1 && $a_province==-1) || ($s_report == "contem") ? "1=1" : "team_access.id_users='$id_recno' AND team_access.access_members>=1" )."
					".($s_province && $s_province!="All" ? "AND members.team_province='$s_province'" : "")."
					".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
					$cont_filter
					".($s_report == "contin" ? "AND members.flag_inactive='1'" : "AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)")."
					".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
					$search_filter
					GROUP BY teams_members.id_record
					ORDER BY team_name, members.display_priority, members.name_last, members.name_first
					";

				break 1;

			#///////////////////////////////////
			#/// Certification by Level
			#///////////////////////////////////
			case ($s_report=="certlev" && $a_cert != 0):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"member_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_cert;

				# Main Query: Set column headings and data fields
				$col[]=$l['full_name']; $col[]=$l['team']; $col[]=$l['certification']; $col[]=$l['number']; $col[]=$l['certified']; $col[]=$l['expiry'];
				$dat[]="full_name"; $dat[]="team_name"; $dat[]="level"; $dat[]="cert_no"; $dat[]="certified"; $dat[]="expiry";

				# Main Query: Set DB query
				$query="
					SELECT members.id_record AS id_record,
					CONCAT(members.name_first,' ',members.name_last) AS full_name,
					members.title AS title,
					members.team_province AS province,
					teams.id_record AS team,
					teams.team_name AS team_name,
					CONCAT(certifications.id_types_certifications,'-',LPAD(certifications.id_record,5,'0')) as cert_no,
					certifications.id_types_certifications AS id_cert,
					certifications.date_certified AS certified,
					certifications.date_expires AS expiry,
					types_certifications.type$lang AS level
					FROM certifications
					LEFT JOIN members ON members.id_record=certifications.id_members
					LEFT JOIN teams_members ON teams_members.id_members=members.id_record
					LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
					WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND members.team_province='$s_province'" : "")."
					".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
					AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
					$search_filter
					GROUP BY certifications.id_record
					ORDER BY certifications.id_types_certifications, team, members.name_last, members.name_first
					";

				break 1;

			#///////////////////////////////////
			#/// Certification by Status (certified, expired, not certified)
			#///////////////////////////////////
			case ($s_report=="certstat" && $a_cert != 0):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"member_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_cert;

				# Main Query: Set column headings and data fields
				$col[]=$l['full_name']; $col[]=$l['team']; $col[]=$l['certification']; $col[]=$l['number']; $col[]=$l['certified']; $col[]=$l['expiry'];
				$dat[]="full_name"; $dat[]="team_name"; $dat[]="level"; $dat[]="cert_no"; $dat[]="certified"; $dat[]="expiry";

				# Main Query: Set DB query
				$query="
					SELECT members.id_record AS id_record,
					CONCAT(members.name_first,' ',members.name_last) AS full_name,
					members.title AS title,
					teams.id_record AS team,
					teams.team_name AS team_name,
					members.team_province AS province,
					CONCAT(certifications.id_types_certifications,'-',LPAD(certifications.id_record,5,'0')) as cert_no,
					certifications.id_types_certifications AS id_cert,
					certifications.date_certified AS certified,
					certifications.date_expires AS expiry,
					IF(certifications.date_expires AND certifications.date_certified, (IF(TO_DAYS(certifications.date_expires)>TO_DAYS(CURDATE()),\"Certified\",\"Expired\")), \"Not Certified\") as status,
					types_certifications.type$lang AS level
					FROM certifications
					LEFT JOIN members ON members.id_record=certifications.id_members
					LEFT JOIN teams_members ON teams_members.id_members=members.id_record
					LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
					WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND members.team_province='$s_province'" : "")."
					".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
					AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
					$search_filter
					GROUP BY certifications.id_record
					ORDER BY status, certifications.id_types_certifications, certifications.date_expires, team, members.name_last, members.name_first
					";

				break 1;


			#///////////////////////////////////
			#/// Certification by Team
			#///////////////////////////////////
			case ($s_report=="certteam" && $a_cert != 0):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"member_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_cert;

				# Main Query: Set column headings and data fields
				$col[]=$l['full_name']; $col[]=$l['certification']; $col[]=$l['number']; $col[]=$l['certified']; $col[]=$l['expiry'];
				$dat[]="full_name"; $dat[]="level"; $dat[]="cert_no"; $dat[]="certified"; $dat[]="expiry";

				# Main Query: Set DB query
				$query="
					SELECT members.id_record AS id_record,
					CONCAT(members.name_first,' ',members.name_last) AS full_name,
					members.title AS title,
					teams.id_record AS team,
					teams.team_name AS team_name,
					members.team_province AS province,
					CONCAT(certifications.id_types_certifications,'-',LPAD(certifications.id_record,5,'0')) as cert_no,
					certifications.id_types_certifications AS id_cert,
					certifications.date_certified AS certified,
					certifications.date_expires AS expiry,
					types_certifications.type$lang AS level
					FROM certifications
					LEFT JOIN members ON members.id_record=certifications.id_members AND certifications.id_members=members.id_record
					LEFT JOIN teams_members ON teams_members.id_members=members.id_record
					LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
					WHERE ".($a_all_teams!=1 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND members.team_province='$s_province'" : "")."
					".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
					AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
					$search_filter
					GROUP BY certifications.id_record
					ORDER BY team_name, certifications.id_types_certifications, members.name_last, members.name_first
					";

				break 1;

			#///////////////////////////////////
			#/// S/M Certifications by Team
			#///////////////////////////////////
			case ($s_report=="certsm" && $a_cert != 0):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"member_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_cert;

				# Main Query: Set column headings and data fields
				$col[]=$l['team']; $col[]=$l['full_name']; $col[]=$l['number']; $col[]=$l['test']; $col[]=$l['certified']; $col[]=$l['expiry']; $col[]=$l['search1']; $col[]=$l['search2']; $col[]=$l['agency']; $col[]=$l['user_id']; $col[]=$l['date'];
				$dat[]="team_name"; $dat[]="full_name"; $dat[]="cert_no"; $dat[]="date_test"; $dat[]="date_certified"; $dat[]="date_expires"; $dat[]="date_search1"; $dat[]="date_search2"; $dat[]="agency"; $dat[]="user"; $dat[]="cedit_time";

				# Main Query: Set DB query
				$query="
				SELECT members.id_record AS id_record,
				CONCAT(members.name_first,' ',members.name_last) AS full_name,
				members.title AS title,
				DATE_FORMAT(members.when_entered,'%W %M %D, %Y %H:%i:%s') AS medit_time,
				teams.id_record AS team,
				teams.team_name AS team_name,
				members.team_province AS province,
				users.full_name AS user,
				CONCAT(certifications.id_types_certifications,'-',LPAD(certifications.id_record,5,'0')) as cert_no,
				certifications.id_record AS record,
				DATE_FORMAT(certifications.when_entered,'%W %M %D, %Y %H:%i:%s') AS cedit_time,
				certifications.date_test,
				certifications.date_certified,
				certifications.date_expires,
				certifications.id_instructor,
				certifications.date_search1,
				certifications.flag_search1,
				certifications.date_search2,
				certifications.flag_search2,
				certifications.id_types_certifications,
				types_cert_agencies.agency_desc$lang AS agency,
				types_certifications.type$lang AS level
				FROM certifications
				LEFT JOIN members ON members.id_record=certifications.id_members
				LEFT JOIN users ON users.id_record=certifications.id_users
				LEFT JOIN teams_members ON teams_members.id_members=members.id_record
				LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
				LEFT JOIN types_cert_agencies ON types_cert_agencies.id_record=certifications.id_certifying_agency
				LEFT JOIN teams ON teams.id_record=teams_members.id_teams
				LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
				WHERE certifications.id_types_certifications='5'
				AND ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
				".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
				".($s_province && $s_province!="All" ? "AND members.team_province='$s_province'" : "")."
				".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
				AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
				$search_filter
				GROUP BY certifications.id_record
				ORDER BY team, members.name_last, members.name_first
				";

				break 1;


			#///////////////////////////////////
			#/// Contact Mailing
			#///////////////////////////////////
			case ($s_report=="contmail" && $a_memb != 0):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"member_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_memb;

				# Set column headings and data fields
				$col[]=$l['full_name']; $col[]=$l['title']; $col[]=$l['address'];
				$dat[]="full_name"; $dat[]="title"; $dat[]="address";

				# Set DB query
				$query="
					SELECT members.id_record AS id_record,
					CONCAT(members.name_first,' ',members.name_last) AS full_name,
					CONCAT(address_street,IF(address_street!='',', ',''),address_city,IF(address_city!='',', ',''),address_pcode,IF(address_city!='',', ',''),types_province.type$lang) AS address,
					members.title AS title,
					members.team_province AS province,
					teams_members.id_teams AS team
					FROM members
					LEFT JOIN teams_members ON members.id_record=teams_members.id_members
					LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
					LEFT JOIN types_province ON members.id_address_province=types_province.id_record
					WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND teams_members.id_teams='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND members.team_province='$s_province'" : "")."
					$cont_filter
					".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
					AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
					$search_filter
					GROUP BY members.id_record
					ORDER BY team, members.display_priority, members.name_last, members.name_first
					";

				break 1;

			#///////////////////////////////////
			#/// Search Summary
			#///////////////////////////////////
			case ($s_report=="ssum" && $a_search != 0):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"sr_edit.php?mode=[mode]&s_id=[recno]".SIDAND."\">[rectext]</a>";
				$team_access=$a_search;

				# Set column headings and data fields
				$col[]=$l['date']; $col[]=$l['file_id']; $col[]=$l['team']; $col[]=$l['type_normal']; $col[]=$l['activity']; $col[]=$l['total_hours'];
				$dat[]="when_alerted"; $dat[]="gsar_file_id"; $dat[]="team_name"; $dat[]="event"; $dat[]="activity"; $dat[]="hours_total";

				# Set DB query
				$query="
					SELECT team_search.id_record,
					DATE_FORMAT(team_search.when_alerted,'%Y-%m-%d') AS when_alerted,
					team_search.description,
					IF(team_search.flag_complete,CONCAT('<font color=green>',types_province.prefix,team_search.id_search,'-',team_search.gsar_sub_id,'</font>'),CONCAT('<font color=red>',types_province.prefix,team_search.id_search,'-',team_search.gsar_sub_id,'</font>')) AS gsar_file_id,
					search.police_file_id,
					search.name_ic,
					subjects.subject_name,
					types_events.type$lang AS event,
					types_activity.type$lang AS activity,
					types_environment.type$lang AS environment,
					types_reason.type$lang AS reason,
					team_search.id_teams AS team,
					teams.team_name AS team_name,
					teams.id_address_province AS province,
					team_search.cost_total ,
					team_search.hours_total,
					types_province.prefix
					FROM team_search
					LEFT JOIN search ON team_search.id_search=search.id_record
					LEFT JOIN teams ON team_search.id_teams=teams.id_record
					LEFT JOIN types_events ON search.id_types_events=types_events.id_record
					LEFT JOIN types_activity ON search.id_types_activity=types_activity.id_record
					LEFT JOIN subjects ON search.id_record=subjects.id_search
					LEFT JOIN types_weather ON search.id_weather=types_weather.id_record
					LEFT JOIN types_environment ON search.id_types_environment=types_environment.id_record
					LEFT JOIN types_reason ON search.id_types_reason_1=types_reason.id_record AND search.id_types_reason_2=types_reason.id_record
					LEFT JOIN types_province ON types_province.id_record=teams.id_address_province
					WHERE 1=1
					$search_filter
					".($s_period ? period_filter($s_period,"team_search.when_alerted") : "" )."
					".($s_filter && $s_filter != "All" && $s_filter != "None" ? " AND team_search.id_teams='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND search.id_province='$s_province'" : "")."
					GROUP BY gsar_file_id
					ORDER BY when_alerted
					";

# These lines restrict searches displayed to those specifically granted access to
#					WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
#					LEFT JOIN team_access ON search.id_teams=team_access.id_teams AND team_access.access_searches>=1

				break 1;


			#///////////////////////////////////
			#/// Search Attendance Report
			#///////////////////////////////////
			case ($s_report=="sattend"):
				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"sr_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_search;

#				echo "<h2 class=BodyH2><img src=\"images/caution.gif\" border=0 alt=\"information\">&nbsp;&nbsp;".$l['not_available'].".</h2><br>";
				$query1="SELECT attend_persons.id_members,
							teams.id_record AS team,
							teams.team_name AS team_name,
							teams.id_address_province AS province,
							CONCAT(members.name_first,' ',members.name_last) AS full_name
							FROM attend_persons
							LEFT JOIN members ON members.id_record=attend_persons.id_members
							LEFT JOIN teams_members ON teams_members.id_members=members.id_record
							LEFT JOIN teams ON teams.id_record=teams_members.id_teams
							LEFT JOIN types_position ON types_position.id_record=attend_persons.id_types_position
							LEFT JOIN team_search ON team_search.id_record=attend_persons.id_search
							LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
							LEFT JOIN types_province ON types_province.id_record=teams.id_address_province
							WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
								".($s_filter && $s_filter!="All" ? "AND teams.id_record='$s_filter'" : "")."
								".($s_period ? period_filter($s_period,"team_search.when_alerted") : "" )."
								".($s_province && $s_province!="All" ? "AND teams.id_address_province='$s_province'" : "")."
								$cont_filter
								".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
								AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
								$search_filter
							GROUP BY members.id_record
							";
				$result1 = mysql_query($query1) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query1");
				$row_count = mysql_num_rows($result1);
				if (mysql_num_rows($result1)) {
						echo "<p class=BodyH2>$l[$s_report]</p>";
						echo "<p class=BodyTxt>".($s_province && $s_province!="All" ? $provinces[$s_province] : $l['all']).", ".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>";
						echo "<table class=BodyTbl cellpadding=2 cellspacing=0>";

					while ($r1 = mysql_fetch_array($result1)) {
						echo "<tr><td class=BodyTd><p class=BodyH3>".$r1['full_name'].", ".$r1['team_name']."</p></td></tr>";
						$query2 = "SELECT team_search.id_record AS id_record,
										DATE_FORMAT(team_search.when_alerted,'%Y/%m/%d') AS d_start,
										DATE_FORMAT(search.when_concluded,'%Y/%m/%d') AS d_end,
										types_position.type$lang AS position,
										attend_persons.hours AS hours,
										search.location AS location,
										CONCAT(types_province.prefix,team_search.id_search,'-',team_search.gsar_sub_id) AS gsar_file_id
										FROM attend_persons
										LEFT JOIN team_search ON team_search.id_record=attend_persons.id_search
										LEFT JOIN search ON search.id_record=team_search.id_search
										LEFT JOIN types_position ON types_position.id_record=attend_persons.id_types_position
										LEFT JOIN team_access ON team_access.id_teams=team_search.id_teams OR team_access.id_teams=9999
										LEFT JOIN teams ON teams.id_record=team_search.id_teams
										LEFT JOIN types_province ON types_province.id_record=search.id_province
										WHERE attend_persons.id_members='".$r1['id_members']."'
										".($s_period ? period_filter($s_period,"team_search.when_alerted") : "" )."
										GROUP BY attend_persons.id_record
										ORDER BY d_start";
						$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
						if (mysql_num_rows($result2)) {
							$total_hours = 0;
							echo "<tr><td class=BodyTd><table class=BodyRepTbl border=1 cellpadding=2 cellspacing=0><tr>";
							echo "<td class=BodyRepTh><p class=BodyRepH2>+</p></td>";
							echo "<td class=BodyRepTh><p class=BodyRepH2>".$l['date_start']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['date_end']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['file_id']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['location']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['position']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['hours']."</p></td>
									</tr>";
							while ($r2 = mysql_fetch_array($result2)) {
								echo "<tr>";
								# Set link column for edit/display
								if ( ($r1['team'] == 0 || $r1['team'] == 9999 || $r1['team'] == "") && $a_admin == 1) {
									# This record has no team assignment and user is admin
									echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/blue.gif\" border=0>",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[mode\]","update",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[team\]","1",$link)))))."</td>";
								}elseif ($team_access[$r1['team']] >= 2 ) {
									# This user has edit access this record
									echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/blue.gif\" border=0>",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[mode\]","update",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[team\]",$r1['team'],$link)))))."</td>";
								}elseif ($team_access[$r1['team']] == 1 && $s_report!="wcal") {
									# This user has read access for this record
									echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/grey.gif\" border=0>",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[mode\]","display",ereg_replace("\[team\]",$r1['team'],$link))))."</td>";
								}else{
									# This user has no access to view or edit record detail
									echo "<td class=BodyRepTd>&nbsp;</td>";
								}

							 echo "<td class=BodyRepTd><p class=BodyRepTxt>".($r2['d_start'] ? $r2['d_start'] : "&nbsp;")."</td>
								 	<td class=BodyRepTd><p class=BodyRepTxt>".($r2['d_end'] ? $r2['d_end'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['gsar_file_id'] ? $r2['gsar_file_id'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['location'] ? $r2['location'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['position'] ? $r2['position'] : "&nbsp;")."</td>
								 	<td class=BodyRepTd><p class=BodyRepTxt>".($r2['hours'] ? $r2['hours'] : "&nbsp;")."</td>
							 		</tr>";
							 $total_hours = $total_hours + $r2['hours'];
							}
							echo "<tr><td class=BodyRepTd colspan=3><p class=BodyRepTxt><strong>".$l['total_hours']."</strong></td>
									<td class=BodyRepTd colspan=6><p class=BodyRepTxt><strong>$total_hours</strong></td></tr>";
							echo "</table></td></tr>";
						}
						echo "<tr><td class=BodyTd><hr></td></tr>";
					}
					echo "</table>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyH2>$l[$s_report]</p>";
					echo "<p class=BodyTxt>".($s_province && $s_province!="All" ? $provinces[$s_province] : $l['all']).", ".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>";
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}

				foot();
				exit;

			break 1;


			#///////////////////////////////////
			#/// Team Summary
			#///////////////////////////////////
			case ($s_report=="tsum"):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"team_edit.php?mode=[mode]&s_id=[recno]".SIDAND."\">[rectext]</a>";
				$team_access=$a_memb;

				# Set column headings and data fields
				$col[]=$l['team']; $col[]=$l['established']; $col[]=$l['address'];  $col[]=$l['phone_1']; $col[]=$l['phone_2']; $col[]=$l['phone_cell']; $col[]=$l['phone_pager']; $col[]=$l['phone_fax']; $col[]=$l['email'];
				$dat[]="team_name"; $dat[]="date_established"; $dat[]="address";  $dat[]="phone_1"; $dat[]="phone_2"; $dat[]="phone_cell"; $dat[]="phone_pager"; $dat[]="phone_fax"; $dat[]="email";

				# Set DB query
				$query="
					SELECT teams.id_record AS id_record,
					teams.id_record AS team,
					team_name,
					teams.id_address_province AS province,
					date_established,
					phone_1,
					phone_2,
					phone_pager,
					phone_cell,
					phone_fax,
					email,
					CONCAT(team_address,IF(team_address!='',', ',''),team_city,IF(team_city!='',', ',''),team_pcode,IF(team_pcode!='',', ',''),types_province.type$lang) AS address
					FROM teams
					LEFT JOIN types_province ON teams.id_address_province=types_province.id_record
					WHERE 1=1
					".($s_filter && $s_filter != "All" && $s_filter != "None" ? " AND teams.id_record='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND teams.id_address_province='$s_province'" : "")."
#					".($a_province!=-1 ? "AND (teams.id_address_province='$a_province' OR teams.id_address_province=9999)" : "")."
					$search_filter
					ORDER BY team_name
					";

				break 1;

			#///////////////////////////////////
			#/// Event Calendar
			#///////////////////////////////////
			case ($s_report=="wcal"):

				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"event_edit.php?mode=[mode]&s_id=[recno]".SIDAND."\">[rectext]</a>";
				$team_access=$a_memb;

				# Set column headings and data fields
				$col[]=$l['date']; $col[]=$l['team']; $col[]=$l['category'];  $col[]=$l[location]; $col[]=$l['description'];
				$dat[]="date"; $dat[]="team_name"; $dat[]="category";  $dat[]="location"; $dat[]="description";

				# Set DB query
				$query="
					SELECT calendar.id_record AS id_record,
					calendar.id_teams AS team,
					calendar.id_province AS province,
					IF (calendar.id_province!=9999,types_province.type$lang,'".$l['all']."') AS province_name,
					IF (calendar.id_teams!=9999,teams.team_name,'".$l['all']."') AS team_name,
					calendar.date,
					TO_DAYS(calendar.date) AS sort_date,
					types_cal_events.type$lang AS category,
					calendar.description,
					calendar.location
					FROM calendar
					LEFT JOIN types_cal_events ON calendar.id_category=types_cal_events.id_record
					LEFT JOIN teams ON calendar.id_teams=teams.id_record
					LEFT JOIN types_province ON types_province.id_record=calendar.id_province
					LEFT JOIN team_access ON team_access.id_teams=calendar.id_teams OR team_access.id_teams=9999
					WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_period ? period_filter($s_period,"calendar.date") : "" )."
					".($s_filter && $s_filter != "All" && $s_filter != "None" ? " AND calendar.id_teams='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND calendar.id_province='$s_province'" : "")."
					$search_filter
					GROUP BY calendar.id_record
					ORDER BY sort_date
					";

				break 1;

			#///////////////////////////////////
			#/// Courses
			#///////////////////////////////////
			case ($s_report=="trcourses"):
				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"tms_course_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_train;

				# Set column headings and data fields
				$col[]=$l['province']; $col[]=$l['team']; $col[]=$l['course']; $col[]=$l['certification'];
				$dat[]="province_name"; $dat[]="team_name"; $dat[]="title"; $dat[]="certification";

				# Set DB query
				$query="
					SELECT courses.id_record AS id_record,
					courses.title$lang AS title,
					courses.id_province AS province,
					IF(courses.id_province=9999,'".$l['all']."',types_province.type$lang) AS province_name,
					IF(courses.id_teams=9999,'".$l['all']."',teams.team_name) AS team_name,
					courses.id_teams AS team,
					types_certifications.type$lang AS certification
					FROM courses
					LEFT JOIN types_certifications ON courses.id_certifications=types_certifications.id_record
					LEFT JOIN team_access ON team_access.id_teams=courses.id_teams OR team_access.id_teams=9999
					LEFT JOIN teams ON teams.id_record=courses.id_teams
					LEFT JOIN types_province ON types_province.id_record=courses.id_province
				WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND teams.id_record='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND courses.id_province='$s_province'" : "")."
					$cont_filter
					".($a_province!=-1 ? "AND (courses.id_province='$a_province' OR courses.id_province=9999)" : "")."
					$search_filter
					GROUP BY courses.id_record
					ORDER BY team, title
					";

				break 1;

			#///////////////////////////////////
			#/// TMS: Modules
			#///////////////////////////////////
			case ($s_report=="trmodules"):
				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"tms_course_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_train;

				# Set column headings and data fields
				$col[]=$l['team']; $col[]=$l['course']; $col[]=$l['module']; $col[]=$l['certification'];
				$dat[]="team_name"; $dat[]="course_title"; $dat[]="module_title"; $dat[]="certification";

				# Set DB query
				$query="
					SELECT courses.id_record AS id_record,
					modules.title$lang AS module_title,
					courses.title$lang AS course_title,
					IF(courses.id_province=9999,'".$l['all']."',types_province.type$lang) AS province_name,
					IF(courses.id_teams=9999,'".$l['all']."',teams.team_name) AS team_name,
					teams.id_record AS team,
					courses.id_province AS province,
					types_certifications.type$lang AS certification
					FROM modules
					LEFT JOIN courses ON courses.id_record=modules.id_course
					LEFT JOIN types_certifications ON courses.id_certifications=types_certifications.id_record
					LEFT JOIN team_access ON team_access.id_teams=courses.id_teams OR team_access.id_teams=9999
					LEFT JOIN teams ON teams.id_record=courses.id_teams
					LEFT JOIN types_province ON types_province.id_record=courses.id_province
				WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND teams.id_record='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND teams.id_address_province='$s_province'" : "")."
					$cont_filter
					".($a_province!=-1 ? "AND (courses.id_province='$a_province' OR courses.id_province=9999)" : "")."
					$search_filter
					GROUP BY modules.id_record
					ORDER BY team, course_title, module_title
					";

				break 1;

			#///////////////////////////////////
			#/// TMS: Classes
			#///////////////////////////////////
			case ($s_report=="trclasses"):
				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"tms_class_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_train;

				# Set column headings and data fields
				$col[]=$l['date']; $col[]=$l['location']; $col[]=$l['team']; $col[]=$l['course']; $col[]=$l['module']; $col[]=$l['certification'];
				$dat[]="when_start"; $dat[]="location"; $dat[]="team_name"; $dat[]="title"; $dat[]="module_title"; $dat[]="certification";

				# Set DB query
				$query="
					SELECT classes.id_record AS id_record,
					courses.title$lang AS title,
					classes.id_province AS province,
					classes.id_teams AS team,
					IF(classes.id_province=9999,'".$l['all']."',types_province.type$lang) AS province_name,
					IF(classes.id_teams=9999,'".$l['all']."',teams.team_name) AS team_name,
					classes.location,
					classes.when_start,
					classes.when_end,
					modules.title$lang AS module_title,
					/*teams.id_record AS team,*/
					types_certifications.type$lang AS certification
					FROM classes
					LEFT JOIN modules ON modules.id_record=classes.id_module
					LEFT JOIN courses ON courses.id_record=modules.id_course
					LEFT JOIN types_certifications ON courses.id_certifications=types_certifications.id_record
					LEFT JOIN team_access ON team_access.id_teams=courses.id_teams OR team_access.id_teams=9999
					LEFT JOIN teams ON teams.id_record=courses.id_teams
					LEFT JOIN types_province ON types_province.id_record=classes.id_province
				WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND teams.id_record='$s_filter'" : "")."
					".($s_period ? period_filter($s_period,"classes.when_start") : "" )."
					".($s_province && $s_province!="All" ? "AND classes.id_province='$s_province'" : "")."
					$cont_filter
					".($a_province!=-1 ? "AND (classes.id_province='$a_province' OR classes.id_province=9999)" : "")."
					$search_filter
					GROUP BY classes.id_record
					ORDER BY when_start, location
					";

				break 1;

			#///////////////////////////////////
			#/// TMS: Students
			#///////////////////////////////////
			case ($s_report=="trstudents"):
				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"tms_class_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_train;

#				echo "<h2 class=BodyH2><img src=\"images/caution.gif\" border=0 alt=\"information\">&nbsp;&nbsp;".$l['not_available'].".</h2><br>";
				$query1="SELECT
							attend_classes.id_members,
							teams.team_name AS team_name,
							CONCAT(members.name_first,' ',members.name_last) AS full_name
							FROM attend_classes
							LEFT JOIN members ON members.id_record=attend_classes.id_members
							LEFT JOIN classes ON classes.id_record=attend_classes.id_classes
							LEFT JOIN teams_members ON teams_members.id_members=attend_classes.id_members
							LEFT JOIN teams ON teams.id_record=teams_members.id_teams
							LEFT JOIN team_access ON team_access.id_teams=teams_members.id_teams OR team_access.id_teams=9999
							LEFT JOIN types_province ON types_province.id_record=teams.id_address_province
							WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'" : "1=1" )."
								".($s_filter && $s_filter!="All" ? "AND teams.id_record='$s_filter'" : "")."
								".($s_period ? period_filter($s_period,"classes.when_start") : "" )."
								".($s_province && $s_province!="All" ? "AND teams.id_address_province='$s_province'" : "")."
								$cont_filter
								".($a_province!=-1 ? "AND members.team_province='$a_province'" : "")."
								AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
								$search_filter
							GROUP BY members.id_record
							";
				$result1 = mysql_query($query1) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query1");
				$row_count = mysql_num_rows($result1);
				if (mysql_num_rows($result1)) {
						echo "<p class=BodyH2>$l[$s_report]</p>";
						echo "<p class=BodyTxt>".($s_province && $s_province!="All" ? $provinces[$s_province] : $l['all']).", ".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>";
						echo "<table class=BodyTbl cellpadding=2 cellspacing=0>";

					while ($r1 = mysql_fetch_array($result1)) {
						echo "<tr><td class=BodyTd><p class=BodyH3>".$r1['full_name'].", ".$r1['team_name']."</p></td></tr>";
						$query2 = "SELECT
										classes.id_record AS id_record,
										attend_classes.grade,
										attend_classes.instructor,
										courses.title$lang AS title,
										IF(classes.id_province=9999,'".$l['all']."',types_province.type$lang) AS province_name,
										IF(classes.id_teams=9999,'".$l['all']."',teams.team_name) AS team_name,
										classes.location,
										ROUND(((UNIX_TIMESTAMP(classes.when_end)-UNIX_TIMESTAMP(classes.when_start))/60/60),2) as hours,
										DATE_FORMAT(classes.when_start,'%Y-%m-%d') AS d_start,
										DATE_FORMAT(classes.when_end,'%Y-%m-%d') AS d_end,
										modules.title$lang AS module_title,
										teams.id_record AS team,
										teams.id_address_province AS province,
										types_certifications.type$lang AS certification
										FROM attend_classes
										LEFT JOIN classes ON classes.id_record=attend_classes.id_classes
										LEFT JOIN modules ON modules.id_record=classes.id_module
										LEFT JOIN courses ON courses.id_record=modules.id_course
										LEFT JOIN types_certifications ON courses.id_certifications=types_certifications.id_record
										LEFT JOIN team_access ON team_access.id_teams=courses.id_teams OR team_access.id_teams=9999
										LEFT JOIN teams ON teams.id_record=classes.id_teams
										LEFT JOIN types_province ON types_province.id_record=classes.id_province
										WHERE attend_classes.id_members='".$r1['id_members']."'
										".($a_province!=-1 ? "AND classes.id_province='$a_province'" : "")."
								".($s_period ? period_filter($s_period,"classes.when_start") : "" )."
										GROUP BY attend_classes.id_record
										ORDER BY classes.when_start";
						$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
						if (mysql_num_rows($result2)) {
							$total_hours = 0;
							echo "<tr><td class=BodyTd><table class=BodyRepTbl border=1 cellpadding=2 cellspacing=0><tr>";
							echo "<td class=BodyRepTh><p class=BodyRepH2>+</p></td>";
							echo "<td class=BodyRepTh><p class=BodyRepH2>".$l['date_start']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['date_end']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['hours']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['title']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['module']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['grade']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>I</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['certification']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['location']."</p></td>
									<td class=BodyRepTh><p class=BodyRepH2>".$l['province']."</p></td>
									</tr>";
							while ($r2 = mysql_fetch_array($result2)) {
								echo "<tr>";
								# Set link column for edit/display
								if ( ($r['team'] == 0 || $r['team'] == 9999 || $r['team'] == "") && $a_admin == 1) {
									# This record has no team assignment and user is admin
									echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/blue.gif\" border=0>",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[mode\]","update",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[team\]","1",$link)))))."</td>";
								}elseif ($team_access[$r['team']] >= 2 ) {
									# This user has edit access this record
									echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/blue.gif\" border=0>",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[mode\]","update",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[team\]",$r['team'],$link)))))."</td>";
								}elseif ($team_access[$r['team']] == 1 && $s_report!="wcal") {
									# This user has read access for this record
									echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/grey.gif\" border=0>",ereg_replace("\[recno\]",$r2['id_record'],ereg_replace("\[mode\]","display",ereg_replace("\[team\]",$r['team'],$link))))."</td>";
								}else{
									# This user has no access to view or edit record detail
									echo "<td class=BodyRepTd>&nbsp;</td>";
								}

							 echo "<td class=BodyRepTd><p class=BodyRepTxt>".($r2['d_start'] ? $r2['d_start'] : "&nbsp;")."</td>
								 	<td class=BodyRepTd><p class=BodyRepTxt>".($r2['d_end'] ? $r2['d_end'] : "&nbsp;")."</td>
								 	<td class=BodyRepTd><p class=BodyRepTxt>".($r2['hours'] ? $r2['hours'] : "&nbsp;")."</td>
								 	<td class=BodyRepTd><p class=BodyRepTxt>".($r2['title'] ? $r2['title'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['module_title'] ? $r2['module_title'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['grade'] ? $r2['grade'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['instructor']==1 ? substr($l['yes'],0,1) : substr($l['no'],0,1))."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['certification'] ? $r2['certification'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['location'] ? $r2['location'] : "&nbsp;")."</td>
							 		<td class=BodyRepTd><p class=BodyRepTxt>".($r2['province_name'] ? $r2['province_name'] : "&nbsp;")."</td>
							 		</tr>";
							 $total_hours = $total_hours + $r2['hours'];
							}
							echo "<tr><td class=BodyRepTd colspan=3><p class=BodyRepTxt><strong>".$l['total_hours']."</strong></td>
									<td class=BodyRepTd colspan=8><p class=BodyRepTxt><strong>$total_hours</strong></td></tr>";
							echo "</table></td></tr>";
						}
						echo "<tr><td class=BodyTd><hr></td></tr>";
					}
					echo "</table>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyH2>$l[$s_report]</p>";
					echo "<p class=BodyTxt>".($s_province && $s_province!="All" ? $provinces[$s_province] : $l['all']).", ".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>";
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}

				foot();
				exit;

			break 1;

			#///////////////////////////////////
			#/// Certification Levels
			#///////////////////////////////////
			case ($s_report=="trcerts"):
				# Set the security access for display only, display detail, and update link
				$link="<a class=BodyLink href=\"cert_edit.php?mode=[mode]&s_id=[recno]&t_id=[team]".SIDAND."\">[rectext]</a>";
				$team_access=$a_cert;

				# Set column headings and data fields
				$col[]=$l['province']; $col[]=$l['team']; $col[]=$l['certification'];
				$dat[]="province_name"; $dat[]="team_name";  $dat[]="certification";

				# Set DB query
				$query="
					SELECT types_certifications.id_record,
					types_certifications.id_teams AS team,
					types_certifications.type$lang AS certification,
					types_certifications.id_province AS province,
					IF (types_certifications.id_province!=9999,types_province.type$lang,'".$l['all']."') AS province_name,
					IF (types_certifications.id_teams!=9999,teams.team_name,'".$l['all']."') AS team_name
					FROM types_certifications
					LEFT JOIN types_province ON types_province.id_record=types_certifications.id_province
					LEFT JOIN teams ON teams.id_record=types_certifications.id_teams
					LEFT JOIN team_access ON team_access.id_teams=types_certifications.id_teams OR team_access.id_teams=9999
					WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno'".($a_province!=-1 ? " OR (types_certifications.id_province='$a_province' OR types_certifications.id_province=9999)" : "") : "1=1" )."
					".($s_filter && $s_filter!="All" ? "AND types_certifications.id_teams='$s_filter'" : "")."
					".($s_province && $s_province!="All" ? "AND types_certifications.id_province='$s_province'" : "")."
					$cont_filter
					$search_filter
					GROUP BY types_certifications.id_record
					ORDER BY team_name
					";

				break 1;

			#///////////////////////////////////
			#/// Users
			#///////////////////////////////////
			case ($s_report=="users"):

				# Set the edit/detail link
				$link="&nbsp;";
				$team_access=$a_admin;

				# Set the email field
				$e_field="email";

				if($s_filter && $s_filter!="All"){
					# Set column headings and data fields
					$col[]=$l['full_name']; $col[]=$l['phone_1']; $col[]=$l[email]; $col[]=$l['expires']; $col[]="Dir/Alt"; $col[]="Admin"; $col[]="A_search"; $col[]="A_memb"; $col[]="A_cert"; $col[]="A_train";
					$dat[]="full_name"; $dat[]="phone"; $dat[]="email"; $dat[]="when_expires"; $dat[]="a_diralt"; $dat[]="a_admin"; $dat[]="access_searches"; $dat[]="access_members"; $dat[]="access_training"; $dat[]="access_certifications";

					# Set DB query
					$query="
						SELECT users.*,
						IF(flag_admin,'Y','N') AS a_admin,
						IF(flag_diralt,'Y','N') AS a_diralt,
						team_access.access_searches,
						team_access.access_members,
						team_access.access_training,
						team_access.access_certifications
						FROM users
						LEFT JOIN team_access ON team_access.id_users=users.id_record
						LEFT JOIN teams ON team_access.id_teams=teams.id_record OR team_access.id_teams=9999
						WHERE team_access.id_teams='$s_filter' OR team_access.id_teams=9999 OR users.flag_admin=1
						".($s_province && $s_province!="All" ? " AND (auth_province='$s_province')" : "")."
						".($a_province!=-1 ? "AND (teams.id_address_province='$a_province' OR teams.id_address_province=9999)" : "")."
						GROUP BY users.id_record
						ORDER BY users.full_name
						";
				}else{
					# Set column headings and data fields
					$col[]=$l['full_name']; $col[]=$l['phone_1']; $col[]=$l[email]; $col[]=$l['expires']; $col[]="Dir/Alt"; $col[]="Admin";
					$dat[]="full_name"; $dat[]="phone"; $dat[]="email"; $dat[]="when_expires"; $dat[]="a_diralt"; $dat[]="a_admin";

					# Set DB query
					$query="
						SELECT users.*,
						IF(flag_admin,'Y','N') AS a_admin,
						IF(flag_diralt,'Y','N') AS a_diralt
						FROM users
						LEFT JOIN team_access ON team_access.id_users=users.id_record
						LEFT JOIN teams ON team_access.id_teams=teams.id_record OR team_access.id_teams=9999
						".($s_filter && $s_filter!="All" ? "WHERE team_access.id_teams='$s_filter' OR team_access.id_teams=9999 OR users.flag_admin=1" : "WHERE 1=1")."
						".($s_province  && $s_province!="All" ? " AND (auth_province='$s_province')" : "")."
						".($a_province!=-1 ? "AND (teams.id_address_province='$a_province' OR teams.id_address_province=9999)" : "")."
						GROUP BY users.id_record
						ORDER BY users.full_name
						";
				}
				break 1;

			#///////////////////////////////////
			#/// Default - No Match
			#///////////////////////////////////

			default:
				echo $l['no_results'];
				foot();
				exit;

		}

		#///////////////////////////////////
		#/// Perform the query
		#///////////////////////////////////
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		$row_count = mysql_num_rows($result);
		# Initialize Email Link
		if ($e_field){$e_all="<a href='mailto:";}

		# Display the results/report

		# Set the table data full span width for colspan parameter
		$fullspan=(count($col)+count($sub_col))+1;

		if (mysql_num_rows($result)) {
			echo "<p class=BodyH2>$l[$s_report]</p>";
			echo "<p class=BodyTxt>".($s_province && $s_province!="All" ? $provinces[$s_province] : $l['all']).", ".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>";
			echo "<table class=BodyRepTbl cellpadding=2 cellspacing=0>";

			if (substr($s_report,0,1)!="c"||$s_report=="certsm"){
					# Display column headings
					echo "<tr>";
					echo "<td class=BodyRepTh><p class=BodyRepH2>+</p></td>";
					foreach ($col as $column){
							echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
					}
					echo "</tr>";
			}

			# Display the table data
			while ($r = mysql_fetch_array($result)) {

				if ((substr($s_report,0,3)=="con" || $s_report=="certteam") && $r['team']!=$team_index){


					# Display email all link
					if (substr($s_report,0,3)=="con" && $e_all!="<a href='mailto:" && $e_all!=""){
						echo "<tr><td class=BodyRepTd colspan=" . (count($col)+count($sub_col)) . "><p class=BodyRepTxt>$e_all'>".$l['email_all']."</a></p></td></tr>";
						# Reset Email Link
						$e_all="<a class=BodyLink href='mailto:";
					}


					# Display Team Information
					$team_index=$r['team'];
					if ($team_index != 9999){
						$team_query="SELECT * FROM teams WHERE id_record='$team_index'";
						$team_result = mysql_query($team_query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$team_query");
						$team_info = mysql_fetch_array($team_result);
						if (mysql_num_rows($result)) {
							echo "<tr><td class=BodyRepThSub colspan=$fullspan><font class=BodyRepH2>".$team_info['team_name']."".($team_info['team_city'] ? ", ".$team_info['team_city'] : "")."</font><br>
									<font class=BodyHsub>
									".($team_info['phone_1'] ? "&nbsp;&nbsp;".$l['phone_1'].": ".$team_info['phone_1'] : "")."
									".($team_info['phone_2'] ? "&nbsp;&nbsp;".$l['phone_2'].": ".$team_info['phone_2'] : "")."
									".($team_info['phone_pager'] ? "&nbsp;&nbsp;".$l['phone_pager'].": ".$team_info['phone_pager'] : "")."
									".($team_info['phone_cell'] ? "&nbsp;&nbsp;".$l['phone_cell'].": ".$team_info['phone_cell'] : "")."
									".($team_info['phone_fax'] ? "&nbsp;&nbsp;".$l['phone_fax'].": ".$team_info['phone_fax'] : "")."
									".($team_info['email'] ? "&nbsp;&nbsp;".$l['email'].": ".$team_info['email'] : "")."
									</font>
									</td></tr>";
						}
					}else{
						echo "<tr><td class=BodyRepTh colspan=" . (count($col)+count($sub_col)) . "><p class=BodyRepH2>".$l['unassigned']."</p></td></tr>";
					}


					# Display column headings
					echo "<tr>";
					echo "<td class=BodyRepTh><p class=BodyRepH3>+</p></td>";
					foreach ($col as $column){
							echo "<td class=BodyRepTh><p class=BodyRepH3>$column</p></td>";
					}
					echo "</tr>";
				}

				if ($s_report=="certstat" && $r['status']!=$status_index){

					# Display Certification Level Information
					$status_index=$r['status'];
					echo "<tr><td class=BodyRepTh colspan=$fullspan><p class=BodyRepH2>".$r['status']."</p></td></tr>";

					# Display column headings
					echo "<tr>";
					echo "<td class=BodyRepTh><p class=BodyRepH2>+</p></td>";
					foreach ($col as $column){
							echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
					}
					echo "</tr>";
				}

				if ($s_report=="certlev" && $r['id_cert']!=$level_index){

					# Display Certification Level Information
					$level_index=$r['id_cert'];
					echo "<tr><td class=BodyRepTh colspan=$fullspan><p class=BodyRepH2>".$r['level']."</p></td></tr>";

					# Display column headings
					echo "<tr>";
					echo "<td class=BodyRepTh><p class=BodyRepH2>+</p></td>";
					foreach ($col as $column){
							echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
					}
					echo "</tr>";
				}

				echo "<tr>";

				# Set link column for edit/display
				if ( ($r['team'] == 0 || $r['team'] == 9999 || $r['team'] == "") && $a_admin == 1) {
					# This record has no team assignment and user is admin
					echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/blue.gif\" border=0>",ereg_replace("\[recno\]",$r['id_record'],ereg_replace("\[mode\]","update",ereg_replace("\[recno\]",$r['id_record'],ereg_replace("\[team\]","1",$link)))))."</td>";
#				}elseif ( $r['team'] == 9999 && $a_team == -1) {
#					# This user can access all teams
#					echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/blue.gif\" border=0>",ereg_replace("\[recno\]",$r['id_record'],ereg_replace("\[mode\]","update",ereg_replace("\[recno\]",$r['id_record'],ereg_replace("\[team\]","1",$link)))))."</td>";
				}elseif ($r['team'] != 9999 && $team_access[$r['team']] >= 2
						|| ($r['team'] == 9999 && ($r['province'] == $a_province || $a_province==9999))) {
					# This user has edit access this record
					echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/blue.gif\" border=0>",ereg_replace("\[recno\]",$r['id_record'],ereg_replace("\[mode\]","update",ereg_replace("\[recno\]",$r['id_record'],ereg_replace("\[team\]",$r['team'],$link)))))."</td>";
				}elseif ($team_access[$r['team']] == 1 && $s_report!="wcal") {
					# This user has read access for this record
					echo "<td class=BodyRepTd>".ereg_replace("\[rectext\]","<img src=\"images/grey.gif\" border=0>",ereg_replace("\[recno\]",$r['id_record'],ereg_replace("\[mode\]","display",ereg_replace("\[team\]",$r['team'],$link))))."</td>";
				}else{
					# This user has no access to view or edit record detail
					echo "<td class=BodyRepTd>&nbsp;</td>";
				}

				foreach ($dat as $data){
					if ($data == "access_searches" | $data == "access_members" | $data == "access_training" | $data == "access_certifications"){
						switch ($r[$data]) {
							case 0:
							$level = $l['none'];
							break 1;

							case 1:
							$level = $l['read'];
							break 1;

							case 2:
							$level = $l['write'];
							break 1;

							case 4:
							$level = $l['delete'];
							break 1;

							case 128:
							$level = $l['admin'];
							break 1;
						}
						echo "<td class=BodyRepTd><p class=BodyRepTxt>$level</p></td>";
					}else{
						echo "<td class=BodyRepTd><p class=BodyRepTxt>".($r[$data] ? $r[$data] : "&nbsp;")."</p></td>";
					}
				}

				if($e_field!="" && $r[$e_field]!=""){$e_all.="$r[$e_field],";}
				$flag=0;
				echo "</tr>";
			}

			# Display last email all link
			if ($s_report=="users" || substr($s_report,0,3)=="con" && $e_all!="<a class=BodyLink href='mailto:" && $e_all!=""){
				echo "<tr><td class=BodyRepTd colspan=$fullspan><p class=BodyRepTxt>$e_all'>".$l['email_all']."</a></p></td></tr>";
			}

			$time_end = getmicrotime();
			$time = $time_end - $time_start;
			echo "</table>
					<br><p class=BodyFootTxt>".$l['total_execution_time'].": ".round($time,3)." ".$l['seconds']."&nbsp;&nbsp;&nbsp;&nbsp;".$l['records_displayed'].": $row_count&nbsp;&nbsp;&nbsp;&nbsp;".strftime("%a %b %d %R %Z %Y");
		}else{
			# Nothing matched the query
			echo "<p class=BodyH2>$l[$s_report]</p>";
			echo "<p class=BodyTxt>".($s_province && $s_province!="All" ? $provinces[$s_province] : $l['all']).", ".($s_filter && $s_filter!="All" ? $teams[$s_filter] : $l['all']).", ".($s_period && $s_period!="All" ? $l[$s_period] : $l['all'])."</p>";
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
		}

		#///////////////////////////////////
		#/// Finish Page
		#///////////////////////////////////
		if ($_REQUEST['action'] == "print"){
			echo "</BODY></HTML>";
		}else{
			foot();
		}


		#DEBUG
		if (preg_match("/$debug_addr/",$_SERVER["REMOTE_ADDR"])){
			echo "<html><body><br><hr>
					<br><h2>Debug Information</h2><br>
					<b><big>Total Execution Time:</big></b><br>$time seconds<br><br>
					<b><big>Versions:</big></b><br>Php: ".phpversion()."<br>MySQL: ".mysql_get_server_info()."<br><br>
					<b><big>Query Status:</big></b><br>".mysql_errno().": ".mysql_error()."<br><br>
					<b><big>Query:</big></b><br>$query<br><br>
					<b><big>User:</big></b><br> $id_recno,$id_user.<br><br>
					<b><big>Variables:</big></b><br> lang=$lang,a_diralt=$a_diralt,a_admin=$a_admin<br>
					report=$report,s_report=$s_report,filter=$filter,s_filter=$s_filter<br>
					a_prov=$a_prov,a_all_teams=$a_all_teams,a_province=$a_province,a_provName1=".$a_provName[1].",a_provName2=".$a_provName[2].",a_provName3=".$a_provName[3].",a_provName4=".$a_provName[4].",a_provName5=".$a_provName[5].",a_team=$a_team,a_team_name=$a_team_name<br><br>";
			echo "<table>";
			echo "<tr><td><b>Team</b></td>
					<td><b>a_search</b></td>
					<td><b>a_memb</b></td>
					<td><b>a_train</b></td>
					<td><b>a_cert</b></td>
					</tr>";
			$i2=(count($a_search)-1);
			for ($i=1; $i<=$i2; $i++){
				echo "<tr>
						<td>$i</td>
						<td>$a_search[$i]</td>
						<td>$a_memb[$i]</td>
						<td>$a_train[$i]</td>
						<td>$a_cert[$i]</td>
						</tr>";
			}
				echo "<tr>
						<td>9999</td>
						<td>$a_search[9999]</td>
						<td>$a_memb[9999]</td>
						<td>$a_train[9999]</td>
						<td>$a_cert[9999]</td>
						</tr>";

			echo "</table>";
			echo "</body></html>";

		}
	}else{
			fail_access($_SERVER["QUERY_STRING"]);
	}

function getmicrotime(){
    list($usec, $sec) = explode(" ",microtime());
    return ((float)$usec + (float)$sec);
}

?>