/* *********************************BOF********************************* */

// E-GADS! Electronic Ground Search and Rescue Administrative Database
// Copyright (C) 2003 Calvin Martini

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// 
// Program: add_days.js
// Version: 1.3, 25 April 2002
// Author: Calvin Martini
//
function dateAdd(reset) {
	// Description: Function to add or subtract days from form date fields
	// Add or subtract days from form values. If days is divisible evenly by 365, assume a full year.
	var icert = document.MForm.e_certification.options[document.MForm.e_certification.selectedIndex].value;
	if (icert == "" || icert == 0 || icert == null) {
		// For cert_edit, e_certification is a text field, not a select
		icert = document.MForm.e_certification.value;
	}
	var days = eval('document.MForm.certdays' + icert + '.value');
	var icertY = document.MForm.yyyy_e_certified.selectedIndex;
	var icertD = document.MForm.dd_e_certified.selectedIndex;
	var icertM = document.MForm.mm_e_certified.selectedIndex;
	var certY = document.MForm.yyyy_e_certified.options[icertY].value;
	var certD = document.MForm.dd_e_certified.options[icertD].value;
	var certM = document.MForm.mm_e_certified.options[icertM].value;
	var cyears = days/365;
	if (reset == "Y" || icertY == 0){
		document.MForm.dd_e_expires.selectedIndex = 0;
		document.MForm.mm_e_expires.selectedIndex = 0;
		document.MForm.yyyy_e_expires.selectedIndex = 0;
		document.MForm.dd_e_certified.selectedIndex = 0;
		document.MForm.mm_e_certified.selectedIndex = 0;
		document.MForm.yyyy_e_certified.selectedIndex = 0;
		document.MForm.dd_e_date_test.selectedIndex = 0;
		document.MForm.mm_e_date_test.selectedIndex = 0;
		document.MForm.yyyy_e_date_test.selectedIndex = 0;
		document.MForm.dd_e_search1.selectedIndex = 0;
		document.MForm.mm_e_search1.selectedIndex = 0;
		document.MForm.yyyy_e_search1.selectedIndex = 0;
		document.MForm.dd_e_search2.selectedIndex = 0;
		document.MForm.mm_e_search2.selectedIndex = 0;
		document.MForm.yyyy_e_search2.selectedIndex = 0;
		document.MForm.e_agency.selectedIndex = 0;
		document.MForm.e_mock1.checked = false;
		document.MForm.e_mock2.checked = false;
	}else{
		if (cyears == Math.round(days/365)) {
			// Add or subtract years
			if (document.MForm.yyyy_e_certified.selectedIndex == 0){
				document.MForm.dd_e_expires.selectedIndex = 0;
				document.MForm.mm_e_expires.selectedIndex = 0;
				document.MForm.yyyy_e_expires.selectedIndex = 0;
				document.MForm.dd_e_certified.selectedIndex = 0;
				document.MForm.mm_e_certified.selectedIndex = 0;
				document.MForm.yyyy_e_certified.selectedIndex = 0;
			}else{
				document.MForm.dd_e_expires.selectedIndex = document.MForm.dd_e_certified.selectedIndex;
				document.MForm.mm_e_expires.selectedIndex = document.MForm.mm_e_certified.selectedIndex;
				document.MForm.yyyy_e_expires.selectedIndex = icertY + cyears;
			}
		}else{
			// Add or subtract days
			var d = new Date(certY,certM,certD);
			var dv = d.valueOf();
			var ndv;
			ndv = dv + (days*(1000*60*60*24));
			var nd = new Date(ndv);
			var od = nd.getDate();
			var om = nd.getMonth();
			var oy = nd.getFullYear() - 1972;
			document.MForm.dd_e_expires.selectedIndex = od;
			document.MForm.mm_e_expires.selectedIndex = om;
			document.MForm.yyyy_e_expires.selectedIndex = oy + 1;
		}
	}
}

function dateReset() {
	// Resets day and month select based on year select index being 0
	// Requires form text input myfield to be populated with field name prefix 
	var preField = document.MForm.myfield.value;
	var curYear = eval("document.MForm.yyyy_" + preField + ".selectedIndex");
	if (curYear == 0){
		var resVar = eval("document.MForm.mm_" + preField + ".selectedIndex = 0");
		resVar = eval("document.MForm.dd_" + preField + ".selectedIndex = 0");
	}
}
/* *********************************EOF********************************* */
