/* *********************************BOF********************************* */

// E-GADS! Electronic Ground Search and Rescue Administrative Database
// Copyright (C) 2004 Calvin Martini

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// 
// Program: rtc.js
// Version: 21 May 2004
// Author: Calvin Martini
// Description: Real Time Clock Library
//

// Sample Implementation with real time clock and elapsed time:
//
// <BODY onLoad="startRTC();startElapsed();">
// <form name=Mform>
//   Date/Time: <input id="rtcTimer" type="text" size="25"><a href="javascript:stopRTC();">Stop Clock</a> <a href="javascript:startRTC();">Start Clock</a>
//   <br>
//	 Elapsed Time: <input id="elapsedTimer" type="text" size="25">
// </form>


// Initialize Variables
// startDate should be defined in your script in javascript ahead of this library
//startDate = new Date(); // Set startDate to current date/time

// opPeriod is the length of an operational period expressed in hours
//opPeriod = 12;

// Next line for testing
//startDate = new Date("May 1, 2005 11:10:00"); // set time for testing:  "Month day, year hours:minutes:seconds."

startSeconds = (startDate.getHours()*60*60) + (startDate.getMinutes()*60) + startDate.getSeconds();
dateSeparator = '-';
rtcRunning = false;

function RTC() {
	rawTime = new Date();
	fmt_hour = padZero(rawTime.getHours());
	fmt_minute = padZero(rawTime.getMinutes());
	fmt_second = padZero(rawTime.getSeconds());
	fmt_year = takeYear(rawTime);
	fmt_month = padZero(rawTime.getMonth() +1);
	fmt_day = padZero(rawTime.getDate());

	fmt_time = fmt_hour + ':' + fmt_minute + ':' + fmt_second;
	fmt_date = fmt_year +  dateSeparator + fmt_month + dateSeparator + fmt_day + ' ';
	fmt_dateTime = fmt_year + dateSeparator + fmt_month + dateSeparator + fmt_day + ' ' + fmt_hour + ':' + fmt_minute + ':' + fmt_second;

	document.MForm.rtcTimer.value = fmt_dateTime;
	rtcID = setTimeout('RTC()',1000);
	rtcRunning = true;
}

function startElapsed() {
	now = new Date();
	then = startDate;

	var elapsedSeconds = ((now.getTime() - then.getTime()) / 1000);

	var diffDay = Math.floor(elapsedSeconds / 86400);
	var oPeriod = Math.floor(((elapsedSeconds / 3600) / opInterval) + 1 );
	elapsedSeconds = elapsedSeconds - (diffDay * 86400);

	var diffHour = Math.floor(elapsedSeconds / 3600);
	elapsedSeconds = elapsedSeconds - (diffHour * 3600);

	var diffMinute = 	Math.floor(elapsedSeconds / 60);
	elapsedSeconds = elapsedSeconds - (diffMinute * 60);

	var diffSecond = Math.floor(elapsedSeconds);

	document.all.elapsedTimer.innerHTML = padZero(diffDay) + 'd ' + padZero(diffHour) + 'h ' + padZero(diffMinute) + 'm ' + padZero(diffSecond) + 's';
	document.all.oPeriod.innerHTML = oPeriod;

	timerID = setTimeout('startElapsed()',1000);
}

function padZero(inValue) {
	var outValue = (inValue <10 ? '0' + inValue : inValue);
	return outValue;
}

function stopRTC(){
	if(rtcRunning)
	clearTimeout(rtcID);
	rtcRunning = false;
}

function startRTC(rTimer){
	stopRTC();
	RTC(rTimer);
}

function takeYear(theDate){
	// This function obtains proper 4-digit year from most browsers (getFullYear is IE specific)
	x = theDate.getYear();
	var y = x % 100;
	y += (y < 38) ? 2000 : 1900;
	return y;
}

/* *********************************EOF********************************* */
