<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: lib_fileio.php
	# Version: 1.3, 14 April 2002
	# Author: Calvin Martini
	# Description: File I/O function library

function logit($filename,$output) {
	# Function: Outputs a string to a text file
	# Requires:
	#		$filename	file to write to
	#		$output		text to write
	#
	# Returns:
	#		nil
	$fp = fopen( $filename,"a" ); 
	fwrite( $fp, date('Y-m-d H:i:s') . "\t" . $_SERVER["REMOTE_ADDR"] ."\t$output\n" ); 
	fclose( $fp ); 
}

function connect_db() {
	global $hostname,$dbname,$dbhostname,$dbusername,$dbpassword;
	mysql_connect($dbhostname,$dbusername,$dbpassword) OR die($l[connect_fail]);
	mysql_select_db($dbname) or die($l[select_fail]);
}

function period_filter($type,$field){
		#/////////////////////////////////////////////////////////////////////////////////// 
		#/// FUNCTION:
		#/// Set the MYSQL period filter query
		#/// 
		#/// PARAMETERS:
		#/// $type							Period filter type - based on report
		#/// $field							Date field to compare with (table.field)
		#/// 
		#/// RETURNS: 
		#/// String containg MYSQL query condition for date
		#///////////////////////////////////////////////////////////////////////////////////
	
		switch ($type) {
			case "All":
				$filter="";
				break 1;
			case "last_year":
				$filter="AND YEAR($field)=YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR))";
				break 1;
			case "last_month":
				$filter="AND (TO_DAYS($field)>TO_DAYS(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)))";
				break 1;
			case "last_3_months":
				$filter="AND (TO_DAYS($field)>TO_DAYS(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)))";
				break 1;
			case "current_year":
				$filter="AND YEAR($field)=YEAR(CURDATE())";
				break 1;
			case "next_month":
				$filter="AND TO_DAYS($field) BETWEEN TO_DAYS(CURDATE()) AND TO_DAYS(DATE_ADD(CURDATE(), INTERVAL 1 MONTH))";
				break 1;
			case "next_3_months":
				$filter="AND TO_DAYS($field) BETWEEN TO_DAYS(CURDATE()) AND TO_DAYS(DATE_ADD(CURDATE(), INTERVAL 3 MONTH))";
				break 1;
		}
	return $filter;
}

?>