<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: lib_headers.php
	# Version: 21 February 2006
	# Author: Calvin Martini
	# Description: Header/footer function library.

function head($which) {
	global $l;

	# Set the value for previous page
	page_track($_SERVER["REQUEST_URI"]);

	echo "<html>
	<head>
	<TITLE>".$l['app_title']."</TITLE>
	<META name=\"description\" content=\"E-GADS! (Electronic GSAR Administrative Database System). Copyright ©2003 by Calvin Martini. All Rights Reserved.\">
	<META name=\"keywords\" content=\"Search and Rescue, SAR, GSAR, database, E-GADS, e-gads\">
	<link rel=\"stylesheet\" href=\"css.html\" type=\"text/css\">";
	echo "</head>";
	echo "<body>";
	switch ($which) {
	  case "main":
			head_main();
			break 1;
		case "print";
			head_print();
			break 1;
		case "popup";
			head_popup();
			break 1;
		case "login":
			head_login();
			break 1;
	  case "pass_edit":
			head_pass_edit();
			break 1;
	  case "search":
			head_search();
			break 1;
	  case "admin":
			head_admin();
			break 1;
	  case "admin_edit":
			head_admin_edit();
			break 1;
	  case "event_edit":
			head_event_edit();
			break 1;
	  case "edit":
			head_edit();
			break 1;
	  case "user":
			head_user();
			break 1;
	  case "sr_select":
			head_sr_select();
			break 1;
	  case "sr_edit":
			head_sr_edit();
			break 1;
	  case "team_edit":
			head_team_edit();
			break 1;
	  case "member_edit":
			head_member_edit();
			break 1;
	  case "cert_edit":
			head_cert_edit();
			break 1;
	  case "tms_class_edit":
			tms_class_edit();
			break 1;
	  case "tms_course_edit":
			tms_course_edit();
			break 1;
	  case "tms_module_edit":
			tms_module_edit();
			break 1;
	  case "tms_course_select":
			tms_course_select();
			break 1;
	  case "tms_display":
			tms_display();
			break 1;
	}

}

function head_login() {
}

function head_popup() {
}

function head_print() {
	global $l;
	echo "<a class=BodyLink href=\"".$_SESSION['URI_previous'].SIDPRINT."\">".$l['return_previous']."</a><br><br>";
}

function head_search() {
}


function head_team_edit() {
	global $l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}


function head_pass_edit() {
	global $l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function head_event_edit() {
	global $l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function head_cert_edit() {
	global $l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function head_member_edit() {
	global $mode,$s_id,$t_id,$l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: View Subtree
	if ($mode != "new" && $s_id !=-999) {
		echo "oCMenu.makeMenu('View','','','','',".$widthView[$_SESSION['lang']].",0,'$locale/images/off_view".$_SESSION['lang'].".gif','$locale/images/on_view".$_SESSION['lang'].".gif','','','bottom');";
		echo "oCMenu.makeMenu('','View',\"".$l['display_print']."\",\"member_print.php?s_id=$s_id&t_id=$t_id&mode=$mode".SIDAND."\");";
	}


	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function head_sr_edit() {
	global $mode,$s_id,$l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: View Subtree
	if ($mode != "new" && $s_id !=-999) {
		echo "oCMenu.makeMenu('View','','','','',".$widthView[$_SESSION['lang']].",0,'$locale/images/off_view".$_SESSION['lang'].".gif','$locale/images/on_view".$_SESSION['lang'].".gif','','','bottom');";
		echo "oCMenu.makeMenu('','View',\"".$l['display_print']."\",\"sr_print.php?s_id=$s_id&mode=$mode".SIDAND."\");";
	}

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function head_sr_select() {
	global $mode,$s_id,$l,$a_search,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	#****** Start Logo/Search Row
	navbar_top();

	# Search Control START
	echo "<table class=SearchTbl BORDER=0 CELLPADDING=0 CELLSPACING=0 align=\"RIGHT\">
			<tr>
			<td class=SearchTd width=85><font class=SearchTxt>".$l['search_for']."</font></td>
			<td class=SearchTd width=100><input class=SearchInp type=text name=search size=15></td>
			<td class=SearchTd width=20><font class=SearchTxt>".$l['in']."</font></td>
			<td class=SearchTd><select class=SearchInp name=\"search_scope_2\">";
	if (max($a_search) != 0) {
		echo "<option value=sweather".($_SESSION['s_search_scope_2'] == "sweather" ? " selected" : "") .">".$l['sweather']."
				<option value=smanager".($_SESSION['s_search_scope_2'] == "smanager" ? " selected" : "") .">".$l['smanager']."
				<option value=ssubject".($_SESSION['s_search_scope_2'] == "ssubject" ? " selected" : "") .">".$l['ssubject']."
				<option value=sactivity".($_SESSION['s_search_scope_2'] == "sactivity" ? " selected" : "") .">".$l['sactivity']."
				<option value=slocation".($_SESSION['s_search_scope_2'] == "slocation" ? " selected" : "") .">".$l['slocation']."
				<option value=senvironment".($_SESSION['s_search_scope_2'] == "senvironment" ? " selected" : "") .">".$l['senvironment']."
				<option value=sreason".($_SESSION['s_search_scope_2'] == "sreason" ? " selected" : "") .">".$l['sreason'];
	}
	echo "</select></td>";
	echo "<td class=SearchTd width=80><input class=SearchBut type=submit value=\"".$l['Search']."\">
				".SIDHIDDEN."
				<input type=hidden name=mode value=\"$mode\">
				<input type=hidden name=s_id value=\"$s_id\">
				<input type=hidden name=period value=\"".$_SESSION['s_period_2']."\">
				<input type=hidden name=province value=\"".$_SESSION['s_province_2']."\">
			</td>
			</tr>
			</table>";
	# Search Control END

	#****** End Logo/Search Row
	echo "</td></tr>";

	#******** Navbar
	navbar_menu();

	#******** Menu START
	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('Logout','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: New Subtree
	echo "oCMenu.makeMenu('New','','','','',".$widthNew[$_SESSION['lang']].",0,'$locale/images/off_new".$_SESSION['lang'].".gif','$locale/images/on_new".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','New',\"".$l['search_report']."\",'sr_edit.php?mode=new&s_id=-999&r_id=-999".SIDAND."');";


	# Menu: View Subtree
	echo "oCMenu.makeMenu('View','','','','',".$widthView[$_SESSION['lang']].",0,'$locale/images/off_view".$_SESSION['lang'].".gif','$locale/images/on_view".$_SESSION['lang'].".gif','','','bottom');";
	menu_period();

	echo "oCMenu.makeMenu('View_Prov','View','".$l['province']."','');";
	echo "oCMenu.makeMenu('','View_Prov',\"".$l['all']."\",'','','300','','','','','','','','',\"javascript:set_report('province','All')\",'','');";
	$query = "SELECT id_record, type".$_SESSION['lang']." AS province FROM types_province ORDER BY province";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	if (mysql_num_rows($result)) {
	   while ($r = mysql_fetch_array($result)) {
			echo "oCMenu.makeMenu('','View_Prov',\"".strtr($r['province'],',',' ')."\",'','','300','','','','','','','','',\"javascript:set_report('province','".$r['id_record']."')\",'','');";
		}
	}

	# Menu: Refresh Screen Button
#	echo "oCMenu.makeMenu('Refresh','','','','',".$widthRefresh[$_SESSION['lang']].",0,'$locale/images/off_refresh".$_SESSION['lang'].".gif','$locale/images/on_refresh".$_SESSION['lang'].".gif','','','bottom','','','javascript:document.NAV.submit()','','');";

	//Leave this line - it constructs the menu
	echo "oCMenu.construct();
		</script>";
	#******** Menu END

}

function head_admin_edit() {
	global $s_id,$l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function head_admin() {
	global $l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	# NAV Form
	echo "<input type=hidden name=filter value=\"".$_SESSION['sa_filter']."\">
			<input type=hidden name=province value=\"".$_SESSION['sa_province']."\">
			<input type=hidden name=report value=\"".$_SESSION['sa_report']."\">";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: New Subtree
	if ($_SESSION['a_admin'] == 1) {
		echo "oCMenu.makeMenu('New','','','','',".$widthNew[$_SESSION['lang']].",0,'$locale/images/off_new".$_SESSION['lang'].".gif','$locale/images/on_new".$_SESSION['lang'].".gif','','','bottom');";
		echo "oCMenu.makeMenu('','New',\"".$l['new']."\",'admin_edit.php?mode=new".SIDAND."');";
	}


	# Menu: View Subtree
	echo "oCMenu.makeMenu('View','','','','',".$widthView[$_SESSION['lang']].",0,'$locale/images/off_view".$_SESSION['lang'].".gif','$locale/images/on_view".$_SESSION['lang'].".gif','','','bottom');";
	if($_SESSION['sa_report'] == "users"){menu_teams();}
	echo "oCMenu.makeMenu('','View',\"".$l['types_activity']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_activity')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_agencies']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_agencies')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_cal_events']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_cal_events')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_cert_agencies']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_cert_agencies')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_condition']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_condition')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_environment']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_environment')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_equipment']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_equipment')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_events']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_events')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_experience']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_experience')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_outcome']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_outcome')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_position']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_position')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_province']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_province')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_resources']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_resources')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_reason']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_reason')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_techniques']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_techniques')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['users']."\",'','','','','','','','','','','',\"javascript:set_report('report','users')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['types_weather']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_weather')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['variable_fields']."\",'','','','','','','','','','','',\"javascript:set_report('report','types_vars')\",'','');";

	echo "oCMenu.makeMenu('','View',\"".$l['display_print']."\",'".$_SERVER["PHP_SELF"]."?".($_SERVER["QUERY_STRING"] ? $_SERVER["QUERY_STRING"]."&action=print" : "action=print").SIDAND."');";

	# Menu: Refresh Screen Button
	echo "oCMenu.makeMenu('Refresh','','','','',".$widthRefresh[$_SESSION['lang']].",0,'$locale/images/off_refresh".$_SESSION['lang'].".gif','$locale/images/on_refresh".$_SESSION['lang'].".gif','','','bottom','','','javascript:document.NAV.submit()','','');";

	//Leave this line - it constructs the menu
	echo "oCMenu.construct()
		</script>";

}

function head_edit() {
}

function head_user() {
}

function head_main() {
	global $l,$a_search,$a_memb,$a_train,$a_cert,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	#****** Start Logo/Search Row
	navbar_top();

	# Search Control START
	echo "<table class=SearchTbl BORDER=0 CELLPADDING=0 CELLSPACING=0 align=\"RIGHT\">
			<tr>
			<td class=SearchTd width=85><font class=SearchTxt>".$l['search_for']."</font></td>
			<td class=SearchTd width=100><input class=SearchInp type=text name=search size=15></td>
			<td class=SearchTd width=20><font class=SearchTxt>".$l['in']."</font></td>
			<td class=SearchTd><select class=SearchInp name=search_scope>";
	if (max($a_search) != 0) {
		echo "<option value=sweather".($_SESSION['s_search_scope'] == "sweather" ? " selected" : "").">".$l['sweather']."
				<option value=smanager".($_SESSION['s_search_scope'] == "smanager" ? " selected" : "").">".$l['smanager']."
				<option value=sattendee".($_SESSION['s_search_scope'] == "sattendee" ? " selected" : "").">".$l['sattendee']."
				<option value=ssubject".($_SESSION['s_search_scope'] == "ssubject" ? " selected" : "").">".$l['ssubject']."
				<option value=sactivity".($_SESSION['s_search_scope'] == "sactivity" ? " selected" : "").">".$l['sactivity']."
				<option value=senvironment".($_SESSION['s_search_scope'] == "senvironment" ? " selected" : "").">".$l['senvironment']."
				<option value=sreason".($_SESSION['s_search_scope'] == "sreason" ? " selected" : "").">".$l['sreason']."";
	}
	if (max($a_memb) != 0) {
		echo "<option value=contname".($_SESSION['s_search_scope'] == "contname" ? " selected" : "").">".$l['contname']."
				<option value=contcontact".($_SESSION['s_search_scope'] == "contcontact" ? " selected" : "").">".$l['contcontact']."
				<option value=contaddress".($_SESSION['s_search_scope'] == "contaddress" ? " selected" : "").">".$l['contaddress']."";

	}
	if (max($a_train) != 0) {
		echo "<option value=scourse".($_SESSION['s_search_scope'] == "scourse" ? " selected" : "").">".$l['trcourses']."
				<option value=smodule".($_SESSION['s_search_scope'] == "smodule" ? " selected" : "").">".$l['trmodules']."
				<option value=sclass".($_SESSION['s_search_scope'] == "sclass" ? " selected" : "") .">".$l['trclasses']."
				<option value=sstudent".($_SESSION['s_search_scope'] == "sstudent" ? " selected" : "").">".$l['trstudents']."\n";
	}
	echo "<option value=teamname".($_SESSION['s_search_scope'] == "teamname" ? " selected" : "") .">".$l['teamname']."
			<option value=teamaddress".($_SESSION['s_search_scope'] == "teamaddress" ? " selected" : "").">".$l['teamaddress']."";
	echo "</select></td>";
	echo "<td class=SearchTd width=80><input class=SearchBut type=submit value=\"".$l['Search']."\">
				".SIDHIDDEN."
				<input type=hidden name=navsubmit value=\"1\">
				<input type=hidden name=minx value=\"".$_REQUEST['minx']."\">
				<input type=hidden name=miny value=\"".$_REQUEST['miny']."\">
				<input type=hidden name=maxx value=\"".$_REQUEST['maxx']."\">
				<input type=hidden name=maxy value=\"".$_REQUEST['maxy']."\">
				<input type=hidden name=CMD value=\"".$_REQUEST['CMD']."\">
				<input type=hidden name=imagewidth value=\"".$_REQUEST['imagewidth']."\">
				<input type=hidden name=imageheight value=\"".$_REQUEST['imageheight']."\">
				<input type=hidden name=INPUT_TYPE value=\"".$_REQUEST['INPUT_TYPE']."\">
				<input type=hidden name=INPUT_COORD value=\"".$_REQUEST['INPUT_COORD']."\">
				<input type=hidden name=period value=\"".$_SESSION['s_period']."\">
				<input type=hidden name=filter value=\"".$_SESSION['s_filter']."\">
				<input type=hidden name=province value=\"".$_SESSION['s_province']."\">
				<input type=hidden name=report value=\"".$_SESSION['s_report']."\">
			</td>";
	echo "</tr></table>";
	# Search Control END


	#****** End Logo/Search Row
	echo "</td></tr>";

	#****** Map Controls START
	if ($_SESSION['s_report']=="map" && ENABLEMAP){
		echo "<tr><td>
				<table class=MapCtrlTbl width=100% BORDER=0 CELLPADDING=0 CELLSPACING=0>
				<tr>
				<td class=MapCtrlTd><font class=MapCtrlTH>".$l['map_controls']."</font></td>
				<td class=MapCtrlTd><INPUT TYPE=\"checkbox\" NAME=\"mroad\" VALUE=\"Y\"".($_SESSION['s_road']=="Y" ? " CHECKED>" : ">")."</td>
				<td class=MapCtrlTd><IMG SRC=\"images/leg_road.gif\" WIDTH=\"20\" HEIGHT=\"15\"></td>
				<td class=MapCtrlTd><font class=MapCtrlTxt>Roads</FONT></td>
				<td class=MapCtrlTd><INPUT TYPE=\"checkbox\" NAME=\"mrail\" VALUE=\"Y\"".($_SESSION['s_rail']=="Y" ? " CHECKED>" : ">")."</td>
				<td class=MapCtrlTd><IMG SRC=\"images/leg_rail.gif\" WIDTH=\"20\" HEIGHT=\"15\"></td>
				<td class=MapCtrlTd><font class=MapCtrlTxt>Railroads</FONT></td>
				<td class=MapCtrlTd><INPUT TYPE=\"checkbox\" NAME=\"mpopplace\" VALUE=\"Y\"".($_SESSION['s_popplace']=="Y" ? " CHECKED>" : ">")."</td>
				<td class=MapCtrlTd><font class=MapCtrlTxt>Pop. Place</FONT></td>
				<td class=MapCtrlTd><INPUT TYPE=\"checkbox\" NAME=\"mteams\" VALUE=\"Y\"".($_SESSION['s_teams']=="Y" ? " CHECKED>" : ">")."</td>
				<td class=MapCtrlTd><IMG SRC=\"images/leg_teams.gif\" WIDTH=\"20\" HEIGHT=\"15\"></td>
				<td class=MapCtrlTd><font class=MapCtrlTxt>Team Boundaries</FONT></td>
				<td class=MapCtrlTd width=*>&nbsp;</td>
			 	</tr>
				</table>
				</td></tr>";
	}
	#******** Map Controls END

	#******** Navbar
	navbar_menu();

	#******** Menu START
	/******************************************
	Menu item creation:
	myCoolMenu.makeMenu(name, parent_name, text, link, target, width, height, regImage, overImage, regClass, overClass , align, rows, nolink, onclick, onmouseover, onmouseout)
	*************************************/

	echo "<script language=\"JavaScript1.2\" src=\"js/cm_options.js\"></script>";

	echo "<script>";
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	menu_lang();
	echo "oCMenu.makeMenu('Password','Main',\"".$l['change_password']."\",'pass_edit.php".SIDPRINT."');";
	if ($_SESSION['a_admin']==1) {echo "oCMenu.makeMenu('Admin','Main',\"".$l['administration']."\",'admin_display.php".SIDPRINT."');";}
	echo "oCMenu.makeMenu('Logout','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";
	echo "oCMenu.makeMenu('New','','','','',".$widthNew[$_SESSION['lang']].",0,'$locale/images/off_new".$_SESSION['lang'].".gif','$locale/images/on_new".$_SESSION['lang'].".gif','','','bottom');";
	if (max($a_memb) >= 2) {echo "oCMenu.makeMenu('New_Member','New',\"".$l['member']."\",'member_edit.php?mode=new&s_id=-999".SIDAND."');";}
	if (max($a_search) >= 2) {
		echo "oCMenu.makeMenu('New_Searches','New',\"".$l['search_report']."\",'sr_select.php?mode=new&s_id=-999".SIDAND."');";
	}
	if (max($a_train) >= 2) {
		echo "oCMenu.makeMenu('New_Training','New','".$l['training']."','');";
		echo "oCMenu.makeMenu('','New_Training',\"".$l['course']."\",'tms_course_edit.php?mode=new&s_id=-999".SIDAND."');";
		echo "oCMenu.makeMenu('','New_Training',\"".$l['class']."\",'tms_course_select.php?mode=new&s_id=-999".SIDAND."');";
	}
	if (max($a_memb) >= 2) {
		echo "oCMenu.makeMenu('New_Event','New','".$l['event']."','event_edit.php?mode=new&s_id=-999".SIDAND."');";
	}
	if (max($a_cert) >= 2) {
		echo "oCMenu.makeMenu('New_Cert','New','".$l['certificationlevel']."','cert_edit.php?mode=new&s_id=-999".SIDAND."');";
	}
	if ($_SESSION['a_admin']==1) {
		echo "oCMenu.makeMenu('New_Team','New','".$l['team']."','team_edit.php?mode=new&s_id=-999".SIDAND."');";
	}

	# Menu: View Subtree
	echo "oCMenu.makeMenu('View','','','','',".$widthView[$_SESSION['lang']].",0,'$locale/images/off_view".$_SESSION['lang'].".gif','$locale/images/on_view".$_SESSION['lang'].".gif','','','bottom');";
	menu_teams();
	menu_period();
	if (max($a_cert) != 0) {
		echo "oCMenu.makeMenu('View_Cert','View','".$l['certifications']."','');";
		echo "oCMenu.makeMenu('','View_Cert',\"".$l['by_level']."\",'','','','','','','','','','','',\"javascript:set_report('report','certlev')\",'','');";
		echo "oCMenu.makeMenu('','View_Cert',\"".$l['by_status']."\",'','','','','','','','','','','',\"javascript:set_report('report','certstat')\",'','');";
		echo "oCMenu.makeMenu('','View_Cert',\"".$l['by_team']."\",'','','','','','','','','','','',\"javascript:set_report('report','certteam')\",'','');";
		echo "oCMenu.makeMenu('','View_Cert',\"".$l['search_managers']."\",'','','','','','','','','','','',\"javascript:set_report('report','certsm')\",'','');";
		echo "oCMenu.makeMenu('','View_Cert',\"".$l['levels']."\",'','','','','','','','','','','',\"javascript:set_report('report','trcerts')\",'','');";
	}
	echo "oCMenu.makeMenu('','View',\"".$l['events']."\",'','','','','','','','','','','',\"javascript:set_report('report','wcal')\",'','');";
	echo "oCMenu.makeMenu('View_Members','View','".$l['members']."','');";
	if (max($a_memb) != 0) {echo "oCMenu.makeMenu('','View_Members',\"".$l['administrators']."\",'','','','','','','','','','','',\"javascript:set_report('report','contadmin')\",'','');";}
	if (max($a_memb) != 0 || $_SESSION['a_diralt']) {
		echo "oCMenu.makeMenu('','View_Members',\"".$l['board_directors']."\",'','','','','','','','','','','',\"javascript:set_report('report','contdir')\",'','');";
		echo "oCMenu.makeMenu('','View_Members',\"".$l['board_alternates']."\",'','','','','','','','','','','',\"javascript:set_report('report','contalt')\",'','');";
	}
	if (max($a_memb) != 0) {
		echo "oCMenu.makeMenu('','View_Members',\"".$l['callout_list']."\",'','','','','','','','','','','',\"javascript:set_report('report','contcall')\",'','');";
		echo "oCMenu.makeMenu('','View_Members',\"".$l['mailing_list']."\",'','','','','','','','','','','',\"javascript:set_report('report','contmail')\",'','');";
	}
	echo "oCMenu.makeMenu('','View_Members',\"".$l['emergency_contacts']."\",'','','','','','','','','','','',\"javascript:set_report('report','contem')\",'','');";
	echo "oCMenu.makeMenu('','View_Members',\"".$l['inactive']."\",'','','','','','','','','','','',\"javascript:set_report('report','contin')\",'','');";
	echo "oCMenu.makeMenu('','View_Members',\"".$l['inactive_active']."\",'','','','','','','','','','','',\"javascript:set_report('report','contactin')\",'','');";
	echo "oCMenu.makeMenu('View_Searches','View','".$l['searches']."','');";
	if (max($a_search) != 0) {echo "oCMenu.makeMenu('','View_Searches',\"".$l['summary']."\",'','','','','','','','','','','',\"javascript:set_report('report','ssum')\",'','');";}
	if (ENABLEMAP) {echo "oCMenu.makeMenu('','View_Searches',\"".$l['map']."\",'','','','','','','','','','','',\"javascript:set_report('report','map')\",'','');";}
	echo "oCMenu.makeMenu('','View_Searches',\"".$l['attendance']."\",'','','','','','','','','','','',\"javascript:set_report('report','sattend')\",'','');";
	echo "oCMenu.makeMenu('','View_Searches',\"".$l['statistical_summary']."\",'','','','','','','','','','','',\"javascript:set_report('report','xsum')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['teams']."\",'','','','','','','','','','','',\"javascript:set_report('report','tsum')\",'','');";

	if (max($a_train) != 0) {
		echo "oCMenu.makeMenu('View_Training','View','".$l['training']."','');";
		echo "oCMenu.makeMenu('','View_Training',\"".$l['courses']."\",'','','','','','','','','','','',\"javascript:set_report('report','trcourses')\",'','');";
		echo "oCMenu.makeMenu('','View_Training',\"".$l['modules']."\",'','','','','','','','','','','',\"javascript:set_report('report','trmodules')\",'','');";
		echo "oCMenu.makeMenu('','View_Training',\"".$l['classes']."\",'','','','','','','','','','','',\"javascript:set_report('report','trclasses')\",'','');";
		echo "oCMenu.makeMenu('','View_Training',\"".$l['students']."\",'','','','','','','','','','','',\"javascript:set_report('report','trstudents')\",'','');";
	}
	echo "oCMenu.makeMenu('','View',\"".$l['users']."\",'','','','','','','','','','','',\"javascript:set_report('report','users')\",'','');";
	echo "oCMenu.makeMenu('','View',\"".$l['display_print']."\",'".$_SERVER["PHP_SELF"]."?".($_SERVER["QUERY_STRING"] ? $_SERVER["QUERY_STRING"]."&action=print" : "action=print").SIDAND."','','','','','','clSep2','clSep2over');";

	echo "oCMenu.makeMenu('Info','','','','',".$widthInfo[$_SESSION['lang']].",0,'$locale/images/off_info".$_SESSION['lang'].".gif','$locale/images/on_info".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Info',\"".$l['notices']."\",'','','','','','','','','','','',\"javascript:show_notice()\",'','');";

	# Menu: Refresh Screen Button
	echo "oCMenu.makeMenu('Refresh','','','','',".$widthRefresh[$_SESSION['lang']].",0,'$locale/images/off_refresh".$_SESSION['lang'].".gif','$locale/images/on_refresh".$_SESSION['lang'].".gif','','','bottom','','','javascript:document.NAV.submit()','','');";

	//Leave this line - it constructs the menu
	echo "oCMenu.construct();
		</script>";
	#******** Menu END
}

function tms_course_edit () {
	global $l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function tms_course_select() {
	global $mode,$s_id,$l,$a_search,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	#****** Start Logo/Search Row
	navbar_top();

	# Search Control START
	echo "<table class=SearchTbl BORDER=0 CELLPADDING=0 CELLSPACING=0 align=\"RIGHT\">
			<tr>
			<td class=SearchTd width=85><font class=SearchTxt>".$l['search_for']."</font></td>
			<td class=SearchTd width=100><input class=SearchInp type=text name=t_search size=15></td>
			<td class=SearchTd width=20><font class=SearchTxt>".$l['in']."</font></td>
			<td class=SearchTd><select class=SearchInp name=t_scope>";
	if (max($a_search) != 0) {
		echo "<option value=team".($_SESSION['t_search_scope'] == "team" || !$_SESSION['t_search_scope'] ? " selected" : "") .">".$l['team']."
				<option value=province".($_SESSION['t_search_scope'] == "province" ? " selected" : "") .">".$l['province']."
				<option value=course".($_SESSION['t_search_scope'] == "course" ? " selected" : "") .">".$l['course']."
				<option value=module".($_SESSION['t_search_scope'] == "module" ? " selected" : "") .">".$l['module'];
	}
	echo "</select></td>";
	echo "<td class=SearchTd width=80><input class=SearchBut type=submit value=\"".$l['Search']."\">
				".SIDHIDDEN."
				<input type=hidden name=mode value=\"$mode\">
				<input type=hidden name=s_id value=\"$s_id\">
				<input type=hidden name=province value=\"".$_SESSION['t_province']."\">
				<input type=hidden name=period value=\"".$_SESSION['t_period']."\">
				<input type=hidden name=filter value=\"".$_SESSION['t_filter']."\">
			</td>
			</tr>
			</table>";
	# Search Control END

	#****** End Logo/Search Row
	echo "</td></tr>";

	#******** Navbar
	navbar_menu();

	#******** Menu START
	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: View Subtree
	if ($_SESSION['a_prov'] == 9999) {
		echo "oCMenu.makeMenu('View','','','','',".$widthView[$_SESSION['lang']].",0,'$locale/images/off_view".$_SESSION['lang'].".gif','$locale/images/on_view".$_SESSION['lang'].".gif','','','bottom');";
		menu_teams();
		menu_period();
	}

	//Leave this line - it constructs the menu
	echo "oCMenu.construct()
		</script>";
	#******** Menu END

}

function tms_class_edit()
{
	global $l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"display.php".SIDPRINT."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";


}

function tms_module_edit()
{
	global $mode1,$course,$t_id,$l,$widthMain,$widthNew,$widthView,$widthInfo,$widthRefresh,$locale;

	navbar_top();
	echo "</td></tr>";
	navbar_menu();

	echo "<script language='JavaScript1.2' src='js/cm_options.js'></script>";
	echo "<script>";

	# Menu: Main Subtree
	echo "oCMenu.makeMenu('Main','','','','',".$widthMain[$_SESSION['lang']].",0,'$locale/images/off_main".$_SESSION['lang'].".gif','$locale/images/on_main".$_SESSION['lang'].".gif','','','bottom');";
	echo "oCMenu.makeMenu('','Main',\"".$l['return_main']."\",\"tms_course_edit.php?s_id=$course&t_id=$t_id&mode=$mode1".SIDAND."\");";
	menu_lang();
	echo "oCMenu.makeMenu('','Main',\"".$l['logout']."\",'login.php".SIDPRINT."');";

	# Menu: End
	echo "oCMenu.construct()
			</script>";

}

function foot() {
	global $admin_email,$l;
	echo "<hr><p align=\"center\">&copy; ".date('Y')."<br><a class=\"c1\"". ((strpos($admin_email, "@") && strpos($admin_email, "mailto")===FALSE) ? "href=\"mailto:$admin_email\"" : "href=\"$admin_email\"").">".$l['contact_webmaster']."</a></p><br>";
	echo "</body>\n</html>\n";
}

function navbar_top(){
	global $locale;
	echo "<script language=\"JavaScript1.2\" src=\"js/coolmenus4.js\">
		/*****************************************************************************
		Copyright (c) 2001 Thomas Brattli (webmaster@dhtmlcentral.com)
		DHTML coolMenus - Get it at coolmenus.dhtmlcentral.com
		Version 4.0_beta
		This script can be used freely as long as all copyright messages are	intact.
		******************************************************************************/
		</script>";

	echo "<script language=\"JavaScript1.2\" src=\"js/cm_addins.js\">
		/*****************************************************************************
		Copyright (c) 2001 Thomas Brattli (webmaster@dhtmlcentral.com)
		Coolmenus add-in file for more advanced featuers..
		******************************************************************************/
		</script>";

	echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/nav.js\"></SCRIPT>";

	echo "<table class=MenuTbl BORDER=0 CELLPADDING=0 CELLSPACING=0 width=900>
			<tr>
			<td class=LogoTd STYLE=\"background-image: url($locale/images/banner".$_SESSION['lang'].".jpg);\" VALIGN=\"MIDDLE\" HEIGHT=50>
			<form STYLE=\"border:0;padding:0;margin:0\" form method=GET ENCTYPE=\"application/x-www-form-urlencoded\" name=NAV>";
}

function navbar_menu(){

?>
	<tr>
		<td class=MenuTd>
			<table class=MenuTbl width=100% BORDER=0 CELLPADDING=0 CELLSPACING=0>
				<tr>
					<!--td class=MenuTd width=500-->
					<td class=MenuTd>
						<ilayer id="layerMenu">
							<span id="divMenu">
								<img src="images/cm_fill.gif" width="10" height="25" alt="" border="0">
							</span>
						</ilayer>
					</td>
					<!--td class=MenuTd ALIGN=RIGHT><font class=MenuH>Settings:</font></td>
					<td class=MenuTd ALIGN=LEFT><input class=MenuInp type="text" name="menusettings" size=50></td>
					<td class=MenuTd width=*>&nbsp;</td-->
				</tr>
			</table>
			</form>
		</td>
	</tr>
</table>
<?php

}

function menu_teams() {
	global $l,$a_all_teams;

	echo "oCMenu.makeMenu('View_Team','View','".$l['team']."','','','','','','','clSep1','clSep1over');";
	echo "oCMenu.makeMenu('','View_Team',\"".$l['all']."\",'','','','','','','','','','','',\"javascript:set_team('All','All')\",'','');";

	$query = "SELECT id_record, type".$_SESSION['lang']." AS province FROM types_province ORDER BY province";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	if (mysql_num_rows($result)) {
		while ($r = mysql_fetch_array($result)) {
			echo "oCMenu.makeMenu('View".$r['id_record']."','View_Team',\"".strtr($r['province'],',',' ')."\",'');";
			echo "oCMenu.makeMenu('','View".$r['id_record']."',\"".$l['all']."\",'','','300','','','','','','','','',\"javascript:set_team('".$r['id_record']."','All')\",'','');";
			$query2 = "
					SELECT
					teams.id_record,
					teams.team_name
					FROM teams
					".($a_all_teams!=1 ? "LEFT JOIN team_access ON team_access.id_teams=teams.id_record AND team_access.id_users='".$_SESSION['id_recno']."' WHERE team_access.access_members>=2" : "WHERE 1=1")."
					AND teams.id_address_province='".$r['id_record']."'
					".($_SESSION['a_prov']!=9999 ? "AND teams.id_address_province='".$_SESSION['a_prov']."'" : "")."
					ORDER BY team_name
					";
			$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
			if (mysql_num_rows($result2)) {
				while ($r2 = mysql_fetch_array($result2)) {
						echo "oCMenu.makeMenu('','View".$r['id_record']."',\"".$r2['team_name']."\",'','','300','','','','','','','','',\"javascript:set_team('".$r['id_record']."','".$r2['id_record']."')\",'','');";
				}
			}
		}
	}
}

function menu_period() {
	global $l;

	echo "oCMenu.makeMenu('View_Period','View','".$l['period']."','','','','','','','clSep1','clSep1over');";
	echo "oCMenu.makeMenu('','View_Period',\"".$l['all']."\",'','','','','','','','','','','',\"javascript:set_option('period','All')\",'','');";

	echo "oCMenu.makeMenu('','View_Period',\"".$l['last_year']."\",'','','','','','','','','','','',\"javascript:set_option('period','last_year')\",'','');";
	echo "oCMenu.makeMenu('','View_Period',\"".$l['last_3_months']."\",'','','','','','','','','','','',\"javascript:set_option('period','last_3_months')\",'','');";
	echo "oCMenu.makeMenu('','View_Period',\"".$l['last_month']."\",'','','','','','','','','','','',\"javascript:set_option('period','last_month')\",'','');";
	echo "oCMenu.makeMenu('','View_Period',\"".$l['current_year']."\",'','','','','','','','','','','',\"javascript:set_option('period','current_year')\",'','');";
	echo "oCMenu.makeMenu('','View_Period',\"".$l['next_month']."\",'','','','','','','','','','','',\"javascript:set_option('period','next_month')\",'','');";
	echo "oCMenu.makeMenu('','View_Period',\"".$l['next_3_months']."\",'','','','','','','','','','','',\"javascript:set_option('period','next_3_months')\",'','');";

}

function menu_lang() {
	global $l,$maxLang;

	if ($maxLang > 1){
		echo "oCMenu.makeMenu('Language','Main',\"".$l['Language']."\",'');";
		for ($x = 1; $x <= $maxLang; $x++){
			echo "oCMenu.makeMenu('','Language',\"".$l['lang'.$x]."\",'".$_SERVER['PHP_SELF']."?".(strstr($_SERVER['QUERY_STRING'],"language=") ? ereg_replace("language=.","language=$x",$_SERVER['QUERY_STRING']) : "language=$x&".($_SERVER['QUERY_STRING'] ? $_SERVER['QUERY_STRING'] : "")).(sid && ! strstr($_SERVER['QUERY_STRING'],"PHPSESSID=") ? SIDAND : "")."','',160,0);";
		}
	}
}

function get_teams() {
	$query = "SELECT id_record, team_name FROM teams ORDER BY team_name";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	if (mysql_num_rows($result)) {
		while (list($team_id, $team_name) = mysql_fetch_array($result)) {
				$teams[$team_id]=$team_name;
		}
	}
	return $teams;
}

function get_provinces() {
	global $l,$lang;
	$query = "SELECT id_record,types_province.type$lang AS province_name FROM types_province ORDER BY province_name";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	if (mysql_num_rows($result)) {
		while (list($province_id, $province_name) = mysql_fetch_array($result)) {
				$provinces[$province_id]=$province_name;
		}
	}
	return $provinces;
}

function page_track($current_URI) {
	if(isset($_SESSION['URI_previous'])){$_SESSION['URI_previous']=$_SESSION['URI_current'];}
	if(isset($_SESSION['URI_current'])){$_SESSION['URI_current']=$current_URI;}
}

function esc_string($in_string) {
	$out_string=ereg_replace("'","\'",$in_string);
	return $out_string;
}
?>
