<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: lib_html.php
	# Version: 1.1, 27 March 2003
	# Author: Calvin Martini
	# Description: html function library.


	function input_date($name,$in_date,$yy_past,$yy_future){
		#/////////////////////////////////////////////////////////////////////////////////// 
		#/// FUNCTION:
		#/// Outputs HTML formatted selection drop down boxes for year, month, day
		#/// 
		#/// 
		#/// PARAMETERS:
		#/// $name							base field name
		#/// $in_date						current date (yyyy-mm-dd)
		#/// $yy_past,$yy_future		years to subtract and add to current year to get year range
		#/// 
		#/// RETURNS: 
		#/// An array with three elements containing the HTML code for year, month and day select dropdowns
		#///////////////////////////////////////////////////////////////////////////////////
		
		list($yyyy,$mm,$dd) = split("-",$in_date);

		$today = getdate(); 
		$mon = $today['mon']; 
		$mday = $today['mday']; 
		$year = $today['year']; 

		$y="<select class=BodyInp name=\"yyyy_$name\" value=\"$yyyy\"><option value=\"0000\"".($yyyy =="0000" ? " SELECTED" : "").">0000";
		for ($i = ($year-$yy_past); $i <= ($year+$yy_future); $i++) {
			if ($i == $yyyy){
				$y.= "<option value=\"$i\" SELECTED>$i";
			}else{
				$y.= "<option value=\"$i\">$i";
			}
		}
		$y.= "</select>";

		$m= "<select class=BodyInp name=\"mm_$name\" value=\"$mm\"><option value=\"00\"".($mm =="00" ? " SELECTED" : "").">00";
		for ($i = 1; $i <= 12; $i++) {
			if ($i == $mm){
				$m.= "<option value=\"".($i<10 ? "0$i" : "$i")."\" SELECTED>".($i<10 ? "0$i" : "$i")."";
			}else{
				$m.= "<option value=\"".($i<10 ? "0$i" : "$i")."\">".($i<10 ? "0$i" : "$i")."";
			}
		}
		$m.= "</select>";

		$d= "<select class=BodyInp name=\"dd_$name\" value=\"$dd\"><option value=\"00\"".($dd =="00" ? " SELECTED" : "").">00";
		for ($i = 1; $i <= 31; $i++) {
			if ($i == $dd){
				$d.= "<option value=\"".($i<10 ? "0$i" : "$i")."\" SELECTED>".($i<10 ? "0$i" : "$i")."";
			}else{
				$d.= "<option value=\"".($i<10 ? "0$i" : "$i")."\">".($i<10 ? "0$i" : "$i")."";
			}
		}
		$d.= "</select>";
		
		return array ($y, $m, $d);

	}

?>
