<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: lib_security.php
	# Version: 17 April 2005
	# Author: Calvin Martini
	# Description: Security function library.

function check_pw($section) {
	#///////////////////////////////////////////////////////////////////////////////////
	#/// FUNCTION:
	#/// Validates credentials and sets security related session variables
	#///
	#///
	#/// PARAMETERS:
	#///
	#/// RETURNS:
	#/// Session variables
	#///////////////////////////////////////////////////////////////////////////////////

	global $l,$id_user,$id_password,$id_recno,$logfile,$error_url,$a_diralt,$a_admin,$a_prov,$a_province,$a_provName;
	$query = "SELECT users.* FROM users WHERE user_id='".$id_user."'";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$r = mysql_fetch_array($result);

	$id_recno = $r['id_record'];
	$count = $r['attempt_count'];

	# Check for user exists
	if ( mysql_num_rows($result) == 0 ) {
		fail_login("");
		logit($logfile,"501\tLogin attempt failed. User ".$id_user." not found.");
		exit;
	}

	# Check for account lockout
	# Calculate lockout time
	# TIMESTAMP when_attempt is formatted YYYYMMDDHHMMSS, convert it to something strtotime can convert
	$attempt_time = substr($r['when_attempt'],0,4)."-".substr($r['when_attempt'],4,2)."-".substr($r['when_attempt'],6,2)." ".substr($r['when_attempt'],8,2).":".substr($r['when_attempt'],10,2).":".substr($r['when_attempt'],12,2);
	$lockout_time = strtotime($attempt_time)+3600;
	$lockout_time_str = date("Y-m-d H:i:s",$lockout_time);
	# If 5 attempts, last less than 1 hour ago, account is locked out = refuse login
	if ($count == 5 && $r['when_attempt'] && ($lockout_time > time())) {
		$count++;
		$query2 = "UPDATE users SET attempt_count='$count' WHERE id_record='$id_recno'";
		$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
		fail_login($l['locked_out']." $lockout_time_str");
		logit($logfile,"502\tLOCKED OUT until $lockout_time_str. $id_user. 5 attempts. (No further attempts will be logged)");
		exit;
	}
	# Don't log for attempts 6+ since we don't want to overfill log - Could be denial of service attack.
	if ($count > 5 && $r['when_attempt'] && ($lockout_time > time())) {
		fail_login($l['locked_out']." $lockout_time_str");
		exit;
	}

	# Check for bad password

	if ( crypt($id_password,$r['password']) != $r['password'] ) {
		$count++;
		# Reset the counter if lockout time has passed
		if ($count >= 5 && $r['when_attempt'] && ($lockout_time < time())) {
			$count = 1;
		}
		fail_login("");
		$query2 = "UPDATE users SET attempt_count='$count' WHERE id_record='$id_recno'";
		$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
		logit($logfile,"504\tLogin attempt failed. Invalid password #$count for $id_user.");
		exit;
	}

	# Check for account expiry
	if ( $r['when_expires'] && (strtotime($r['when_expires']) < time())) {
		fail_login($l['account_expired']." (".$r['when_expires'].").");
		logit($logfile,"505\t".$l['account_expired']." (".$r['when_expires'].")");
		exit;
	}

	# Set access flags
	$a_diralt=$r['flag_diralt'];
	$a_admin=$r['flag_admin'];
	$a_prov=$r['auth_province'];
	if ($a_prov == 9999){
		$a_province = -1;
	}else{
		$a_province=$r['auth_province'];
		$query="SELECT type1, type2, type3, type4, type5 FROM types_province WHERE id_record='$a_province'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		$r = mysql_fetch_array($result);
		$a_provName[1]=$r['type1'];
		$a_provName[2]=$r['type2'];
		$a_provName[3]=$r['type3'];
		$a_provName[4]=$r['type4'];
		$a_provName[5]=$r['type5'];
	}

	# Good login, Reset counter
	$query2 = "UPDATE users SET attempt_count='0' WHERE id_record='$id_recno'";
	$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");

}

function team_access($field){
	#///////////////////////////////////////////////////////////////////////////////////
	#/// FUNCTION:
	#/// Reads team_access, determines security access
	#///
	#/// PARAMETERS:
	#/// $field							database field in table users to compare for single team access
	#/// $name							base field name
	#/// $in_date						current date (yyyy-mm-dd)
	#/// $yy_past,$yy_future		years to subtract and add to current year to get year range
	#///
	#/// RETURNS:
	#/// Arrays for a_search, a_memb, a_cert, a_train, a_exp
	#///////////////////////////////////////////////////////////////////////////////////

	global $l,$id_recno,$id_user,$logfile,$a_province,$a_prov,$a_provName;

	# Get the number of teams
	$query = "SELECT COUNT(*) AS count_teams FROM teams";
	$result = mysql_query($query)  or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$num_rows = mysql_num_rows($result);
	if ($num_rows) {
		$r = mysql_fetch_array($result);
		$count_teams = $r['count_teams'];
	}

	# Initialize the access arrays
	$a_search = array_pad(array(), $count_teams+1, "0");
	$a_memb = array_pad(array(), $count_teams+1, "0");
	$a_cert = array_pad(array(), $count_teams+1, "0");
	$a_train = array_pad(array(), $count_teams+1, "0");
	$a_all_teams=0;
	$a_team=0;
	$a_team_name = NULL;

	# Set team access
	$query = "SELECT team_access.*
				FROM team_access
				WHERE team_access.id_users='$id_recno'";
	$result = mysql_query($query)  or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$num_rows = mysql_num_rows($result);
	if ($num_rows) {
		while ($r = mysql_fetch_array($result)) {
			if ($r['id_teams']=="9999"){
				$a_all_teams = 1;
				$a_team = -1;

				if ($a_prov==9999){
					$a_search = array_pad(array(), $count_teams+1, $r['access_searches']);	$a_search[0]=0;
					$a_memb = array_pad(array(), $count_teams+1, $r['access_members']);	$a_memb[0]=0;
					$a_cert = array_pad(array(), $count_teams+1, $r['access_certifications']);	$a_cert[0]=0;
					$a_train = array_pad(array(), $count_teams+1, $r['access_training']);	$a_train[0]=0;
				}else{
					$query2="SELECT id_record FROM teams WHERE id_address_province='$a_prov'";
					$result2 = mysql_query($query2)  or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
					while ($r2 = mysql_fetch_array($result2)) {
						$a_search[$r2['id_record']]=$r['access_searches'];
						$a_memb[$r2['id_record']]=$r['access_members'];
						$a_cert[$r2['id_record']]=$r['access_certifications'];
						$a_train[$r2['id_record']]=$r['access_training'];
					}
				}

				$a_search[9999]=$r['access_searches'];
				$a_memb[9999]=$r['access_members'];
				$a_cert[9999]=$r['access_certifications'];
				$a_train[9999]=$r['access_training'];

				break 1;
			}else{
				$a_search[$r['id_teams']]=$r['access_searches'];
				$a_memb[$r['id_teams']]=$r['access_members'];
				$a_cert[$r['id_teams']]=$r['access_certifications'];
				$a_train[$r['id_teams']]=$r['access_training'];
			}
		}
	}

	# Determine single team access
	if ($a_all_teams==0){
		$query = "SELECT teams.id_record, teams.team_name
			FROM teams
			LEFT JOIN team_access ON team_access.id_teams=teams.id_record
			WHERE team_access.$field>=2 AND team_access.id_users='$id_recno'
			GROUP BY teams.id_record";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result) == 1){
			$r = mysql_fetch_array($result);
				$a_team = $r['id_record'];
				$a_team_name = $r['team_name'];
		}
	}

#	echo "teams=$count_teams<br>a_search:".var_dump($a_search)."<br><br>";
#	exit;
	# Return the access arrays
	return array ($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name);
#	return $a_search;
}

function fail_login($message){
	global $l,$error_url,$logfile,$id_user;
	$message=preg_replace("/&id_password=.*/","(password supressed)",$message);
	head("login");
#	logit($logfile,"504\tInvalid login, $id_user: $message");
	echo "<center>
			<h1 class=\"title\">".$l['invalid_login']."</h1>
			<h2 class=\"normal\">".$l['invalid_login2']."</h2>
			<h3 class=\"normal\">$message</h2>
			<br><br><p>".$l['attempts_are_recorded']." <a href=\"$error_url\">".$l['login_page']."</a>.</p><br><br><br>
			</center>";
	foot();
#	exit;
}

function fail_access($message){
	global $l,$error_url,$logfile,$id_user;
	$message=preg_replace("/&id_password=.*/","(password supressed)",$message);
	head("login");
	logit($logfile,"505\tInvalid access by $id_user: $message");
	echo "<center>
			<h1 class=\"title\">".$l['invalid_access']."</h1>
			<h2 class=\"normal\">".$l['invalid_access2']."</h2>
			<h3 class=\"normal\">$message</h2>
			<br><br><p>".$l['attempts_are_recorded']." <a href=\"$error_url\">".$l['login_page']."</a>.</p><br><br><br>
			</center>";
	foot();
	exit;
}

function bad_access($message){
	global $l,$error_url,$s_id,$mode;
#	head("login");
	$message=preg_replace("/&id_password=.*/","(password supressed)",$message);
	echo "<center>
			<h1 class=\"title\">".$l['error']."</h1>
			<h3 class=\"normal\">$message</h2>
			<br><br><p><a href=\"".$_SERVER["HTTP_REFERER"]."\">".$l['continue']."</a>.</p><br><br><br>
			</center>";
	foot();
}

?>