# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# E-GADS! Application Data load
# Version 29 April 2004

USE egads;

# Create test user accounts
INSERT INTO users (email,full_name,user_id,password,flag_diralt,flag_admin,when_expires,auth_province) VALUES
('your.email@host.org','E-GADS Administrator','admin','AGr6Sr3RFjWCY','1','1','2010-12-31','9999');

# Set up team access, User 2
# 999 in id_teams means access applies for ALL TEAMS
INSERT INTO team_access (id_users,id_teams,access_searches,access_members,access_training,access_certifications) VALUES 
('1','9999','128','128','128','128');

INSERT INTO types_cert_agencies (
	agency_desc1,
	agency_desc2,
	agency_desc3,
	agency_desc4,
	agency_desc5,
	agency_address,
	agency_city,
	agency_province,
	agency_pcode,
	agency_phone,
	agency_fax,
	agency_email,
	agency_website
) VALUES 
('Red Cross','','','','','','','2','','','','',''),
('DND','','','','','','','2','','','','',''),
('Saint John Ambulance','','','','','','','2','','','','','');
	
INSERT INTO types_events (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Lost','Perdue','','','','Subject doesn\'t know where they are','Sujet ne sait pas ou elle se trouve','','',''),
('Missing','Manquante','','','','Subject knows where they are but friends/family believe they are lost or injured','Personne n\'est pas perdue, mais amis/famille pensent qu\'elle est','','',''),
('Evidence','Evidence','','','','Tasked by police to find something other than lost/missing person.','Recherche demandee par agence policiere pour retrouver autre que des personnes perdues/manquantes.','','',''),
('Rescue','Sauvetage','','','','','','','',''),
('Meeting','Reunion','','','','','','','',''),
('Recovery','Recovery','','','','','','','','');

INSERT INTO types_cal_events (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Meeting','Reunion','','','','','','','',''),
('Training','Formation','','','','','','','',''),
('Social','Sociable','','','','','','','',''),
('Information','Information','','','','','','','',''),
('Holiday','Vacances','','','','','','','','');

INSERT INTO types_equipment (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Unknown','Inconnu','','','','','','','',''),
('Excessive','Trop','','','','','','','',''),
('Adequate','Bonne','','','','','','','',''),
('Inadequate','Mal','','','','','','','','');

INSERT INTO types_experience (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Unknown','Inconnu','','','','','','','',''),
('Expert','Expert','','','','','','','',''),
('Advanced','Advanced','','','','','','','',''),
('Intermediate','Intermediate','','','','','','','',''),
('Beginner','Beginner','','','','','','','',''),
('None','Aucun','','','','','','','','');

INSERT INTO types_position (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Search Manager','Directeur Recherche','','','','','','','',''),
('OPs Section Chief','Chef De Section OPs','','','','','','','',''),
('Planning Section Chief','Planification','','','','','','','',''),
('Logistics Officer','Officier','','','','','','','',''),
('Communications Operator','Oprateur De Transmissions','','','','','','','',''),
('Equipment Officer','Officier Matriel','','','','','','','',''),
('Investigations Officer','Officier Logistics','','','','','','','',''),
('Sitstat/Restat','Sitstat/Restat','','','','','','','',''),
('Finance','Finances','','','','','','','','');

INSERT INTO types_contacts (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Home','Maison','','','','','','','',''),
('Office','Bureau','','','','','','','',''),
('Pager','Pager','','','','','','','',''),
('Cellular','Cellulaire','','','','','','','',''),
('E-mail','E-Mail','','','','','','','',''),
('Fax','Fax','','','','','','','','');
	
INSERT INTO types_reason (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Avalanche','Avalanche','','','','','','','',''),
('Darkness','Obscurit','','','','','','','',''),
('Lost','garement','','','','','','','',''),
('Broke through ice','Bris de glace','','','','','','','',''),
('Weather','Mto','','','','','','','',''),
('Natural disaster','Catastrophe naturelle','','','','','','','',''),
('Other environmental','Autre cause environnementale','','','','','','','',''),
('Fell','Chute','','','','','','','',''),
('Drowned','Noyade','','','','','','','',''),
('Capsized','Chavirage','','','','','','','',''),
('Ran aground','chouement','','','','','','','',''),
('Swamped','Submersion','','','','','','','',''),
('Exceeded ability','Surestimation des capacits','','','','','','','',''),
('Other activity-related','Autre cause lie  l\'activit','','','','','','','',''),
('Violence','Violence','','','','','','','',''),
('Poor communication','Mauvaise communication','','','','','','','',''),
('Alchohol','Alcool','','','','','','','',''),
('Medical','Raison mdicale','','','','','','','',''),
('Allergic reaction','Raction allergique','','','','','','','',''),
('Cardiac arrest','Arrêt cardiaque','','','','','','','',''),
('Despondent','Dpression','','','','','','','',''),
('Injury','Blessure','','','','','','','',''),
('Separation','Sparation','','','','','','','',''),
('False alarm','Fausse alarme','','','','','','','',''),
('Fatigue','Fatigue','','','','','','','',''),
('Wildlife conflict','Incident caus par un animal','','','','','','','',''),
('Suicide or attempt','Suicide ou tentative','','','','','','','',''),
('Mechanical breakdown','Panne mcanique','','','','','','','',''),
('Out of fuel','Panne d=essence','','','','','','','',''),
('Stuck','Coinc','','','','','','','',''),
('Stranded (physically)','Laiss en plan','','','','','','','',''),
('Other','Autre','','','','','','','',''),
('Unknown','Inconnue','','','','','','','','');

INSERT INTO types_resources (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Trained volunteer','Personnel form','','','','','','','',''),
('Untrained personnel','Personnel non form','','','','','','','',''),
('Police','Police','','','','','','','',''),
('Military','Militaires','','','','','','','',''),
('Firefighters','Pompiers','','','','','','','',''),
('Medical personnel','Personnel mdical','','','','','','','',''),
('Social service','Services sociaux','','','','','','','',''),
('Dog','Chien','','','','','','','',''),
('FLIR','FLIR','','','','','','','',''),
('Hovercraft','Aroglisseur','','','','','','','',''),
('Land vehicle','Vhicule terrestre','','','','','','','',''),
('Vessel','Navire','','','','','','','',''),
('Fixed wing aircraft','Aronef  voilure fixe','','','','','','','',''),
('Helicopter','Hlicoptre','','','','','','','',''),
('Jaws of life','Mâchoires de survie','','','','','','','',''),
('Mobile litter','Civire ambulante','','','','','','','','');

INSERT INTO types_techniques (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Hasty Search','Recherche Rapide','','','','','','','',''),
('Critical Separation','Separation Criticale','','','','','','','',''),
('Night Search','Recherche de nuit','','','','','','','',''),
('Line search','Recherches en ligne droite','','','','','','','',''),
('Confinement','Isolement','','','','','','','',''),
('Attraction','Attraction','','','','','','','',''),
('Open grid spacing','Dploiement  quadrillage ouvert','','','','','','','',''),
('Sweep','Ratissage','','','','','','','',''),
('Air scent dog','Chiens travaillant en dtection','','','','','','','',''),
('Ground scent dog','Chiens travaillant en dpistage','','','','','','','',''),
('Tracking','Pistage','','','','','','','',''),
('Air Search','Recherche arienne','','','','','','','',''),
('Water search','Recherche maritime','','','','','','','',''),
('Avalanche search','Recherche en cas d\'avalanche','','','','','','','',''),
('Contour','Contour','','','','','','','','');

INSERT INTO types_province (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5,extent) VALUES 
('Newfoundland and Labrador','Terre Neuve et du Labrador','','','','','','','','',''),
('New Brunswick','Nouveau Brunswick','','','','','','','','',''),
('Prince Edward Island','l\'le-du-Prince-douard','','','','','','','','',''),
('Quebec','Qubec','','','','','','','','',''),
('Ontario','Ontario','','','','','','','','',''),
('Nova Scotia','Nouvelle-cosse','','','','','','','','',''),
('Manitoba','Manitoba','','','','','','','','',''),
('Saskatchewan','Saskatchewan','','','','','','','','',''),
('Alberta','Alberta','','','','','','','','',''),
('British Columbia','Columbie Britanique','','','','','','','','',''),
('Maine, USA','Maine, Etats-Unis','','','','','','','','',''),
('Yukon','Yukon','','','','','','','','',''),
('Northwest Territories','Territoires du Nord-Ouest','','','','','','','','',''),
('Nunavut','Nunavut','','','','','','','','','');

INSERT INTO types_activity (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Hiking','Randonne','','','','','','','',''),
('Camping','Camping','','','','','','','',''),
('Fishing','Pêche','','','','','','','',''),
('Hunting','Chasse','','','','','','','',''),
('Picking','Cueillette','','','','','','','',''),
('Boating','Navigation','','','','','','','',''),
('Climbing','Escalade','','','','','','','',''),
('Swimming','Natation','','','','','','','',''),
('Skiing (cross-country)','Ski de fond','','','','','','','',''),
('Skiing (alpine)','Ski alpin','','','','','','','',''),
('Snowboarding','Planche  neige','','','','','','','',''),
('Walkaway','Errance','','','','','','','',''),
('Runaway','Fugue','','','','','','','',''),
('Occupational activity','Activit professionnelle','','','','','','','',''),
('Other','Autre','','','','','','','',''),
('Unknown','Inconnue','','','','','','','','');

INSERT INTO types_environment (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Urban/suburban','Urbain/Banlieue','','','','','','','',''),
('Flat','Plat','','','','','','','',''),
('Rolling','Cteux','','','','','','','',''),
('Rugged','Accident','','','','','','','',''),
('Water','Milieu marin','','','','','','','',''),
('Mountainous','Montagneux','','','','','','','',''),
('River/lake','Rivire/Lac','','','','','','','',''),
('Swiftwater','Eaux vives','','','','','','','',''),
('Flood/control system','Inondation/Systme de contrle','','','','','','','',''),
('Other','Autre','','','','','','','',''),
('Unknown','Inconnu','','','','','','','','');

INSERT INTO types_weather (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Unknown','Inconnu','','','','','','','',''),
('Cold temperature','Temps froid','','','','','','','',''),
('Dry/normal','Temps sec/Normal','','','','','','','',''),
('Rain/freezing rain','Pluie/Pluie verglaante','','','','','','','',''),
('Snow','Neige','','','','','','','',''),
('Windy','Vente','','','','','','','',''),
('Other','Autre','','','','','','','',''),
('Fog','Brouillard','','','','','','','','');

INSERT INTO types_outcome (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Unknown','Inconnu','','','','','','','',''),
('Found Alive','Trouv en vie','','','','','','','',''),
('Found deceased','Trouv mort','','','','','','','',''),
('Not found','Non trouv','','','','','','','',''),
('False alarm','Fausse alarme','','','','','','','',''),
('Walked out','Sujet s&acute;en sort seul','','','','','','','','');

INSERT INTO types_condition (type1,type2,type3,type4,type5,desc_type1,desc_type2,desc_type3,desc_type4,desc_type5) VALUES 
('Unknown','Inconnu','','','','','','','',''),
('Good','Bon tat','','','','','','','',''),
('Ill','Malade','','','','','','','',''),
('Hypothermic','Hypothermique','','','','','','','',''),
('Shock','Choc','','','','','','','',''),
('Unconcious','vanouissement','','','','','','','',''),
('Minor injuries','Blessures mineures','','','','','','','',''),
('Major injuries','Blessures graves','','','','','','','',''),
('Other','Autre','','','','','','','','');

