<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: member_cert_edit.php
	# Version: 8 March 2006
	# Author: Calvin Martini
	# Description: This script provides editing of existing certification records.
	
	session_start(); 

	require("globals.php");
	connect_db();

	# Set client variables
	$client_vars=array('s_id','t_id','mode','mode1','member'); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}
	if ( isset($t_id) ) { $team = $t_id; }else{ $team = NULL; }
	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_certifications");
	
	# Check to ensure proper access level to edit record
	if ($a_cert[$t_id] < 1 || session_is_registered("id_user")==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	head("cert_edit");
	echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/calendar/calendar.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/CallCalendar.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/add_days.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/CallWindow.js\"></SCRIPT>
			";
	$query = "
		SELECT certifications.id_record AS record, 
		certifications.date_test,
		certifications.date_certified,
		certifications.date_expires,
		certifications.id_instructor,
		certifications.date_search1,
		certifications.flag_search1,
		certifications.date_search2,
		certifications.flag_search2,
		certifications.id_types_certifications,
		certifications.id_certifying_agency,
		users.full_name AS user,
		DATE_FORMAT(certifications.when_entered,'%W %M %D, %Y %H:%i:%s') AS edit_time,
		types_certifications.type$lang AS type,
		types_certifications.id_record AS cert_record,
		types_certifications.expires AS expires,
		types_cert_agencies.agency_desc$lang AS agency,
		types_certifications.flag_cuser AS flag_cuser,
		members.team_province AS province
		FROM certifications
		LEFT JOIN users ON users.id_record=certifications.id_users
		LEFT JOIN members ON certifications.id_members=members.id_record
		LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
		LEFT JOIN types_cert_agencies ON types_cert_agencies.id_record=certifications.id_certifying_agency
		WHERE certifications.id_record='$s_id'
		";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>$l[query_failed]:$query");

	if (mysql_num_rows($result)) {
		$r = mysql_fetch_array($result);

		### Edit Start
		if ($a_cert[$t_id] >= 2 && $mode == "update") {
			echo "<form method=GET action=member_cert_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm><input type=hidden name=mode value=\"$mode\">
					".SIDHIDDEN."
					<input type=hidden name=mydate value=\"\">
					<input type=hidden name=myfield value=\"\">
					<input type=hidden name=cert_name value=\"$r[type]\">
					<input type=hidden name=e_certification value=".($r[cert_record] + 0).">
					<input type=hidden name=certdays".$r[cert_record]." value=".($r[expires] + 0).">
					".($s_id ? "<input type=hidden name=s_id value=\"$s_id\"><input type=hidden name=mode1 value=\"$mode1\"><input type=hidden name=member value=\"$member\">" : "")."
					".($t_id ? "<input type=hidden name=t_id value=\"$t_id\">" : "")."
					<input type=hidden name=e_cert_changed value=\"F\">
					<table class=BodyInputTbl width=100% border=0>
					<table class=BodyInputTbl width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
					<tr><td class=BodyInputTd align=left colspan=2><p class=BodyH2>$l[edit_certification]</p></td></tr>
					<tr><td class=BodyInputTd colspan=2><hr></td></tr>
					<tr>";

			# Element: Certification
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>$l[certification]</p></td>
					<td class=BodyInputTd><p class=BodyInp>$r[type]</p></td>";

			if ($a_cert[$t_id] == 128 || $r[flag_cuser] == 0){
				# Element: Date Certified
				list($year,$month,$day) = input_date(e_certified,$r[date_certified],30,0);		
				$year = str_replace('yyyy_e_certified"','yyyy_e_certified" onChange="document.MForm.e_cert_changed.value=\'T\'; dateAdd(\'N\');"', $year); # Add java change code to year select tag 
				$month = str_replace('mm_e_certified"','mm_e_certified" onChange="document.MForm.e_cert_changed.value=\'T\'; dateAdd(\'N\');"', $month); # Add java change code to month select tag 
				$day = str_replace('dd_e_certified"','dd_e_certified" onChange="document.MForm.e_cert_changed.value=\'T\'; dateAdd(\'N\');"', $day); # Add java change code to day select tag 
				echo "<tr>
						<td class=BodyInputTd><input type=hidden name=e_cert_fields value=\"T\"><p class=BodyInpH>$l[certified]</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<small><small>$l[yyyy_mm_dd]</small></small>
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_certified',1);
						//--></SCRIPT>
						</p></td>
						</tr>";

				# Element: Date Expires
				list($year,$month,$day) = input_date(e_expires,$r[date_expires],30,10);		
				$year = str_replace('yyyy_e_expires"','yyyy_e_expires" onChange="document.MForm.e_cert_changed.value=\'T\';"', $year); # Add java change code to year select tag 
				$month = str_replace('mm_e_expires"','mm_e_expires" onChange="document.MForm.e_cert_changed.value=\'T\';"', $month); # Add java change code to month select tag 
				$day = str_replace('dd_e_expires"','dd_e_expires" onChange="document.MForm.e_cert_changed.value=\'T\';"', $day); # Add java change code to day select tag 
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>$l[expires]</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<small><small>$l[yyyy_mm_dd]</small></small>
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_expires',1);
						//--></SCRIPT>
						</p></td>
						</tr>";

			# Element: Date of Test
			list($year,$month,$day) = input_date(e_date_test,$r[date_test],30,0);		
			$year = str_replace('yyyy_e_date_test"','yyyy_e_date_test" onChange="document.MForm.myfield.value=\'e_date_test\'; dateReset();"', $year); # Add java change code to year select tag 
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>$l[test]&nbsp;<sup><strong>(2)</strong></sup></p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<small><small>$l[yyyy_mm_dd]</small></small>
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_date_test',0);
					//--></SCRIPT>
					</p></td>
					</tr>";

			}else{
				echo "<tr>
							<td class=BodyInputTd><input type=hidden name=e_cert_fields value=\"F\"><p class=BodyInpH>$l[certified]</p></td>
							<td class=BodyInputTd><p class=BodyInp>$r[date_certified]</p></td>
							</tr>
							<tr>
							<td class=BodyInputTd><p class=BodyInpH>$l[expires]</p></td>
							<td class=BodyInputTd><p class=BodyInp>$r[date_expires]</p></td>
							</tr>
							<tr>
							<td class=BodyInputTd><p class=BodyInpH>$l[test]</p></td>
							<td class=BodyInputTd><p class=BodyInp>$r[date_test]</p></td>
							</tr>";
			}
			
			# Element: Agency
			echo "<tr><td class=BodyInputTd><p class=BodyInpH>$l[agency]</p></td>
					<td class=BodyInputTd>";
					$query2 = "
						SELECT types_cert_agencies.agency_desc$lang AS type, 
						if(types_cert_agencies.id_record='$r[id_certifying_agency]',' SELECTED','') AS selected,
						types_cert_agencies.id_record AS id_record 
						FROM types_cert_agencies
						WHERE (agency_province='$r[province]' OR agency_province=9999)
						ORDER BY types_cert_agencies.agency_desc$lang";
					$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>$l[query_failed]:$query2");
					if (mysql_num_rows($result2)) {
						echo "<select class=BodyInp name=e_agency size=1>
								<option value=\"\">";
						while ($r2 = mysql_fetch_array($result2)) {
								echo "<option value=$r2[id_record]$r2[selected]>$r2[type]";
						}
						echo "</select>";
					}else{
						# Nothing matched the query
						echo "<p class=BodyTxt>$l[no_results]</p>";
					}
			echo "</td></tr>";

			# Element: Search 1 date/Mock
			list($year,$month,$day) = input_date(e_search1,$r[date_search1],5,0);		
			$year = str_replace('yyyy_e_search1"','yyyy_e_search1" onChange="document.MForm.myfield.value=\'e_search1\'; dateReset();"', $year); # Add java change code to year select tag 
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>$l[search1]&nbsp;<sup><strong>(2)</strong></sup></p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<small><small>$l[yyyy_mm_dd]</small></small>&nbsp;&nbsp;&nbsp;$l[mock]?<input class=BodyChk type=\"checkbox\" name=\"e_mock1\" value=\"1\" " . ("$r[flag_search1]" == "1" ? "checked" : "") . ">
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_search1',0);
					//--></SCRIPT>
					</p></td>
					</tr>";

			# Element: Search 2 date/Mock
			list($year,$month,$day) = input_date(e_search2,$r[date_search2],5,0);		
			$year = str_replace('yyyy_e_search2"','yyyy_e_search2" onChange="document.MForm.myfield.value=\'e_search2\'; dateReset();"', $year); # Add java change code to year select tag 
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>$l[search2]&nbsp;<sup><strong>(2)</strong></sup></p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<small><small>$l[yyyy_mm_dd]</small></small>&nbsp;&nbsp;&nbsp;$l[mock]?<input class=BodyChk type=\"checkbox\" name=\"e_mock2\" value=\"1\" " . ("$r[flag_search2]" == "1" ? "checked" : "") . ">
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_search2',0);
					//--></SCRIPT>
					</p></td>
					</tr>";

			# Notes	
			echo "<tr><td class=BodyInputTd colspan=2><p class=BodyTxt><sup><strong>(2)</strong></sup>&nbsp;&nbsp;$l[required_search_manager]</p></td></tr>";

			$last_edit=$l[last_edited_by];
			echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>
			<tr><td class=BodyInputTd colspan=2><p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$r[edit_time],ereg_replace("\[user\]",$r[user],$last_edit))."</p></td></tr>";

			echo "</table>
					<input class=BodyBut type=submit name=action value=$l[save]>
					".($mode=="update" ? "<input class=BodyBut type=submit name=action value=$l[delete]>" : "")."
					<input class=BodyBut type=reset value=$l[reset]>
					<input class=BodyBut type=submit name=action value=$l[cancel]>
					</form>";
				#	</table>";
				

		}elseif($a_cert[$t_id] >= 1 && $mode == "display"){
	############# DISPLAY START

	### SECTION: Main Table Body
			echo "<table class=BodyInputTbl width=100% border=0>
					<table class=BodyInputTbl width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
					<tr>
					<td class=BodyInputTd colspan=2><p class=BodyH2>$l[display_certification]</p></td></tr>
					<tr>
					<td class=BodyInputTd colspan=2><hr></td>
					</tr>
					<tr>
					<table class=BodyInputTbl>";
					$query = "
						SELECT certifications.id_record AS record, 
						certifications.date_certified,
						certifications.date_expires,
						certifications.date_test,
						certifications.id_instructor,
						certifications.date_search1,
						certifications.flag_search1,
						certifications.date_search2,
						certifications.flag_search2,
						types_certifications.type$lang AS type,
						types_cert_agencies.agency_desc$lang AS agency
						FROM certifications
						LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
						LEFT JOIN types_cert_agencies ON types_cert_agencies.id_record=certifications.id_certifying_agency
						WHERE certifications.id_members='$s_id'
						ORDER BY certifications.id_types_certifications
						";
					$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>$l[query_failed]:$query");
					if (mysql_num_rows($result)) {
						echo "<td class=BodyInputTd colspan=2>
								<table class=BodyInputTbl>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[certification]</p></td>
								<td class=BodyInputTd><p class=BodyInp>$r[type]</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[certified]</p></td>
								<td class=BodyInputTd><p class=BodyInp>$r[date_certified]</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[expires]</p></td>
								<td class=BodyInputTd><p class=BodyInp>$r[date_expires]</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[test]</p></td>
								<td class=BodyInputTd><p class=BodyInp>$r[date_test]</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[agency]</p></td>
								<td class=BodyInputTd><p class=BodyInp>$r[agency]</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[search1]</p></td>
								<td class=BodyInputTd><p class=BodyInp>$r[date_search1]</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[mock]?</p></td>
								<td class=BodyInputTd><p class=BodyInp>".($r[flag_search1] ? $l[yes] : $l[no])."</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[search2]</p></td>
								<td class=BodyInputTd><p class=BodyInp>$r[date_search2]</p></td>
								</tr>
								<tr>
								<td class=BodyInputTd><p class=BodyInpH>$l[mock]?</p></td>
								<td class=BodyInputTd><p class=BodyInp>".($r[flag_search2] ? $l[yes] : $l[no])."</p></td>
								</tr>
								</table>";
					}else{
						# Nothing matched the query
						echo "<td class=BodyInputTd colspan=2><p class=BodyTxt>$l[none].</p></td>";
					}
			echo "</tr>";

			$last_edit=$l[last_edited_by];
			echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>
			<tr><td class=BodyInputTd colspan=2><p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$r[edit_time],ereg_replace("\[user\]",$r[user],$last_edit))."</p></td></tr>";

			echo "</table>";

	############# DISPLAY END

		}else{
			bad_access($_SERVER['QUERY_STRING']);
		}
			
		foot();

	}else{
		# Nothing matched the query
		echo "<td colspan=2><p class=BodyTxt>$l[none].</p></td>";
	}

?>