<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: member_edit.php
	# Version: 1 February 2005
	# Author: Calvin Martini
	# Description: This script provides editing of new and existing contact records.

	session_start(); 

	require("globals.php");
	require("lib_js.php");

	connect_db();

	# Set client variables
	$client_vars=array('s_id','t_id','mode'); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}
	if ( isset($t_id) ) { $team = $t_id; }else{ $team = NULL; }
	
	$provinces = get_provinces();
	
	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_members");

	# Check to ensure proper access level to edit record
	if (max($a_memb) < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	# Intitialize form input values
	if ($mode == "update" || $mode == "display") {
		$query = "SELECT *, DATE_FORMAT(when_entered,'%W %M %D, %Y %H:%i:%s') AS edit_time FROM members WHERE id_record='$s_id'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);
			$e_member_id=$r['member_id'];
			$e_id_users=$r['id_users'];
			$e_when_entered=$r['edit_time'];
			$e_name_first=$r['name_first'];
			$e_name_last=$r['name_last'];
			$e_name_middle=$r['name_middle'];
			$e_name_common=$r['name_common'];
			$e_address_street=$r['address_street'];
			$e_address_city=$r['address_city'];
			$e_id_address_province=$r['id_address_province'];
			$e_address_pcode=$r['address_pcode'];
			$e_health=$r['health'];
			$e_date_applied=$r['date_applied'];
			$e_date_approved=$r['date_approved'];
			$e_date_joined=$r['date_joined'];
			$e_date_expires=$r['date_expires'];
			$e_title=$r['title'];
			$e_name_next_of_kin=$r['name_next_of_kin'];
			$e_occupation=$r['occupation'];
			$e_date_of_birth=$r['date_of_birth'];
			$e_flag_director=$r['flag_director'];
			$e_flag_alternate=$r['flag_alternate'];
			$e_flag_emergency=$r['flag_emergency'];
			$e_flag_admin=$r['flag_admin'];
			$e_flag_inactive=$r['flag_inactive'];
			$e_notes=$r['notes'];
			$e_display_priority=$r['display_priority'];
			$e_phone_work=$r['phone_work'];
			$e_phone_home=$r['phone_home'];
			$e_phone_cell=$r['phone_cell'];
			$e_phone_fax=$r['phone_fax'];
			$e_phone_pager=$r['phone_pager'];
			$e_phone_other=$r['phone_other'];
			$e_email=$r['email'];
			$e_team_province=$r['team_province'];
			$e_opt1=$r['OptField1'];
			$e_opt2=$r['OptField2'];
			$e_opt3=$r['OptField3'];
			$e_opt4=$r['OptField4'];
			$e_opt5=$r['OptField5'];
		}else{
			echo $l['no_results'];
		}
	}else{
		# This is a new record
		$e_display_priority=2;

	}

	head("member_edit");
	echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/calendar/calendar.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/CallCalendar.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/add_days.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/CallWindow.js\"></SCRIPT>
			";
	if ($a_province == -1 && !$e_team){
		# If user has access to all provinces, include javascript to update teams list based on province selection
		echo "<SCRIPT LANGUAGE=\"JavaScript\">";
		team_js("",1,0);
		echo "</SCRIPT>";
	}

	if (($mode == "update" && $a_memb[$t_id] >= 2) || ($mode == "new" && max($a_memb) >= 2 )) {

			echo "<form method=POST action=member_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm onSubmit=\"document.MForm.e_id_teams.name='e_id_teams[]'\">
					<input type=hidden name=mode value=\"$mode\">
					".SIDHIDDEN."
					".($s_id ? "<input type=hidden name=s_id value=\"$s_id\">" : "")."
					".($t_id ? "<input type=hidden name=t_id value=\"$t_id\">" : "")."
					<input type=hidden name=e_cert_changed value=\"F\">
					<input type=hidden name=mydate value=\"\">
					<input type=hidden name=myfield value=\"\">
					<input type=hidden name=FlagState value=0>
					<input type=hidden name=cert_name value=\"\">
					<table class=BodyInputTbl width=100%>
					<table class=BodyInputTbl width=100% cols=2 cellpadding=0 cellspacing=1>
					<tr>
					<td class=BodyInputTd colspan=2><p class=BodyH2>
					".($mode == "update" ? "".$l['edit_member']."" : $l['new_member'])."
					</p></td></tr>
					<tr>
					<td class=BodyInputTd colspan=2><hr></td>
					</tr>
					<tr>
					<td class=BodyInputTd colspan=2><p class=BodyH3>1. ".$l['personal_information']."</p></td>
					</tr>";
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['name_first']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_name_first size=20 value=\"$e_name_first\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['name_middle']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_name_middle size=20 value=\"$e_name_middle\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['name_last']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_name_last size=20 value=\"$e_name_last\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['name_common']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_name_common size=20 value=\"$e_name_common\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>$l[street]&nbsp;<sup><strong>(1)</strong></sup></p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_address_street size=20 value=\"$e_address_street\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['city']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_address_city size=20 value=\"$e_address_city\"></td>
					</tr>";
				$query2 = "SELECT id_record, type$lang AS province FROM types_province ORDER BY province";
				$result2 = mysql_query($query2) or die ($l['query_failed']);
				if (mysql_num_rows($result2)) { 
					echo "<tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
							<td class=BodyInputTd>
							<select class=BodyInp name=e_id_address_province value=\"$e_id_address_province\">
							<option value=\"\">";
					while ($r2 = mysql_fetch_array($result2)) {
						echo "<option value=\"".$r2['id_record']."\"".($e_id_address_province==$r2['id_record'] ? " selected" : "").">".substr($r2['province'],0,20)."\n";
					}
					echo "</select></td></tr>";
				}
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['postal_code']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_address_pcode size=8 value=\"$e_address_pcode\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['health']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_health size=20 value=\"$e_health\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['member_id']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_member_id size=20 value=\"$e_member_id\"></td>
					</tr>";
			list($year,$month,$day) = input_date(e_date_applied,$e_date_applied,30,0);		
			echo	"<tr>				
					<td class=BodyInputTd><p class=BodyInpH>".$l['date_applied']."</p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_date_applied',1);
					//--></SCRIPT>
					</p></td>
					</tr>";
			list($year,$month,$day) = input_date(e_date_approved,$e_date_approved,30,0);		
			echo	"<tr>				
					<td class=BodyInputTd><p class=BodyInpH>".$l['date_approved']."</p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_date_approved',1);
					//--></SCRIPT>
					</p></td>
					</tr>";
			list($year,$month,$day) = input_date(e_date_joined,$e_date_joined,30,0);		
			echo	"<tr>				
					<td class=BodyInputTd><p class=BodyInpH>".$l['date_joined']."</p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_date_joined',1);
					//--></SCRIPT>
					</p></td>
					</tr>";
			list($year,$month,$day) = input_date(e_date_expires,$e_date_expires,5,10);		
			echo	"<tr>				
					<td class=BodyInputTd><p class=BodyInpH>$l[date_expires]</p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>$l[yyyy_mm_dd]</font>
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_date_expires',1);
					//--></SCRIPT>
					</p></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['title']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_title size=20 value=\"$e_title\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['next_of_kin']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_name_next_of_kin size=20 value=\"$e_name_next_of_kin\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['occupation']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_occupation size=20 value=\"$e_occupation\"></td>
					</tr>";
			list($year,$month,$day) = input_date(e_date_of_birth,$e_date_of_birth,80,-15);		
			echo	"<tr>				
					<td class=BodyInputTd><p class=BodyInpH>".$l['date_of_birth']."</p></td>
					<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
					<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
					OutputLink('e_date_of_birth',1);
					//--></SCRIPT>
					</p></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['director']."</p></td>
					<td class=BodyInputTd><input class=BodyChk type=checkbox name=e_flag_director value=1 " . ($e_flag_director == 1 ? "checked" : "") . "></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['alternate']."</p></td>
					<td class=BodyInputTd><input class=BodyChk type=checkbox name=e_flag_alternate value=1 " . ($e_flag_alternate == 1 ? "checked" : "") . "></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['emergency_contact']."</p></td>
					<td class=BodyInputTd><input class=BodyChk type=checkbox name=e_flag_emergency value=1 " . ($e_flag_emergency == 1 ? "checked" : "") . " onChange=\"MForm.FlagState.value='" . ($e_flag_emergency == 1 ? "No longer an emergency contact." : "Now an emergency contact.") . "';\"></td>
					</tr>
					<tr class=BodyInputTd>
					<td class=BodyInputTd><p class=BodyInpH>".$l['team_administrator']."</p></td>
					<td class=BodyInputTd><input class=BodyChk type=checkbox name=e_flag_admin value=1 " . ($e_flag_admin == 1 ? "checked" : "") . "></td>
					</tr>
					<tr class=BodyInputTd>
					<td class=BodyInputTd><p class=BodyInpH>".$l['inactive']."</p></td>
					<td class=BodyInputTd><input class=BodyChk type=checkbox name=e_flag_inactive value=1 " . ($e_flag_inactive == 1 ? "checked" : "") . "></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['notes']."</p></td>
					<td class=BodyInputTd><textarea class=BodyInp name=e_notes cols=36 rows=4>$e_notes</textarea></td>
					</tr>";
			if ($a_province == -1){
				# User is authorized for all provinces, display province selection list
				$query2 = "SELECT id_record, type$lang AS province FROM types_province ORDER BY province";
				$result2 = mysql_query($query2) or die ($l['query_failed']);
				if (mysql_num_rows($result2)) { 
					echo "<tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['team_province']."</p></td>
							<td class=BodyInputTd>
							<select class=BodyInp name=e_team_province value=\"$e_team_province\" onchange=\"PopulateTeams(MForm.e_team_province,MForm.e_id_teams,1);\">
							<option value=\"\">
							<option value=\"9999\">".$l['all'];
					while ($r2 = mysql_fetch_array($result2)) {
						echo "<option value=\"".$r2['id_record']."\"".($e_team_province==$r2['id_record'] ? " selected" : "").">".substr($r2['province'],0,20)."\n";
					}
					echo "</select></td></tr>";
				}
			}else{
				# User has access to one province
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['team_province']."</p></td>
						<td class=BodyInputTd><p class=BodyInp><input class=BodyInp type=hidden name=e_team_province size=20 value=\"$a_province\">".$a_provName[$lang]."</p></td>
						</tr>";
			}

			# Select list for team
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['team']."</p></td>
					<td class=BodyInputTd>";

			# Display team select based on access
			if ($a_team == -1 && $a_province == -1){
				# User has access to all province and all teams
				if ($e_team_province && $e_team_province != 9999){
					$query3 = "SELECT 
						teams.id_record, 
						teams.team_name,
						if(teams_members.id_teams=teams.id_record,\"selected\",\"\") AS selected
						FROM teams
						LEFT JOIN teams_members ON teams.id_record=teams_members.id_teams AND teams_members.id_members='$s_id'
						WHERE id_address_province='$e_team_province'
						ORDER BY team_name";
					$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
					if (mysql_num_rows($result3)) {
						echo "<select class=BodyInp name=e_id_teams size=5 MULTIPLE>
									<option value=\"0\">".$l['none']."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>";
						while ($r3 = mysql_fetch_array($result3)) {
								echo "<option value=".$r3['id_record']." ".(mysql_num_rows($result3)==1 ?"selected" : $r3['selected']).">".$r3['team_name'];
						}
						echo "</select>";
					}else{
						# Nothing matched the query
						echo "<p class=BodyTxt>".$l['no_results']."</p>";
					}
				}else{
					$o_string="<option>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>";
					echo "<select class=BodyInp name=e_id_teams size=5 MULTIPLE><option value=\"".$r['id_teams']."\" selected>$team".$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string."</select>";
				}
			}elseif($a_team == -1 && $a_province >0){
				# User has access to one province and all teams in that province
				$query3 = "SELECT 
					teams.id_record, 
					teams.team_name,
					if(teams_members.id_teams=teams.id_record,\"selected\",\"\") AS selected
					FROM teams
					LEFT JOIN teams_members ON teams.id_record=teams_members.id_teams AND teams_members.id_members='$s_id'
					WHERE id_address_province='$a_province'
					ORDER BY team_name";
				$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
				if (mysql_num_rows($result3)) {
					echo "<select class=BodyInp name=e_id_teams size=5 MULTIPLE>
							<option value=\"0\">".$l['none'];
					while ($r3 = mysql_fetch_array($result3)) {
							echo "<option value=".$r3['id_record']." ".(mysql_num_rows($result3)==1 ? "selected" : $r3['selected']).">".$r3['team_name'];
					}
					echo "</select>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
			}elseif($a_team >0){
				# User has single team access
				$e_id_teams=$a_team;
				$e_team_province=$a_province;
				echo "<input class=BodyInp type=hidden name=e_id_teams value=\"$a_team\">$a_team_name</td></tr>";
			}else{
				# User can access two or more teams
				$query3 = "SELECT teams.id_record, teams.team_name,
					if(teams_members.id_teams=teams.id_record,\"selected\",\"\") AS selected
					FROM teams
					LEFT JOIN team_access ON team_access.id_teams=teams.id_record  
					LEFT JOIN teams_members ON teams.id_record=teams_members.id_teams AND teams_members.id_members='$s_id'
					WHERE team_access.access_members>=2 AND team_access.id_users='$id_recno'
					GROUP BY teams.id_record
					ORDER BY team_name";
				$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
				if (mysql_num_rows($result3)) {
					echo "<select class=BodyInp name=e_id_teams size=5 MULTIPLE>
							<option value=\"0\">".$l['none'];
					while ($r3 = mysql_fetch_array($result3)) {
							echo "<option value=".$r3['id_record']." ".(mysql_num_rows($result3)==1 ? "selected" : $r3['selected']).">".$r3['team_name'];
					}
					echo "</select>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
			}

			echo "</td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['display_priority']."</p></td>
					<td class=BodyInputTd>
					<select class=BodyInp name=e_display_priority value=$e_display_priority>
					<option value=1" . ($e_display_priority == 1 ? " selected" : "")  . ">".$l['high']." 
					<option value=2" . ($e_display_priority == 2 ? " selected" : "")  . ">".$l['normal']." 
					<option value=3" . ($e_display_priority == 3 ? " selected" : "")  . ">".$l['low']." 
					<option value=4" . ($e_display_priority == 4 ? " selected" : "")  . ">".$l['lowx']." 
					<option value=5" . ($e_display_priority == 5 ? " selected" : "")  . ">".$l['lowxx']." 
					</select>
					</td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_home']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_home size=20 value=\"$e_phone_home\" onChange=\"if(MForm.e_flag_emergency.checked){MForm.FlagState.value='Home phone changed from ".($e_phone_home ? "$e_phone_home " : "(blank) ")."to ' + MForm.e_phone_home.value + '.';}\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_work']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_work size=20 value=\"$e_phone_work\" onChange=\"if(MForm.e_flag_emergency.checked){MForm.FlagState.value='Work phone changed from ".($e_phone_work ? "$e_phone_work " : "(blank) ")."to ' + MForm.e_phone_work.value + '.';}\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_pager']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_pager size=20 value=\"$e_phone_pager\" onChange=\"if(MForm.e_flag_emergency.checked){MForm.FlagState.value='Pager phone changed from ".($e_phone_pager ? "$e_phone_pager " : "(blank) ")."to ' + MForm.e_phone_pager.value + '.';}\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_cell']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_cell size=20 value=\"$e_phone_cell\" onChange=\"if(MForm.e_flag_emergency.checked){MForm.FlagState.value='Cellular phone changed from ".($e_phone_cell ? "$e_phone_cell " : "(blank) ")."to ' + MForm.e_phone_cell.value + '.';}\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_fax']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_fax size=20 value=\"$e_phone_fax\" onChange=\"if(MForm.e_flag_emergency.checked){MForm.FlagState.value='Fax phone changed from ".($e_phone_fax ? "$e_phone_fax " : "(blank) ")."to ' + MForm.e_phone_fax.value + '.';}\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['phone_other']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_other size=20 value=\"$e_phone_other\" onChange=\"if(MForm.e_flag_emergency.checked){MForm.FlagState.value='Other phone changed from ".($e_phone_other ? "$e_phone_other " : "(blank) ")."to ' + MForm.e_phone_other.value + '.';}\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['email']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_email size=20 value=\"$e_email\"></td>
					</tr>";

			# Variable fields
			$query = "SELECT field_desc$lang AS field_desc, enabled FROM types_vars WHERE id_type=1 ORDER BY id_record LIMIT 5";
			$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$count=1; 
				while ($r = mysql_fetch_array($result)) {
					if ($r['enabled']){
						$var = "e_opt$count";
						echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$r['field_desc']."</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_opt$count size=30 value=\"".$$var."\"></td>
						</tr>";
					}
					$count++;				
				}
			}

			# Notes	
			echo "<tr><td colspan=2><p class=BodyInp><sup><strong>(1)</strong></sup>&nbsp;&nbsp;".$l['required_director']."</p></td></tr>";

			if ($a_cert[$t_id] >= 1 ||($mode == "new" && max($a_cert) >= 1 )){
		#### SECTION: Certifications		
				echo "<tr>
						<td class=BodyInputTd colspan=2><hr></td>
						</tr>
						<tr>
						<td class=BodyInputTd colspan=2><p class=BodyH3>2. ".$l['certifications']."</p></td>
						</tr>
						<tr>";
						$query = "
							SELECT certifications.id_record AS record, 
							certifications.date_test,
							certifications.date_certified,
							certifications.date_expires,
							certifications.id_instructor,
							certifications.date_search1,
							certifications.flag_search1,
							certifications.date_search2,
							certifications.flag_search2,
							types_certifications.type$lang AS type,
							types_cert_agencies.agency_desc$lang AS agency
							FROM certifications
							LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
							LEFT JOIN types_cert_agencies ON types_cert_agencies.id_record=certifications.id_certifying_agency
							WHERE certifications.id_members='$s_id'
							ORDER BY certifications.id_types_certifications
							";
						$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							echo "<td class=BodyInputTd colspan=2><table class=BodyInputTbl>
									<tr>";
									if ($a_cert[$t_id] >= 2){
										echo "<td><p class=BodyH3>".$l['edit']."</p></td>";
									}elseif ($a_cert[$t_id] == 1){
										echo "<td><p class=BodyH3>".$l['display']."</p></td>";
									}
									if ($a_cert[$t_id] >= 4){
										echo "<td><p class=BodyH3>".$l['delete']."</p></td>";
									}
							echo "<td class=BodyInputTh><p class=BodyH3>".$l['certification']."</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['certified']."</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['expires']."</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['agency']."</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['test']."</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['search1']."</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['mock']."?</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['search2']."</p></td>
									<td class=BodyInputTh><p class=BodyH3>".$l['mock']."?</p></td>
									<td></td>
									</tr>
									<tr>";
							while ($r = mysql_fetch_array($result)) {
									echo "<tr>";
									if ($a_cert[$t_id] >= 2 ||($mode == "new" && max($a_cert) >= 2 )){
										echo "<td class=BodyInputTd><a class=BodyLink href=\"member_cert_edit.php?mode1=$mode&member=$s_id&t_id=$t_id&mode=update&s_id=".$r['record'].SIDAND."\">E</a></td>";
									}elseif ($a_cert[$t_id] == 1 ||($mode == "new" && max($a_cert) == 1 )){
										echo "<td class=BodyInputTd><a class=BodyLink href=\"member_cert_edit.php?mode1=$mode&member=$s_id&t_id=$t_id&mode=display&s_id=".$r['record'].SIDAND."\">D</a></td>";
									}
									if ($a_cert[$t_id] >= 4 ||($mode == "new" && max($a_cert) >= 4 )){
										echo "<td class=BodyInputTd><a class=BodyLink href=\"member_cert_save.php?mode1=$mode&action=".$l['delete']."&member=$s_id&t_id=$t_id&mode=update&s_id=".$r['record']."&cert_name=".str_replace(" ","+",$r['type']).SIDAND."\">X</a></td>";
									}
									echo "<td class=BodyInputTd><p class=BodyInp>".$r['type']."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".$r['date_certified']."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".$r['date_expires']."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".$r['agency']."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".$r['date_test']."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".$r['date_search1']."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".($r['flag_search1'] ? $l['yes'] : $l['no'])."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".$r['date_search2']."</p></td>
									<td class=BodyInputTd><p class=BodyInp>".($r['flag_search2'] ? $l['yes'] : $l['no'])."</p></td>
									";
									echo "</tr>";
							}
							echo "</table>";
	#						if ($a_cert[$team] >= 4){
	#							# Add Column	
	#							echo "<tr><td class=BodyInputTd colspan=2><input class=BodyBut type=submit name=action value=\"".$l['delete_selected']."\"></td></tr>";
	#						}
						}else{
							# Nothing matched the query
							echo "<td class=BodyInputTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td>";
						}
				echo "</tr>";
			}

		### Subsection :Add
			if ($a_cert[$t_id] >= 2 ||($mode == "new" && max($a_cert) >= 2)){
				echo "<tr><td class=BodyInputTd colspan=2><p class=BodyH3>".$l['add_certification']."</p><td></tr>";

				# Element: Certification
				echo "<tr><td class=BodyInputTd><p class=BodyInpH>".$l['certification']."</p></td>
						<td class=BodyInputTd>";
				$query = "
					SELECT id_record, 
					type$lang AS type,
					expires,
					desc_type$lang as desc_type
					FROM types_certifications 
					WHERE 1=1".($a_province==9999 ? "" : " AND (id_province='$e_team_province' OR id_province='9999')");
				if ($a_all_teams==0){
					$query.=" AND (";
					$count=count($e_id_teams);
					for ($i=0; $i<$count; $i++){
						$t_id = $e_id_teams[$i];
						$query.="id_teams='$e_id_teams[$i]' OR ";
					}
					$query.="id_teams='9999' OR id_teams IS NULL)";
				}
				$query.=" ORDER BY types_certifications.type$lang";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					$flag=0;
					$day_string = "<input type=hidden name=\"certdays0\" value=0>";
					echo "<select class=BodyInp name=e_certification size=1 onChange=\"MForm.cert_name.value=this.options[this.selectedIndex].text;dateAdd('Y');if(".($a_cert[$t_id] == 128 ||($mode == "new" && max($a_cert) == 128) ? "1==0" : "1==1")." && this.options[this.selectedIndex].value==".($sc_record+0)."){alert('".esc_string($l['cert_alert'])."');}\">
							<option value=\"0\">".$l['none'];
					while ($r = mysql_fetch_array($result)) {
						$day_string .= "<input type=hidden name=\"certdays".$r['id_record']."\" value=".($r['expires'] + 0).">";   
						echo "<option value=".$r['id_record'].">".$r['type'];
						if ($r['desc_type']){$flag=1;}
					}
					echo "</select>";
					echo $day_string;
					if ($flag==1){ 
						echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_certifications','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
					}
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
				echo "</td></tr>";

				# Element: Date Certified
			#	if ($a_cert[$t_id] == 128 ||($mode == "new" && max($a_cert) == 128)){
					list($year,$month,$day) = input_date(e_certified,$e_certified,30,0);
					$year = str_replace('yyyy_e_certified"','yyyy_e_certified" onChange="MForm.e_cert_changed.value=\'T\'; dateAdd(\'N\');"', $year); # Add java change code to year select tag 
					$month = str_replace('mm_e_certified"','mm_e_certified" onChange="MForm.e_cert_changed.value=\'T\'; dateAdd(\'N\');"', $month); # Add java change code to month select tag 
					$day = str_replace('dd_e_certified"','dd_e_certified" onChange="MForm.e_cert_changed.value=\'T\'; dateAdd(\'N\');"', $day); # Add java change code to day select tag 
					echo "<tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['certified']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
							<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
							OutputLink('e_certified',1);
							//--></SCRIPT>
							</p></td>
							</tr>";
			#	}

				# Element: Date Expires
			#	if ($a_cert[$t_id] == 128 ||($mode == "new" && max($a_cert) == 128)){
					list($year,$month,$day) = input_date(e_expires,$e_expires,30,10);		
					$year = str_replace('yyyy_e_expires"','yyyy_e_expires" onChange="MForm.e_cert_changed.value=\'T\';"', $year); # Add java change code to year select tag 
					$month = str_replace('mm_e_expires"','mm_e_expires" onChange="MForm.e_cert_changed.value=\'T\';"', $month); # Add java change code to month select tag 
					$day = str_replace('dd_e_expires"','dd_e_expires" onChange="MForm.e_cert_changed.value=\'T\';"', $day); # Add java change code to day select tag 
					echo "<tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['expires']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
							<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
							OutputLink('e_expires',0);
							//--></SCRIPT>
							</p></td>
							</tr>";
			#	}

				# Element: Agency
				echo "<tr><td class=BodyInputTd><p class=BodyInpH>".$l['agency']."</p></td>
						<td class=BodyInputTd>";
						$query = "
							SELECT types_cert_agencies.agency_desc$lang AS type, 
							types_cert_agencies.id_record AS id_record 
							FROM types_cert_agencies
							WHERE 1=1".($a_province == -1 ? "" : " AND (agency_province='$e_team_province' OR agency_province='9999')")."
							ORDER BY types_cert_agencies.agency_desc$lang";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							echo "<select class=BodyInp name=e_agency size=1>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
									echo "<option value=".$r['id_record'].">".$r['type']."";
							}
							echo "</select>";
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td></tr>";

				# Element: Date of Test
			#	if ($a_cert[$t_id] >= 2 ||($mode == "new" && max($a_cert) == 128)){
					list($year,$month,$day) = input_date(e_date_test,$e_date_test,30,0);		
					echo "<tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['test']."&nbsp;<sup><strong>(2)</strong></sup></p></td>
							<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
							<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
							OutputLink('e_date_test',0);
							//--></SCRIPT>
							</p></td>
							</tr>";
			#	}

				# Element: Search 1 date/Mock
				list($year,$month,$day) = input_date(e_search1,$e_search1,5,0);		
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['search1']."&nbsp;<sup><strong>(2)</strong></sup></p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;&nbsp;".$l['mock']."?<input class=BodyChk type=\"checkbox\" name=\"e_mock1\" value=\"1\" " . ("$e_mock1" == "1" ? "checked" : "") . ">
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_search1',0);
						//--></SCRIPT>
						</p></td>
						</tr>";

				# Element: Search 2 date/Mock
				list($year,$month,$day) = input_date(e_search2,$e_search2,5,0);		
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['search2']."&nbsp;<sup><strong>(2)</strong></sup></p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;&nbsp;".$l['mock']."?<input class=BodyChk type=\"checkbox\" name=\"e_mock2\" value=\"1\" " . ("$e_mock2" == "1" ? "checked" : "") . ">
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_search2',0);
						//--></SCRIPT>
						</p></td>
						</tr>";

				# Add Column	
				echo "<tr><td class=BodyInputTd colspan=2><input class=BodyBut type=submit name=action value=".$l['add']."></td></tr>";

				# Notes	
				echo "<tr><td class=BodyInputTd colspan=2><p class=BodyTxt><sup><strong>(2)</strong></sup>&nbsp;&nbsp;".$l['required_search_manager']."</p></td></tr>";

			}

			echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>";

			echo "</table>
					<input class=BodyBut type=submit name=action value=".$l['save'].">
					".($mode=="update" && $a_memb[$t_id] >= 4 ? "<input class=BodyBut type=submit name=action value=".$l['delete']." onClick=\"if(MForm.e_flag_emergency.checked){MForm.FlagState.value=1;}\">" : "")."
					<input class=BodyBut type=reset value=".$l['reset'].">
					<input class=BodyBut type=submit name=action value=".$l['cancel'].">
					</form>";
				#	</table>";

			if ($mode=="update") {
					$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
					$result = mysql_query($query) or die ($l['query_failed'].":$query");
					if (mysql_num_rows($result)) {
						$r = mysql_fetch_array($result);
					$last_edit=$l['last_edited_by'];
					echo "<p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p>";
					}
			}
	}elseif($mode == "display"){
############# DISPLAY START

### SECTION: Main Table Body
		echo "<table class=BodyInputTbl width=100% border=0>
				<table class=BodyInputTbl width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyInputTd align=left colspan=2><p class=BodyH2>".$l['display_member']."</></td></tr>
				<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>1. ".$l['personal_information']."</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['name_first']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_name_first</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['name_middle']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_name_middle</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['name_last']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_name_last</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['name_common']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_name_common</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['street']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_address_street</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['city']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_address_city</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>";
				$query = "SELECT type1, type2, type3, type4, type5 FROM types_province WHERE id_record='$e_id_address_province'";
				connect_db();
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					$r = mysql_fetch_array($result);
					echo $r['type'.$lang];
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['health']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_health</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['member_id']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_member_id</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['date_applied']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_date_applied</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['date_approved']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_date_approved</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['date_joined']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_date_joined</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['date_expires']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_date_expires</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['title']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_title</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['next_of_kin']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_name_next_of_kin</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['occupation']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_occupation</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['date_of_birth']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_date_of_birth</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['director']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>" . ($e_flag_director == 1 ? $l['yes'] : $l['no']) . "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['alternate']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>" . ($e_flag_alternate == 1 ? $l['yes'] : $l['no']) . "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['emergency_contact']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>" . ($e_flag_emergency == 1 ? $l['yes'] : $l['no']) . "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['team_administrator']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>" . ($e_flag_admin == 1 ? $l['yes'] : $l['no']) . "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['inactive']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>" . ($e_flag_inactive == 1 ? $l['yes'] : $l['no']) . "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['notes']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_notes</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['teams']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>";
				$query = "
					SELECT teams.id_record AS id_record, 
					teams.team_name AS team_name 
					FROM teams_members
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					WHERE teams_members.id_members='$s_id'
					ORDER BY team_name
					";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							echo "".$r['team_name']."<br>";
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		$pri[1]=$l['high']; $pri[2]=$l['normal']; $pri[3]=$l['low']; $pri[4]=$l['lowx']; $pri[5]=$l['lowxx'];
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['display_priority']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$pri[$e_display_priority]</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_home']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_home</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_work']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_work</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_pager']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_pager</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_cell']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_cell</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_fax']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_fax</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_other']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_other</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['email']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_email</p></td>
				</tr>";

			# Variable fields
			$query = "SELECT field_desc$lang AS field_desc, enabled FROM types_vars WHERE id_type=1 ORDER BY field_desc$lang LIMIT 5";
			$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$count=1; 
				while ($r = mysql_fetch_array($result)) {
					if ($r['enabled']){
						$var = "e_opt$count";
						echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$r['field_desc']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>".$$var."</p></td>
						</tr>";
					}
					$count++;				
				}
			}

	#### SECTION: Certifications		
		echo "<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><h3 class=normal>2. ".$l['certifications']."</h3></td>
				</tr>
				<tr>";
				$query = "
					SELECT certifications.id_record AS record, 
					certifications.date_certified,
					certifications.date_expires,
					certifications.date_test,
					certifications.id_instructor,
					certifications.date_search1,
					certifications.flag_search1,
					certifications.date_search2,
					certifications.flag_search2,
					types_certifications.type$lang AS type,
					types_cert_agencies.agency_desc$lang AS agency
					FROM certifications
					LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
					LEFT JOIN types_cert_agencies ON types_cert_agencies.id_record=certifications.id_certifying_agency
					WHERE certifications.id_members='$s_id'
					ORDER BY certifications.id_types_certifications
					";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					echo "<td class=BodyInputTd colspan=2><table class=BodyInputTbl>
							<tr>
							<td class=BodyInputTh><p class=BodyH2>".$l['certification']."</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['certified']."</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['expires']."</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['agency']."</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['test']."</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['search1']."</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['mock']."?</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['search2']."</p></td>
							<td class=BodyInputTh><p class=BodyH2>".$l['mock']."?</p></td>
							<td class=BodyInputTh></td>
							</tr>";
					while ($r = mysql_fetch_array($result)) {
							echo "<tr>
							<td class=BodyInputTd><p class=BodyInp>".$r['type']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".$r['date_certified']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".$r['date_expires']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".$r['agency']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".$r['date_test']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".$r['date_search1']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".($r['flag_search1'] ? $l['yes'] : $l['no'])."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".$r['date_search2']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".($r['flag_search2'] ? $l['yes'] : $l['no'])."</p></td>
							</tr>";
					}
					echo "</table>";
				}else{
					# Nothing matched the query
					echo "<td class=BodyInputTd colspan=2><p class=BodyInp>".$l['none'].".</p></td>";
				}
		echo "</tr>";

		$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$last_edit=$l['last_edited_by'];
			echo "<tr><td colspan=2><hr></td></tr>
			<tr><td colspan=2><p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p></td></tr>";
		}

		echo "</table>";

############# DISPLAY END

	}else{
		bad_access($_SERVER['QUERY_STRING']);
	}
			
	foot();

?>