<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: member_print.php
	# Version: 21 November 2004
	# Author: Calvin Martini
	# Description: This script provides print display of existing member records.

	session_start(); 

	require("globals.php");

	connect_db();

	# Set client variables
	$client_vars=array(
		's_id',
		't_id',
		'mode'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_members");

	# Check to ensure proper access level to edit record
	if ($a_memb[$t_id] < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	# Intitialize form input values
	$query = "SELECT *, DATE_FORMAT(when_entered,'%W %M %Y %H:%i:%s') AS edit_time FROM members WHERE id_record='$s_id'";
	$result = mysql_query($query) or die ("$l[query_failed]:$query");
	if (mysql_num_rows($result)) {
		$r=mysql_fetch_array($result);
		$e_id_users=$r[id_users];
		$e_when_entered=$r[edit_time];
		$e_name_first=$r[name_first];
		$e_name_last=$r[name_last];
		$e_name_middle=$r[name_middle];
		$e_name_common=$r[name_common];
		$e_address_street=$r[address_street];
		$e_address_city=$r[address_city];
		$e_id_address_province=$r[id_address_province];
		$e_address_pcode=$r[address_pcode];
		$e_health=$r[health];
		$e_date_applied=$r[date_applied];
		$e_date_approved=$r[date_approved];
		$e_date_joined=$r[date_joined];
		$e_date_expires=$r[date_expires];
		$e_title=$r[title];
		$e_name_next_of_kin=$r[name_next_of_kin];
		$e_occupation=$r[occupation];
		$e_date_of_birth=$r[date_of_birth];
		$e_flag_director=$r[flag_director];
		$e_flag_alternate=$r[flag_alternate];
		$e_flag_emergency=$r[flag_emergency];
		$e_flag_admin=$r[flag_admin];
		$e_flag_inactive=$r[flag_inactive];
		$e_notes=$r[notes];
		$e_display_priority=$r[display_priority];
		$e_phone_work=$r[phone_work];
		$e_phone_home=$r[phone_home];
		$e_phone_cell=$r[phone_cell];
		$e_phone_fax=$r[phone_fax];
		$e_phone_pager=$r[phone_pager];
		$e_phone_other=$r[phone_other];
		$e_email=$r[email];
		$e_opt1=$r['OptField1'];
		$e_opt2=$r['OptField2'];
		$e_opt3=$r['OptField3'];
		$e_opt4=$r['OptField4'];
		$e_opt5=$r['OptField5'];

		echo "<html><head><title>$l[contact]</title>";
		readfile("css_print.html");
		echo "</head><body>";
		
		echo "<a href=\"member_edit.php?s_id=$s_id&t_id=$t_id&mode=$mode".SIDAND."\">$l[return_previous]</a><br><br>";

		### SECTION: Main Table Body
		echo "<table width=* border=0 cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=normal align=left colspan=2><h2 class=normal>$l[display_member]</h2></td></tr>
				<tr>
				<td colspan=2><hr></td>
				</tr>
				<tr>
				<td colspan=2><h3 class=normal>1. $l[personal_information]</h3></td>
				</tr>
				<tr>
				<td><p>$l[name_first]</p></td>
				<td><p>$e_name_first&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[name_middle]</p></td>
				<td><p>$e_name_middle&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[name_last]</p></td>
				<td><p>$e_name_last&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[name_common]</p></td>
				<td><p>$e_name_common&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[street]</p></td>
				<td><p>$e_address_street&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[city]</p></td>
				<td><p>$e_address_city&nbsp;</p></td>
				</tr>
				<tr>
				<td valign=top><p>$l[province]</p></td>
				<td><p>";
				$query = "SELECT type1, type2, type3, type4, type5 FROM types_province WHERE id_record='$e_id_address_province'";
				$result = mysql_query($query) or die ("$l[query_failed]:$query");
				if (mysql_num_rows($result)) {
					$r = mysql_fetch_array($result);
					echo $r['type'.$x];
				}else{
					# Nothing matched the query
					echo $l[no_results];
				}
		echo "&nbsp;</p></td>
				<tr>
				<td><p>$l[postal_code]</p></td>
				<td><p>$e_address_pcode&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[health]</p></td>
				<td><p>$e_health&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[date_applied]</p></td>
				<td><p>$e_date_applied&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[date_approved]</p></td>
				<td><p>$e_date_approved&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[date_joined]</p></td>
				<td><p>$e_date_joined&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[date_expires]</p></td>
				<td><p>$e_date_expires&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[title]</p></td>
				<td><p>$e_title&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[next_of_kin]</p></td>
				<td><p>$e_name_next_of_kin&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[occupation]</p></td>
				<td><p>$e_occupation&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[date_of_birth]</p></td>
				<td><p>$e_date_of_birth&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[director]</p></td>
				<td><p>" . ($e_flag_director == 1 ? "$l[yes]" : "$l[no]") . "</p></td>
				</tr>
				<tr>
				<td><p>$l[alternate]</p></td>
				<td><p>" . ($e_flag_alternate == 1 ? "$l[yes]" : "$l[no]") . "</p></td>
				</tr>
				<tr>
				<td><p>$l[emergency_contact]</p></td>
				<td><p>" . ($e_flag_emergency == 1 ? "$l[yes]" : "$l[no]") . "</p></td>
				</tr>
				<tr>
				<td><p>$l[team_administrator]</p></td>
				<td><p>" . ($e_flag_admin == 1 ? "$l[yes]" : "$l[no]") . "</p></td>
				</tr>
				<tr>
				<td><p>$l[inactive]</p></td>
				<td><p>" . ($e_flag_inactive == 1 ? "$l[yes]" : "$l[no]") . "</p></td>
				</tr>
				<tr>
				<td valign=top><p>$l[notes]</p></td>
				<td><p>$e_notes&nbsp;</p></td>
				</tr>
				<tr>
				<td valign=top><p>$l[teams]</p></td>
				<td><p>";
				$query = "
					SELECT teams.id_record AS id_record, 
					teams.team_name AS team_name 
					FROM teams_members
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					WHERE teams_members.id_members='$s_id'
					ORDER BY team_name
					";
				$result = mysql_query($query) or die ("$l[query_failed]:$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							echo "$r[team_name]<br>";
					}
				}else{
					# Nothing matched the query
					echo $l[no_results];
				}
		$pri[1]=$l[high]; $pri[2]=$l[normal]; $pri[3]=$l[low]; $pri[4]=$l['lowx']; $pri[5]=$l['lowxx'];
		echo "&nbsp;</p></td>
				</tr>
				<tr>
				<td valign=top><p>$l[display_priority]</p></td>
				<td><p>$pri[$e_display_priority]</p></td>
				</tr>
				<tr>
				<td><p>$l[phone_home]</p></td>
				<td><p>$e_phone_home&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[phone_work]</p></td>
				<td><p>$e_phone_work&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[phone_pager]</p></td>
				<td><p>$e_phone_pager&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[phone_cell]</p></td>
				<td><p>$e_phone_cell&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[phone_fax]</p></td>
				<td><p>$e_phone_fax&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[phone_other]</p></td>
				<td><p>$e_phone_other&nbsp;</p></td>
				</tr>
				<tr>
				<td><p>$l[email]</p></td>
				<td><p>$e_email&nbsp;</p></td>
				</tr>";

			# Variable fields
			$query = "SELECT field_desc$lang AS field_desc, enabled FROM types_vars WHERE id_type=1 ORDER BY field_desc$lang LIMIT 5";
			$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$count=1;
				while ($r = mysql_fetch_array($result)) {
					$var = "e_opt$count";
					if ($r['enabled']){
						echo "<tr>
						<td><p>".$r['field_desc']."&nbsp;</p></td>
						<td><p>".$$var."&nbsp;</p></td>
						</tr>";
					}
					$count++;				
				}
			}

	#### SECTION: Certifications		
		echo "<tr>
				<td colspan=2><hr></td>
				</tr>
				<tr>
				<td colspan=2><h3 class=normal>2. $l[certifications]</h3></td>
				</tr>
				<tr>
				<td colspan=2>";
				$query = "
					SELECT certifications.id_record AS record, 
					certifications.date_certified,
					certifications.date_expires,
					certifications.date_test,
					certifications.id_instructor,
					certifications.date_search1,
					certifications.flag_search1,
					certifications.date_search2,
					certifications.flag_search2,
					types_certifications.type$lang AS type,
					types_cert_agencies.agency_desc$lang AS agency
					FROM certifications
					LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
					LEFT JOIN types_cert_agencies ON types_cert_agencies.id_record=certifications.id_certifying_agency
					WHERE certifications.id_members='$s_id'
					ORDER BY certifications.id_types_certifications
					";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>$l[query_failed]:$query");
				if (mysql_num_rows($result)) {
					echo "<table>
							<tr>
							<td><h3 class=normal>$l[certification]</h3></td>
							<td><h3 class=normal>$l[certified]</h3></td>
							<td><h3 class=normal>$l[expires]</h3></td>
							<td><h3 class=normal>$l[agency]</h3></td>
							<td><h3 class=normal>$l[test]</h3></td>
							<td><h3 class=normal>$l[search1]</h3></td>
							<td><h3 class=normal>$l[mock]?</h3></td>
							<td><h3 class=normal>$l[search2]</h3></td>
							<td><h3 class=normal>$l[mock]?</h3></td>
							<td></td>
							</tr>";
					while ($r = mysql_fetch_array($result)) {
							echo "<tr>
							<td><p>$r[type]&nbsp;</p></td>
							<td><p>$r[date_certified]&nbsp;</p></td>
							<td><p>$r[date_expires]&nbsp;</p></td>
							<td><p>$r[agency]&nbsp;</p></td>
							<td><p>$r[date_test]&nbsp;</p></td>
							<td><p>$r[date_search1]&nbsp;</p></td>
							<td><p>".($r[flag_search1] ? $l[yes] : $l[no])."</p></td>
							<td><p>$r[date_search2]&nbsp;</p></td>
							<td><p>".($r[flag_search2] ? $l[yes] : $l[no])."</p></td>
							</tr>";
					}
					echo "</table>";
				}else{
					# Nothing matched the query
					echo "<p>$l[none].</p>";
				}
		echo "</td></tr>
				<tr>
				<td colspan=2><hr></td>
				</tr>
				</table>";

		$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
		$result = mysql_query($query) or die ("$l[query_failed]:$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$last_edit=$l[last_edited_by];
			echo "<p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r[full_name],$last_edit))."</p>";
		}
	
	}else{
		echo $l[no_results];
	}

	echo "</body></html>";

?>
