<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003,2004 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: ops_signin.php
	# Version: 31 May 2004
	# Author: Calvin Martini
	# Description: ops module sign-in/out script

	# Set start time for performance data
	$time_start = getmicrotime();

	session_start(); 

	# Set client variables
	$client_vars=array('e_filter','s_id','o_filter','sort','order','orderID','orderlname','orderfname','orderteam','orderin','orderout'); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");
	require("lib_js.php");

	connect_db();

	require("ops_testvars.php"); # Defines variables for testing purposes

	# Set the user's team access arrays
#	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_searches");

	# Check to ensure proper access level to edit record
#	if ( max($a_search) < 1 || isset($_SESSION["id_user"])==FALSE) {
#		fail_access($_SERVER['QUERY_STRING']);
#	}

	# Change the sort order for the specified column
	if ($sortState[1]==""){ 
		$sortState = array("ASC","ASC","ASC","ASC","ASC","ASC");
	}
	
	# Change the filter
	if ($e_filter){
		switch ($e_filter) {
			case "0":
				# All
				$filter = "";
				break;
			case "1":
				# Signed in (no time out)
				$filter = "WHERE log_attend.when_out='00000000000000'";
				break;
			case "2":
				# Signed out (time out)
				$filter = "WHERE log_attend.when_out!='00000000000000'";
				break;
			case "3":
				# Members
				$filter = "WHERE log_attend.id_members!=0";
				break;
			case "4":
				# Civilians
				$filter = "WHERE log_attend.id_civilians!=0";
				break;
		}
	}
	
	# Set the sort criteria
	if ($sort){
			switch ($sort) {
			case "1":
				$sortBy="ID";
				break;
			case "2":
				$sortBy="lname"; 
				break;
			case "3":
				$sortBy="fname"; 
				break;
			case "4":
				$sortBy="team_name";
				break;
			case "5":
				$sortBy="log_attend.when_in"; 
				break;
			case "6":
				$sortBy="log_attend.when_out"; 
				break;
		}
		if ($order == "ASC" || $order == "DESC"){
			$sortBy .= " ".$order;
			$sortState[$sort] = $order;
		} 
	}

	
	# If an operation is specified, get it's data
	$opStart = "";
	if ($_SESSION['op_id']){
		$query = "SELECT
					ops.id_record,
					DATE_FORMAT(team_search.when_activated,'%b %e, %T %Y') AS start_dt
					FROM ops
					LEFT JOIN team_search ON team_search.id_record=ops.id_team_search
					WHERE ops.id_record='".$_SESSION['op_id']."'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$opInfo = mysql_fetch_array($result);
			$opStart = $opInfo['start_dt'];
		}
	}
	
	# Get team names
	$teams=get_teams();
	
	# Output headers
	echo "<HEAD>
		<TITLE>".$l['app_title']."</TITLE>
		<META name=\"description\" content=\"E-GADS! (Electronic GSAR Administrative Database System). Copyright 2003 by Calvin Martini. All Rights Reserved.\">
		<META name=\"keywords\" content=\"Search and Rescue, SAR, GSAR, database, E-GADS, e-gads\">
		<link rel=\"stylesheet\" href=\"css.html\" type=\"text/css\">

			<SCRIPT LANGUAGE=\"JavaScript\">
				<!-- Begin
					// Set operation start time for elapsed timer
					startDate = new Date(\"$opStart\");
					// Set operation period interval (hours)
					opInterval = 12;
				//  End -->
			</SCRIPT>

			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/datetimepicker.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/rtc.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/CallWindow.js\"></SCRIPT>";



	# Validation script - ensures input is valid		
	echo "<SCRIPT LANGUAGE=\"JavaScript\">
		function validateSave() {
			if (document.MForm.e_input.value.length < 4){
				alert(\"".ereg_replace("\[field\]",$l['sign_in'],ereg_replace("\[length\]","3",$l['too_short']))."\");
				return false;
			}
			// document.MForm.submit();
			return true;
		}
		</SCRIPT>";

	echo "</HEAD>
			<BODY onLoad='startRTC();startElapsed();'>";

	echo "<form method=POST action=ops_signin_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm>
			".SIDHIDDEN."
			<input type=hidden name=sortState[1] value=\"".$sortState[1]."\">
			<input type=hidden name=sortState[2] value=\"".$sortState[2]."\">
			<input type=hidden name=sortState[3] value=\"".$sortState[3]."\">
			<input type=hidden name=sortState[4] value=\"".$sortState[4]."\">
			<input type=hidden name=sortState[5] value=\"".$sortState[5]."\">
			<input type=hidden name=sortState[6] value=\"".$sortState[6]."\">
			<input type=hidden name=s_id value=\"$s_id\">
			<input type=hidden name=e_id_users=\"$e_id_users\">";

	# Output the status line
	echo "
		<table border=0 cellspacing=0 width='100%'>
			<tr bgcolor='#000000' style='font-family: Verdana, Tahoma, Arial; font-size: x-small'>
				<td style='font-family: Verdana, Tahoma, Arial; font-size: x-small; color: green'>E-GADS v".EGADSVER."</td>
				<td style='font-family: Verdana, Tahoma, Arial; font-size: x-small; color: green'>".$l['user_id'].": $id_user</td>
				<td style='font-family: Verdana, Tahoma, Arial; font-size: x-small; color: green'>".$l['op'].": $s_id</td>
				<td style='font-family: Verdana, Tahoma, Arial; font-size: x-small; color: green; text-align: right'>".$l['operational_period'].": </td>
				<td ID=\"oPeriod\" style='font-family: Verdana, Tahoma, Arial; font-size: x-small; color: green; text-align: left'></td>
				<td style='font-family: Verdana, Tahoma, Arial; font-size: x-small; color: green; text-align: right'>".$l['elapsed'].":</td>
				<td ID=\"elapsedTimer\" style='font-family: Verdana, Tahoma, Arial; font-size: x-small; color: green; text-align: left'></td>
				<td width=*>&nbsp;</td>
			</tr>
		</table>";



	# Output the user entry area
	echo "<p class=BodyInpH>".$l['sign_in']."<input type=text name=e_input size=20>&nbsp;
			".$l['time_in']."<input ID=\"rtcTimer\" name=e_datetime type=text size=25 readonly><a href=\"javascript:stopRTC();NewCal('rtcTimer','yyyymmdd',true,24)\"><img src='images/cal.gif' width=16 height=16 border=0 alt=\"".$l[pick_a_date]."\"></a> <a href=\"javascript:startRTC();\"><img src='images/clock3.gif' width=16 height=16 border=0 alt='Start Clock'></a>&nbsp
			<input class=BodyBut type=submit name=action value=\"".$l['add']."\" onClick=\"return validateSave()\">&nbsp;
			<input class=BodyBut type=submit name=action value=\"".$l['add_civilian']."\">
			";

	# Display the filters area
	echo "&nbsp;&nbsp;".$l['view']."<select class=BodyInp name=e_filter value=\"$e_filter\" onChange=\"self.location.href='".$_SERVER["PHP_SELF"]."?e_filter=' + this.options[this.selectedIndex].value\">
						<option value=0" . ($e_filter == 0 ? " selected" : "")  . ">".$l['all']." 
						<option value=1" . ($e_filter == 1 ? " selected" : "")  . ">".$l['signed_in']." 
						<option value=2" . ($e_filter == 2 ? " selected" : "")  . ">".$l['signed_out']." 
						<option value=3" . ($e_filter == 3 ? " selected" : "")  . ">".$l['members']." 
						<option value=4" . ($e_filter == 4 ? " selected" : "")  . ">".$l['civilians']." 
					</select></p>";
	
	# Display the main table
	$query = "SELECT
				log_attend.id_record,
				log_attend.id_users,
				log_attend.when_entered,
				log_attend.id_members,
				log_attend.id_civilians,
				log_attend.id_ops,
				IF(log_attend.id_members,CONCAT('M',log_attend.id_members),CONCAT('C',log_attend.id_civilians)) AS ID,
				IF(log_attend.id_members,members.name_first,civilians.name_first) AS fname,
				IF(log_attend.id_members,members.name_last,civilians.name_last) AS lname,
				CONCAT(IF(log_attend.id_members,members.name_last,civilians.name_last),', ',IF(log_attend.id_members,members.name_first,civilians.name_first)) AS full_name,
				teams.team_name,
				teams_members.id_teams,
				log_attend.when_in,
				log_attend.when_out
				FROM log_attend 
				LEFT JOIN civilians ON log_attend.id_civilians=civilians.id_record
				LEFT JOIN members ON log_attend.id_members=members.id_record
				LEFT JOIN teams_members ON members.id_record=teams_members.id_members
				LEFT JOIN teams on teams_members.id_teams=teams.id_record
				".($filter ? $filter : "")."
				GROUP BY log_attend.id_record
				".($sortBy ? "ORDER BY $sortBy" : "");

	#/////////////////////////////////// 
	#/// Perform the query
	#///////////////////////////////////
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$row_count = mysql_num_rows($result); 

	# Display the results/report

	# Set the table data full span width for colspan parameter
	$fullspan=(count($col)+count($sub_col))+1;

	if (mysql_num_rows($result)) {

		echo "<table class=BodyRepTbl cellpadding=2 cellspacing=0>";

		# Display column headings
		echo "<tr>
					<td class=BodyRepTh><p class=BodyRepH2><a class=BodyLink href=\"javascript:flipSelect()\">".$l['select']."</a></p></td>
					<td class=BodyRepTh><p class=BodyRepH2><a class=BodyLink href=\"ops_signin.php?sort=1&order=".flipOrder($sortState[1])."\">".$l['ID']."</a></p></td>
					<td class=BodyRepTh><p class=BodyRepH2><a class=BodyLink href=\"ops_signin.php?sort=2&order=".flipOrder($sortState[2])."\">".$l['lname']."</a></p></td>
					<td class=BodyRepTh><p class=BodyRepH2><a class=BodyLink href=\"ops_signin.php?sort=3&order=".flipOrder($sortState[3])."\">".$l['fname']."</a></p></td>
					<td class=BodyRepTh><p class=BodyRepH2><a class=BodyLink href=\"ops_signin.php?sort=4&order=".flipOrder($sortState[4])."\">".$l['team']."</a></p></td>
					<td class=BodyRepTh><p class=BodyRepH2><a class=BodyLink href=\"ops_signin.php?sort=5&order=".flipOrder($sortState[5])."\">".$l['time_in']."</a></p></td>
					<td class=BodyRepTh><p class=BodyRepH2><a class=BodyLink href=\"ops_signin.php?sort=6&order=".flipOrder($sortState[6])."\">".$l['time_out']."</a></p></td>
					</tr>";

		$count = 0;
		# Display the table data
		while ($r = mysql_fetch_array($result)) {

			echo "<tr>";
			echo "<td class=BodyInputTd>
						<input type=hidden name=e_count[$count] value=\"$count\">
						<input type=hidden name=e_id[$count] value=\"".$r['id_record']."\">
						<input type=hidden name=e_mid[$count] value=\"".$r['id_members']."\">
						<input type=hidden name=e_cid[$count] value=\"".$r['id_civilians']."\">
						<input class=BodyChk type=checkbox id=chk$count name=e_select[$count] value=1></td>";

			if ($r['id_civilians']){
				echo "<td class=BodyInputTd><p class=BodyTxt><a class=BodyLink href=\"ops_civilian_edit.php?mode=update&s_id=".$r['id_civilians'].SIDAND."\">C".$r['id_civilians']."</a>";
			}elseif($r['id_members']){
				echo "<td class=BodyInputTd><p class=BodyTxt><a class=BodyLink href=\"member_edit.php?mode=update&t_id=".$r['id_teams']."&s_id=".$r['id_members'].SIDAND."\">M".$r['id_members']."</a>";
			}

			echo "<td class=BodyInputTd><p class=BodyTxt>".$r['lname']."</p></td>
						<td class=BodyInputTd><p class=BodyTxt>".$r['fname']."</p></td>
						<td class=BodyInputTd><p class=BodyTxt>".$r['team_name']."</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_in[$count] size=20 value=\"".$r['when_in']."\" readonly><a href=\"javascript:document.MForm.chk$count.checked='True';NewCal('e_in[$count]','yyyymmdd',true,24)\"><img src='images/cal.gif' width=16 height=16 border=0 alt=\"".$l['pick_a_date']."\"></a></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_out[$count] size=20 value=\"".$r['when_out']."\" readonly><a href=\"javascript:document.MForm.chk$count.checked='True';NewCal('e_out[$count]','yyyymmdd',true,24)\"><img src='images/cal.gif' width=16 height=16 border=0 alt=\"".$l['pick_a_date']."\"></a></td>
						</tr>";
			$count++;
	}

		echo "</table>";

		# Buttons
		echo "<input class=BodyBut type=submit name=action value=\"".$l['delete_selected']."\">&nbsp;
					<input class=BodyBut type=submit name=action value=\"".$l['set_time_in']."\">&nbsp;
					<input class=BodyBut type=submit name=action value=\"".$l['set_time_out']."\">&nbsp;
					<input class=BodyBut type=submit name=action value=\"".$l['save_changes']."\">&nbsp;
					";
		
		# End Form
		echo "</form>";

		# Select Script
		echo "<SCRIPT LANGUAGE=\"JavaScript\">
				<!-- Begin
				function flipSelect(){";
		if ($count>0){
			echo "var flipState = true;
						if(document.MForm.chk0.checked == true){
							flipState = false;
						}

						for (n=0 ; n<$count ; n++){
							eval(\"document.MForm.chk\" + n + \".checked=\" + flipState);
						}";
		}
		echo "}
			//  End -->
		</SCRIPT>";

		# Output performance data
		$time_end = getmicrotime();
		$time = $time_end - $time_start;
		echo "<br><p class=BodyFootTxt>".$l['total_execution_time'].": ".round($time,3)." ".$l['seconds']."&nbsp;&nbsp;&nbsp;&nbsp;".$l['records_displayed'].": $row_count&nbsp;&nbsp;&nbsp;&nbsp;".date("D M j G:i:s T Y");

	}else{
		# Nothing matched the query
		echo "<p class=BodyTxt>".$l['no_results']."</p>";
	}

	#/////////////////////////////////// 
	#/// Finish Page
	#///////////////////////////////////
	foot();

function getmicrotime(){ 
    list($usec, $sec) = explode(" ",microtime()); 
    return ((float)$usec + (float)$sec); 
} 

function flipOrder($sortOrder){
	if ($sortOrder == "ASC"){
		$sortOrder = "DESC";
	}else{
		$sortOrder = "ASC";
	}
	return $sortOrder;
}

function sqldate($dateTime){
	list($dY,$dM,$dD,$tH,$tM,$tS) = sscanf($dateTime,"%d-%d-%d %d:%d:%d");
	$dateTime = sprintf("%04d%02d%02d%02d%02d%02d",$dY,$dM,$dD,$tH,$tM,$tS);
	return $dateTime;
}

function phpdate($dateTime){
	list($dY,$dM,$dD,$tH,$tM,$tS) = sscanf($dateTime,"%4d%2d%2d%2d%2d%2d");
	$dateTime = sprintf("%04d-%02d-%02d %02d:%02d:%02d",$dY,$dM,$dD,$tH,$tM,$tS);
	return $dateTime;
}

?>