<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: ops_signin_save.php
	# Version: 31 May 2004
	# Author: Calvin Martini
	# Description: Save signin record.

	session_start(); 

	# Set client variables
	$client_vars=array(
		'action',
		'e_input',
		'e_filter',
		's_id',
		'e_select',
		'sortState',
		'e_id_users',
		'e_datetime',
		'e_id',
		'e_count',
		'e_mid',
		'e_cid',
		'e_in',
		'e_out',

		'$e_name_first',
		'$e_name_last',
		'$e_address_street',
		'$e_address_city',
		'$e_id_address_province',
		'$e_address_pcode',
		'$e_health',
		'$e_name_next_of_kin',
		'$e_height',
		'$e_weight',
		'$e_hair',
		'$yyyy_e_date_of_birth-$mm_e_date_of_birth-$dd_e_date_of_birth',
		'$e_notes',
		'$e_phone_work',
		'$e_phone_home',
		'$e_phone_cell',
		'$e_phone_fax',
		'$e_phone_pager',
		'$e_phone_other'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");

	require("ops_testvars.php"); # Defines variables for testing purposes

	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_searches");

	# Check to ensure proper access level to edit record
#	if ($a_search[$team] < 2 || isset($_SESSION["id_user"])==FALSE) {
#		fail_access($_SERVER['QUERY_STRING']);
#	}

	# First, obtain first name and last name from the string
	if(strpos($e_input,",") === false){
		$nameParts = explode(" ",$e_input);
		$firstName = $nameParts[0];
		$lastName = $nameParts[count($nameParts)-1];
		for ($x=1; $x < count($nameParts) - 1; $x++){
			$middleName .= $nameParts[$x]." ";
		}
		$middleName = rtrim($middleName);
	}else{
		list($lastName,$restName) = preg_split("/[\s,]+/",$e_input);
		$nameParts = explode(" ",$restName);
		$firstName = $nameParts[0];
		$middleName = "";
		for ($x=1; $x < count($nameParts) - 1; $x++){
			$middleName .= $nameParts[$x]." ";
		}
		$middleName = rtrim($middleName);
	}
if($debug){print "First Name: $firstName<br>Middle Name: $middleName<br>Last Name: $lastName<br><br>";}

	# Process Actions
	if ($action){
		switch ($action) {
			case $l['add']:
				# Check members for EXACT match records (last name, full name, phone number, member ID)
				$query = "SELECT id_record FROM members WHERE
									'".$e_input."' REGEXP CONCAT('^',name_last,', ?',name_first,'$') OR
									'".$e_input."' REGEXP CONCAT('^',name_first,' ?',name_last,'$') OR
									'".$e_input."' REGEXP CONCAT('^',name_last,', ?',LEFT(name_first,1),'$') OR
									'".$e_input."' REGEXP CONCAT('^',name_first,' ?',LEFT(name_last,1),'$') OR
									'".$e_input."' REGEXP CONCAT('^',LEFT(name_first,1),' ?',name_last,'$') OR
									'".$e_input."' REGEXP CONCAT('^',LEFT(name_last,1),', ?',name_first,'$') OR
									'".$e_input."' REGEXP CONCAT('^',name_first,' ',name_middle,'\.? ',name_last,'$') OR
									'".$e_input."' = member_id OR
									phone_work = '$e_input' OR
									phone_home = '$e_input' OR
									phone_cell = '$e_input' OR
									phone_fax = '$e_input' OR
									phone_pager = '$e_input' OR
									phone_other = '$e_input'";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
if($debug){print "Check members for exact matches:<br><br>$query<br><br>Returned ".mysql_num_rows($result)." records.<br><br>";}
				if (mysql_num_rows($result)) {
					$r = mysql_fetch_array($result);
					$id_members = $r['id_record'];
					$id_civilians = 0;
				}else{
					# Check members for PARTIAL match records (last name, full name, phone number, member ID)
					$query2 = "SELECT id_record FROM members WHERE
										CONCAT(name_last,', ',name_first)  REGEXP '^".$lastName."[[:alpha:]]*, ?".$firstName." ".$middleName."$' OR
										CONCAT(name_first,' ',name_last)  REGEXP '^".$firstName."[[:alpha:]]* ".$middleName." ".$lastName."$' OR
										'".$e_input."' REGEXP CONCAT('^',name_first,' ',name_middle,'[[:alpha:]]* ',name_last,'$') OR
										CONCAT(name_first,' ',name_middle,' ',name_last) REGEXP '^".$firstName." ".$middleName."[[:alpha:]]* ".$lastName."$' OR
										phone_work LIKE '%".$e_input."%' OR
										phone_home LIKE '%".$e_input."%' OR
										phone_cell LIKE '%".$e_input."%' OR
										phone_fax LIKE '%".$e_input."%' OR
										phone_pager LIKE '%".$e_input."%' OR
										phone_other LIKE '%".$e_input."%'";
					$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
if($debug){print "Check members for similar matches:<br><br>$query2<br><br>Returned ".mysql_num_rows($result2)." records.<br><br>";}
					if (mysql_num_rows($result2)) {
						$r2 = mysql_fetch_array($result2);
						$id_members = $r2['id_record'];
						$id_civilians = 0;
					}else{
				
				
						# Check civilian records (last name, full name)
						$query = "SELECT id_record FROM civilians WHERE
										'$firstName $lastName' = CONCAT(name_first,' ',name_last) OR
										'$firstName $lastName' REGEXP CONCAT(name_first,'[[:alpha:]]* ',name_last) OR
										'$firstName $lastName' REGEXP CONCAT(name_first,' ',name_last,'[[:alpha:]]*') OR
										CONCAT(name_first,' ',name_last) REGEXP '".$firstName."[[:alpha:]]* ".$lastName."' OR
										CONCAT(name_first,' ',name_last) REGEXP '".$firstName." ".$lastName."[[:alpha:]]*' OR
										phone_work LIKE '%".$e_input."%' OR
										phone_home LIKE '%".$e_input."%' OR
										phone_cell LIKE '%".$e_input."%' OR
										phone_fax LIKE '%".$e_input."%' OR
										phone_pager LIKE '%".$e_input."%' OR
										phone_other LIKE '%".$e_input."%'";
						$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
if($debug){print "Check civilian records:<br><br>$query<br><br>Returned ".mysql_num_rows($result)." records.<br><br>";}
						if (mysql_num_rows($result)) {
							$r = mysql_fetch_array($result);
							$id_members = 0;
							$id_civilians = $r['id_record'];
						}else{
							# No match, add as civilian

							$query = "INSERT INTO civilians (id_users,name_first,name_last)
												VALUES ('$id_recno','$firstName','$lastName')";
							$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
if($debug){print "Added civilian:<br><br>$query<br><br>";}
							$id_civilians = mysql_insert_id();
							$id_members = 0;
						}
					}
				}

				# Insert the log_attend record
				$query = "INSERT INTO log_attend (id_users,id_members,id_civilians,id_ops,when_in,when_out)
									VALUES ('$id_recno','$id_members','$id_civilians','$s_id','".sqldate($e_datetime)."','00000000000000')";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
if($debug){print "Added attend record:<br><br>$query<br><br>";}
				break;

			case $l['add_civilian']:
				$query = "INSERT INTO civilians (
										id_users,
										name_first,
										name_last,
										address_street,
										address_city,
										id_address_province,
										address_pcode,
										health,
										name_next_of_kin,
										height,
										weight,
										hair,
										date_of_birth,
										notes,
										phone_work,
										phone_home,
										phone_cell,
										phone_fax,
										phone_pager,
										phone_other
									)VALUES (
										'$id_recno',
										'$e_name_first',
										'$e_name_last',
										'$e_address_street',
										'$e_address_city',
										'$e_id_address_province',
										'$e_address_pcode',
										'$e_health',
										'$e_name_next_of_kin',
										'$e_height',
										'$e_weight',
										'$e_hair',
										'$yyyy_e_date_of_birth-$mm_e_date_of_birth-$dd_e_date_of_birth',
										'$e_notes',
										'$e_phone_work',
										'$e_phone_home',
										'$e_phone_cell',
										'$e_phone_fax',
										'$e_phone_pager',
										'$e_phone_other'
									)";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				$id_civilians = mysql_insert_id();

				# Insert the log_attend record
				$query = "INSERT INTO log_attend (id_users,id_members,id_civilians,id_ops,when_in,when_out)
									VALUES ('$id_recno','','$id_civilians','$s_id','$e_in','$e_out')";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				break;
			
			case $l['delete_selected']:
				$count=count($e_select);
				$count2=0;
				if($count>0){
					$query = "DELETE FROM log_attend WHERE id_record IN(";
					foreach($e_count as $i){
						if ($e_select[$i]){
							$query.="'$e_id[$i]',";
							$count2++;
						}
					}
					$query = rtrim($query,",");
					$query .= ")";
				}
				if ($count2>0){
					$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				}
				break;
				
			case $l['set_time_in']:
				$count=count($e_select);
				$count2=0;
				if($count>0){
					$query = "UPDATE log_attend set when_in='".sqldate($e_datetime)."' WHERE id_record IN(";
					foreach($e_count as $i){
						if ($e_select[$i]){
							$query.="'$e_id[$i]',";
							$count2++;
						}
					}
					$query = rtrim($query,",");
					$query .= ")";
				}
				if ($count2>0){
					$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				}
				break;
				
			case $l['set_time_out']:
				$count=count($e_select);
				$count2=0;
				if($count>0){
					$query = "UPDATE log_attend SET when_out='".sqldate($e_datetime)."' WHERE id_record IN(";
					foreach($e_count as $i){
						if ($e_select[$i]){
							$query.="'$e_id[$i]',";
							$count2++;
						}
					}
					$query = rtrim($query,",");
					$query .= ")";
				}
				if ($count2>0){
					$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				}
				break;
				
			case $l['save_changes']:
				$count=count($e_select);
				$count2=0;
				if($count>0){
					foreach($e_count as $i){
						if ($e_select[$i]){
							$query = "UPDATE log_attend SET when_in='".sqldate($e_in[$i])."', when_out='".sqldate($e_out[$i])."' WHERE id_record='$e_id[$i]'";
							$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
							$count2++;
						}
					}
				}
				break;

		}
	}
	################# END SUBSECTIONS

	# logit($logfile,"250\t$mode search report ".($s_id ? "$s_id " : "")."by $id_user.");
#	header("Location: ops_signin.php".SIDPRINT."&e_filter=$e_filter&s_id=$s_id&e_id_ops=$e_id_ops\n\n");
	if($debug){
		print "<br><a href=\"ops_signin.php?e_filter=$e_filter&s_id=$s_id&sortState[1]=$sortState[1]&sortState[2]=$sortState[2]&sortState[3]=$sortState[3]&sortState[4]=$sortState[4]&sortState[5]=$sortState[5]&sortState[6]=$sortState[6]\">Return</a>";
	}else{
		header("Location: ops_signin.php?e_filter=$e_filter&s_id=$s_id&sortState[1]=$sortState[1]&sortState[2]=$sortState[2]&sortState[3]=$sortState[3]&sortState[4]=$sortState[4]&sortState[5]=$sortState[5]&sortState[6]=$sortState[6]\n\n");
	}
	exit;

function sqldate($dateTime){
	list($dY,$dM,$dD,$tH,$tM,$tS) = sscanf($dateTime,"%d-%d-%d %d:%d:%d");
	$dateTime = sprintf("%04d%02d%02d%02d%02d%02d",$dY,$dM,$dD,$tH,$tM,$tS);
	return $dateTime;
}

function phpdate($dateTime){
	list($dY,$dM,$dD,$tH,$tM,$tS) = sscanf($dateTime,"%4d%2d%2d%2d%2d%2d");
	$dateTime = sprintf("%04d-%02d-%02d %02d:%02d:%02d",$dY,$dM,$dD,$tH,$tM,$tS);
	return $dateTime;
}
?>