<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: pub_emergency.php
	# Version: 28 April 2004
	# Author: Calvin Martini
	# Description: Generates an html report containing team emergency contacts

	$time_start = getmicrotime();

	require("globals.php");

	if ($action == "print"){
		echo "<HTML><BODY><a href=$PHP_SELF".SIDPRINT.">".$l['return_previous']."</a><br><br>";
	}elseif($s_report!="map"){
		head("public");
	}

	$cont_filter="";

	# Set the edit/detail link
	if ($a_search == 0) {
		$link="[rectext]";
	}elseif($a_memb == 1) {
		$link="<a href=\"member_edit.php?mode=display&s_id=[recno]".SIDAND."\">[rectext]</a>";
	}elseif($a_memb >= 2) {
		$link="<a href=\"member_edit.php?mode=update&s_id=[recno]".SIDAND."\">[rectext]</a>";
	}

	# Main Query: Set column headings and data fields
	$col[]=$l['full_name']; $col[]=$l['title']; $col[]=$l['phone_work']; $col[]=$l['phone_home']; $col[]=$l['phone_cell']; $col[]=$l['phone_pager']; $col[]=$l['phone_other'];
	$dat[]="full_name"; $dat[]="title"; $dat[]="phone_work"; $dat[]="phone_home"; $dat[]="phone_cell"; $dat[]="phone_pager"; $dat[]="phone_other";

	# Main Query: Set DB query
	$query="
		SELECT members.id_record AS id_record,
		CONCAT(members.name_first,' ',members.name_last) AS full_name,
		members.title AS title,
		IF(teams_members.id_teams,teams_members.id_teams,9999) AS team,
		members.phone_work,
		members.phone_home,
		members.phone_cell,
		members.phone_fax,
		members.phone_pager,
		members.phone_other,
		members.email
		FROM teams_members
		LEFT JOIN members ON members.id_record=teams_members.id_members
		LEFT JOIN teams on teams_members.id_teams=teams.id_record
		WHERE members.flag_emergency=1 AND teams.flag_ops=1
		AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
		ORDER BY team, members.display_priority, members.name_last
		";

	#/////////////////////////////////// 
	#/// Perform the query
	#///////////////////////////////////
	connect_db();
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$row_count = mysql_num_rows($result); 

	# Display the results/report

	# Set the table data full span width for colspan parameter
	$fullspan=(count($col)+count($sub_col));

	if (mysql_num_rows($result)) {
		echo "<h2 class=normal>".$l['team_emergency_contacts']."</h2>
				<h3>".date("D M j G:i:s T Y")."</h3>";
		if ($action == "print"){
			echo "<b>CONTROLLED DOCUMENT:</b> <u>Obsolete once printed</u>.<br>Current version can be found at <a href=http://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/oub_emergency.php?action=print>http://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/pub_emergency.php?action=print</a><br><br>";
		}
		echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\">";

		# Display the table data
		while ($r = mysql_fetch_array($result)) {

			if ($r['team']!=$team_index){

				# Display Team Information
				$team_index=$r['team'];
				if ($team_index != 9999){
					$team_query="SELECT * FROM teams WHERE id_record='$team_index'";
					$team_result = mysql_query($team_query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$team_query");
					$team = mysql_fetch_array($team_result);
					if (mysql_num_rows($result)) {
						echo "<tr><td class=h1 colspan=" . (count($col) + count($sub_col)) . "><h2 class=inverse>" . $team['team_name'] . ($team['team_city'] ? ", ".$team['team_city']: "")."</h2>
								<h3 class=inverse>
								".(strlen($team['phone_1'])>3 ? "&nbsp;&nbsp;<b>".$l['phone_1'].":</b>".$team['phone_1']."<br>": "")."
								".(strlen($team['phone_2'])>3 ? "&nbsp;&nbsp;<b>".$l['phone_2'].":</b> ".$team['phone_2']."<br>": "")."
								".(strlen($team['phone_pager'])>3 ? "&nbsp;&nbsp;<b>".$l['phone_pager'].":</b> ".$team['phone_pager']."<br>": "")."
								".(strlen($team['phone_cell'])>3 ? "&nbsp;&nbsp;<b>".$l['phone_cell'].":</b> ".$team['phone_cell']."<br>": "")."
								".(strlen($team['phone_fax'])>3 ? "&nbsp;&nbsp;<b>".$l['phone_fax'].":</b> ".$team['phone_fax']."<br>": "")."
								".(strlen($team['email'])>3 ? "&nbsp;&nbsp;<b>".$l['email'].":</b> ".$team['email']."<br>": "")."
								</h3>
								</td></tr>";
					}
				}else{
					echo "<tr><td class=h1 colspan=" . (count($col)+count($sub_col)) . "><h2 class=inverse>".$l['unassigned']."</h2></td></tr>";
				}					

				# Display column headings
				echo "<tr>";
				foreach ($col as $column){
						echo "<td class=\"h1\"><h3 class=\"inverse\">$column</h3></td>";
				}	
				if ($query2){
					foreach ($sub_col as $column){
							echo "<td class=\"h1\"><h3 class=\"inverse\">$column</h3></td>";
					}
				}
				echo "</tr>";
			}

			echo "<tr>";
			foreach ($dat as $data){
				echo "<td>$r[$data]&nbsp;</td>";
			}
			echo "</tr>";
		}
		echo "</table>";
		
		$time_end = getmicrotime();
		$time = $time_end - $time_start;
		echo "<br>".$l['total_execution_time'].": ".round($time,3)." ".$l['seconds']."&nbsp;&nbsp;&nbsp;&nbsp;".$l['records_displayed'].": $row_count&nbsp;&nbsp;&nbsp;&nbsp;".date("D M j G:i:s T Y");

	}else{
		# Nothing matched the query
		echo $l['no_results'];
	}	

	if ($action == "print"){
		echo "</BODY></HTML>";
	}else{
		foot();
	}

	function getmicrotime(){ 
		 list($usec, $sec) = explode(" ",microtime()); 
		 return ((float)$usec + (float)$sec); 
	} 

?>