<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: pub_events.php
	# Version: 01 November 2005
	# Author: Calvin Martini
	# Description: Generates an html report containing calendar events

	# Set client variables
	$client_vars=array(
		'period',
		'event_filter',
		's_filter'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");

#	head("public");

#	$event_filter="";

	# Set column headings and data fields
	$col[]=$l['date']; if (! $s_filter){ $col[]=$l['team']; } $col[]=$l['category'];  $col[]=$l['location']; $col[]=$l['description'];
	$dat[]="date"; if (! $s_filter){ $dat[]="team_name"; } $dat[]="category";  $dat[]="location"; $dat[]="description"; 

	# Set DB query
	$query="
		SELECT calendar.id_record AS id_record,
		calendar.id_teams AS team,
		IF(calendar.id_teams=9999,'All',teams.team_name) as team_name,
		calendar.date,
		types_cal_events.type$lang AS category,
		calendar.description,
		calendar.location
		FROM calendar
		LEFT JOIN types_cal_events ON calendar.id_category=types_cal_events.id_record 
		LEFT JOIN teams ON calendar.id_teams=teams.id_record 
		WHERE 1=1
		".($period ? period_filter($period,"calendar.date") : "" )."
		".($event_filter ? " AND calendar.id_category='$event_filter'" : "")."				
		".($s_filter && $s_filter != "All" && $s_filter != "None" ? " AND teams.id_record='$s_filter'" : "")."				
		ORDER BY calendar.date
		";

	#/////////////////////////////////// 
	#/// Perform the query
	#///////////////////////////////////
	connect_db();
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$row_count = mysql_num_rows($result); 

	# Display the results/report

	# Set the table data full span width for colspan parameter
	$fullspan=(count($col)+count($sub_col));
	
	# Echo usage instructions
	echo "<!-- USAGE: pub_events.php?event_filter=[event]&s_filter=[team]&period=[period]\n     WHERE:  [team] = team number\n             [event] = event type number\n             [period] = All, last_month, last_3_months, current_year, next_month, or next_3_months\n-->\n\n";
	echo "<!-- Using: s_filter=$s_filter, period=$period -->\n\n";

	if (mysql_num_rows($result)) {
		echo "<h2 class=normal>".$l['event_calendar']."</h2>
				<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\">";

		# Display column headings
		echo "<tr>";
		foreach ($col as $column){
				echo "<td class=\"h1\"><h3 class=\"inverse\">$column</h3></td>";
		}	
		echo "</tr>";

		# Display the table data
		while ($r = mysql_fetch_array($result)) {
			echo "<tr>";
			foreach ($dat as $data){
				echo "<td>$r[$data]&nbsp;</td>";
			}
			echo "</tr>";
		}
		echo "</table>";
	}else{
		# Nothing matched the query
		echo $l['no_results'];
	}	

#	foot();

?>