# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# MySQL Input Script to Setup E-GADS Database Structure and User Accounts
#
#
#  For MySQL Server
#  version 14 September 2004

DROP DATABASE IF EXISTS egads;

CREATE DATABASE egads;

USE egads;

GRANT SELECT,INSERT,UPDATE,DELETE ON egads.* TO egads@localhost IDENTIFIED BY 'CHANGE_ME';
FLUSH PRIVILEGES;

--
-- Table structure for table 'attend_classes'
--

CREATE TABLE attend_classes (
  id_record int(11) NOT NULL auto_increment,
  id_classes int(10) unsigned default NULL,
  id_members int(10) unsigned default NULL,
  grade int(10) unsigned default NULL,
  instructor int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM;

--
-- Table structure for table 'attend_persons'
--

CREATE TABLE attend_persons (
  id_record int(11) NOT NULL auto_increment,
  id_search int(11) default NULL,
  id_types_position int(10) unsigned default NULL,
  id_members int(10) unsigned default NULL,
  hours int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM;

--
-- Table structure for table 'calendar'
--

CREATE TABLE calendar (
  id_record int(11) NOT NULL auto_increment,
  date varchar(50) default NULL,
  id_teams int(10) unsigned default NULL,
  id_category int(10) unsigned default NULL,
  location varchar(50) default NULL,
  description text,
  id_province int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'certifications'
--

CREATE TABLE certifications (
  id_record int(11) NOT NULL auto_increment,
  id_users int(10) unsigned default NULL,
  when_entered timestamp(14) NOT NULL,
  id_members int(10) unsigned default NULL,
  id_types_certifications int(10) unsigned default NULL,
  date_certified date default NULL,
  date_expires date default NULL,
  date_test date default NULL,
  id_instructor int(10) unsigned default NULL,
  id_certifying_agency int(10) unsigned default NULL,
  date_search1 date default NULL,
  flag_search1 tinyint(3) unsigned default NULL,
  date_search2 date default NULL,
  flag_search2 tinyint(3) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'classes'
--

CREATE TABLE classes (
  id_record int(11) NOT NULL auto_increment,
  id_module int(10) unsigned default NULL,
  id_members int(10) unsigned default NULL,
  location varchar(80) default NULL,
  id_province int(10) unsigned default NULL,
  id_teams int(10) unsigned default NULL,
  when_start datetime default NULL,
  when_end datetime default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM;

--
-- Table structure for table 'courses'
--

CREATE TABLE courses (
  id_record int(11) NOT NULL auto_increment,
  id_teams int(10) unsigned default NULL,
  id_users int(10) unsigned default NULL,
  id_province int(10) unsigned default NULL,
  when_entered timestamp(14) NOT NULL,
  title1 text,
  title2 text,
  title3 text,
  title4 text,
  title5 text,
  id_certifications int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM;

--
-- Table structure for table 'members'
--

CREATE TABLE members (
  id_record int(11) NOT NULL auto_increment,
  id_users int(10) unsigned default NULL,
  when_entered timestamp(14) NOT NULL,
  name_first varchar(50) default NULL,
  name_last varchar(50) NOT NULL default '',
  name_middle varchar(50) default NULL,
  name_common varchar(50) default NULL,
  address_street varchar(50) default NULL,
  address_city varchar(50) default NULL,
  id_address_province tinyint(3) unsigned default NULL,
  address_pcode varchar(7) default NULL,
  health varchar(50) default NULL,
  date_applied date default NULL,
  date_approved date default NULL,
  date_joined date default NULL,
  date_expires date default NULL,
  title varchar(50) default NULL,
  name_next_of_kin varchar(50) default NULL,
  occupation varchar(50) default NULL,
  date_of_birth date default NULL,
  flag_admin tinyint(3) unsigned default NULL,
  flag_director tinyint(3) unsigned default NULL,
  flag_alternate tinyint(3) unsigned default NULL,
  flag_emergency tinyint(3) unsigned default NULL,
  notes varchar(200) default NULL,
  display_priority int(11) default NULL,
  phone_work varchar(20) default NULL,
  phone_home varchar(20) default NULL,
  phone_cell varchar(20) default NULL,
  phone_fax varchar(20) default NULL,
  phone_pager varchar(20) default NULL,
  phone_other varchar(20) default NULL,
  email varchar(50) default NULL,
  team_province int(10) unsigned default NULL,
  flag_inactive tinyint(3) unsigned default NULL,
  member_id varchar(20) default NULL,
 OptField1 varchar(30),
 OptField2 varchar(30),
 OptField3 varchar(30),
 OptField4 varchar(30),
 OptField5 varchar(30),
 PRIMARY KEY  (id_record),
  KEY index_name_last (name_last(10))
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'modules'
--

CREATE TABLE modules (
  id_record int(11) NOT NULL auto_increment,
  id_course int(10) unsigned default NULL,
  type int(10) unsigned default NULL,
  title1 text,
  title2 text,
  title3 text,
  title4 text,
  title5 text,
  pass int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM;

--
-- Table structure for table 'resources'
--

CREATE TABLE resources (
  id_record int(11) NOT NULL auto_increment,
  id_search int(10) unsigned default NULL,
  id_types_resources int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'search'
--

CREATE TABLE search (
  id_record int(11) NOT NULL auto_increment,
  when_entered timestamp(14) NOT NULL,
  id_users int(10) unsigned default NULL,
  name_ic varchar(80) default NULL,
  id_agency varchar(80) default NULL,
  phone_ic varchar(50) default NULL,
  lat_coords_pls decimal(7,4) default NULL,
  long_coords_pls decimal(7,4) default NULL,
  distance_from_pls int(11) default NULL,
  weather_factor tinyint(3) unsigned default NULL,
  when_concluded datetime default NULL,
  when_released datetime default NULL,
  when_found datetime default NULL,
  id_weather int(10) unsigned default NULL,
  id_types_events int(10) unsigned default NULL,
  id_types_environment int(10) unsigned default NULL,
  id_types_activity int(10) unsigned default NULL,
  id_types_reason_1 int(10) unsigned default NULL,
  id_types_reason_2 int(10) unsigned default NULL,
  police_file_id varchar(50) default NULL,
  when_debrief date default NULL,
  loc_debrief varchar(80) default NULL,
  location varchar(80) default NULL,
  id_province int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM;

--
-- Table structure for table 'subjects'
--

CREATE TABLE subjects (
  id_record int(11) NOT NULL auto_increment,
  id_search int(10) unsigned default NULL,
  id_experience tinyint(3) unsigned default NULL,
  id_equipment tinyint(3) unsigned default NULL,
  subject_name varchar(80) default NULL,
  subject_age tinyint(3) unsigned default NULL,
  subject_gender char(1) default NULL,
  id_types_condition int(10) unsigned default NULL,
  id_types_outcome int(10) unsigned default NULL,
  flag_training tinyint(3) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'team_access'
--

CREATE TABLE team_access (
  id_record int(11) NOT NULL auto_increment,
  id_users int(10) unsigned default NULL,
  id_teams int(10) unsigned default NULL,
  access_searches tinyint(3) unsigned default NULL,
  access_members tinyint(3) unsigned default NULL,
  access_training tinyint(3) unsigned default NULL,
  access_certifications tinyint(3) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'team_search'
--

CREATE TABLE team_search (
  id_record int(11) NOT NULL auto_increment,
  id_users int(10) unsigned default NULL,
  id_teams int(10) unsigned default NULL,
  when_entered timestamp(14) NOT NULL,
  id_search int(10) unsigned default NULL,
  hours_total int(10) unsigned default NULL,
  members_total int(10) unsigned default NULL,
  cost_total decimal(9,2) default NULL,
  description text,
  when_alerted datetime default NULL,
  when_activated datetime default NULL,
  when_arrived datetime default NULL,
  when_began datetime default NULL,
  when_returned datetime default NULL,
  gsar_sub_id int(10) unsigned default NULL,
  flag_complete int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM;

--
-- Table structure for table 'teams'
--

CREATE TABLE teams (
  id_record int(11) NOT NULL auto_increment,
  id_users int(10) unsigned default NULL,
  when_entered timestamp(14) NOT NULL,
  team_name varchar(75) default NULL,
  team_address varchar(50) default NULL,
  team_city varchar(50) default NULL,
  team_pcode varchar(7) default NULL,
  phone_1 varchar(20) default NULL,
  phone_2 varchar(20) default NULL,
  phone_pager varchar(20) default NULL,
  phone_cell varchar(20) default NULL,
  phone_fax varchar(20) default NULL,
  email varchar(40) default NULL,
  description longtext,
  id_address_province int(10) unsigned NOT NULL default '0',
  date_established date default NULL,
  id_members int(10) unsigned default NULL,
  flag_ops tinyint(3) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'teams_members'
--

CREATE TABLE teams_members (
  id_record int(11) NOT NULL auto_increment,
  id_members int(10) unsigned default NULL,
  id_teams int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'techniques'
--

CREATE TABLE techniques (
  id_record int(11) NOT NULL auto_increment,
  id_search int(10) unsigned default NULL,
  id_types_techniques int(10) unsigned default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_activity'
--

CREATE TABLE types_activity (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_agencies'
--

CREATE TABLE types_agencies (
  id_record int(11) NOT NULL auto_increment,
  agency_desc1 varchar(75) default NULL,
  agency_desc2 varchar(75) default NULL,
  agency_desc3 varchar(75) default NULL,
  agency_desc4 varchar(75) default NULL,
  agency_desc5 varchar(75) default NULL,
  agency_address varchar(50) default NULL,
  agency_city varchar(50) default NULL,
  agency_province varchar(50) default NULL,
  agency_pcode varchar(7) default NULL,
  agency_phone varchar(12) default NULL,
  agency_fax varchar(12) default NULL,
  agency_email varchar(100) default NULL,
  agency_website varchar(100) default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_cal_events'
--

CREATE TABLE types_cal_events (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_cert_agencies'
--

CREATE TABLE types_cert_agencies (
  id_record int(11) NOT NULL auto_increment,
  agency_desc1 varchar(75) default NULL,
  agency_desc2 varchar(75) default NULL,
  agency_desc3 varchar(75) default NULL,
  agency_desc4 varchar(75) default NULL,
  agency_desc5 varchar(75) default NULL,
  agency_address varchar(50) default NULL,
  agency_city varchar(50) default NULL,
  agency_province varchar(50) default NULL,
  agency_pcode varchar(7) default NULL,
  agency_phone varchar(12) default NULL,
  agency_fax varchar(12) default NULL,
  agency_email varchar(100) default NULL,
  agency_website varchar(100) default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_certifications'
--

CREATE TABLE types_certifications (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  expires int(10) unsigned default NULL,
  id_province int(10) unsigned default NULL,
  id_teams int(11) default NULL,
  flag_cuser tinyint(3),
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_condition'
--

CREATE TABLE types_condition (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_contacts'
--

CREATE TABLE types_contacts (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_environment'
--

CREATE TABLE types_environment (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_equipment'
--

CREATE TABLE types_equipment (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_events'
--

CREATE TABLE types_events (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_experience'
--

CREATE TABLE types_experience (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_outcome'
--

CREATE TABLE types_outcome (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_places'
--

CREATE TABLE types_places (
  id_record int(11) NOT NULL auto_increment,
  type varchar(50) default NULL,
  lat_coords varchar(50) default NULL,
  long_coords varchar(50) default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_position'
--

CREATE TABLE types_position (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_province'
--

CREATE TABLE types_province (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  prefix varchar(50) default NULL,
  logo_file varchar(75) default NULL,
  assoc1 varchar(75) default NULL,
  assoc2 varchar(75) default NULL,
  assoc3 varchar(75) default NULL,
  assoc4 varchar(75) default NULL,
  assoc5 varchar(75) default NULL,
  extent varchar(100) default NULL,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_reason'
--

CREATE TABLE types_reason (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_resources'
--

CREATE TABLE types_resources (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_techniques'
--

CREATE TABLE types_techniques (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'types_weather'
--

CREATE TABLE types_weather (
  id_record int(11) NOT NULL auto_increment,
  type1 varchar(50) default NULL,
  type2 varchar(50) default NULL,
  type3 varchar(50) default NULL,
  type4 varchar(50) default NULL,
  type5 varchar(50) default NULL,
  desc_type1 text,
  desc_type2 text,
  desc_type3 text,
  desc_type4 text,
  desc_type5 text,
  PRIMARY KEY  (id_record)
) TYPE=MyISAM PACK_KEYS=1;

--
-- Table structure for table 'users'
--

CREATE TABLE users (
  id_record int(11) NOT NULL auto_increment,
  id_members int(10) unsigned default NULL,
  full_name varchar(50) default NULL,
  phone varchar(12) default NULL,
  email varchar(100) default NULL,
  user_id varchar(20) NOT NULL default '',
  password varchar(20) default NULL,
  when_expires date default NULL,
  attempt_count tinyint(3) unsigned default NULL,
  when_attempt timestamp(14) NOT NULL,
  flag_diralt tinyint(3) unsigned default NULL,
  flag_admin tinyint(3) unsigned default NULL,
  auth_province int(10) unsigned default NULL,
  PRIMARY KEY  (id_record),
  UNIQUE KEY index_user_id (user_id)
) TYPE=MyISAM PACK_KEYS=1;


CREATE TABLE types_vars (
	id_record int(11) NOT NULL auto_increment,
	id_type Int,
	enabled tinyint(3) unsigned default NULL,
	field_desc1 varchar(20),
	field_desc2 varchar(20),
	field_desc3 varchar(20),
	field_desc4 varchar(20),
	field_desc5 varchar(20),
	PRIMARY KEY (id_record)
) TYPE=MyISAM PACK_KEYS=1;
