#!/usr/local/bin/php -q
<?php

# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2006 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Program: sm_cert_renew.php
# Version: 04 May 2006
# Author: Calvin Martini
# Description: This script automatically renews search manager certifications based on NBGSARA criteria.

require("globals.php");
connect_db();

$recipients = "cdm_ext@rogers.com"; # Email report recipients
$out_file = "/home/httpd/html/nbgsaradb/reports/sm_certs"; # Output file

# Determine periods. Certifications are based on searches in the previous period and are granted based on the current period.
$CApril30 = mktime(0, 0, 0, 4, 30,  date("Y"));
$CDate = mktime(0, 0, 0, date("m"), date("d"),  date("Y"));
If ($CDate  <= $CApril30){
	$CAprilYear = date("Y")-1;
	$PAprilYear = date("Y")-2;
	$CStart = mktime(0, 0, 0, 5, 1,  date("Y")-1);
	$CEnd = mktime(0, 0, 0, 4, 30,  date("Y"));
	$PStart = mktime(0, 0, 0, 5, 1,  date("Y")-2);
	$PEnd = mktime(0, 0, 0, 4, 30,  date("Y")-1);
}else{
	# $CurDate > $CurYearApril30
	$CAprilYear = date("Y");
	$PAprilYear = date("Y")-1;
	$CStart = mktime(0, 0, 0, 5, 1,  date("Y"));
	$CEnd = mktime(0, 0, 0, 4, 30,  date("Y")+1);
	$PStart = mktime(0, 0, 0, 5, 1,  date("Y")-1);
	$PEnd = mktime(0, 0, 0, 4, 30,  date("Y"));
}

# Query to retrieve expired SM certs
$query = "
SELECT certifications.id_record AS c_record,
CONCAT(members.name_last,', ',members.name_first) AS full_name,
members.id_record AS m_record,
teams.team_name,
UNIX_TIMESTAMP(certifications.date_test) AS d_test,
UNIX_TIMESTAMP(certifications.date_certified) AS d_certified,
UNIX_TIMESTAMP(certifications.date_expires) AS d_expired,
certifications.id_instructor,
UNIX_TIMESTAMP(certifications.date_search1) AS d_search1,
certifications.flag_search1,
UNIX_TIMESTAMP(certifications.date_search2) AS d_search2,
certifications.flag_search2,
certifications.id_types_certifications,
certifications.id_certifying_agency,
users.full_name AS user,
DATE_FORMAT(certifications.when_entered,'%W %M %D, %Y %H:%i:%s') AS edit_time,
types_certifications.type1 AS type,
types_certifications.id_record AS cert_record,
types_certifications.expires AS expires,
types_cert_agencies.agency_desc1 AS agency,
types_certifications.flag_cuser AS flag_cuser,
members.team_province AS province
FROM certifications
LEFT JOIN users ON users.id_record=certifications.id_users
LEFT JOIN members ON certifications.id_members=members.id_record
LEFT JOIN teams_members ON members.id_record=teams_members.id_members
LEFT JOIN teams ON teams_members.id_teams=teams.id_record
LEFT JOIN types_certifications ON certifications.id_types_certifications=types_certifications.id_record
LEFT JOIN types_cert_agencies ON types_cert_agencies.id_record=certifications.id_certifying_agency
WHERE UNIX_TIMESTAMP(certifications.date_expires) < UNIX_TIMESTAMP(CONCAT(CURDATE(),' 00:00')) AND certifications.id_types_certifications = 5 AND certifications.date_test != 0
ORDER BY team_name, full_name
";

$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
if (mysql_num_rows($result)) {

	# Wite the modifed user list to disk
	$fp = fopen( $out_file,"w" ) or die ("FATAL: Could not create output file $out_file.");

	fwrite( $fp, "<HTML><BODY><H1>NBGSARA SEARCH MANAGER AUTOMATED CERTIFICATE RENEWALS</H1><H3>Generated $date $time</H3>" );
	fwrite( $fp, "<br>This and other generated reports can be found at <a href=http://www.nbgsara.nb.ca/reports/>http://www.nbgsara.nb.ca/reports/</a><br><br>" );
	fwrite( $fp, "<TABLE border=1 cellpadding=2 cellspacing=0>" );

	# Display column headings
	fwrite( $fp, "<tr>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Team</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Member</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Cert</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Name</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Old Expiry</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Recertified</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Certified</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Expiry</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Test Date</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Search Date 1</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Mock</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Search Date 2</h2></td>" );
	fwrite( $fp, "<td class=h1><h2 class=inverse>Mock</h2></td>" );
	fwrite( $fp,  "</tr>" );


	while ($r = mysql_fetch_array($result)) {

		# Determine if certification is eligible for renewal:
		# (Certified = Last Period OR test = last period)
		# AND ((Search1 = Last Period AND Mock1 = No)
		# OR (Search 1, search2 = Last Period AND Mock1, Mock2 = Yes))


		if(($PEnd > $r['d_certified'] > $PStart) && ((($PEnd > $r['d_search1'] > $PStart) && $r['flag_search1'] == 0) || (($PEnd > $r['d_search1'] > $PStart) && $r['flag_search1'] == 1) && ($PEnd > $r['d_search2'] > $PStart) && $r['flag_search2'] == 1)){
			# Meets criteria for recertification
			$flag_cert = 1;
			$cert_date = date('Y-m-d');
			$exp_date = date('Y-m-d',$CEnd);

			# Update record
			$query="UPDATE certifications SET
					date_certified='$cert_date',
					date_expires='$exp_date ',
					WHERE id_record='".$r['c_record']."'";
			#$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>$l[query_failed]:$query");

		}else{
			# Does not meet criteria for recertification
			$flag_cert = 0;
			$cert_date = date('Y-m-d',$r['d_certified');
			$exp_date = date('Y-m-d',$r['d_expired');
		}


		# Output report row
		fwrite( $fp, "<tr>" );
		fwrite( $fp, "<td>".$r['team_name']."&nbsp;</td>" );
		fwrite( $fp, "<td>".$r['m_record']."&nbsp;</td>" );
		fwrite( $fp, "<td>".$r['c_record']."&nbsp;</td>" );
		fwrite( $fp, "<td>".$r['full_name']."&nbsp;</td>" );
		fwrite( $fp, "<td>".date('Y-m-d',$r['d_expired'])."&nbsp;</td>" );
		fwrite( $fp, "<td>".($flag_cert == 1 ? "Y" : "N")."&nbsp;</td>" );
		fwrite( $fp, "<td>".$cert_date."&nbsp;</td>" );
		fwrite( $fp, "<td>".$exp_date."&nbsp;</td>" );
		fwrite( $fp, "<td>".date('Y-m-d',$r['d_search1'])."&nbsp;</td>" );
		fwrite( $fp, "<td>".($r['flag_search1']==1 ? "Yes" : "No")."&nbsp;</td>" );
		fwrite( $fp, "<td>".date('Y-m-d',$r['d_search2'])."&nbsp;</td>" );
		fwrite( $fp, "<td>".($r['flag_search2']==1 ? "Y" : "N")."&nbsp;</td>" );
		fwrite( $fp, "</tr>" );
	}

	fwrite( $fp, "</TABLE><BR><P>For General Inquiries:<BR>NBGSARA Provincial Secretary<BR><A HREF=\"mailto:info\@nbgsara.nb.ca\">info\@nbgsara.nb.ca</A><BR><BR>For Technical Information:<BR>NBGSARA Provincial Webmaster<BR><A HREF=\"mailto:webmaster\@nbgsara.nb.ca\">webmaster\@nbgsara.nb.ca</A></P>" );
	fwrite( $fp, "</BODY></HTML>" );
	fclose( $fp ) or die("FATAL: Could not close output file.");

	# Email Report


}


?>
