<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: sr_edit.php
	# Version: 10 September 2004
	# Author: Calvin Martini
	# Description: This script provides editing of new and existing search report records.

	session_start(); 

	# Set client variables
	$client_vars=array('s_id','mode','r_id','e_team','e_team_province','e_province'); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");
	require("lib_js.php");

	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_searches");

	# Check to ensure proper access level to edit record
	if ( max($a_search) < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	$teams=get_teams();
	$provinces=get_provinces();
	
	# Intitialize form input values for existing records
	if ($mode == "update" || $mode == "display") {

		# Read team_search data
		$query = "SELECT 
					DATE_FORMAT(team_search.when_entered,'%W %M %D, %Y %H:%i:%s') AS edit_time,
					team_search.id_record,
					team_search.id_users,
					team_search.id_teams,
					team_search.id_search,
					team_search.hours_total,
					team_search.members_total,
					team_search.cost_total,
					team_search.description,	
					team_search.when_alerted,
					team_search.when_activated,
					team_search.when_arrived,
					team_search.when_began,
					team_search.when_returned,
					team_search.gsar_sub_id,
					team_search.flag_complete,
					teams.team_name AS team_name,
					teams.id_address_province AS team_province,
					DATE_FORMAT(search.when_entered,'%W %M %D, %Y %H:%i:%s') AS r_edit_time,
					search.id_users AS r_id_users,
					search.name_ic,
					search.id_agency,
					search.phone_ic,
					search.lat_coords_pls,
					search.long_coords_pls,
					search.distance_from_pls,
					search.weather_factor,
					search.when_concluded,
					search.when_released,
					search.when_found,
					search.id_weather,
					search.id_types_events,
					search.id_types_environment,
					search.id_types_activity,
					search.id_types_reason_1,
					search.id_types_reason_2,
					search.police_file_id,
					search.when_debrief,
					search.loc_debrief,
					search.id_province,
					types_province.type$lang AS province_name,
					types_province.prefix,
					search.location
					FROM team_search 
					LEFT JOIN search ON search.id_record=team_search.id_search
					LEFT JOIN teams ON teams.id_record=team_search.id_teams
					LEFT JOIN types_province ON types_province.id_record=search.id_province
					WHERE team_search.id_record='$s_id'";
		$result = mysql_query($query) or die ($l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);
			
			$query2="SELECT types_province.prefix, types_province.assoc$lang AS assoc  
						FROM types_province 
						LEFT JOIN teams ON teams.id_address_province=types_province.id_record
						WHERE teams.id_record='".$r['id_teams']."'";
			$result2 = mysql_query($query2) or die ($l['query_failed'].":$query2");
			if (mysql_num_rows($result2)) {
				$r2=mysql_fetch_array($result2);
				$e_prefix=$r2['prefix'];
			}
			
			$r_id=$r['id_search'];
			$gsar_sub_id=$r['gsar_sub_id'];
			$e_gid="$e_prefix".$r['id_search']."-".$r['gsar_sub_id'];
			$e_distance_from_pls=$r['distance_from_pls'];
			$e_id_agency=$r['id_agency'];
			$e_team=$r['id_teams'];
			$e_team_province=$r['team_province'];
			$team=$r['id_teams'];
			$e_members_total=$r['members_total'];
			$e_hours_total=$r['hours_total'];
			$e_id_types_events=$r['id_types_events'];
			$e_pid=$r['police_file_id'];
			$e_name_ic=$r['name_ic'];
			$e_phone_ic=$r['phone_ic'];
			$e_id_sc=$r['id_sc'];
			$e_latpls=$r['lat_coords_pls'];
			$e_longpls=$r['long_coords_pls'];
			list($e_d_began,$e_t_began)=split(" ",$r['when_began']); $e_t_began=substr($e_t_began,0,5);
			list($e_d_released,$e_t_released)=split(" ",$r['when_released']); $e_t_released=substr($e_t_released,0,5);
			list($e_d_returned,$e_t_returned)=split(" ",$r['when_returned']); $e_t_returned=substr($e_t_returned,0,5);
			list($e_d_act,$e_t_act)=split(" ",$r['when_activated']); $e_t_act=substr($e_t_act,0,5);
			list($e_d_alert,$e_t_alert)=split(" ",$r['when_alerted']); $e_t_alert=substr($e_t_alert,0,5);
			list($e_d_arr,$e_t_arr)=split(" ",$r['when_arrived']); $e_t_arr=substr($e_t_arr,0,5);
			list($e_d_found,$e_t_found)=split(" ",$r['when_found']); $e_t_found=substr($e_t_found,0,5);
			list($e_d_conc,$e_t_conc)=split(" ",$r['when_concluded']); $e_t_conc=substr($e_t_conc,0,5);
			$e_cost=$r['cost_total'];
			$e_env=$r['id_types_environment'];
			$e_activity=$r['id_types_activity'];
			$e_reason1=$r['id_types_reason_1'];
			$e_reason2=$r['id_types_reason_2'];
			$e_desc=$r['description'];
			$e_weather_factor=$r['weather_factor'];
			$e_weather=$r['id_weather'];
			$e_when_entered=$r['edit_time'];
			$e_id_users=$r['id_users'];
			$e_record=$r['id_record'];
			$e_when_debrief=$r['when_debrief'];
			$e_loc_debrief=$r['loc_debrief'];
			$e_location=$r['location'];
			$e_flag_complete=$r['flag_complete'];
			$e_province=$r['id_province'];
			$e_province_name=$r['province_name'];
			$e_team=$r['id_teams'];
			$e_team_name=$r['team_name'];

		}else{
			echo $l['no_results'];
		}
		
	}else{
		# This is a new record
		if ($r_id != -999){

			# Use existing search record and new team_search record

			# Determine high count for gsar_sub_id
			$query = "SELECT MAX(gsar_sub_id) AS max_id FROM team_search WHERE id_search=$r_id";
			$result = mysql_query($query) or die ($l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$r=mysql_fetch_array($result);
				$gsar_sub_id=$r['max_id']+1;
			}else{
				$gsar_sub_id=1;
			}

			# Load the data
			$query = "SELECT 
						DATE_FORMAT(search.when_entered,'%W %M %D, %Y %H:%i:%s') AS r_edit_time,
						search.id_users AS r_id_users,
						search.id_record,
						search.name_ic,
						search.id_agency,
						search.phone_ic,
						search.lat_coords_pls,
						search.long_coords_pls,
						search.distance_from_pls,
						search.weather_factor,
						search.when_concluded,
						search.when_released,
						search.when_found,
						search.id_weather,
						search.id_types_events,
						search.id_types_environment,
						search.id_types_activity,
						search.id_types_reason_1,
						search.id_types_reason_2,
						search.police_file_id,
						search.when_debrief,
						search.loc_debrief,
						search.id_province,
						types_province.type$lang AS province_name,
						types_province.prefix,
						search.location
						FROM search 
						LEFT JOIN types_province ON types_province.id_record=search.id_province
						WHERE search.id_record='$r_id'";
			$result = mysql_query($query) or die ($l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$r=mysql_fetch_array($result);
				$e_distance_from_pls=$r['distance_from_pls'];
				$e_id_agency=$r['id_agency'];
				$e_id_types_events=$r['id_types_events'];
				$e_gid=$r['prefix'].$r['id_record']."-$gsar_sub_id";
				$e_pid=$r['police_file_id'];
				$e_name_ic=$r['name_ic'];
				$e_phone_ic=$r['phone_ic'];
				$e_latpls=$r['lat_coords_pls'];
				$e_longpls=$r['long_coords_pls'];
				list($e_d_released,$e_t_released)=split(" ",$r['when_released']); $e_t_released=substr($e_t_released,0,5);
				list($e_d_found,$e_t_found)=split(" ",$r['when_found']); $e_t_found=substr($e_t_found,0,5);
				list($e_d_conc,$e_t_conc)=split(" ",$r['when_concluded']); $e_t_conc=substr($e_t_conc,0,5);
				$e_env=$r['id_types_environment'];
				$e_activity=$r['id_types_activity'];
				$e_reason1=$r['id_types_reason_1'];
				$e_reason2=$r['id_types_reason_2'];
				$e_desc=$r['description'];
				$e_weather_factor=$r['weather_factor'];
				$e_weather=$r['id_weather'];
				$e_record=$r['id_record'];
				$e_when_debrief=$r['when_debrief'];
				$e_loc_debrief=$r['loc_debrief'];
				$e_location=$r['location'];
				$e_flag_complete="0";
				$e_province=$r['id_province'];
				$e_province_name=$r['province_name'];

				# Initialize the other date fields
				$e_d_began=$e_d_conc;
				$e_d_returned=$e_d_conc;
				$e_d_act=$e_d_conc;
				$e_d_alert=$e_d_conc;
				$e_d_arr=$e_d_conc;

				$e_desc2=str_pad($l['full_name'],20)." ".str_pad($l['hours'],10)."\n";
				$e_desc2.="==================== ==========\n";

			}
		}else{
			# New search and team_search records

			$query = "SELECT COUNT(*) AS count FROM search";
			$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$r = mysql_fetch_array($result);
				$next_r_id = $r['count'] + 1;
			}

			$gsar_sub_id=1;
			$e_d_began=date("Y-m-d");
			$e_d_released=date("Y-m-d");
			$e_d_returned=date("Y-m-d");
			$e_d_act=date("Y-m-d");
			$e_d_alert=date("Y-m-d");
			$e_d_arr=date("Y-m-d");
			$e_d_found=date("Y-m-d");
			$e_d_conc=date("Y-m-d");
			$e_when_debrief=date("Y-m-d");
			$e_flag_complete="0";
			$e_desc2=str_pad($l['full_name'],20)." ".str_pad($l['hours'],10)."\n";
			$e_desc2.="==================== ==========\n";
			$e_province_name=$provinces[$e_province];


			$query = "SELECT prefix FROM types_province WHERE id_record='$e_province'";
			$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$r = mysql_fetch_array($result);
				$e_gid=$r['prefix']."$next_r_id-1";
			}
		}
	}

	head("sr_edit");
	
	if (($mode == "new" && max($a_search) >= 2) || ($mode == "update" && $a_search[$team] >=2)){

		echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/calendar/calendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\">
					function callSelect() {
							myopen('sc_choose.php?team=$e_team&target=MForm.e_name_sc&value=MForm.e_id_sc','windowName', 'toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=200,height=300');
					}
				</SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/CallCalendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/add_days.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/CallWindow.js\"></SCRIPT>";

		if ($a_province == -1 && !$e_team){
			# If user has access to all provinces, include javascript to update teams list based on province selection
			echo "<SCRIPT LANGUAGE=\"JavaScript\">";
			team_js("",1,0);
			echo "</SCRIPT>";
		}

		echo "<SCRIPT LANGUAGE=\"JavaScript\">

					function validateSave() {
					
						if (document.MForm.e_team.options[document.MForm.e_team.selectedIndex].value == 0){
							alert(\"".$l['choose_team_first']."\");
						}else{
							self.location.href='$PHP_SELF'+ self.location.search + '&e_province=' + document.MForm.e_province.options[document.MForm.e_province.selectedIndex].value + '&e_team=' + document.MForm.e_team.options[document.MForm.e_team.selectedIndex].value;
						}
					}

					function callSubject(target_field,target_value,data_field,data_value) {
						// Function: opens a searcher selection window for a given search scope
						// target_field	text area field on parent form to use as target for output
						// target_value	value of target form text area field
						// data_field		machine readable text data form field for input/output
						// data_value		value of data form text field
						myopen('sr_subject_edit.php?target_field=' + escape(target_field) + '&target_value=' + escape(target_value) + '&data_field=' + escape(data_field) + '&data_value=' + escape(data_value),'windowName', 'toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=900,height=400');
					}

					function callSelect2(e_mode,id_class,s_text,s_type,e_attend,e_team) {
						// Function: opens a searcher selection window for a given search scope
						// e_mode			edit or add
						// id_class			class record to add to or edit
						// s_text			text to use as search criteria
						// s_type			member or team
						// e_students		value of e_students
						myopen('sr_attend_choose.php?e_mode=' + escape(e_mode) + '&id_class=' + escape(id_class) + '&s_text=' + escape(s_text) + '&s_type=' + escape(s_type) + '&e_attend=' + escape(e_attend) + '&e_team=' + escape(e_team),'windowName', 'toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=400,height=400');
					}
					
				</SCRIPT>";
	
		echo "<form method=POST action=sr_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm>
				".SIDHIDDEN."
				<input type=hidden name=mode value=\"$mode\">
				<input type=hidden name=mydate value=\"\">
				<input type=hidden name=myfield value=\"\">
				<input type=hidden name=e_id_sc value=\"$e_id_sc\">
				<input type=hidden name=e_id_users=\"$e_id_users\">
				<input type=hidden name=s_id value=\"$s_id\">
				<input type=hidden name=r_id value=\"$r_id\">
				<input type=hidden name=gsar_sub_id value=\"$gsar_sub_id\">
				".($e_record ? "<input type=hidden name=record value=\"$e_record\">" : "")."
				".($e_record ? "<input type=hidden name=e_gid value=\"$e_gid\">" : "")."
				<table class=BodyTbl width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyTd align=left colspan=2><p class=BodyH2>
				".($mode == "update" ? $l['edit_search_report'] : $l['new_search_report'])."
				</p></td></tr>
				<tr>
				<td class=BodyTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyTd colspan=2><p class=BodyH3>1. ".$l['search_details']."</p></td>
				</tr>";


		if ($mode =="new" && !$e_team && $a_team<1){
			if ($a_province == -1){
				# User is authorized for all provinces, display province selection list
				$query2 = "SELECT id_record, type$lang AS province FROM types_province";
				$result2 = mysql_query($query2) or die ($l['query_failed']);
				if (mysql_num_rows($result2)) { 
					echo "<tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['team_province']."</p></td>
							<td class=BodyInputTd>
							<select class=BodyInp name=e_team_province value=\"\" onChange=\"PopulateTeams(MForm.e_team_province,MForm.e_team,0);\">
							<option value=\"\">
							<option value=\"9999\">".$l['all'];
					while ($r2 = mysql_fetch_array($result2)) {
#						echo "<option value=\"".$r2['id_record']."\"".($r['id_province']==$r2['id_record'] ? " selected" : "").">".substr($r2['province'],0,20)."\n";
						echo "<option value=\"".$r2['id_record']."\">".substr($r2['province'],0,20)."\n";
					}
					echo "</select></td></tr>";
				}
			}else{
			# User has access to one province
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['team_province']."</p></td>
						<td class=BodyInputTd><p class=BodyInp><input class=BodyInp type=hidden name=e_team_province size=20 value=\"$a_province\">".$a_provName[$lang]."</p></td>
						</tr>";
				$e_province=$a_province;
			}

			# Select list for team
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['team']."</p></td>
					<td class=BodyInputTd>";

			# Display team select based on access
			if ($a_team == -1 && $a_province == -1){
				# User has access to all province and all teams
				$o_string="<option>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>";
				echo "<select class=BodyInp name=e_team><option value=\"\"><option value=\"".$r['id_teams']."\">$team".$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string."</select>";
#				echo "<select class=BodyInp name=e_team><option value=\"9999\">".$l['all']."<option value=\".$r['id_teams']."\" selected>$team".$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string."</select>";
			}elseif($a_team == -1 && $a_province >0){
				# User has access to one province and all teams in that province
				$query3 = "SELECT teams.id_record, teams.team_name
					FROM teams
					WHERE id_address_province='$a_province'
					ORDER BY team_name";
				$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
				if (mysql_num_rows($result3)) {
					echo "<select class=BodyInp name=e_team size=1>
							<option value=\"\">";
					while ($r3 = mysql_fetch_array($result3)) {
							echo "<option value=".$r3['id_record'].">".$r3['team_name'];
					}
					echo "</select>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
			}else{
				# User can access two or more teams
				$query3 = "SELECT teams.id_record, teams.team_name
					FROM teams
					LEFT JOIN team_access ON team_access.id_teams=teams.id_record  
					WHERE team_access.access_members>=2 AND team_access.id_users='$id_recno'
					GROUP BY teams.id_record
					ORDER BY team_name";
				$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
				if (mysql_num_rows($result3)) {
					echo "<select class=BodyInp name=e_team size=1>
							<option value=\"0\">".$l['none'];
					while ($r3 = mysql_fetch_array($result3)) {
							echo "<option value=".$r3['id_record'].">".$r3['team_name'];
					}
					echo "</select>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
			}

			echo "</td></tr>";
			
			# Search Province
			$query2 = "SELECT id_record, type$lang AS province FROM types_province ORDER BY province";
			$result2 = mysql_query($query2) or die ($l['query_failed']);
			if (mysql_num_rows($result2)) { 
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['search_province']."</p></td>
						<td class=BodyInputTd>
						<select class=BodyInp name=e_province value=\"\" onchange=\"validateSave()\">
						<option value=\"\">";
				while ($r2 = mysql_fetch_array($result2)) {
					echo "<option value=\"".$r2['id_record']."\">".substr($r2['province'],0,20)."\n";
				}
				echo "</select></td></tr>";
			}
		}else{
			if($a_team >0 && ! $e_team){
				# User has single team access
				$e_team=$a_team;
				$e_province=$a_province;
			}
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['team']."</p></tr>
					<td class=BodyInputTd>";
			echo "<input class=BodyInp type=hidden name=e_team value=\"$e_team\">".($e_team==9999 ? $l['all'] : $teams[$e_team])."</td></tr>";

			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['gsar_file_id']."</p></td>
					<td class=BodyInputTd><p class=BodyInp>$e_gid<small><small> </small></small></p></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['status']."</p></td>
					<td class=BodyInputTd><p class=BodyInp>".($e_flag_complete=="1" ? "<font color=green>".$l['complete']."</font>" : "<font color=red>".$l['incomplete']."</font>")."</p></td>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['police_file_id']."</p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_pid size=20 value=\"$e_pid\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['incident_commander']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
					<td class=BodyInputTd><input class=BodyInp type=text name=e_name_ic size=20 value=\"$e_name_ic\"></td>
					</tr>
					<tr>
					<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['agency']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
					<td class=BodyInputTd>";
					$query = "SELECT * 
								FROM types_agencies
								WHERE agency_province='$e_province' OR agency_province=9999
								ORDER BY agency_desc$lang";
					$result = mysql_query($query) or die ($l['query_failed'].":$query");
					if (mysql_num_rows($result)) {
						echo "<select class=BodyInp name=e_id_agency size=1>
								<option value=\"\">";
						while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record'].($e_id_agency==$r['id_record'] ? " selected" : "").">".$r['agency_desc'.$lang];
						}
						echo "</select>";
					}else{
						# Nothing matched the query
						echo "<p class=BodyInp>".$l['no_results']."</p>";
					}
				echo "</td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['ic_phone']."</p></td>
						<td class=BodyInputTd><p class=BodyInp><input class=BodyInp type=text name=e_phone_ic size=20 value=\"$e_phone_ic\"><font class=BodyExTxt>###-###-####</font></p></td>
						</tr>";
				# Search Province
				if ($e_province_name){
					echo "<tr>
							<td class=BodyInputTd><p class=BodyInpH>".$l['search_province']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
							<td class=BodyInputTd><input class=BodyInp type=hidden name=e_province value=\"$e_province\">
							<p class=BodyInp>$e_province_name</td></tr>";
				}else{
					$query2 = "SELECT id_record, type$lang AS province FROM types_province ORDER BY province";
					$result2 = mysql_query($query2) or die ($l['query_failed']);
					if (mysql_num_rows($result2)) { 
						echo "<tr>
								<td class=BodyInputTd><p class=BodyInpH>".$l['search_province']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
								<td class=BodyInputTd>
								<select class=BodyInp name=e_province value=\"\" onchange=\"validateSave()\">
								<option value=\"\">";
						while ($r2 = mysql_fetch_array($result2)) {
							echo "<option value=\"".$r2['id_record']."\">".substr($r2['province'],0,20)."\n";
						}
						echo "</select></td></tr>";
					}
				}
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['location']."</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_location size=20 value=\"$e_location\"></td>
						</tr>";
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['point_last_seen']." (".$l['lat'].")&nbsp;<sup><strong>(1)</strong></sup></p></td>
						<td class=BodyInputTd><p class=BodyInp><input class=BodyInp type=text name=e_latpls size=10 value=\"$e_latpls\"><font class=BodyExTxt>".$l['decimal_degrees']."</font></p></td>
						</tr>";
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['point_last_seen']." (".$l['long'].")&nbsp;<sup><strong>(1)</strong></sup></p></td>
						<td class=BodyInputTd><p class=BodyInp><input class=BodyInp type=text name=e_longpls size=10 value=\"$e_longpls\"><font class=BodyExTxt>".$l['decimal_degrees']."</font></p></td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['distance_from_pls']."</p></td>
						<td class=BodyInputTd><p class=BodyInp><input class=BodyInp type=text name=e_distance_from_pls size=5 value=\"$e_distance_from_pls\"><font class=BodyExTxt>(".$l['meters'].")</font></p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_alert,$e_d_alert,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_alerted']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_alert size=5 value=\"$e_t_alert\"><font class=BodyExTxt>hh:mm (24 hr)</font>
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_d_alert',0);
						//--></SCRIPT>
						</p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_act,$e_d_act,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_activated']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_act size=5 value=\"$e_t_act\"><font class=BodyExTxt>hh:mm (24 hr)</font></p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_arr,$e_d_arr,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_arrived']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_arr size=5 value=\"$e_t_arr\"><font class=BodyExTxt>hh:mm (24 hr)</font></p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_began,$e_d_began,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_began']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_began size=5 value=\"$e_t_began\"><font class=BodyExTxt>hh:mm (24 hr)</font></p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_found,$e_d_found,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_found']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_found size=5 value=\"$e_t_found\"><font class=BodyExTxt>hh:mm (24 hr)</font></p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_released,$e_d_released,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_subject_released']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_released size=5 value=\"$e_t_released\"><font class=BodyExTxt>hh:mm (24 hr)</font></p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_conc,$e_d_conc,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_concluded']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_conc size=5 value=\"$e_t_conc\"><font class=BodyExTxt>hh:mm (24 hr)</font></p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_returned,$e_d_returned,10,0);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['date_time_returned_to_base']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_returned size=5 value=\"$e_t_returned\"><font class=BodyExTxt>hh:mm (24 hr)</font></p></td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['total_cost']." ($)</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_cost size=10 value=\"$e_cost\"></td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['environment']."</p></td>
						<td class=BodyInputTd>";
						$query = "SELECT * FROM types_environment ORDER BY type$lang";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=e_env size=1>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record'].($e_env==$r['id_record'] ? " selected" : "").">".$r['type'.$lang];
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a href=\"javascript:myopen('type_desc.php?table=types_environment','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['type_event']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
						<td class=BodyInputTd>";
						$query = "SELECT * FROM types_events ORDER BY type$lang";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=e_id_types_events size=1>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record'].($e_id_types_events==$r['id_record'] ? " selected" : "").">".$r['type'.$lang];
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_events','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['description']."&nbsp;<sup><strong>(1)</strong></sup></p></td>
						<td class=BodyInputTd><textarea class=BodyInp name=e_desc cols=60 rows=10>$e_desc</textarea></td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['activity']."</p></td>
						<td class=BodyInputTd>";
						$query = "SELECT * FROM types_activity ORDER BY type$lang";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=e_activity size=1>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record'].($e_activity==$r['id_record'] ? " selected" : "").">".$r['type'.$lang];
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_activity','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['reason']." 1&nbsp;<sup><strong>(1)</strong></sup></p></td>
						<td class=BodyInputTd>";
						$query = "SELECT * FROM types_reason ORDER BY type$lang";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=e_reason1 size=1>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record'].($e_reason1==$r['id_record'] ? " selected" : "").">".$r['type'.$lang];
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_reason','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['reason']." 2</p></td>
						<td class=BodyInputTd>";
						$query = "SELECT * FROM types_reason ORDER BY type$lang";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=e_reason2 size=1>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record'].($e_reason2==$r['id_record'] ? " selected" : "").">".$r['type'.$lang];
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_reason','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['was_weather_factor']."</p></td>
						<td class=BodyInputTd><p class=BodyInp><input type=\"checkbox\" name=\"e_weather_factor\" value=\"1\" " . ("$e_weather_factor" == "1" ? "checked" : "") . "></p></td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['weather']."</p></td>
						<td class=BodyInputTd>";
						$query = "SELECT * FROM types_weather ORDER BY type$lang";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=e_weather size=1 value=$e_weather>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record'].($e_weather==$r['id_record'] ? " selected" : "").">".$r['type'.$lang];
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_weather','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['total_members']."</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_members_total size=10 value=\"$e_members_total\"></td>
						</tr>
						<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['total_hours']."</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_hours_total size=10 value=\"$e_hours_total\"></td>
						</tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['debrief_location']."</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_loc_debrief size=20 value=\"$e_loc_debrief\"></td>
						</tr>";
				list($year,$month,$day) = input_date(e_when_debrief,$e_when_debrief,10,2);		
				echo"<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['debrief_date']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_when_debrief',0);
						//--></SCRIPT>
						</p></td>
						</tr>";

				#### SECTION: Techniques/Tactics
				echo "<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['tactics_used']."</p></td>
						<td class=BodyInputTd>";
						$query = "
							SELECT *,
							types_techniques.id_record AS id_record,
							types_techniques.type$lang AS type,
							if(techniques.id_types_techniques=types_techniques.id_record,'SELECTED','') AS selected
							FROM types_techniques 
							LEFT JOIN techniques ON types_techniques.id_record=techniques.id_types_techniques AND techniques.id_search='$r_id'
							ORDER BY types_techniques.type$lang";
						$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=\"e_techniques[]\" size=3 MULTIPLE>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record']." ".$r['selected'].">".$r['type'];
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_techniques','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>";

				#### SECTION: Resources
				echo "<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['resources_used']."</p></td>
						<td class=BodyInputTd>";
						$query = "
							SELECT *,
							types_resources.id_record AS id_record,
							types_resources.type$lang AS type,
							if(resources.id_types_resources=types_resources.id_record,'SELECTED','') AS selected
							FROM types_resources 
							LEFT JOIN resources ON types_resources.id_record=resources.id_types_resources AND resources.id_search='$r_id'
							ORDER BY types_resources.type$lang";
						$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$flag=0;
							echo "<select class=BodyInp name=\"e_resources[]\" size=3 MULTIPLE>
									<option value=\"0\">".$l['none'];
							while ($r = mysql_fetch_array($result)) {
								echo "<option value=".$r['id_record']." ".$r['selected'].">".$r['type']."";
								if ($r['desc_type'.$lang]){$flag=1;}
							}
							echo "</select>";
							if ($flag==1){ 
								echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_resources','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
							}
						}else{
							# Nothing matched the query
							echo "<p class=BodyTxt>".$l['no_results']."</p>";
						}
				echo "</td>
						</tr>";


				#### SECTION: Subjects			
			# Subject data
			$query2 = "SELECT subjects.id_record AS record,
				types_experience.type$lang AS experience,
				subjects.id_experience,
				types_equipment.type$lang AS equipment,
				subjects.id_equipment,
				subjects.subject_name AS subject_name, 
				subjects.subject_age AS subject_age, 
				subjects.subject_gender AS subject_gender,
				subjects.flag_training AS flag_training,
				IF(subjects.flag_training=0,'".$l['no']."','".$l['yes']."') AS training,
				types_outcome.type$lang AS outcome,
				subjects.id_types_outcome,
				types_condition.type$lang AS condition,
				subjects.id_types_condition
				FROM subjects
				LEFT JOIN types_condition ON subjects.id_types_condition=types_condition.id_record 
				LEFT JOIN types_outcome ON subjects.id_types_outcome=types_outcome.id_record
				LEFT JOIN types_experience ON subjects.id_experience=types_experience.id_record
				LEFT JOIN types_equipment ON subjects.id_equipment=types_equipment.id_record
				WHERE subjects.id_search='$r_id' 
				ORDER BY subjects.subject_name";
			$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
			$e_desc2=str_pad($l['name'],20)." ".str_pad($l['age'],3)." ".str_pad($l['m_f'],3)." ".str_pad($l['experience'],10)." ".str_pad($l['equipment'],10)." ".str_pad($l['outcome'],10)." ".str_pad($l['condition'],10)." ".str_pad($l['training'],10)."\n";
			$e_desc2.="==================== === === ========== ========== ========== ========== ==========\n";
			if (mysql_num_rows($result2)) {
				while ($r2 = mysql_fetch_array($result2)) {
					$e_subjects.=$r2['subject_name'].",".$r2['subject_age'].",".$r2['subject_gender'].",".$r2['id_experience'].",".$r2['id_equipment'].",".$r2['id_types_outcome'].",".$r2['id_types_condition'].",".$r2['flag_training'].";";
					$e_desc2.= substr(str_pad($r2['subject_name'],20),0,20)." ".substr(str_pad($r2['subject_age'],3),0,3)." ".substr(str_pad($r2['subject_gender'],3),0,3)." ".substr(str_pad($r2['experience'],10),0,10)." ".substr(str_pad($r2['equipment'],10),0,10)." ".substr(str_pad($r2['outcome'],10),0,10)." ".substr(str_pad($r2['condition'],10),0,10)." ".substr(str_pad($r2['training'],10),0,10)."\n";
				}
			}

				echo "<tr>
						<td class=BodyInputTd colspan=2><hr></td>
						</tr>
						<tr><td class=BodyTd colspan=2><p class=BodyH3>2. ".$l['search_subjects']."</p></td></tr>
						<tr><td class=BodyInputTd colspan=2><input type=hidden name=e_subjects value=\"$e_subjects\"><textarea name=e_desc2 cols=86 rows=7 readonly>$e_desc2</textarea></td></tr>
						<tr><td class=BodyInputTd colspan=2><input class=BodyBut type=button name=action value=\"".$l['edit']."\" onClick=\"javascript:callSubject('MForm.e_desc2',window.document.MForm.e_desc2.value,'MForm.e_subjects',window.document.MForm.e_subjects.value)\"></td></tr>";

				# SECTION 4: Searcher Attendance
				echo "<tr>
						<td class=BodyTd colspan=2><hr></td>
						</tr>
						<tr>
						<td class=BodyTd colspan=2><p class=BodyH3>3. ".$l['attendance']."</p></td>
						</tr>";

				# Set types_position array
				$query = "SELECT *, id_record,
					type$lang AS type,
					desc_type$lang AS desc_type
				FROM types_position ORDER BY type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
						$position_id[]=$r['id_record'];
						$position_type[]=$r['type'];
						if ($r['desc_type']){$desc_flag=1;}
					}
				}

				$query="SELECT members.id_record,
				CONCAT(members.name_last,', ',members.name_first) AS full_name,
				attend_persons.id_search AS search,
				attend_persons.id_types_position,
				attend_persons.hours
				FROM members
				LEFT JOIN teams_members ON teams_members.id_members=members.id_record
				LEFT JOIN attend_persons ON attend_persons.id_members=members.id_record AND attend_persons.id_search='$s_id'
				WHERE teams_members.id_teams='$e_team'
				AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
				ORDER BY full_name";

				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				if (mysql_num_rows($result)) { 
					echo "<tr>
							<td class=BodyInputTd colspan=2>
							<table class=BodyTbl>
							<tr>
							<td class=BodyInputTd><p class=BodyH3>".$l['select']."&nbsp;&nbsp;</p></td>
							<td class=BodyInputTd><p class=BodyH3>".$l['full_name']."</p></td>
							<td class=BodyInputTd><p class=BodyH3>".$l['hours']."&nbsp;&nbsp;</p></td>";
					if ($desc_flag==1){
						echo "<td class=BodyInputTd><p class=BodyH3>".$l['position']."&nbsp;&nbsp;<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_position','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a></td>";
					}else{
						echo "<td class=BodyInputTd><p class=BodyH3>".$l['position']."&nbsp;&nbsp;</p></td>";
					}
					echo "</tr>";
					$count=1;
					echo "<tr>";
					while ($r = mysql_fetch_array($result)) {
						echo "<td class=BodyInputTd><input type=hidden name=e_count[$count] value=\"$count\"><input type=hidden name=e_id[$count] value=\"".$r['id_record']."\"><input class=BodyChk type=checkbox name=e_select[$count] value=1 ".($r['search']=="$s_id" ? "checked" : "")."></td>
								<td class=BodyInputTd><p class=BodyTxt>".$r['full_name']."</p></td>
								<td class=BodyInputTd><input class=BodyInp type=text name=e_hours[$count] size=3 value=\"".$r['hours']."\"></td>
								<td class=BodyInputTd>
								<select class=BodyInp name=e_position[$count] size=1>
								<option value=\"".$r['id_types_position']."\">";
						$count2=0;
						foreach ($position_id as $id){
							echo "<option value=\"$id\"".($id==$r['id_types_position'] ? " SELECTED" : "").">$position_type[$count2]";
							$count2++;
						}
						echo "</select>";
						echo "</td></tr><tr>";
						$count++;
					}
					echo "</tr></table>
							</td></tr>";
				}

				## Bottom Menu Starts
				echo "<tr>
						<td class=BodyInputTd colspan=2><hr></td>
						</tr>";

				# Notes	
				echo "<tr><td class=BodyInputTd><p class=BodyTxt><sup><strong>(1)</strong></sup>&nbsp;&nbsp;".$l['required_field']."</p></td></tr>";
				echo "</tr>";


				echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>";

				echo "<tr>
						</table>
						<input class=BodyBut type=submit name=action value=\"".$l['save']."\">".($mode=="update" && $a_search[$team] >=4 ? "<input class=BodyBut type=submit name=action value=\"".$l['delete']."\">" : "")."
						<input class=BodyBut type=reset value=".$l['reset'].">
						<input class=BodyBut type=submit name=action value=".$l['cancel'].">
						</form>";

				if ($mode=="update") {
						$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
						$result = mysql_query($query) or die ($l['query_failed'].":$query");
						if (mysql_num_rows($result)) {
							$r = mysql_fetch_array($result);
							$last_edit=$l['last_edited_by'];
							echo "<p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p>";
						}
				}

					#	</table>";
		}
	}elseif($mode=="display"){

	############ DISPLAY MODE ##############
	### SECTION: Main Table Body
		echo "<table class=BodyTbl width=100%>
				<table class=BodyTbl width=100% cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyTd align=left colspan=2><p class=BodyH2>".$l['display_search_report']."</p></td>
				</tr>
				<tr>
				<td class=BodyTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyTd colspan=2><p class=BodyH3>1. ".$l['search_details']."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['gsar_file_id']."</p></td>
				<td class=BodyTd><p class=BodyTxt><big><strong>$e_gid</big></strong> (".$l['payment_code'].")</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['status']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_flag_complete=="1" ? "<font class=BodyComplete>".$l['complete']."</font>" : "<font class=BodyIncomplete>".$l['incomplete']."</font>")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['police_file_id']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_pid</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['agency']."</p></td>
				<td class=BodyTd><p class=BodyInp>";
				$query = "SELECT * FROM types_agencies ORDER BY agency_desc$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
						if ($e_id_agency==$r['id_record']) { 
							echo $r['agency_desc'.$lang];
						}
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['incident_commander']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_name_ic</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['ic_phone']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_phone_ic</p></td>
				</tr>
				<tr>
				<td valign=top><p class=BodyInpH>".$l['team']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$teams[$e_team]</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['location']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_location</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['point_last_seen']." (".$l['lat'].")</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_latpls!=0 ? "$e_latpls&deg ".$l['n_north']."" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['point_last_seen']." (".$l['long'].")</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_longpls!=0 ? "$e_longpls&deg ".$l['w_west']."" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['alerted']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_alert!="0000-00-00" ? "$e_d_alert $e_t_alert" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['activated']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_act!="0000-00-00" ? "$e_d_act $e_t_act" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['arrived']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_arr!="0000-00-00" ? "$e_d_arr $e_t_arr" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['began']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_began!="0000-00-00" ? "$e_d_began $e_t_began" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['found']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_found!="0000-00-00" ? "$e_d_found $e_t_found" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['subject_released']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_released!="0000-00-00" ? "$e_d_released $e_t_released" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['concluded']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_conc!="0000-00-00" ? "$e_d_conc $e_t_conc" : "")."</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['returned_to_base']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_d_returned!="0000-00-00" ? "$e_d_returned $e_t_returned" : "")."</p></td>
				</tr>
				<tr>
				<td><p class=BodyInpH>".$l['total_cost']." ($)</p></td>
				<td><p class=BodyTxt>\$$e_cost</p></td>
				</tr>
				<tr>
				<td><p class=BodyInpH>".$l['distance_from_pls']." (m)</p></td>
				<td><p class=BodyTxt>$e_distance_from_pls</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['environment']."</p></td>
				<td class=BodyTd><p class=BodyTxt>";
				$query = "SELECT * FROM types_environment ORDER BY type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							if ($e_env==$r['id_record']) { 
								echo $r['type'.$lang];
							}
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['type_event']."</p></td>
				<td class=BodyTd><p class=BodyInp>";
				$query = "SELECT * FROM types_events ORDER BY type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							if ($e_id_types_events==$r['id_record']) { 
								echo $r['type'.$lang];
							}
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['description']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_desc</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['activity']."</p></td>
				<td class=BodyTd><p class=BodyTxt>";
				$query = "SELECT * FROM types_activity ORDER BY type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							if ($e_activity==$r['id_record']) { 
								echo $r['type'.$lang];
							}
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['reason']." 1</p></td>
				<td class=BodyTd><p class=BodyTxt>";
				$query = "SELECT * FROM types_reason ORDER BY type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							if ($e_reason1==$r['id_record']) { 
								echo $r['type'.$lang];
							}
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['reason']." 2</p></td>
				<td class=BodyTd><p class=BodyTxt>";
				$query = "SELECT * FROM types_reason ORDER BY type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							if ($e_reason2==$r['id_record']) { 
								echo $r['type'.$lang];
							}
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['was_weather_factor']."</p></td>
				<td class=BodyTd><p class=BodyTxt>" . ("$e_weather_factor" == "1" ? $l['yes'] : $l['no']) . "</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['weather']."</p></td>
				<td class=BodyTd><p class=BodyTxt>";
				$query = "SELECT * FROM types_weather ORDER BY type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							if ($e_weather==$r['id_record']) { 
								echo $r['type'.$lang];
							}
					}
				}else{
					# Nothing matched the query
					echo $l['no_results'];
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['total_members']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_members_total</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['total_hours']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_hours_total</p></td>
				</tr>
				<tr>
				<td class=BodyTd valign=top><p class=BodyInpH>".$l['debrief_location']."</p></td>
				<td class=BodyTd><p class=BodyTxt>$e_loc_debrief</p></td>
				</tr>
				<tr>
				<td class=BodyTd><p class=BodyInpH>".$l['debrief_date']."</p></td>
				<td class=BodyTd><p class=BodyTxt>".($e_when_debrief!="0000-00-00" ? "$e_when_debrief" : "")."</p></td>
				</tr>";

	#### SECTION: Tactics			
		echo "<tr>
				<td class=BodyTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyTd colspan=2><p class=BodyH3>2. ".$l['tactics_used']."</p></td>
				</tr>";
				$query = "SELECT techniques.id_record AS record, types_techniques.type1 AS type1, types_techniques.type2 AS type2, types_techniques.type3 AS type3, types_techniques.type4 AS type4, types_techniques.type5 AS type5 FROM types_techniques, techniques WHERE techniques.id_search='$r_id' AND techniques.id_types_techniques=types_techniques.id_record ORDER BY types_techniques.type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
						echo "<tr><td class=BodyTd colspan=2><p class=BodyTxt>".$r['type']."</p></td>";
					}
				}else{
					# Nothing matched the query
					echo "<tr><td class=BodyTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td></tr>";
				}

	#### SECTION: Subjects			
		echo "<tr>
				<td class=BodyTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyTd colspan=2><p class=BodyH3>3. ".$l['search_subjects']."</p></td>
				</tr>";
				$query = "SELECT subjects.id_record AS record,
							types_experience.type$lang AS experience, 
							types_equipment.type$lang AS equipment, 
							subjects.subject_name AS subject_name, 
							subjects.subject_age AS subject_age, 
							subjects.subject_gender AS subject_gender,
							subjects.flag_training AS flag_training,
							types_outcome.type$lang AS outcome,
							types_condition.type$lang AS condition 
							FROM subjects
							LEFT JOIN types_condition ON subjects.id_types_condition=types_condition.id_record 
							LEFT JOIN types_outcome ON subjects.id_types_outcome=types_outcome.id_record
							LEFT JOIN types_experience ON subjects.id_experience=types_experience.id_record
							LEFT JOIN types_equipment ON subjects.id_equipment=types_equipment.id_record
							WHERE subjects.id_search='$r_id' 
							ORDER BY subjects.subject_name";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					echo "<tr><td class=BodyTd colspan=2><table cellspacing=\"10\">
							<tr>
							<td class=BodyTd><p class=BodyH3>".$l['name']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['age']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['m_f']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['experience']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['equipment']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['outcome']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['condition']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['training']."</p></td>
							<td></td>
							</tr>
							<tr>";
					while ($r = mysql_fetch_array($result)) {
							echo "<tr><td><p class=BodyTxt>".$r['subject_name']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".($r['subject_age']!=0 ? $r['subject_age'] : "")."</p></td>
							<td class=BodyTd><p class=BodyTxt>".$r['subject_gender']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".$r['experience']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".$r['equipment']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".$r['outcome']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".$r['condition']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".($r['flag_training']=="0" ? $l['no'] : $l['yes'])."</p></td>";
					}
					echo "</table></tr>";
				}else{
					# Nothing matched the query
					echo "<tr><td class=BodyTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td></tr>";
				}

	#### SECTION: Resources			
		echo "<tr>
				<td class=BodyTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyTd colspan=2><p class=BodyH3>4. ".$l['resources_used']."</p></td>
				</tr>";
				$query = "SELECT resources.id_record AS record, types_resources.type1 AS type1, types_resources.type2 AS type2, types_resources.type3 AS type3, types_resources.type4 AS type4, types_resources.type5 AS type5 FROM types_resources, resources WHERE resources.id_search='$r_id' AND resources.id_types_resources=types_resources.id_record ORDER BY types_resources.type$lang";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
						echo "<tr><td class=BodyTd colspan=2><p class=BodyTxt>".$r['type']."</p></td></tr>";
					}
				}else{
					# Nothing matched the query
					echo "<tr><td class=BodyTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td></tr>";
				}


	#### SECTION: Attendance			
		echo "<tr>
				<td class=BodyTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyTd colspan=2><p class=BodyH3>5. ".$l['attendance']."</p></td>
				</tr>";
				$query="SELECT attend_persons.id_record,
					CONCAT(members.name_last,', ',members.name_first) AS full_name,
					teams.team_name,
					attend_persons.id_types_position,
					types_position.type$lang AS position,
					attend_persons.hours
					FROM attend_persons
					LEFT JOIN members ON members.id_record=attend_persons.id_members
					LEFT JOIN teams_members ON teams_members.id_members=members.id_record
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					LEFT JOIN types_position ON types_position.id_record=attend_persons.id_types_position
					WHERE attend_persons.id_search='$s_id'
					GROUP BY attend_persons.id_record
					ORDER BY members.name_last";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					echo "<tr><td class=BodyTd colspan=2>
							<table class=BodyTbl cellspacing=10>
							<tr>
							<td class=BodyTd><p class=BodyH3>".$l['full_name']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['hours']."</p></td>
							<td class=BodyTd><p class=BodyH3>".$l['position']."</p></td>
							<td class=BodyTd></td>
							</tr>";
					while ($r = mysql_fetch_array($result)) {
							echo "<tr>
							<td class=BodyTd><p class=BodyTxt>".$r['full_name']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".$r['hours']."</p></td>
							<td class=BodyTd><p class=BodyTxt>".$r['position']."</p></td>
							</tr>";
					}
					echo "</table></td></tr>";
				}else{
					# Nothing matched the query
					echo "<tr><td class=BodyTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td></tr>";
				}

		### Last Edited By
		$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$last_edit=$l['last_edited_by'];
			echo "<tr><td class=BodyTd colspan=2><hr></td></tr>
			<tr><td class=BodyTd colspan=2><p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p></td></tr>";
		}


	}
		### End of table	
		echo "</table>";

	foot();

?>
