<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: sr_print.php
	# Version: 30 April 2004
	# Author: Calvin Martini
	# Description: This script provides print display of existing search report records.

	session_start(); 

	# Set client variables
	$client_vars=array('s_id','mode'); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");


	# Load all languages into arrays
	for ($x = 1; $x <= $maxLang; $x++){
			require ("$locale/lang$x.php");
			$myVar = "l$x";
			$$myVar = $l;
	}
	$myVar = "l$lang";
	$myLang = $$myVar;
	
	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_searches");

	# Intitialize form input values
	$query = "SELECT search.when_entered,
			search.name_ic,
			search.id_agency,
			search.phone_ic,
			search.lat_coords_pls,
			search.long_coords_pls,
			search.distance_from_pls,
			search.weather_factor,
			search.when_concluded,
			search.when_released,
			search.when_found,
			search.id_weather,
			search.id_types_events,
			search.id_types_environment,
			search.id_types_activity,
			search.id_types_reason_1,
			search.id_types_reason_2,
			search.police_file_id,
			search.when_debrief,
			search.loc_debrief,
			search.location,
			team_search.id_record,
			team_search.id_users,
			team_search.id_teams,
			team_search.when_entered,
			team_search.id_search,
			team_search.hours_total,
			team_search.members_total,
			team_search.cost_total,
			team_search.description,	
			team_search.when_alerted,
			team_search.when_activated,
			team_search.when_arrived,
			team_search.when_began,
			team_search.when_returned,
			team_search.gsar_sub_id,
			team_search.flag_complete,
			users.full_name AS user_name,
			users.phone AS user_phone,
			teams.team_name,
			types_agencies.agency_desc$lang AS agency,
			types_environment.type$lang AS environment,
			types_events.type$lang AS event,
			types_activity.type$lang AS activity,
			reason1.type$lang AS reason1,
			reason2.type$lang AS reason2,
			types_weather.type$lang AS weather,
			IF(attend_persons.id_members!='-999',CONCAT(members.name_first,' ',members.name_last),'".multilang('l','other')."') AS name_sc,
			members.phone_home AS phone_sc,
			DATE_FORMAT(search.when_entered, '%d/%m/%Y %H:%i') AS when_entered
			FROM team_search
			LEFT JOIN search ON search.id_record=team_search.id_search
			LEFT JOIN users ON users.id_record=team_search.id_users
			LEFT JOIN teams ON teams.id_record=team_search.id_teams
			LEFT JOIN types_agencies ON types_agencies.id_record=search.id_agency
			LEFT JOIN types_environment ON types_environment.id_record=search.id_types_environment
			LEFT JOIN types_events ON types_events.id_record=search.id_types_events
			LEFT JOIN types_activity ON types_activity.id_record=search.id_types_activity
			LEFT JOIN types_reason AS reason1 ON reason1.id_record=search.id_types_reason_1
			LEFT JOIN types_reason AS reason2 ON reason2.id_record=search.id_types_reason_2
			LEFT JOIN types_weather ON types_weather.id_record=search.id_weather
			LEFT JOIN attend_persons ON attend_persons.id_search=team_search.id_record AND attend_persons.id_types_position=1
			LEFT JOIN members ON members.id_record=attend_persons.id_members
			WHERE team_search.id_record='$s_id'";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$myLang['query_failed'].":$query");
	if (mysql_num_rows($result)) {
		$r=mysql_fetch_array($result);

		$query2="SELECT *
					FROM types_province 
					LEFT JOIN teams ON teams.id_address_province=types_province.id_record
					WHERE teams.id_record='".$r['id_teams']."'";
		$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$myLang['query_failed'].":$query2");
		if (mysql_num_rows($result2)) {
			$r2=mysql_fetch_array($result2);
			$e_prefix=$r2['prefix'];
			$e_logo_file=$r2['logo_file'];
			$e_assoc['assoc1']=$r2['assoc1'];
			$e_assoc['assoc2']=$r2['assoc2'];
			$e_assoc['assoc3']=$r2['assoc3'];
			$e_assoc['assoc4']=$r2['assoc4'];
			$e_assoc['assoc5']=$r2['assoc5'];
		}

		$e_distance_from_pls=$r['distance_from_pls'];
		$e_id_agency=$r['id_agency'];
		$e_id_teams=$r['id_teams'];
		$team=$r['id_teams'];
		$e_members_total=$r['members_total'];
		$e_hours_total=$r['hours_total'];
		$e_id_types_events=$r['id_types_events'];
		$e_pid=$r['police_file_id'];
		$e_gid="$e_prefix".$r['id_search']."-".$r['gsar_sub_id'];
		$e_name_ic=$r['name_ic'];
		$e_phone_ic=$r['phone_ic'];
		$e_id_sc=$r['id_members'];
		$e_name_sc=$r['name_sc'];
		$e_phone_sc=$r['phone_sc'];
		$e_latpls=$r['lat_coords_pls'];
		$e_longpls=$r['long_coords_pls'];
		list($e_d_began,$e_t_began)=split(" ",$r['when_began']); $e_t_began=substr($e_t_began,0,5);
		list($e_d_released,$e_t_released)=split(" ",$r['when_released']); $e_t_released=substr($e_t_released,0,5);
		list($e_d_returned,$e_t_returned)=split(" ",$r['when_returned']); $e_t_returned=substr($e_t_returned,0,5);
		list($e_d_act,$e_t_act)=split(" ",$r['when_activated']); $e_t_act=substr($e_t_act,0,5);
		list($e_d_alert,$e_t_alert)=split(" ",$r['when_alerted']); $e_t_alert=substr($e_t_alert,0,5);
		list($e_d_arr,$e_t_arr)=split(" ",$r['when_arrived']); $e_t_arr=substr($e_t_arr,0,5);
		list($e_d_found,$e_t_found)=split(" ",$r['when_found']); $e_t_found=substr($e_t_found,0,5);
		list($e_d_conc,$e_t_conc)=split(" ",$r['when_concluded']); $e_t_conc=substr($e_t_conc,0,5);
		$e_cost=$r['cost_total'];
		$e_env=$r['id_types_environment'];
		$e_activity=$r['id_types_activity'];
		$e_reason1=$r['id_types_reason_1'];
		$e_reason2=$r['id_types_reason_2'];
		$e_desc=$r['description'];
		$e_weather_factor=$r['weather_factor'];
		$e_weather=$r['id_weather'];
		$e_when=$r['when_entered'];
		$e_user=$r['id_users'];
		$e_id_search=$r['id_search'];
		$e_record=$r['id_record'];
		$e_team=$r['id_teams'];
		$e_team_name=$r['team_name'];
		$e_agency_name=$r['agency'];
		$e_env_name=$r['environment'];
		$e_user_name=$r['user_name'];
		$e_user_phone=$r['user_phone'];
		$e_event_name=$r['event'];
		$e_activity_name=$r['activity'];
		$e_reason1_name=$r['reason1'];
		$e_reason2_name=$r['reason2'];
		$e_weather_name=$r['weather'];
		$e_when_debrief=$r['when_debrief'];
		$e_place_bebrief=$r['loc_debrief'];
		$e_place_location=$r['location'];
		
		# Check to ensure proper access level to read record
		if ($a_search[$team] == 0 || isset($_SESSION["id_user"])==FALSE) {
			fail_access($_SERVER['QUERY_STRING']);
		}

		echo "<html><head><title>".multilang('l','search_report')."</title>";
		readfile("css_print.html");
		echo "</head><body>";

		echo "<a href=\"sr_edit.php?s_id=$s_id&mode=$mode".SIDAND."\">".$myLang['return_previous']."</a><br><br>";

	### SECTION: Main Table Body
		echo "<table width=100% border=0>
			 <tr><td class=h2><img src=\"$e_logo_file\" alt=\"Logo\" width=200></td>
			 <td class=h2>

			 <table border=0>
			 <tr><td class=h2>
			 <h3 class=normal>".multitype($e_assoc,'assoc')."</h3>
			 <h3 class=normal><em>".multilang('l','search_report')."</em></h3><br>
			 </td></tr></table>
			 <table border=0>
			 <tr><td class=h1><p class=title>".multilang('l','date').":</p><p class=data>$e_when</p></td>
			 <td class=h1>
			 <p class=title>".multilang('l','gsar_file_id').":</p>
			 <p class=data><big><strong>".($e_gid ? $e_gid : "<font color=red>".multilang('l','incomplete')."</font>")."</big></strong></p>
			 </td></tr>
			 <tr><td class=h1><p class=title>".multilang('l','author').":</p><p class=data>$e_user_name</p></td>
			 <td class=h1>
			 <p class=title>".multilang('l','police_file_id').":</p>
			 <p class=data>$e_pid</p>
			 </td></tr></table>
			 </td></tr></table>

			 <table width=100% border=1 cellpadding=0 cellspacing=1 cols=6>
			 <tr><td colspan=6 class=inverse align=left><h2 class=inverse>1. ".strtoupper(multilang('l','general_information'))."</h2></td></tr>
			 <tr>
			 <td colspan=6 valign=top><p class=title>A. ".multilang('l','lead_team')."</p>
			 <p class=data>$e_team_name</p></td>
			 </tr>
			 <tr>
			 <td colspan=2 valign=top><p class=title>B. ".multilang('l','IC')."</p><p class=data>$e_name_ic</p></td>
			 <td colspan=2 valign=top><p class=title>".multilang('l','police_agency').":</p><p class=data>$e_agency_name</p></td>
			 <td colspan=2 valign=top><p class=title>".multilang('l','tel').":</p><p class=data>$e_phone_ic</p></td>
			 </tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>C. ".multilang('l','SM')."</p><p class=data>$e_name_sc</p></td>
			 <td colspan=3 valign=top><p class=title>".multilang('l','tel').":</p><p class=data>$e_phone_sc</p></td>
			 </tr>

			 <tr>
			 <td colspan=3 valign=top><p class=title>D. ".multilang('l','location').":</p><p class=data>$e_place_location</p></td>
			 <td colspan=3 valign=top><p class=title>E. ".multilang('l','point_last_seen')." (LAT LONG):</p>
			 <p class=data>".($e_latpls!=0 ? "$e_latpls&deg ".multilang('l','n_north').", $e_longpls&deg ".multilang('l','w_west') : "")."</p></td>
			 </tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>F. ".multilang('l','type_event')."</p><p class=data>$e_event_name</p></td>
			 <td colspan=3 valign=top><p class=title>G. ".multilang('l','environment')."</p><p class=data>$e_env_name</p></td>
			 </tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>H. ".multilang('l','weather')."</p><p class=data>$e_weather_name</p></td>
			 <td colspan=3 valign=top><p class=title>I. ".multilang('l','was_weather_factor')."</p><p class=data>" . ("$e_weather_factor" == "1" ? multilang('l','yes') : multilang('l','no')) . "</p></td>
			 </tr>
			 <tr><td colspan=6 class=inverse align=left><h2 class=inverse>2. ".multilang('l','time_24h')."</h2></td></tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>A. ".multilang('l','alerted').":</p><p class=data>".($e_d_alert!="0000-00-00" ? "$e_d_alert $e_t_alert" : "")."</p></td>
			 <td colspan=3 valign=top><p class=title>B: ".multilang('l','activated')."</p><p class=data>".($e_d_act!="0000-00-00" ? "$e_d_act $e_t_act" : "")."</p></td>
			 </tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>C. ".multilang('l','arrived').":</p><p class=data>".($e_d_arr!="0000-00-00" ? "$e_d_arr $e_t_arr" : "")."</p></td>
			 <td colspan=3 valign=top><p class=title>D: ".multilang('l','began').":</p><p class=data>".($e_d_began!="0000-00-00" ? "$e_d_began $e_t_began" : "")."</p></td>
			 </tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>E: ".multilang('l','found').":</p><p class=data>".($e_d_found!="0000-00-00" ? "$e_d_found $e_t_found" : "")."</p></td>
			 <td colspan=3 valign=top><p class=title>F: ".multilang('l','subject_released').":</p><p class=data>".($e_d_released!="0000-00-00" ? "$e_d_released $e_t_released" : "")."</p></td>
			 </tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>G: ".multilang('l','concluded')." </p><p class=data>".($e_d_conc!="0000-00-00" ? "$e_d_conc $e_t_conc" : "")."</p></td>
			 <td colspan=3 valign=top><p class=title>H: ".multilang('l','returned_to_base').":</p><p class=data>".($e_d_returned!="0000-00-00" ? "$e_d_returned $e_t_returned" : "")."</p></td>
			 </tr>
			 <tr><td class=inverse colspan=6 align=left><h2 class=inverse>3. ".strtoupper(multilang('l','subject'))."</h2></td></tr>
			<tr>
			<td colspan=3 valign=top><p class=title>A: ".multilang('l','distance_from_pls').":</p><p class=data>$e_distance_from_pls (m)</p></td>
			<td colspan=3 valign=top><p class=title>B: ".multilang('l','activity').":</p><p class=data>$e_activity_name</p></td>
			</tr>
			<tr>
			<td colspan=3 valign=top><p class=title>C: ".multilang('l','reason')." 1:</p><p class=data>$e_reason1_name</p></td>
			<td colspan=3 valign=top><p class=title>D: ".multilang('l','reason')." 2:</p><p class=data>$e_reason2_name</p></td>
			</tr>";

		$query = "SELECT subjects.id_record AS record,
				    types_experience.type1 AS experience1, 
				    types_experience.type2 AS experience2, 
				    types_experience.type3 AS experience3, 
				    types_experience.type4 AS experience4, 
				    types_experience.type5 AS experience5, 
				    types_equipment.type1 AS equipment1, 
				    types_equipment.type2 AS equipment2, 
				    types_equipment.type3 AS equipment3, 
				    types_equipment.type4 AS equipment4, 
				    types_equipment.type5 AS equipment5, 
				    subjects.subject_name AS subject_name, 
				    subjects.subject_age AS subject_age, 
				    subjects.subject_gender AS subject_gender, 
				    types_outcome.type1 AS outcome1,
				    types_outcome.type2 AS outcome2,
				    types_outcome.type3 AS outcome3,
				    types_outcome.type4 AS outcome4,
				    types_outcome.type5 AS outcome5,
				    types_condition.type1 AS condition1, 
				    types_condition.type2 AS condition2, 
				    types_condition.type3 AS condition3, 
				    types_condition.type4 AS condition4, 
				    types_condition.type5 AS condition5 
				    FROM subjects
				    LEFT JOIN types_condition ON subjects.id_types_condition=types_condition.id_record 
				    LEFT JOIN types_outcome ON subjects.id_types_outcome=types_outcome.id_record
				    LEFT JOIN types_experience ON subjects.id_experience=types_experience.id_record
				    LEFT JOIN types_equipment ON subjects.id_equipment=types_equipment.id_record
				    WHERE subjects.id_search='$e_id_search' 
				    ORDER BY subjects.subject_name";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$myLang['query_failed'].":$team_query");
		if (mysql_num_rows($result)) {
		    $letter="E";
		    echo "<tr><td colspan=6><table width=100% border=1 cellpadding=0 cellspacing=1 cols=7>";
		    while ($r = mysql_fetch_array($result)) {
			   echo "<tr>
				    <td><p class=title>".$letter."1: ".multilang('l','name').":</p><p class=data>".$r['subject_name']."</p></td>
				    <td><p class=title>".$letter."2: ".multilang('l','age').":</p><p class=data>".($r['subject_age']!=0 ? $r['subject_age'] : "")."</p></td>
				    <td><p class=title>".$letter."3: ".multilang('l','gender').":</p><p class=data>".$r['subject_gender']."</p></td>
				    <td><p class=title>".$letter."4: ".multilang('l','experience').":</p><p class=data>".multitype($r,'experience')."</p></td>
				    <td><p class=title>".$letter."5: ".multilang('l','equipment').":</p><p class=data>".multitype($r,'equipment')."</p></td>
				    <td><p class=title>".$letter."6: ".multilang('l','outcome').":</p><p class=data>".multitype($r,'outcome')."</p></td>
				    <td><p class=title>".$letter."7: ".multilang('l','condition').":</p><p class=data>".multitype($r,'condition')."</p></td>
				    <td></td>
				    </tr>";
			    $letter=chr(ord($letter)+1);
		    }
		    echo "</table></tr>";
		}else{
		    # Nothing matched the query
		    echo "<tr><td colspan=6><p>".multilang('l','none').".</p></td></tr>";
		}
		echo "<tr><td class=inverse colspan=6 align=left><h2 class=inverse>4. ".multilang('l','conclusion_resources')."</h2></td></tr>
				<tr>
				<td colspan=2 valign=top><p class=title>A. ".multilang('l','members_responding').":</p><p class=data>$e_members_total</p></td>
				<td colspan=2 valign=top><p class=title>B. ".multilang('l','total_hours').":</p><p class=data>$e_hours_total</p></td>
				 <td colspan=2 valign=top><p class=title>C. ".multilang('l','total_cost').":</p><p class=data>$e_cost</p></td>
				</tr>";
				
/*		echo "<tr>
				<td colspan=6 valign=top><p class=title>D. ".multilang('l','additional_teams').":</p><p class=data>";
		$query = "SELECT teams.team_name AS team 
					FROM search
					LEFT JOIN team_search ON team_search.id_search=search.id_record
					LEFT JOIN teams ON team_search.id_teams=teams.id_record
					WHERE team_search.id_search='$e_id_search' AND team_search.id_teams!='$e_team' 
					ORDER BY teams.team_name";
		$result = mysql_query($query) or die $myLang['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$flag=0;
		  while ($r = mysql_fetch_array($result)) {
			if ( $flag == 1){ echo ", " ;}else{ $flag = 1 ;}
		    echo $r['team'];
		  }
		}else{
			echo multilang('l','none');
		}
		echo "</p></td>
			 </tr>";
*/			 
		echo "<tr>
			 <td colspan=6 valign=top><p class=title>D. ".multilang('l','resources_used').":</p><p class=data>";
		$query = "SELECT resources.id_record AS record, types_resources.type1, types_resources.type2, types_resources.type3, types_resources.type4, types_resources.type5 FROM types_resources, resources WHERE resources.id_search='$e_id_search' AND resources.id_types_resources=types_resources.id_record ORDER BY types_resources.type1";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$myLang['query_failed'].":$team_query");
		if (mysql_num_rows($result)) {
			$flag=0;
		  while ($r = mysql_fetch_array($result)) {
			if ( $flag == 1){ echo ", " ;}else{ $flag = 1 ;}
		    echo multitype($r,'type');
		  }
		}else{
			echo multilang('l','none');
		}
		echo "</p></td>
			 </tr>
			 <tr>
			 <td colspan=6 valign=top><p class=title>E. ".multilang('l','tactics_used').":</p><p class=data>";
		$query = "SELECT techniques.id_record AS record, types_techniques.type1, types_techniques.type2, types_techniques.type3, types_techniques.type4, types_techniques.type5 FROM types_techniques, techniques WHERE techniques.id_search='$e_id_search' AND techniques.id_types_techniques=types_techniques.id_record ORDER BY types_techniques.type1";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$myLang['query_failed'].":$team_query");
		if (mysql_num_rows($result)) {
			$flag=0;
		  while ($r = mysql_fetch_array($result)) {
			if ( $flag == 1){ echo ", " ;}else{ $flag = 1 ;}
		    echo multitype($r,'type');
		  }
		}else{
			echo multilang('l','none');
		}
		echo "</p></td>
			 </tr>
			 <tr><td class=inverse colspan=6 align=left><h2 class=inverse>5. ".multilang('l','review')."</h2></td></tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>A. ".multilang('l','SM').":</p><p class=data><br></p></td>
			 <td colspan=3 valign=top><p class=title>B. ".multilang('l','sr_team_ops')."</p><p class=data><br></p></td>
			 </tr>
			 <tr>
			 <td colspan=3 valign=top><p class=title>C. ".multilang('l','debrief_date').":</p><p class=data>".($e_when_debrief!="0000-00-00" ? "$e_when_debrief" : "")."</p></td>
			 <td colspan=3 valign=top><p class=title>D. ".multilang('l','debrief_location')."</p><p class=data>$e_place_bebrief</p></td>
			 </tr>
			 <tr><td class=inverse colspan=6 align=left><h2 class=inverse>6. ".multilang('l','narrative')."</h2></td></tr>";
		if ($e_desc){
			 echo "<td colspan=6 valign=top><p class=data>$e_desc</p></td>";
		}else{
			echo "<td colspan=6  valign=top><p class=data>".multilang('l','none').".</p></td>";
		}
		echo "</tr><tr><td class=inverse colspan=6 align=left><h2 class=inverse>7. ".strtoupper(multilang('l','members'))."</h2></td></tr>";
		$query="SELECT attend_persons.id_record,
			CONCAT(members.name_last,', ',members.name_first) AS full_name,
			teams.team_name,
			attend_persons.id_types_position,
			types_position.type1,
			types_position.type2,
			types_position.type3,
			types_position.type4,
			types_position.type5,
			attend_persons.hours
			FROM attend_persons
			LEFT JOIN members ON members.id_record=attend_persons.id_members
			LEFT JOIN teams_members ON teams_members.id_members=members.id_record
			LEFT JOIN teams ON teams.id_record=teams_members.id_teams
			LEFT JOIN types_position ON types_position.id_record=attend_persons.id_types_position
			WHERE attend_persons.id_search='$s_id'
			GROUP BY attend_persons.id_record
			ORDER BY members.name_last";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$myLang['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			echo "<tr><td colspan=6><table cellspacing=\"10\">
					<tr>
					<td><h3 class=normal>".multilang('l','full_name')."</h3></td>
					<td><h3 class=normal>".multilang('l','hours')."</h3></td>
					<td><h3 class=normal>".multilang('l','position')."</h3></td>
					<td></td>
					</tr>";
			while ($r = mysql_fetch_array($result)) {
					echo "<tr>
					<td><p class=data>".$r['full_name']."</p></td>
					<td><p class=data>".$r['hours']."</p></td>
					<td><p class=data>".multitype($r,'type')."</p></td>
					</tr>";
			}
			echo "</table></td></tr>";
		}else{
			echo "<tr><td colspan=6><p class=data>".multilang('l','none').".</p></td></tr>";
		}
		echo "</p></td>
			 </tr>
			 </table>";

	}else{
		echo multilang('l','no_results');
	}

	echo "</body></html>";
	exit;
	
	function multilang($inArray,$element){
		# Return string containing values for element $element for all hashes $inArray(1 to $maxLang)  
		global $maxLang,$l1,$l2,$l3,$l4,$l5;
		$myString = "";
		for ($x = 1; $x <= $maxLang; $x++){
			$myVar="$inArray$x";
			$myHash = $$myVar;
			if ($myHash[$element] != ""){
				$myString .= $myHash[$element];
				if ($x < $maxLang) { $myString .= "/";}
			}
		}
		return $myString;
	}

	function multitype($inArray,$element){
		# Return string containing values for element $element(1 to $maxLang) for hash $inArray 
		global $maxLang;
		$myString = "";
		for ($x = 1; $x <= $maxLang; $x++){
			$myVar="$element$x";
			if ($inArray[$myVar] != ""){
				$myString .= $inArray[$myVar];
				if ($x < $maxLang) { $myString .= "/";} # Separate values by /
			}
		}
		return $myString;
	}
?>
