<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: sr_save.php
	# Version: 19 June 2005
	# Author: Calvin Martini
	# Description: Save search report record.

	session_start();

	# Set client variables
	$client_vars=array(
		'action',
		'dd_e_d_act',
		'e_t_act',
		'dd_e_d_alert',
		'e_t_alert',
		'dd_e_d_arr',
		'e_t_arr',
		'dd_e_d_began',
		'e_t_began',
		'dd_e_d_conc',
		'e_t_conc',
		'dd_e_d_found',
		'e_t_found',
		'dd_e_d_found',
		'e_t_found',
		'dd_e_d_released',
		'e_t_released',
		'dd_e_d_returned',
		'e_t_returned',
		'dd_e_when_debrief',
		'e_activity',
		'e_cost',
		'e_desc',
		'e_distance_from_pls',
		'e_env',
		'e_id_agency',
		'e_id_types_events',
		'e_latpls',
		'e_loc_debrief',
		'e_location',
		'e_longpls',
		'e_members_total',
		'e_name_ic',
		'e_phone_ic',
		'e_pid',
		'e_province',
		'e_reason1',
		'e_reason2',
		'e_team',
		'e_weather',
		'e_weather_factor',
		'gsar_sub_id',
		'mm_e_d_act',
		'mm_e_d_alert',
		'mm_e_d_arr',
		'mm_e_d_began',
		'mm_e_d_conc',
		'mm_e_d_found',
		'mm_e_d_found',
		'mm_e_d_released',
		'mm_e_d_returned',
		'mm_e_when_debrief',
		'mode',
		'r_id',
		's_id',
		'yyyy_e_d_act',
		'yyyy_e_d_alert',
		'yyyy_e_d_arr',
		'yyyy_e_d_began',
		'yyyy_e_d_conc',
		'yyyy_e_d_found',
		'yyyy_e_d_found',
		'yyyy_e_d_released',
		'yyyy_e_d_returned',
		'yyyy_e_when_debrief',
		'e_select',
		'e_id',
		'e_count',
		'e_hours_total',
		'e_hours',
		'e_subjects',
		'e_resources',
		'e_techniques',
		'e_position'
	);
	foreach ($client_vars as $formvar){
		$$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL;
	}
	if ( isset($e_team) ) { $team = $e_team; }else{ $team = NULL; }

	require("globals.php");

	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_searches");

	if ($action == $l['cancel']){
		header("Location: display.php".SIDPRINT."\n\n");
		exit;
	}elseif($action == $l['delete'] && (max($a_search) >= 4 || $a_admin == 1)){
		$query ="SELECT COUNT(*) AS count FROM team_search WHERE id_search='$r_id'";
		$result = mysql_query($query) or die ($l['query_failed'].":$query");
		$r = mysql_fetch_array($result);
		$count = $r['count'];
		$query ="DELETE FROM team_search WHERE id_record='$s_id'";
		$result = mysql_query($query) or die ($l['query_failed'].":$query");
		$query ="DELETE FROM attend_persons WHERE id_search='$s_id'";
		$result = mysql_query($query) or die ($l['query_failed'].":$query");

		# Only delete search related records if this is the only/last linked search record
		if ($count == 1){
				$query ="DELETE FROM techniques WHERE id_search='$r_id'";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				$query ="DELETE FROM subjects WHERE id_search='$r_id'";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				$query ="DELETE FROM search WHERE id_record='$r_id'";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
		}

		# Redirect the browser
		header("Location: display.php".SIDPRINT."\n\n");
		exit;
	}

	# Check to ensure proper access level to edit record
	if ($a_search[$team] < 2 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	# Convert longitude to negative value for Western/North America
	$e_longpls= -abs($e_longpls);

	if ($e_name_ic && $e_id_agency && $team && $e_latpls && $e_longpls && $yyyy_e_d_alert && $mm_e_d_alert && $dd_e_d_alert && $e_t_alert && $yyyy_e_d_conc && $mm_e_d_conc && $dd_e_d_conc && $e_t_conc && $e_id_types_events && $e_desc && $e_reason1){
		## Set as complete
		$e_flag_complete="1";
	}else{
		## Set as incomplete
		$e_flag_complete="0";
	}

	# Save Record
	if ($mode == "update"){
		$query="UPDATE search SET
					distance_from_pls='$e_distance_from_pls',
					when_debrief='$yyyy_e_when_debrief-$mm_e_when_debrief-$dd_e_when_debrief',
					loc_debrief='$e_loc_debrief',
					location='$e_location',
					id_agency='$e_id_agency',
					id_types_events='$e_id_types_events',
					name_ic='$e_name_ic',
					phone_ic='$e_phone_ic',
					lat_coords_pls='$e_latpls',
					long_coords_pls='$e_longpls',
					id_weather='$e_weather',
					weather_factor='$e_weather_factor',
					when_released='$yyyy_e_d_released-$mm_e_d_released-$dd_e_d_released $e_t_released',
					when_concluded='$yyyy_e_d_conc-$mm_e_d_conc-$dd_e_d_conc $e_t_conc',
					when_found='$yyyy_e_d_found-$mm_e_d_found-$dd_e_d_found $e_t_found',
					id_types_environment='$e_env',
					id_types_activity='$e_activity',
					id_types_reason_1='$e_reason1',
					id_types_reason_2='$e_reason2',
					police_file_id='$e_pid',
					id_province='$e_province',
					id_users='$id_recno'
					WHERE id_record='$r_id'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		$query="UPDATE team_search SET
					id_teams='$team',
					id_search='$r_id',
					members_total='$e_members_total',
					hours_total='$e_hours_total',
					when_began='$yyyy_e_d_began-$mm_e_d_began-$dd_e_d_began $e_t_began',
					when_returned='$yyyy_e_d_returned-$mm_e_d_returned-$dd_e_d_returned $e_t_returned',
					when_activated='$yyyy_e_d_act-$mm_e_d_act-$dd_e_d_act $e_t_act',
					when_alerted='$yyyy_e_d_alert-$mm_e_d_alert-$dd_e_d_alert $e_t_alert',
					when_arrived='$yyyy_e_d_arr-$mm_e_d_arr-$dd_e_d_arr $e_t_arr',
					description='$e_desc',
					gsar_sub_id='$gsar_sub_id',
					cost_total='$e_cost',
					flag_complete='$e_flag_complete',
					id_users='$id_recno'
					WHERE id_record='$s_id'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");

	}elseif ($mode == "new"){

		if ($r_id != -999){
			# A new team search for an existing search
			$query="UPDATE search SET
						distance_from_pls='$e_distance_from_pls',
						when_debrief='$yyyy_e_when_debrief-$mm_e_when_debrief-$dd_e_when_debrief',
						loc_debrief='$e_loc_debrief',
						location='$e_location',
						id_agency='$e_id_agency',
						id_types_events='$e_id_types_events',
						name_ic='$e_name_ic',
						phone_ic='$e_phone_ic',
						lat_coords_pls='$e_latpls',
						long_coords_pls='$e_longpls',
						id_weather='$e_weather',
						weather_factor='$e_weather_factor',
						when_released='$yyyy_e_d_released-$mm_e_d_released-$dd_e_d_released $e_t_released',
						when_concluded='$yyyy_e_d_conc-$mm_e_d_conc-$dd_e_d_conc $e_t_conc',
						when_found='$yyyy_e_d_found-$mm_e_d_found-$dd_e_d_found $e_t_found',
						id_types_environment='$e_env',
						id_types_activity='$e_activity',
						id_types_reason_1='$e_reason1',
						id_types_reason_2='$e_reason2',
						police_file_id='$e_pid',
						id_province='$e_province',
						id_users='$id_recno'
						WHERE id_record='$r_id'";
			$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		}else{
			# A completely new search and team search
			$query="INSERT INTO search (
						distance_from_pls,
						when_debrief,
						loc_debrief,
						location,
						id_agency,
						id_types_events,
						name_ic,
						phone_ic,
						lat_coords_pls,
						long_coords_pls,
						id_weather,
						weather_factor,
						when_released,
						when_concluded,
						when_found,
						id_types_environment,
						id_types_activity,
						id_types_reason_1,
						id_types_reason_2,
						police_file_id,
						id_province,
						id_users
					) VALUES (
						'$e_distance_from_pls',
						'$yyyy_e_when_debrief-$mm_e_when_debrief-$dd_e_when_debrief',
						'$e_loc_debrief',
						'$e_location',
						'$e_id_agency',
						'$e_id_types_events',
						'$e_name_ic',
						'$e_phone_ic',
						'$e_latpls',
						'$e_longpls',
						'$e_weather',
						'$e_weather_factor',
						'$yyyy_e_d_released-$mm_e_d_released-$dd_e_d_released $e_t_released',
						'$yyyy_e_d_conc-$mm_e_d_conc-$dd_e_d_conc $e_t_conc',
						'$yyyy_e_d_found-$mm_e_d_found-$dd_e_d_found $e_t_found',
						'$e_env',
						'$e_activity',
						'$e_reason1',
						'$e_reason2',
						'$e_pid',
						'$e_province',
						'$id_recno'
					)";
			$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
			$r_id = mysql_insert_id();
		}
		$query="INSERT INTO team_search (
					id_teams,
					id_search,
					members_total,
					hours_total,
					when_began,
					when_returned,
					when_activated,
					when_alerted,
					when_arrived,
					description,
					gsar_sub_id,
					cost_total,
					flag_complete,
					id_users
				) VALUES (
					'$team',
					'$r_id',
					'$e_members_total',
					'$e_hours_total',
					'$yyyy_e_d_began-$mm_e_d_began-$dd_e_d_began $e_t_began',
					'$yyyy_e_d_returned-$mm_e_d_returned-$dd_e_d_returned $e_t_returned',
					'$yyyy_e_d_act-$mm_e_d_act-$dd_e_d_act $e_t_act',
					'$yyyy_e_d_alert-$mm_e_d_alert-$dd_e_d_alert $e_t_alert',
					'$yyyy_e_d_arr-$mm_e_d_arr-$dd_e_d_arr $e_t_arr',
					'$e_desc',
					'$gsar_sub_id',
					'$e_cost',
					'$e_flag_complete',
					'$id_recno'
				)";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		$s_id = mysql_insert_id();

	}else{
		bad_access($_SERVER['QUERY_STRING']);
	}

	################# START SUBSECTIONS

	# Process Resource Selections
	$query="DELETE FROM resources WHERE id_search='$r_id'";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");

	$query="INSERT INTO resources (id_search, id_types_resources) VALUES ";
	$count=count($e_resources);
	for ($i=0; $i<$count; $i++){
		$query.="('$r_id','$e_resources[$i]')".($i==($count-1)? "":",");
	}
	if ($i>0){$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");}

	# Process Technique Selections
	$query="DELETE FROM techniques WHERE id_search='$r_id'";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");

	$query="INSERT INTO techniques (id_search, id_types_techniques) VALUES";
	$count=count($e_techniques);
	for ($i=0; $i<$count; $i++){
		$query.="('$r_id','$e_techniques[$i]')".($i==($count-1)? "":",");
	}
	if ($i>0){$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");}

	# Process Attendance
	# First, delete all of the attendance records for this search
	$query="DELETE FROM attend_persons WHERE id_search='$s_id'";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");

	$query="INSERT INTO attend_persons (id_search, id_members, hours, id_types_position) VALUES ";
	$count=count($e_select);
	$count2=0;
	if($count>0){
		foreach($e_count as $i){
			if ($e_select[$i]){
				$query.="('$s_id','$e_id[$i]','$e_hours[$i]','$e_position[$i]'),";
				$count2++;
			}
		}
	}
	$query=rtrim($query,",");
	if ($count2>0){$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");}

	# Process Subjects
	# First, delete all of the subject records for this clasee
	$query="DELETE FROM subjects WHERE id_search='$r_id'";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");

	$query="INSERT INTO subjects (
					id_search,
					id_experience,
					id_equipment,
					subject_name,
					subject_age,
					subject_gender,
					id_types_condition,
					id_types_outcome,
					flag_training
				) VALUES ";
	$data = explode(";",$e_subjects);
	array_pop($data);
	$count=0;
	$count2=0;
	foreach ($data as $line){
		list($line_name[$count],$line_age[$count],$line_gender[$count],$line_experience[$count],$line_equipment[$count],$line_outcome[$count],$line_condition[$count],$line_training[$count]) = explode(",",$line);
		if ($line_name[$count]){
			$query.="(
				'$r_id',
				'$line_experience[$count]',
				'$line_equipment[$count]',
				'$line_name[$count]',
				'$line_age[$count]',
				'$line_gender[$count]',
				'$line_condition[$count]',
				'$line_outcome[$count]',
				'$line_training[$count]'
				)".($count==count($data)-1 ? "":",");
			$count2++;
		}
		$count++;
	}

	$query=rtrim($query,",");
	if ($count2>0){$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");}

	################# END SUBSECTIONS

	# Mail new/update notification message
	if (!empty($sr_notify)) {
		# Get team name
		$query="SELECT team_name FROM teams WHERE id_record=$team";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		$r = mysql_fetch_array($result);
		$team = $r['team_name'];

		$summary="SUMMARY:\n========\n\nFile: $r_id-$gsar_sub_id\nTeam: $team\nActivated: $yyyy_e_d_act-$mm_e_d_act-$dd_e_d_act $e_t_act\nLocation: $e_location\nDescription:\n$e_desc\n";
		mail($sr_notify, "$mode search report $r_id-$gsar_sub_id ", "$mode search report $r_id-$gsar_sub_id by $id_user.\n\n".$summary.$mail_footer,
		  "From: $admin_email\nReply-To: $admin_email\nX-Mailer: PHP/" . phpversion());
	}

	logit($logfile,"250\t$mode search report ".($s_id ? "$s_id " : "")."by $id_user.");
	header("Location: display.php".SIDPRINT."\n\n");
	exit;

?>