<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: sr_select.php
	# Version: 14 May 2004
	# Author: Calvin Martini
	# Description: Assign search report record to existing search (ie. multi-team) or create new search

	session_start(); 

	# Set client variables
	$client_vars=array(
		'e_seek',
		'mode',
		'period',
		'province',
		'report',
		's_id',
		'search',
		'search_scope_2',
		't_id'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}
	if ( isset($t_id) ) { $team = $t_id; }else{ $team = NULL; }

	require("globals.php");

	connect_db();
	
	# Limit for number of records to return per page
	$page_limit = 20;
	
	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_searches");

	# Check to ensure proper access level to edit record
	if ( max($a_search) < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	# If user changed display or filter modes, set the session variables
	if ($period){$s_period_2=$period;}
	if ($province){$s_province_2=$province;}

	# Set the search filter
	if ($search_scope_2 && $search){
		switch ($search_scope_2) {
			case "teamname";
				$s_report_2="tsum";
				$s_filter_2="All";
				$search_filter_2="AND team_name LIKE '%$search%'"; 
				break 1;
			case "teamaddress";
				$s_report_2="tsum";
				$s_filter_2="All";
				$search_filter_2="AND (team_address LIKE '%$search%' OR team_city LIKE '%$search%' OR team_pcode LIKE '%$search%')"; 
				break 1;
			case "sweather":
				$s_report_2="ssum";
				$s_filter_2="All";
				$search_filter_2="AND types_weather.type$lang LIKE '%$search%'"; 
				break 1;
			case "smanager":
				$s_report_2="ssum";
				$s_filter_2="All";
				$search_filter_2="AND search.name_ic LIKE '%$search%'"; 
				break 1;
			case "slocation";
				$s_report_2="ssum";
				$s_filter_2="All";
				$search_filter_2="AND search.location LIKE '%$search%'"; 
				break 1;
			case "ssubject";
				$s_report_2="ssum";
				$s_filter_2="All";
				$search_filter_2="AND subjects.subject_name LIKE '%$search%'"; 
				break 1;
			case "sactivity";
				$s_report_2="ssum";
				$s_filter_2="All";
				$search_filter_2="AND types_activity.type$lang LIKE '%$search%'"; 
				break 1;
			case "senvironment";
				$s_report_2="ssum";
				$s_filter_2="All";
				$search_filter_2="AND types_environment.type$lang LIKE '%$search%'"; 
				break 1;
			case "sreason";
				$s_report_2="ssum";
				$s_filter_2="All";
				$search_filter_2="AND types_reason.type$lang LIKE '%$search%'"; 
				break 1;
		}
	}	
	

	head("sr_select");

	# Set DB query
	$query="
		SELECT search.id_record, 
		DATE_FORMAT(search.when_concluded,'%Y-%m-%d') AS when_concluded,
		CONCAT(types_province.prefix,search.id_record) AS gsar_file_id,
		search.police_file_id,
		search.location,
		subjects.subject_name,
		types_activity.type$lang AS activity
		FROM search
		LEFT JOIN types_activity ON search.id_types_activity=types_activity.id_record
		LEFT JOIN subjects ON search.id_record=subjects.id_search
		LEFT JOIN team_search ON team_search.id_search=search.id_record
		LEFT JOIN teams ON team_search.id_teams=teams.id_record
		LEFT JOIN types_province ON types_province.id_record=teams.id_address_province
		WHERE 1=1
		$search_filter_2
		".($s_period_2 ? period_filter($s_period_2,"search.when_concluded") : "" )."
		".($s_filter_2 && $s_filter_2 != "All" && $s_filter_2 != "None" ? " AND search.id_teams='$s_filter_2'" : "")."				
		".($s_province_2 && $s_province_2 != "All" && $s_province_2 != "None" ? " AND search.id_province='$s_province_2'" : "")."				
		GROUP BY gsar_file_id
		ORDER BY when_concluded
		";

	$result = mysql_query($query) or die ($l['query_failed'].":$query");
	$res_row = mysql_num_rows($result);
	if ($res_row) {

		echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/calendar/calendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/CallCalendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/add_days.js\"></SCRIPT>
				";

		echo "<form method=POST action=sr_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm>
				".SIDHIDDEN."
				<input type=hidden name=mode value=\"$mode\">";

		echo "<p class=BodyH2>".$l['multiteam_search']."?</p>
				<p class=BodyTxt>".$l['link_search']."</p>";

		# Print page links
		if ($res_row > $page_limit){
			if (!$e_seek){$e_seek=0;}
			if (($e_seek+$page_limit) <= $res_row){
				$e_end = $e_seek + $page_limit - 1;
			}else{
				$e_end = $res_row;
			}
			$start = $e_seek + 1;
			$end = $e_end + 1;
			$e_page = floor($e_seek/$page_limit) + 1;
			echo "<p class=BodyTxt>".ereg_replace("\[start\]","$start",ereg_replace("\[end\]","$end",ereg_replace("\[records\]","$res_row",$l['page_limit'])));
			echo "&nbsp;&nbsp;&nbsp;<b>".$l['page']."&nbsp;</b> ";
			for ($i = 1; $i <= ceil($res_row / $page_limit); $i++) {
				echo ($i == $e_page ? "<b>" : "")."<a class=BodyLink href=\"sr_select.php?mode=new&s_id=-999&e_seek=".(($i-1) * $page_limit).SIDAND."\">$i</a>&nbsp;&nbsp;&nbsp".($i == $e_page ? "</b>" : "");
			}
			echo "</p>";
		}

		echo "<table class=BodyRepTh cellpadding=0 cellspacing=0>";

		$col[]=$l['date']; $col[]=$l['file_id']; $col[]=$l['police_file_id']; $col[]=$l['location']; $col[]=$l['subject']; $col[]=$l['activity'];
		$dat[]="when_concluded"; $dat[]="gsar_file_id"; $dat[]="police_file_id"; $dat[]="location"; $dat[]="subject_name"; $dat[]="activity";

		# Display column headings
		echo "<tr>";
		echo "<td class=BodyRepTh><p class=BodyRepH2>+</p></td>";
		foreach ($col as $column){
				echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
		}	
		if ($query2){
			foreach ($sub_col as $column){
					echo "<td class=BodyRepTd><p class=BodyRepTh>$column</p></td>";
			}
		}
		echo "</tr>";

		# Set start record
		if ($e_seek && (!mysql_data_seek($result, $e_seek))) {
			echo "<p class=BodyTxt>Cannot seek to row $e_seek</p>";
			continue;
		}

		$count = 0;
		while (($r = mysql_fetch_array($result)) && ($count < $page_limit)) {
			echo "<tr>";
			echo "<td class=BodyRepTd><p class=BodyRepTxt><a class=BodyLink href=\"sr_edit.php?mode=$mode&s_id=$s_id&r_id=".$r['id_record'].SIDAND."\"><img src=\"images/blue.gif\" border=0></a></p></td>";

			foreach ($dat as $data){
				echo "<td class=BodyRepTd><p class=BodyRepTxt>".($r[$data] ? $r[$data] : "&nbsp;")."</p></td>";
			}

			echo "</tr>";
			$count++;

		}
		
		### End of table	
		echo "</table>";

	}else{
		# Nothing matched the query
		echo "<p class=BodyH2>".$l['multiteam_search']."?</p>";
		echo "<p class=BodyTxt>".$l['link_search']."</p><br>";
		echo "<p class=BodyTxt>".$l['no_results']."</p><br>";
	}
	
	foot();

?>