<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: sr_subject_edit.php
	# Version: 10 September 2004
	# Author: Calvin Martini
	# Description: Displays subjects for a given search and returns details to form field
	# Parameters:	
	#					target_field	text area field on parent form to use as target for output
	#					target_value	value of target form text area field
	#					data_field		machine readable text data form field for input/output
	#					data_value		value of data form text field
	
	session_start(); 

	# Set client variables
	$client_vars=array(
		'data_field',
		'data_value',
		'mode',
		's_id',
		't_id',
		'target_field',
		'target_value'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}
	if ( isset($t_id) ) { $team = $t_id; }else{ $team = NULL; }

	require("globals.php");

	# Test to ensure user is logged in
	if (isset($_SESSION["id_user"])==FALSE){
		fail_access($_SERVER['QUERY_STRING']);
	}

	connect_db();
	
	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_searches");

	echo "<head>
		<TITLE>".$l['app_title']."</TITLE>
		<META name=\"description\" content=\"Operational contacts for The New Brunswick Ground Search and Rescue Association.\">
		<META name=\"keywords\" content=\"Search and Rescue, SAR, GSAR, volunteer, non-profit, association, New Brunswick, Canada\">
		<link rel=\"stylesheet\" href=\"./css.html\" type=\"text/css\">";
	echo "</head>";
	
	echo "<body LANGUAGE=javascript onload=\"window.focus()\">";

	echo "<SCRIPT type=\"text/javascript\" LANGUAGE=\"JavaScript1.2\">
				function e_save(e_count) {
					// Rebuilds list based on checked/unchecked records
					newDesc = \"".str_pad($l['name'],20)." ".str_pad($l['age'],3)." ".str_pad($l['m_f'],3)." ".str_pad($l['experience'],10)." ".str_pad($l['equipment'],10)." ".str_pad($l['outcome'],10)." ".str_pad($l['condition'],10)." ".str_pad($l['training'],10)."\\n==================== === === ========== ========== ========== ========== ==========\\n\";
					var newData = \"\";
					for (var i=0;i<e_count;i++) {
						if (eval(\"document.MForm2.e_select\" + i + \".checked\")) {
							newDesc = newDesc + PadRight(eval(\"document.MForm2.e_name\" + i + \".value\"),20,'') + \" \" 
								+ PadRight(eval(\"document.MForm2.e_age\" + i + \".value\"),3,'') + \" \" 
								+ PadRight(eval(\"document.MForm2.e_gender\" + i + \".options[document.MForm2.e_gender\" + i + \".selectedIndex].value.substring(0,3)\"),3,'') + \" \" 
								+ PadRight(eval(\"document.MForm2.e_experience\" + i + \".options[document.MForm2.e_experience\" + i + \".selectedIndex].text.substring(0,10)\"),10,'') + \" \" 
								+ PadRight(eval(\"document.MForm2.e_equipment\" + i + \".options[document.MForm2.e_equipment\" + i + \".selectedIndex].text.substring(0,10)\"),10,'') + \" \" 
								+ PadRight(eval(\"document.MForm2.e_outcome\" + i + \".options[document.MForm2.e_outcome\" + i + \".selectedIndex].text.substring(0,10)\"),10,'') + \" \" 
								+ PadRight(eval(\"document.MForm2.e_condition\" + i + \".options[document.MForm2.e_condition\" + i + \".selectedIndex].text.substring(0,10)\"),10,'') + \" \" 
								+ PadRight(eval(\"document.MForm2.e_training\" + i + \".options[document.MForm2.e_training\" + i + \".selectedIndex].text.substring(0,10)\"),10,'') + \"\\n\";
							newData = newData + eval(\"document.MForm2.e_name\" + i + \".value\") + \",\" + eval(\"document.MForm2.e_age\" + i + \".value\") + \",\" + eval(\"document.MForm2.e_gender\"  + i + \".value\") + \",\" + eval(\"document.MForm2.e_experience\" + i + \".value\") + \",\" + eval(\"document.MForm2.e_equipment\" + i + \".value\") + \",\" + eval(\"document.MForm2.e_outcome\" + i + \".value\") + \",\" + eval(\"document.MForm2.e_condition\" + i + \".value\") + \",\" + eval(\"document.MForm2.e_training\" + i + \".value\") + \";\";
						} 
					}
					window.opener.document.$target_field.value = newDesc;
					window.opener.document.$data_field.value = newData;
					window.opener.CloseWindow();
				}

			</SCRIPT>";
	echo "<SCRIPT type=\"text/javascript\" LANGUAGE=\"JavaScript\" SRC=\"js/CallWindow.js\"></SCRIPT>";
	echo "<SCRIPT type=\"text/javascript\" LANGUAGE=\"JavaScript\" SRC=\"js/PadRight.js\"></SCRIPT>";

			
#DEBUG echo "1=$target_field<br>2=$target_value<br>3=$data_field<br>4=$data_value<br>";		
	echo "<form method=POST action=\"".$_SERVER['PHP_SELF']."\" ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm2>";
	echo "<p class=BodyH2>".$l['search_subjects']."</p>";

	echo "<table class=BodyRepTbl cellpadding=2 cellspacing=0>
				<tr>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['select']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['name']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['age']."</td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['gender']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['experience']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['equipment']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['outcome']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['condition']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['training']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
				</tr>";

	# loop through list
	$data = explode(";",$data_value);
	array_pop($data);
	$count=0;
	foreach ($data as $line){
		list($line_name[$count],$line_age[$count],$line_gender[$count],$line_experience[$count],$line_equipment[$count],$line_outcome[$count],$line_condition[$count],$line_training[$count]) = explode(",",$line);
#DEBUG echo "<br>$line_name[$count],$line_age[$count],$line_gender[$count],$line_experience[$count],$line_equipment[$count],$line_outcome[$count],$line_condition[$count],$line_training[$count]";
		line_out($count,1,$line_name[$count],$line_age[$count],$line_gender[$count],$line_experience[$count],$line_equipment[$count],$line_outcome[$count],$line_condition[$count],$line_training[$count]);
		$count++;
	}
	
	# output 5 extra lines
	for ($i = 0; $i <= 4; $i++){
		line_out(($count+$i),0,"","","","","","","","");
	}


	echo "</table>";
	echo "<input class=BodyBut type=button name=action value='".$l['save']."' onClick='e_save(".($count+5).");'>";
	echo "<input class=BodyBut type=button name=action value='".$l['cancel']."' onClick='window.opener.CloseWindow();'>";
	echo "</form>";



function line_out($line,$select,$name,$age,$gender,$experience,$equipment,$outcome,$condition,$training){
	global $l,$lang;

#DEBUG echo "$line,$select,$name,$age,$gender,$experience,$equipment,$outcome,$condition,$training<br>";
	echo "<tr>
			<td class=BodyRepTd><input class=BodyChk type=checkbox name=e_select$line".($select==1 ? " checked" : "")."></td>
			<td class=BodyRepTd valign=top><input class=BodyInp type=text name=e_name$line size=20 value=\"$name\"></td>
			<td class=BodyRepTd valign=top><input class=BodyInp type=text name=e_age$line size=2 value=\"$age\"></td>";
		
	# Element: Gender
	echo "<td class=BodyRepTd><select class=BodyInp name=e_gender$line value=\"$gender\">
			<option value=\"\">
			<option value=\"M\"".($gender=="M" ? " SELECTED" : "").">".$l['male']." 
			<option value=\"F\"".($gender=="F" ? " SELECTED" : "").">".$l['female']." 
			</select></td>";

	# Element: Experience
	echo "<td class=BodyRepTd>";
			$query = "SELECT *, id_record,type$lang AS type
			FROM types_experience ORDER BY type$lang";
			$result = mysql_query($query) or die ($l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$flag=0;
				echo "<select class=BodyInp name=e_experience$line size=1>
						<option value=\"$experience\">";
				while ($r = mysql_fetch_array($result)) {
					echo "<option value=".$r['id_record'].($experience==$r['id_record'] ? " SELECTED" : "").">".$r['type'];
					if ($r['desc_type'.$lang]){$flag=1;}
				}
				echo "</select>";
				if ($flag==1){ 
					echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_experience','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
				}
			}else{
				# Nothing matched the query
				echo "<p class=BodyTxt>".$l['no_results']."</p>";
			}
	echo "</td>";

	# Element: Equipment
	echo "<td class=BodyRepTd>";
			$query = "SELECT * FROM types_equipment ORDER BY type$lang";
			$result = mysql_query($query) or die ($l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$flag=0;
				echo "<select class=BodyInp name=e_equipment$line size=1>
						<option value=\"$equipment\">";
				while ($r = mysql_fetch_array($result)) {
					echo "<option value=".$r['id_record'].($equipment==$r['id_record'] ? " SELECTED" : "").">".$r['type'.$lang];
					if ($r['desc_type'.$lang]){$flag=1;}
				}
				echo "</select>";
				if ($flag==1){ 
					echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_equipment','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
				}
			}else{
				# Nothing matched the query
				echo "<p class=BodyTxt>".$l['no_results']."</p>";
			}
	echo "</td>";

	# Element: Outcome
	echo "<td class=BodyRepTd>";
			$query = "
				SELECT *, id_record,
				type$lang AS type
				FROM types_outcome ORDER BY type$lang";
			$result = mysql_query($query) or die ($l['query_failed'].":$query");
			if (mysql_num_rows($result)) {
				$flag=0;
				echo "<select class=BodyInp name=e_outcome$line size=1>
						<option value=\"$outcome\">";
				while ($r = mysql_fetch_array($result)) {
					echo "<option value=".$r['id_record'].($outcome==$r['id_record'] ? " SELECTED" : "").">".$r['type'.$lang];
					if ($r['desc_type'.$lang]){$flag=1;}
				}
				echo "</select>";
				if ($flag==1){ 
					echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_outcome','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
				}
			}else{
				# Nothing matched the query
				echo "<p class=BodyTxt>".$l['no_results']."</p>";
			}
	echo "</td>";

	# Element: Condition
	echo "<td class=BodyRepTd>";
	$query = "
		SELECT *, id_record,
		type$lang AS type
		FROM types_condition ORDER BY type$lang";
	$result = mysql_query($query) or die ($l['query_failed'].":$query");
	if (mysql_num_rows($result)) {
		$flag=0;
		echo "<select class=BodyInp name=e_condition$line size=1>
				<option value=\"$condition\">";
		while ($r = mysql_fetch_array($result)) {
			echo "<option value=".$r['id_record'].($condition==$r['id_record'] ? " SELECTED" : "").">".$r['type'.$lang];
			if ($r['desc_type'.$lang]){$flag=1;}
		}
		echo "</select>";
		if ($flag==1){ 
			echo "<a class=BodyDescLink href=\"javascript:myopen('type_desc.php?table=types_condition','windowName','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=260')\">".$l['descriptions']."</a>";
		}
	}else{
		# Nothing matched the query
		echo "<p class=BodyTxt>".$l['no_results']."</p>";
	}
	echo "</td>";

	# Element: Training
	echo "<td class=BodyRepTd><select class=BodyInp name=e_training$line value=\"$training\">
			<option value=\"\">
			<option value=0".($training==0 ? " SELECTED" : "").">".$l['no']." 
			<option value=1".($training==1 ? " SELECTED" : "").">".$l['yes']." 
			</select></td>";

	echo "</tr>";
}

?>

</body>
