<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: team_edit.php
	# Version: 14 May 2004
	# Author: Calvin Martini
	# Description: This script provides editing of new and existing team records.

	session_start(); 

	# Set client variables
	$client_vars=array(
		'mode',
		's_id'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");
	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_members");
	if ( isset($s_id) ) { $team = $s_id; }

	# Check to ensure proper access level to edit record
	if (max($a_memb) < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	head("team_edit");

	echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/calendar/calendar.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/CallCalendar.js\"></SCRIPT>
			<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/add_days.js\"></SCRIPT>
			";

	# Intitialize form input values
	if ($mode == "update"||$mode=="display") {
		$query = "
			SELECT *, 
			DATE_FORMAT(when_entered,'%W %M %D, %Y %H:%i:%s') AS edit_time 
			FROM teams 
			WHERE id_record='$s_id'";
		$result = mysql_query($query) or die ($l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);
			$e_id_users=$r['id_users'];
			$e_when_entered=$r['edit_time'];
			$e_team_name=$r['team_name'];
			$e_team_address=$r['team_address'];
			$e_team_city=$r['team_city'];
			$e_team_pcode=$r['team_pcode'];
			$e_id_address_province=$r['id_address_province'];
			$e_date_established=$r['date_established'];
			$e_phone_home=$r['phone_1'];
			$e_phone_work=$r['phone_2'];
			$e_phone_pager=$r['phone_pager'];
			$e_phone_cell=$r['phone_cell'];
			$e_phone_fax=$r['phone_fax'];
			$e_email=$r['email'];
			$e_description=$r['description'];	
			$e_id_members=$r['id_members'];
			$e_flag_ops=$r['flag_ops'];
		}else{
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
		}
	}else{
		# This is a new record
		$e_date_established=date("Y-m-d");
	}

	if ($a_memb[$team] > 0 && $mode=="display"){
		echo "<table class=BodyInputTbl width=100% cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyInputTd align=left colspan=2><p class=BodyH2>";
		echo $l['display_team'];
		echo "</p>
				</td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['name']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_team_name</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['street']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_team_address</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['city']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_team_city</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['province']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>";
				$query = "SELECT * FROM types_province WHERE id_record='$e_id_address_province'";
				connect_db();
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
							echo $r['type'.$lang];
					}
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['postal_code']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_team_pcode</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['date_established']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_date_established</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['description']."</p></td>
				<td class=BodyInputTd><blockquote><p class=BodyInp>$e_description</p></blockquote></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['operational']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>" . ($e_flag_ops == 1 ? $l['yes'] : $l['no']) . "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_1']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_home</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_2']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_work</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_pager']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_pager</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_cell']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_cell</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_fax']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_phone_fax</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['email']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_email</p></td>
				</tr>";

		## Output last edited section
		$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$last_edit=$l['last_edited_by'];
			echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>
			<tr><td class=BodyInputTd colspan=2><p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p></td></tr>";
		}

		## End table
		echo "</table>";
	
	## EDIT MODE
	}elseif(($a_memb[$team] >=2 && $mode=="update") || (($a_memb[$team] == 128 || $a_admin == 1) && $mode=="new")){
		echo "<form method=GET action=team_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm><input type=hidden name=mode value=\"$mode\">
				".SIDHIDDEN."
				<input type=hidden name=mydate value=\"$e_date_established\">
				<input type=hidden name=myfield value=\"\">
				".($s_id ? "<input type=hidden name=s_id value=\"$s_id\">" : "")."
				<table class=BodyInputTbl width=100% cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH2>";
		if ($mode == "update"){
			echo $l['edit_team'];
		}elseif($mode == "new"){
			echo $l['new_team'];
		}	
		echo "</p></td></tr>
				<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['name']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_team_name size=75 value=\"$e_team_name\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['street']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_team_address size=50 value=\"$e_team_address\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['city']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_team_city size=50 value=\"$e_team_city\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['province']."</p></td>
				<td class=BodyInputTd>";
				$query = "SELECT * FROM types_province ORDER BY type$lang";
				connect_db();
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					echo "<select class=BodyInp name=e_id_address_province size=1>
							<option value=\"\">";
					while ($r = mysql_fetch_array($result)) {
							echo "<option value=".$r['id_record'].($e_id_address_province==$r['id_record'] ? " selected" : "").">".$r['type'.$lang];
					}
					echo "</select>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
		echo "</td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['postal_code']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_team_pcode size=7 value=\"$e_team_pcode\"></td>
				</tr>";

		list($year,$month,$day) = input_date(e_date,$e_date_established,60,1);		
		echo "<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['date_established']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$year $month $day<small><small>".$l['yyyy_mm_dd']."</small></small>
				<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
				OutputLink('e_date',0);
				//--></SCRIPT>
				</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['description']."</p></td>
				<td class=BodyInputTd><textarea class=BodyInp name=e_description cols=36 rows=4 onchange='document.MForm.desc_preview.value = document.MForm.e_description.value;'>$e_description</textarea></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['operational']."</p></td>
				<td class=BodyInputTd><input class=BodyInp class=BodyInp type=checkbox name=e_flag_ops value=1 " . ($e_flag_ops == "1" ? "checked" : "") . "></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_1']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_home size=20 value=\"$e_phone_home\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_2']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_work size=20 value=\"$e_phone_work\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_pager']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_pager size=20 value=\"$e_phone_pager\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_cell']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_cell size=20 value=\"$e_phone_cell\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['phone_fax']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_phone_fax size=20 value=\"$e_phone_fax\"></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['email']."</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_email size=40 value=\"$e_email\"></td>
				</tr>";
		echo "</table>
				<input class=BodyBut type=submit name=action value=".$l['save'].">
				".($mode=="update" && $a_admin ? "<input class=BodyBut type=submit name=action value=".$l['delete'].">" : "")."
				<input class=BodyBut type=reset value=".$l['reset'].">
				<input class=BodyBut type=submit name=action value=".$l['cancel'].">
				</form>";
		if ($mode=="update") {
				$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					$r = mysql_fetch_array($result);
					$last_edit=$l['last_edited_by'];
					echo "<p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p>";
				}
		}
			#	</table>";
	}
			
	foot();

?>