<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: tms_class_choose.php
	# Version: 24 April 2004
	# Author: Calvin Martini
	# Description: Select students for a class based on search criteria
	# Parameters:	e_mode			edit or add
	#					id_class			class record to add to or edit
	#					s_text			text to use as search criteria
	#					s_type			member or team
	#					target_field	field on parent form to use as target for output
		
	session_start(); 

	# Set client variables
	$client_vars=array(
		'e_mode',
		'e_students',
		's_id',
		's_text',
		's_type'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");

	# Test to ensure user is logged in
	if (isset($_SESSION["id_user"])==FALSE){
		fail_access($_SERVER['QUERY_STRING']);
	}

	connect_db();
	
	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_training");

	echo "<head>
		<TITLE>".$l['app_title']."</TITLE>
		<META name=\"description\" content=\"Operational contacts for The New Brunswick Ground Search and Rescue Association.\">
		<META name=\"keywords\" content=\"Search and Rescue, SAR, GSAR, volunteer, non-profit, association, New Brunswick, Canada\">
		<link rel=\"stylesheet\" href=\"./css.html\" type=\"text/css\">
		<body LANGUAGE=javascript onload=\"window.focus()\">";
	echo "</head>";

	if ($e_students){
		$data = explode(";",$e_students);
		$count=1;
		$e_exclude="";
		foreach ($data as $line){
			list($line_id[$count],$line_instructor[$count],$line_grade[$count]) = explode(",",$line);
			if ($line_id[$count]){$e_exclude.="($line_id[$count])";}
			$count++;
		}
	}
#echo"<B>DEBUG: count=$count, line_ic=".$line_id['count']."</b><br>";
	# Main Query: Set DB query
	if ($e_mode == "edit"){
		# e_mode = edit
		# Edit existing students for a given class
		if ($e_students){
				$query="SELECT members.id_record AS id_record,
					CONCAT(members.name_last,', ',members.name_first) AS full_name,
					'1' as attend,
					teams.team_name
					FROM members
					LEFT JOIN teams_members ON teams_members.id_members=members.id_record
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					WHERE '$e_exclude' LIKE CONCAT('%(',members.id_record,')%')
					ORDER BY members.name_last";
		}

	}else{
		# e_mode = add (assumed if blank)
		# Add records based on search criteria
		if ($s_type == "team"){
			$query="SELECT members.id_record AS id_record,
				CONCAT(members.name_last,', ',members.name_first) AS full_name,
				teams.team_name,
				attend_classes.instructor,
				IF(attend_classes.id_members IS NULL,'0','1') AS attend
				FROM teams_members
				LEFT JOIN members ON members.id_record=teams_members.id_members
				LEFT JOIN teams ON teams.id_record=teams_members.id_teams
				LEFT JOIN attend_classes ON attend_classes.id_members=members.id_record AND attend_classes.id_classes='$s_id'
				WHERE teams.team_name LIKE '%$s_text%'
				".($e_exclude ? "AND '$e_exclude' NOT LIKE CONCAT('%(',members.id_record,')%')" : "")."
				AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
				ORDER BY members.name_last";

#				AND attend_classes.id_members IS NULL

		}else{
			# s_type == member (assumed if blank)
			$query="SELECT members.id_record AS id_record,
				CONCAT(members.name_last,', ',members.name_first) AS full_name,
				teams.team_name,
				attend_classes.instructor,
				IF(attend_classes.id_members IS NULL,'0','1') AS attend
				FROM members
				LEFT JOIN attend_classes ON members.id_record=attend_classes.id_members AND attend_classes.id_classes='$s_id'
				LEFT JOIN teams_members ON teams_members.id_members=members.id_record
				LEFT JOIN teams ON teams.id_record=teams_members.id_teams
				WHERE CONCAT(members.name_first,' ',members.name_last) LIKE '%$s_text%'
				".($e_exclude ? "AND '$e_exclude' NOT LIKE CONCAT('%(',members.id_record,')%')" : "")."
				ORDER BY members.name_last";
		}	
	}
	echo "<SCRIPT LANGUAGE=\"JavaScript1.2\">
				function e_save(e_count) {
					// Adds checked students to list if not already present
					newDesc = window.opener.document.MForm.e_desc.value;
					newStudents = (window.opener.document.MForm.e_students.value ? window.opener.document.MForm.e_students.value : \"\");
					for (var i=0;i<e_count;i++) {
						myRE = new RegExp(eval(\"document.MForm2.e_id\" + i + \".value\") + \",\\d+,\\d+;\",'g');
						if (eval(\"document.MForm2.e_select\" + i + \".checked\")) {
								if (myRE.exec(newStudents)) {
								}else{
									if (eval(\"document.MForm2.e_iselect\" + i + \".checked\")) {
										newDesc = newDesc + eval(\"document.MForm2.e_name\" + i + \".value\") + \" \" + eval(\"document.MForm2.e_team\" + i + \".value\") + \" ".substr($l['yes'],0,1)."\" + \" \" + \" \" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \"\\n\";
										newStudents = newStudents + eval(\"document.MForm2.e_id\" + i + \".value\") + \",1,\" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \";\";
									}else{
										newDesc = newDesc + eval(\"document.MForm2.e_name\" + i + \".value\") + \" \" + eval(\"document.MForm2.e_team\" + i + \".value\") + \" ".substr($l['no'],0,1)."\" + \" \" + \" \" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \"\\n\";
										newStudents = newStudents + eval(\"document.MForm2.e_id\" + i + \".value\") + \",0,\" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \";\";
									}
								}
						} 
					}
					window.opener.document.MForm.e_desc.value = newDesc;
					window.opener.document.MForm.e_students.value = newStudents;
					window.opener.CloseWindow();
				}

				function e_save2(e_count) {
					// Rebuilds list based on checked/unchecked students
					newDesc = \"".str_pad($l['full_name'],20)." ".str_pad($l['team'],20)." I ".str_pad($l['grade'],10)."\\n==================== ==================== = ==========\\n\";
					var newStudents = \"\";
					for (var i=0;i<e_count;i++) {
						if (eval(\"document.MForm2.e_select\" + i + \".checked\")) {
							if (eval(\"document.MForm2.e_iselect\" + i + \".checked\")) {
								newDesc = newDesc + eval(\"document.MForm2.e_name\" + i + \".value\") + \" \" + eval(\"document.MForm2.e_team\" + i + \".value\") + \" ".substr($l['yes'],0,1)."\" + \" \" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \"\\n\";
								newStudents = newStudents + eval(\"document.MForm2.e_id\" + i + \".value\") + \",1,\" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \";\";
							}else{
								newDesc = newDesc + eval(\"document.MForm2.e_name\" + i + \".value\") + \" \" + eval(\"document.MForm2.e_team\" + i + \".value\") + \" ".substr($l['no'],0,1)."\" + \" \" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \"\\n\";
								newStudents = newStudents + eval(\"document.MForm2.e_id\" + i + \".value\") + \",0,\" + eval(\"document.MForm2.e_mark\" + i + \".value\") + \";\";
							}
						} 
					}
					window.opener.document.MForm.e_desc.value = newDesc;
					window.opener.document.MForm.e_students.value = newStudents;
					window.opener.CloseWindow();
				}

			</SCRIPT>";
			
#echo "e_students=$e_students<br>e_exclude=$e_exclude<br><br>";		
	echo "<form method=POST action=tms_class_choose_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm2>";
	echo "<p class=BodyH2>".$l['students']."</p>";
#echo "query=$query<br><br>";

	if($query){
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			echo "<table class=BodyRepTbl>
					<tr><td class=BodyRepTh><p class=BodyRepH2>".$l['select']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					".($s_type!="team" ? "<td class=BodyRepTh><p class=BodyRepH2>".$l['team']."</p></td>" : "")."
					<td class=BodyRepTh><p class=BodyRepH2>".$l['full_name']."&nbsp;&nbsp;&nbsp;&nbsp;</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['grade']."</p></td>
					<td class=BodyRepTh><p class=BodyRepH2>".$l['instructor']."</p></td></tr>";
			$count=0;
			while ($r = mysql_fetch_array($result)) {
				echo "<tr>
						<td class=BodyRepTd><input type=hidden name=e_id$count value='".$r['id_record']."'><input class=BodyChk type=checkbox name=e_select$count".($r['attend']==1 ? " checked" : "")."></td>
						".($s_type!="team" ? "<td class=BodyRepTd><p class=BodyInp>".$r['team_name']."</p></td>" : "")."
						<td class=BodyRepTd><p class=BodyInp><input type=hidden name=e_team$count value='".substr(str_pad($r['team_name'],20),0,20)."'><input type=hidden name=e_name$count value='".substr(str_pad($r['full_name'],20),0,20)."'>".$r['full_name']."</p></td>
						<td class=BodyRepTd><input class=BodyInp type=text name=e_mark$count size=3 value='";
				if ($r['grade']){
					echo $r['grade'];
				}elseif($e_exclude && is_array($line_id) && array_search($r['id_record'],$line_id)){
					$line_match = array_search($r['id_record'],$line_id);
					echo $line_grade[$line_match];
				}
				echo "'></td><td class=BodyRepTd>";

				if ($r['instructor']){
					echo "<input class=BodyChk type=checkbox name=e_iselect$count".($r['instructor']==1 ? " checked" : "").">";		
				}elseif(is_array($line_id)){
					$line_match = array_search($r['id_record'],$line_id);
					echo "<input class=BodyChk type=checkbox name=e_iselect$count".($line_instructor[$line_match]==1 ? " checked" : "").">";		
				}else{
					echo "<input class=BodyChk type=checkbox name=e_iselect$count>";		
				}
				echo "</td></tr>";
				$count++;
			}
			echo "</table>";
			echo "<input class=BodyBut type=button name=action value='".$l['save']."' onClick='e_save".($e_mode == "edit" ? "2" : "")."($count);'>";
			echo "<input class=BodyBut type=button name=action value='".$l['cancel']."' onClick='window.opener.CloseWindow();'>";
			echo "</form>";
		}else{
			# Nothing matched the query
			echo $l['no_results'];
			echo "<br><br><input class=BodyBut type=button name=action value='".$l['cancel']."' onClick='window.opener.CloseWindow();'>";
		}
	}else{
			# Nothing matched the query
			echo $l['no_results'];
			echo "<br><br><input class=BodyBut type=button name=action value='".$l['cancel']."' onClick='window.opener.CloseWindow();'>";
	}

?>

</body>
