<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: tms_class_edit.php
	# Version: 10 September 2004
	# Author: Calvin Martini
	# Description: This script provides editing of new and existing class records.

	session_start(); 

	# Set client variables
	$client_vars=array(
		's_id',
		'module',
		'mode',
		'e_province',
		'e_team',
		'team'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");

	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_training");

	# Check to ensure proper access level to edit record
	if ( max($a_train) < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	# Intitialize form input values for existing records
	if ($mode == "update" || $mode == "display") {

		# Read class data
		$query = "SELECT 
					classes.id_record,
					classes.id_module,
					classes.location,
					classes.id_province,
					classes.id_teams,
					classes.when_start,
					classes.when_end,
					courses.id_record as course,
					courses.title$lang AS course_name,
					IF(classes.id_province=9999,'".$l['all']."',types_province.type$lang) AS province_name,
					IF(courses.id_teams=9999,'".$l['all']."',teams.team_name) AS team_name,
					courses.id_teams as course_team,
					courses.id_province as course_province,
					courses.id_certifications,
					modules.title$lang AS module_name,
					modules.id_record as module,
					modules.id_course,
					modules.type,
					modules.pass
					FROM classes
					LEFT JOIN modules ON classes.id_module=modules.id_record
					LEFT JOIN courses ON modules.id_course=courses.id_record
					LEFT JOIN teams ON teams.id_record=courses.id_teams
					LEFT JOIN types_province ON types_province.id_record=classes.id_province
					WHERE classes.id_record='$s_id'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);

			# Fields from classes
			$e_record=$r['id_record'];
			$e_id_module=$r['id_module'];
			$e_location=$r['location'];
			$e_province=$r['id_province'];
			$e_province_name=$r['province_name'];
			$e_team=$r['id_teams'];
			$e_team_name=$r['team_name'];
			list($e_d_start,$e_t_start)=split(" ",$r['when_start']); $e_t_start=substr($e_t_start,0,5);
			list($e_d_end,$e_t_end)=split(" ",$r['when_end']); $e_t_end=substr($e_t_end,0,5);
	
			# Fields from courses
			$e_id_course=$r['course'];
			$e_course_province=$r['course_province'];
			$e_id_teams=$r['id_teams'];
			$e_course_team=$r['course_team'];
			$e_course_name=$r['course_name'];
			$e_course_team_name=$r['team_name'];

			# Fields from modules
			$e_module_name=$r['module_name'];
			$e_module=$r['module'];
			$e_module_type=$r['type'];
			$e_module_pass=$r['pass'];

		}else{
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
		}
		
	}else{
		# New Class Record
		$query = "SELECT 
					courses.id_record as course,
					courses.title$lang AS course_name,
					IF(courses.id_province=9999,'".$l['all']."',types_province.type$lang) AS province_name,
					IF(courses.id_teams=9999,'".$l['all']."',teams.team_name) AS team_name,
					courses.id_teams as course_team,
					courses.id_province as course_province,
					courses.id_certifications,
					modules.title$lang AS module_name,
					modules.id_record as module,
					modules.id_course,
					modules.type,
					modules.pass
					FROM modules
					LEFT JOIN courses ON modules.id_course=courses.id_record
					LEFT JOIN teams ON teams.id_record=courses.id_teams
					LEFT JOIN types_province ON types_province.id_record=courses.id_province
					WHERE modules.id_record='$module'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);
	
			# Fields from courses
			$e_id_course=$r['course'];
			$e_course_province=$r['course_province'];
			$e_id_teams=$r['id_teams'];
			$e_course_team=$r['course_team'];
			$e_course_team_name=$r['team_name'];
			$e_course_name=$r['course_name'];

			# Fields from modules
			$e_module_name=$r['module_name'];
			$e_module=$r['module'];
			$e_module_type=$r['type'];
			$e_module_pass=$r['pass'];
			
			# Fields from classes
			$e_id_module=$r['module'];
			if($e_course_province!=9999 && !$e_province){$e_province=$e_course_province;}
			if($e_course_team!=9999 && !$e_team){$e_team=$e_course_team;}
			if($e_province==9999){$e_team=9999;}
			
			$e_desc=str_pad($l['full_name'],20)." ".str_pad($l['team'],20)." ".substr($l['instructor'],0,1)." ".str_pad($l['grade'],10)."\n";
			$e_desc.="==================== ==================== = ==========\n";
			if ($a_team>0){$e_team=$a_team;}
			
		}else{
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
		}
	}

	head("tms_class_edit");
	
	if (($mode == "new" && max($a_train) >= 2) || ($mode == "update" && max($a_train) >=2) ||($mode != "display" && $e_team==9999 && $a_all_teams==1)){

		echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/calendar/calendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\">
					function callSelect(e_mode,id_class,s_text,s_type,e_students) {
						// Function: opens a student selection window for a given class/team/student
						// e_mode			edit or add
						// id_class			class record to add to or edit
						// s_text			text to use as search criteria
						// s_type			member or team
						// e_students		value of e_students
						myopen('tms_class_choose.php?e_mode=' + escape(e_mode) + '&id_class=' + escape(id_class) + '&s_text=' + escape(s_text) + '&s_type=' + escape(s_type) + '&e_students=' + escape(e_students),'windowName', 'toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=400,height=400');
					}
					
				</SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/CallCalendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/add_days.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/CallWindow.js\"></SCRIPT>
				";


		echo "<form method=POST action=tms_class_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm>
				".SIDHIDDEN."
				<input type=hidden name=mode value=\"$mode\">
				<input type=hidden name=mydate value=\"\">
				<input type=hidden name=myfield value=\"\">
				<input type=hidden name=s_id value=\"$s_id\">
				<input type=hidden name=e_module value=\"$e_module\">
				<table class=BodyInputTbl width=100% border=0>
				<table class=BodyInputTbl width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyInputTd class=normal align=left colspan=2><h2 class=normal>
				".($mode == "update" ? $l['edit_class'] : $l['new_class'])."
				</h2></td></tr>
				<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>1. ".$l['class']."</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['course']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_course_name</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['module']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_module_name</p></td>
				</tr>";
#echo "<tr><td class=BodyInputTd>$e_province,$a_prov,$mode</td></tr>";
		/* Start: Province Selection */
		if ($mode =="new" && !$e_province && $a_prov == 9999){
			# User is authorized for all provinces, display province selection list
			$query = "SELECT id_record, type$lang AS province FROM types_province";
			$result = mysql_query($query) or die ($l['query_failed']);
			if (mysql_num_rows($result)) { 
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
						<td class=BodyInputTd>
						<select class=BodyInp name=e_province value='$e_province' onchange=\"self.location.href='$PHP_SELF'+ self.location.search + '&e_province=' + this.options[this.selectedIndex].value\">
						<option value=\"\">
						<option value=9999>".$l['all']."\n";
				while ($r = mysql_fetch_array($result)) {
					echo "<option value=\"".$r['id_record']."\">".substr($r['province'],0,20)."\n";
				}
				echo "</select></td></tr>";
			}
			echo "</table></form>";
		}else{
			# Province is selected or only one is allowed
			if (!$e_province){
				$e_province = $a_prov;
			}
			echo 	"<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>";
			if ($e_province == 9999){
				echo "<td class=BodyInputTd><p class=BodyInpH>".$l['all']."</p></td></tr>";
			}else{
				$query = "SELECT id_record, type$lang AS province FROM types_province WHERE id_record='$e_province'";
				$result = mysql_query($query) or die ($l['query_failed']);
				if (mysql_num_rows($result)) {
					$r = mysql_fetch_array($result);
					echo "<td class=BodyInputTd><p class=BodyInp><input type=hidden name=e_province value=\"$e_province\">".$r['province']."</p></td></tr>";
				}
			}

			# Select Team
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['team']."</p></tr>
					<td class=BodyInputTd>";

			/* Start: Team */
			if (!$e_team){
				# Team has not been defined. Select.
				$query = "SELECT 
					teams.id_record,
					teams.team_name,
					if(teams_members.id_teams=teams.id_record,\"selected\",\"\") AS selected
					FROM teams 
					LEFT JOIN teams_members ON teams.id_record=teams_members.id_teams AND teams_members.id_members='$s_id'
					".($a_all_teams!=1 ? "LEFT JOIN team_access ON team_access.id_teams=teams.id_record AND team_access.id_users='$id_recno' WHERE team_access.access_members>=2" : "WHERE 1=1")."
					AND teams.id_address_province='$e_province'
					ORDER BY team_name";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					if (mysql_num_rows($result) == 1){
						$r = mysql_fetch_array($result);
						echo "<input type=hidden name=e_team value=\"".$r['id_record']."\">".$r['team_name']; 
					}else{
						echo "<select class=BodyInp name=e_team onchange=\"self.location.href='$PHP_SELF'+ self.location.search + '&e_province=$e_province&e_team=' + this.options[this.selectedIndex].value\">
								<option>
								<option value=9999>".$l['all'];
						while ($r = mysql_fetch_array($result)) {
							echo "<option value=".$r['id_record']." ".($r['id_record']==$e_team ?"selected" : "").">".$r['team_name'];
						}
						echo "</select>";
					}
				}
				echo "</td></tr>";
				echo "</table></form>";
			}else{
				$query = "SELECT teams.team_name
					FROM teams 
					WHERE teams.id_record='$e_team'";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				$r = mysql_fetch_array($result);
				echo "<p class=BodyInp><input type=hidden name=e_team value=\"$e_team\">".($e_team==9999 ? $l['all'] : $r['team_name'])."</p></td></tr>
						<tr>
						<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['location']."</p></td>
						<td class=BodyInputTd><input class=BodyInp type=text name=e_location size=20 value=\"$e_location\"></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_start,$e_d_start,10,0);		
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['time_start']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<small><small>".$l['yyyy_mm_dd']."</small></small>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_start size=5 value=\"$e_t_start\"><font class=BodyExTxt>hh:mm (24 hr)</font>
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_d_start',0);
						//--></SCRIPT>
						</p></td>
						</tr>";
				list($year,$month,$day) = input_date(e_d_end,$e_d_end,10,0);		
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['time_end']."</p></td>
						<td class=BodyInputTd><p class=BodyInp>$year $month $day<font class=BodyExTxt>".$l['yyyy_mm_dd']."</font>&nbsp;&nbsp;<input class=BodyInp type=text name=e_t_end size=5 value=\"$e_t_end\"><font class=BodyExTxt>hh:mm (24 hr)</font>
						<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--
						OutputLink('e_d_end',0);
						//--></SCRIPT>
						</p></td>
						</tr>";

				### Subsection : Students
				echo "<form method=POST action=tms_class_save.php>
						".SIDHIDDEN."
						<input type=hidden name=s_id value=\"$s_id\">
						<input type=hidden name=mode value=\"$mode\">";
				echo "<tr><td class=BodyInputTd colspan=2><br><p class=BodyH3>2. ".$l['students']."</p><td class=BodyInputTd></tr>
						</tr>";

				# Student display and pick list/search interface
				/* Start: Student Interface */
				if ($e_team && $e_team!=9999){
					# A specific team is defined. Use team members to add students
					$query="SELECT members.id_record as member, 
								CONCAT(members.name_last,', ',members.name_first) AS full_name,
								attend_classes.instructor,
								attend_classes.grade,
								attend_classes.id_classes as attend_class
								FROM members 
								LEFT JOIN teams_members ON teams_members.id_members=members.id_record
								LEFT JOIN attend_classes ON attend_classes.id_members=members.id_record AND attend_classes.id_classes='$s_id'
								WHERE teams_members.id_teams='$e_team'
								AND (members.flag_inactive='0' OR members.flag_inactive IS NULL)
								ORDER BY full_name";

					$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
					if (mysql_num_rows($result)) { 
						echo "<tr>
								<td class=BodyInputTd colspan=2>
								<table class=BodyInputTbl>
								<tr>
								<td class=BodyInputTd><p class=BodyH3>".$l['select']."&nbsp;&nbsp;</p></td>
								<td class=BodyInputTd><p class=BodyH3>".$l['full_name']."</p></td>
								<td class=BodyInputTd><p class=BodyH3>".$l['grade']."</p></td>
								<td class=BodyInputTd><p class=BodyH3>".$l['instructor']."</p></td>
								</tr>";
						$count=1;
						while ($r = mysql_fetch_array($result)) {
							echo "<tr>
									<td class=BodyInputTd><input type=hidden name=e_count[$count] value=\"$count\"><input type=hidden name=e_id[$count] value=\"".$r['member']."\"><input type=checkbox name=e_select[$count] value=1 ".($r['attend_class']==$s_id ? "checked" : "")."></td>
									<td class=BodyInputTd><p class=BodyInp>".$r['full_name']."</p></td>
									<td class=BodyInputTd><input class=BodyInp type=text name=e_mark[$count] size=3 value=\"".$r['grade']."\"></td>
									<td class=BodyInputTd><input type=checkbox name=e_iselect[$count] value=1 ".($r['instructor']=="1" ? "checked" : "")."></td>
									</tr>";
							$count++;
						}
						echo "</table>
								</td></tr>";
					}
				}else{
					# A specific team is not defined. Use search interface to add students.

					# Student data
					$query2="SELECT members.id_record as member, 
						CONCAT(members.name_last,', ',members.name_first) AS full_name,
						teams.team_name,
						attend_classes.grade,
						attend_classes.instructor,
						attend_classes.id_record as class
						FROM attend_classes 
						LEFT JOIN members ON members.id_record=attend_classes.id_members
						LEFT JOIN teams_members ON teams_members.id_members=members.id_record
						LEFT JOIN teams ON teams.id_record=teams_members.id_teams
						WHERE attend_classes.id_classes='$s_id'";

					$result2 = mysql_query($query2) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query2");
					if (mysql_num_rows($result2)) {
						$e_desc=str_pad($l['full_name'],20)." ".str_pad($l['team'],20)." ".substr($l['instructor'],0,1)." ".str_pad($l['grade'],10)."\n";
						$e_desc.="==================== ==================== = ==========\n";
						while ($r2 = mysql_fetch_array($result2)) {
							$e_students.=$r2['member'].",".$r2['instructor'].",".$r2['grade'].";";
							$e_desc.= substr(str_pad($r2['full_name'],20),0,20)." ".substr(str_pad($r2['team_name'],20),0,20)." ".($r2['instructor']==1 ? substr($l['yes'],0,1) : substr($l['no'],0,1))." ".substr(str_pad($r2['grade'],10),0,10)."\n";
						}
					}

					echo "<tr><td class=BodyInputTd colspan=2><input type=hidden name=e_students value=\"$e_students\"><textarea name=e_desc cols=60 rows=10 readonly>$e_desc</textarea></td></tr>
							<tr><td class=BodyInputTd colspan=2>
							<table class=BodyInputTbl>
							<tr><td class=BodyInputTd colspan=3>
							<input class=BodyBut type=button value=\"".$l['edit']."\" onClick=\"javascript:callSelect('edit','$e_record','','',document.MForm.e_students.value)\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
							</td></tr>
							<tr><td class=BodyInputTd>".$l['add']."<input  class=BodyInp type=text name=ce_search size=15>".$l['category']."&nbsp;<select class=BodyInp name=ce_search_scope>&nbsp;";
					if (max($a_train) != 0) {
						echo "<option value=student".($ce_search_scope == "student" ? " selected" : "") .">".substr($l['students'],0,20)."
								<option value=team".($ce_search_scope == "team" ? " selected" : "") .">".substr($l['teams'],0,20)."\n";
					}
					echo "</select>";
					echo "</td><td class=BodyInputTd><input class=BodyBut type=button value=\"".$l['search']."\" onClick=\"javascript:callSelect('add','$e_record',document.MForm.ce_search.value,document.MForm.ce_search_scope.options[document.MForm.ce_search_scope.selectedIndex].value,document.MForm.e_students.value)\">";
					echo "</td><td></td></table></td></tr>";

				} /* End: Student Interface */
			
				echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>";
				echo "<tr>
						</table>
						<input class=BodyBut type=submit name=action value=".$l['save'].">
						".($mode=="update" && $a_train[$e_team]>=4 ? "<input class=BodyBut type=submit name=action value=\"".$l['delete']."\">" : "")."
						".($a_train[$e_team]>=2 ? "<input class=BodyBut type=submit name=action value=\"".$l['copy']."\">" : "")."
						<input class=BodyBut type=reset value=".$l['reset'].">
						<input class=BodyBut type=submit name=action value=".$l['cancel'].">
						</form>";

	/*			if ($mode=="update") {
					$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
					$result = mysql_query($query) or die ($l['query_failed'].":$query");
					if (mysql_num_rows($result)) {
						$r = mysql_fetch_array($result);
						$last_edit=$l['last_edited_by'];
						echo "<p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p>";
					}
				}
	*/

			} /* End: Team */

		} /* End: Province Defined */

	}elseif($mode=="display"){

	############ DISPLAY MODE ##############
	### SECTION: Main Table Body
		echo "<table class=BodyInputTbl width=100% border=0>
				<table class=BodyInputTbl width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyInputTd class=normal align=left colspan=2><h2 class=normal>".($a_search[$team] == 1 ? $l['display_search_report'] : $l['edit_search_report'])."</h2></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>1. ".$l['display_class']."</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['course']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_course_name</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['module']."</td>
				<td class=BodyInputTd><p class=BodyInp>$e_module_name</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_province_name</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['team']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_team_name</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['location']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_location</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['time_start']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_d_start $e_t_start</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['time_end']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>$e_d_end $e_t_end</p></td>
				</tr>";

	#### SECTION: Students			
		echo "<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>2. ".$l['students']."</p></td>
				</tr>";
				$query="SELECT attend_classes.id_record,
					CONCAT(members.name_last,', ',members.name_first) AS full_name,
					teams.team_name,
					attend_classes.grade
					FROM attend_classes
					LEFT JOIN members ON members.id_record=attend_classes.id_members
					LEFT JOIN teams_members ON teams_members.id_members=members.id_record
					LEFT JOIN teams ON teams.id_record=teams_members.id_teams
					WHERE attend_classes.id_classes='$s_id'
					GROUP BY attend_classes.id_record
					ORDER BY members.name_last";
				$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					echo "<tr><td class=BodyInputTd colspan=2><table class=BodyInputTbl>
							<tr>
							".($e_team == 9999 ? "<td class=BodyInputTd><p class=BodyH3>".$l['team']."</p></td>":"")."
							<td class=BodyInputTd><p class=BodyH3>".$l['full_name']."</p></td>
							<td class=BodyInputTd><p class=BodyH3>".$l['grade']."</p></td>
							<td class=BodyInputTd></td>
							</tr>";
					while ($r = mysql_fetch_array($result)) {
							echo "<tr>
							".($e_team == 9999 ? "<td class=BodyInputTd><p class=BodyInp>".$r['team_name']."</p></td>" : "")."
							<td class=BodyInputTd><p class=BodyInp>".$r['full_name']."</p></td>
							<td class=BodyInputTd><p class=BodyInp>".$r['grade']."</p></td>
							</tr>";
					}
					echo "</table></td></tr>";
				}else{
					# Nothing matched the query
					echo "<tr><td class=BodyInputTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td></tr>";
				}

		### Last Edited By
		$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$last_edit=$l['last_edited_by'];
			echo "<tr><td class=BodyInputTd colspan=2><hr><p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p></td></tr>";
		}

		### End of table	
		echo "</table>";

	}

	foot();

?>