<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: tms_course_edit.php
	# Version: 27 May 2004
	# Author: Calvin Martini
	# Description: This script provides editing of new and existing courses.

	session_start(); 

	# Set client variables
	$client_vars=array(
		'e_certification',
		'e_id_teams',
		'e_id_users',
		'e_mtitle1',
		'e_mtitle2',
		'e_mtitle3',
		'e_mtitle4',
		'e_mtitle5',
		'e_pass_mark',
		'e_title1',
		'e_title2',
		'e_title3',
		'e_title4',
		'e_title5',
		'e_when_entered',
		'mode',
		'p_id',
		's_id',
		't_id'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");
	require("lib_js.php");

	connect_db();

	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_training");

	# Check to ensure proper access level to edit record
	if ( max($a_train) < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	# Set up type array
	$c_type[]=$l['practical'];
	$c_type[]=$l['theoretical'];
	$c_type[]=$l['mixed'];
	$c_type[]=$l['test'];

	# Intitialize form input values for existing records
	if ($mode == "update" || $mode == "display") {

		# Read data
		$query = "SELECT 
					teams.team_name AS team_name,
					courses.id_record,
					courses.id_teams,
					DATE_FORMAT(courses.when_entered,'%W %M %D, %Y %H:%i:%s') AS edit_time,
					courses.id_certifications AS id_certifications,
					courses.id_users as user,
					courses.title1,
					courses.title2,
					courses.title3,
					courses.title4,
					courses.title5,
					courses.id_province
					FROM courses
					LEFT JOIN teams ON teams.id_record=courses.id_teams
					WHERE courses.id_record='$s_id'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r=mysql_fetch_array($result);
			$id_course=$r['id_record'];
			$e_team_name=$r['team_name'];
			$p_id=$r['id_province'];
			$e_id_users=$r['user'];
			$e_title1=$r['title1'];
			$e_title2=$r['title2'];
			$e_title3=$r['title3'];
			$e_title4=$r['title4'];
			$e_title5=$r['title5'];
			$e_when_entered=$r['edit_time'];
			$e_certification=$r['id_certifications'];
			$e_id_teams=$r['id_teams'];
		}else{
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
		}
		
	}

	head("tms_course_edit");
	
	if (($mode == "new" && max($a_train) >= 2) || ($mode == "update" && $a_train[$e_id_teams] >=2) || ($mode == "update" && $a_all_teams==1 && ($a_prov==$p_id || $a_prov ==9999))){

		echo "<SCRIPT LANGUAGE=\"JavaScript\">
					function validateSave() {
					//	if (document.MForm.e_id_teams.options[document.MForm.e_id_teams.selectedIndex].value == 0){
					//		alert(\"".$l['choose_team_first']."\");
					//	}else{
							if (";
		for ($x = 1; $x <= $maxLang; $x++){
			echo "document.MForm.e_title$x.value == ''";
			if ($x < $maxLang){ echo " || ";}
		}
		echo "){
								alert(\"".$l['enter_titles']."\");
							}else{
								document.MForm.submit(); 
							}
					//	}
					}
				</SCRIPT>";

		if ($a_province == -1){
			# If user has access to all provinces, include javascript to update teams list based on province selection
			echo "<SCRIPT LANGUAGE=\"JavaScript\">";
			team_js("",1,0);
			echo "</SCRIPT>";
		}

		echo "<form method=POST action=tms_course_save.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm>
				".SIDHIDDEN."
				<input type=hidden name=mode value=\"$mode\">
				<input type=hidden name=e_id_users=\"$e_id_users\">
				<input type=hidden name=s_id value=\"$s_id\">
				<input type=hidden name=t_id value=\"$t_id\">
				<table class=BodyInputTbl width=100%>
				<table class=BodyInputTbl width=100% cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyInputTd align=left colspan=2><p class=BodyH2>
				".($mode == "update" ? $l['edit_course'] : $l['new_course'])."
				</p></td></tr>
				<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>1. ".$l['course']."</p></td>
				</tr>";
		
		if ($a_province == -1){
			# User is authorized for all provinces, display province selection list
			$query2 = "SELECT id_record, type$lang AS province FROM types_province ORDER BY province";
			$result2 = mysql_query($query2) or die ($l['query_failed']);
			if (mysql_num_rows($result2)) { 
				echo "<tr>
						<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
						<td class=BodyInputTd>
						<select class=BodyInp name=p_id value=\"".$r['id_province']."\" onchange=\"PopulateTeams(MForm.p_id,MForm.e_id_teams,1);\">
						<option value=\"\">
						<option value=\"9999\"".($r['id_province']==9999 ? " selected" : "").">".$l['all'];
				while ($r2 = mysql_fetch_array($result2)) {
					echo "<option value=\"".$r2['id_record']."\"".($r['id_province']==$r2['id_record'] ? " selected" : "").">".substr($r2[province],0,20)."\n";
				}
				echo "</select></td></tr>";
			}
		}else{
		# User has access to one province
			echo "<tr>
					<td class=BodyInputTd><p class=BodyInpH>".$l['province']."</p></td>
					<td class=BodyInputTd><p class=BodyInp><input class=BodyInp type=hidden name=p_id size=20 value=\"$a_province\">".$a_provName[$lang]."</p></td>
					</tr>";
		}

		# Select list for team
		echo "<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['team']."</p></td>
				<td class=BodyInputTd>";

		# Display team select based on access
		if ($a_team == -1 && $a_province == -1){
			# User has access to all province and all teams
			if ($r['id_province'] && $r['id_province'] != 9999){
				$query3 = "SELECT teams.id_record, teams.team_name
					FROM teams
					WHERE id_address_province='".$r['id_province']."'
					ORDER BY team_name";
				$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
				if (mysql_num_rows($result3)) {
					echo "<select class=BodyInp name=e_id_teams size=1 value=\"$e_id_teams\">
							<option value=\"0\">".$l['none']."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
							<option value=\"9999\"".($r['id_teams']==9999 ? " selected" : "").">".$l['all'];
					while ($r3 = mysql_fetch_array($result3)) {
							echo "<option value=".$r3['id_record']."".($r3['id_record']==$e_id_teams ? " selected" : "").">".$r3['team_name'];
					}
					echo "</select>";
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
			}else{
				$o_string="<option>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>";
				echo "<select class=BodyInp name=e_id_teams value=\"$e_id_teams\"><option value=\"9999\"".($e_id_teams==9999 ? " selected>".$l['all'] : ">".$l['all']."<option value=\$e_id_teams\" selected>$team").$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string.$o_string."</select>";
			}
		}elseif($a_team == -1 && $a_province >0){
			# User has access to one province and all teams in that province
			$query3 = "SELECT teams.id_record, teams.team_name
				FROM teams
				WHERE id_address_province='$a_province'
				ORDER BY team_name";
			$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
			if (mysql_num_rows($result3)) {
				echo "<select class=BodyInp name=e_id_teams size=1 value=\"$e_id_teams\">
						<option value=\"0\">".$l['none']."
						<option value=\"9999\"".($e_id_teams==9999 ? " selected" : "").">".$l['all'];
				while ($r3 = mysql_fetch_array($result3)) {
						echo "<option value=".$r3['id_record'].($r3['id_record']==$e_id_teams ? " selected" : "").">".$r3['team_name'];
				}
				echo "</select>";
			}else{
				# Nothing matched the query
				echo "<p class=BodyTxt>".$l['no_results']."</p>";
			}
		}elseif($a_team >0){
			# User has single team access
			echo "<input class=BodyInp type=hidden name=e_id_teams value=\"$a_team\"><p class=BodyTxt>$a_team_name</p>";
		}else{
			# User can access two or more teams
			$query3 = "SELECT teams.id_record, teams.team_name
				FROM teams
				LEFT JOIN team_access ON team_access.id_teams=teams.id_record  
				WHERE team_access.access_members>=2 AND team_access.id_users='$id_recno'
				GROUP BY teams.id_record
				ORDER BY team_name";
			$result3 = mysql_query($query3) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query3");
			if (mysql_num_rows($result3)) {
				echo "<select class=BodyInp name=e_id_teams size=1>
						<option value=\"0\">".$l['none'];
				while ($r3 = mysql_fetch_array($result3)) {
						echo "<option value=".$r3['id_record'].($r3['id_record']==$e_id_teams ? " selected" : "").">".$r3['team_name'];
				}
				echo "</select>";
			}else{
				# Nothing matched the query
				echo "<p class=BodyTxt>".$l['no_results']."</p>";
			}
		}

		echo "</td>
				</tr>";					

		for ($x = 1; $x <= $maxLang; $x++){
			$myVar = "e_title$x";
			echo "<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['title']." (".$l['lang'.$x].")</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_title$x size=20 value=\"".$$myVar."\"></td>
				</tr>";
		}

		echo "<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['certification']." (".$l['optional'].")</p></td>
				<td class=BodyInputTd>";
		$query = "
			SELECT *, types_certifications.type$lang AS type,
			types_certifications.expires as expires,
			types_certifications.id_record AS id_record 
			FROM types_certifications
			LEFT JOIN teams ON teams.id_record=types_certifications.id_teams
			LEFT JOIN team_access ON team_access.id_teams=types_certifications.id_teams
			WHERE ".($a_all_teams == 0 ? "team_access.id_users='$id_recno' AND (types_certifications.id_teams='$e_id_teams')" : "1=1" )."
			OR (
				(types_certifications.id_teams=9999 AND types_certifications.id_province='$p_id')
				OR (types_certifications.id_teams=9999 AND types_certifications.id_province=9999)
			)
			GROUP BY types_certifications.id_record
			ORDER BY types_certifications.type$lang";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$flag=0;
			echo "<select class=BodyInp name=e_certification size=1>
					<option value=\"0\">".$l['none'];
			while ($r = mysql_fetch_array($result)) {
				echo "<option value='".$r['id_record']."' ".($e_certification==$r['id_record'] || mysql_num_rows($result)==1 ? " selected" : "").">".$r['type'];
				if ($r['desc_type'.$lang]){$flag=1;}
			}
			echo "</select>";
		}else{
			# Nothing matched the query
			echo "<p class=BodyTxt>".$l['no_results']."</p>";
		}
		echo "</td>
				</tr>";

		#### SECTION: Modules		
		echo "<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>2. ".$l['modules']."</p></td>
				</tr>
				<tr>";
		$query = "
			SELECT modules.id_record AS id_record,
			modules.type,
			modules.pass,
			modules.title1,
			modules.title2,
			modules.title3,
			modules.title4,
			modules.title5
			FROM modules
			WHERE modules.id_course='$s_id'
			";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			echo "<td class=BodyInputTd colspan=2><table cellspacing=2 cellpadding=10>
					<tr>";
					if ($a_train[$e_id_teams] >= 2 || ($e_id_teams == 9999 && ($a_prov==$p_id || $a_prov ==9999))){
						echo "<td class=BodyInputTd><p class=BodyH3>".$l['edit']."</p></td>";
					}elseif ($a_train[$e_id_teams] == 1){
						echo "<td class=BodyInputTd><p class=BodyH3>".$l['display']."</p></td>";
					}
					if ($a_train[$e_id_teams] >= 4 || ($e_id_teams == 9999 && ($a_prov==$p_id || $a_prov ==9999))){
						echo "<td class=BodyInputTd><p class=BodyH3>".$l['delete']."</p></td>";
					}
			echo "<td class=BodyInputTd><p class=BodyH3>".$l['type']."</p></td>";
			for ($x = 1; $x <= $maxLang; $x++){
				echo"<td class=BodyInputTd><p class=BodyH3>".$l['title']." (".$l['lang'.$x].")</p></td>";
			}
			echo "<td class=BodyInputTd><p class=BodyH3>".$l['pass_mark']." (%)</p></td>
					<td class=BodyInputTd></td>
					</tr>";
			while ($r = mysql_fetch_array($result)) {
					echo "<tr>";
					if ($a_train[$e_id_teams] >= 2 || ($a_all_teams==1 && $a_train[1] >= 2 )||($mode == "new" && max($a_train) >= 2 )){
						echo "<td class=BodyInputTd><a class=BodyLink href=\"tms_module_edit.php?mode1=$mode&course=$s_id&p_id=$p_id&t_id=$e_id_teams&mode=update&s_id=".$r['id_record'].SIDAND."\">E</a></td>";
					}elseif ($a_train[$e_id_teams] == 1 || ($a_all_teams==1 && $a_train[1] == 1 ) ||($mode == "new" && max($a_train) == 1 )){
						echo "<td class=BodyInputTd><a class=BodyLink href=\"tms_module_edit.php?mode1=$mode&course=$s_id&p_id=$p_id&t_id=$e_id_teams&mode=display&s_id=".$r['id_record'].SIDAND."\">D</a></td>";
					}
					if ($a_train[$e_id_teams] >= 4 || ($a_all_teams==1 && $a_train[1] >= 4 ) ||($mode == "new" && max($a_train) >= 4 )){
						echo "<td class=BodyInputTd><a class=BodyLink href=\"tms_course_save.php?mode=$mode&action=".$l['delete_selected']."&p_id=$p_id&t_id=$e_id_teams&s_id=$s_id&module=".$r['id_record']."&e_id_teams=$e_id_teams&module_name=".$r['title'].SIDAND."\">X</a></td>";
					}
					$c_type_id=$r['type']; 
					echo "<td class=BodyInputTd><p class=BodyInp>$c_type[$c_type_id]</p></td>";
					for ($x = 1; $x <= $maxLang; $x++){
						echo "<td class=BodyInputTd><p class=BodyInp>".$r['title'.$x]."</p></td>";
					}
					echo "<td class=BodyInputTd><p class=BodyInp>".$r['pass']."</p></td>
						</tr>";
			}
			echo "</table>";
		}else{
			# Nothing matched the query
			echo "<td class=BodyInputTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td>";
		}
		echo "</tr>";

		### Subsection : Add Modules
#		echo "<form method=POST action=display.php>
#				".SIDHIDDEN."
#				<input type=hidden name=t_id value=\"$t_id\">
#				<input type=hidden name=s_id value=\"$s_id\">
#				<input type=hidden name=mode value=\"$mode\">";
		echo "<tr><td class=BodyInputTd colspan=2><p class=BodyH3>".$l['add_module']."</p></td></tr>";
		for ($x = 1; $x <= $maxLang; $x++){
			$myVar = "e_mtitle$x";
			echo "<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['title']." (".$l['lang'.$x].")</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_mtitle$x size=20 value=\"".$$myVar."\"></td>
				</tr>";
		}

		# Element: Type
		echo "<tr><td class=BodyInputTd><p class=BodyInpH>".$l['type']."</p></td>
				<td class=BodyInputTd><select class=BodyInp name=e_type value=\"\">
				<option value=0>".$l['practical']." 
				<option value=1>".$l['theoretical']." 
				<option value=2>".$l['mixed']." 
				<option value=3>".$l['test']." 
				</select></td></tr>";

		# Element: Grade
		echo "<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['pass_mark']." (".$l['test']." %)</p></td>
				<td class=BodyInputTd><input class=BodyInp type=text name=e_pass_mark size=20 value=\"$e_pass_mark\"></p></td>
				</tr>";

		# Add Column	
		echo "<tr><td class=BodyInputTd colspan=2><input class=BodyBut type=submit name=action value=\"".$l['add']."\"></td></tr>";


		## Bottom Menu Starts
		echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>";

		echo "<tr>
				</table>
				<input class=BodyBut type=button name=action value=".$l['save']." onClick=\"javascript:validateSave()\">
				".($mode=="update" && $a_train[$e_id_teams]>=4 ? "<input class=BodyBut type=submit name=action value=\"".$l['delete']."\">" : "")."
				<input class=BodyBut type=reset value=".$l['reset'].">
				<input class=BodyBut type=submit name=action value=".$l['cancel'].">
				</form>";

		if ($mode=="update") {
				$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					$r = mysql_fetch_array($result);
					$last_edit=$l['last_edited_by'];
					echo "<p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p>";
				}
		}
	}elseif($mode=="display"){

	############ DISPLAY MODE ##############
	### SECTION: Main Table Body
		echo "<table width=100% border=0>
				<table width=100% border=0 cols=2 cellpadding=0 cellspacing=1>
				<tr>
				<td class=BodyInputTd class=normal align=left colspan=2><p class=BodyH2>".$l['display_course']."</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>1. ".$l['course']."</p></td>
				</tr>";
		for ($x = 1; $x <= $maxLang; $x++){
			
			$myVar="e_title$x";
			echo"<tr>
				<td class=BodyInputTd><p class=BodyInpH>".$l['title']." (".$l['lang'.$x].")</p></td>
				<td class=BodyInputTd><p class=BodyInp>".$$myVar."</p></td>
				</tr>";
		}
		echo "<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['team']."</p></td>
				<td class=BodyInputTd><p class=BodyInp>";
				$query = "SELECT id_record, team_name FROM teams WHERE id_record='$e_id_teams'";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
						if ($e_id_teams==$r['id_record']) { 
							echo $r['team_name'];
						}
					}
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
		echo "</p></td>
				</tr>
				<tr>
				<td class=BodyInputTd valign=top><p class=BodyInpH>".$l['certification']." (".$l['optional'].")</p></td>
				<td class=BodyInputTd><p class=BodyInp>";
				$query = "SELECT id_record, types_certifications.type$lang AS type FROM types_certifications WHERE id_record='$e_certification'";
				$result = mysql_query($query) or die ($l['query_failed'].":$query");
				if (mysql_num_rows($result)) {
					while ($r = mysql_fetch_array($result)) {
						if ($e_certification==$r['id_record']) { 
							echo $r['type'];
						}
					}
				}else{
					# Nothing matched the query
					echo "<p class=BodyTxt>".$l['no_results']."</p>";
				}
		echo "</p></td>
				</tr>";


		#### SECTION: Modules		
		echo "<tr>
				<td class=BodyInputTd colspan=2><hr></td>
				</tr>
				<tr>
				<td class=BodyInputTd colspan=2><p class=BodyH3>2. ".$l['modules']."</p></td>
				</tr>
				<tr>";
		$query = "
			SELECT modules.id_record AS record,
			modules.type,
			modules.pass,
			modules.title1,
			modules.title2,
			modules.title3,
			modules.title4,
			modules.title5
			FROM modules
			WHERE modules.id_course='$s_id'
			";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			echo "<td class=BodyInputTd colspan=2><table>
					<tr>
					<td class=BodyInputTd><p class=BodyH3>".$l['type']."</p></td>";
			for ($x = 1; $x <= $maxLang; $x++){
				echo	"<td class=BodyInputTd><p class=BodyH3>".$l['title']." (".$l['lang'.$x].")</p></td>";
			}
			echo "<td class=BodyInputTd><p class=BodyH3>".$l['pass_mark']." (%)</p></td>
					<td class=BodyInputTd></td>
					</tr>
					<tr>";
			while ($r = mysql_fetch_array($result)) {
					$c_type_id=$r['type']; echo "<td class=BodyInputTd><p class=BodyInp>$c_type[$c_type_id]</p></td>";
				for ($x = 1; $x <= $maxLang; $x++){
					echo "<td class=BodyInputTd><p class=BodyInp>".$r['title'.$x]."</p></td>";
				}
				echo"<td class=BodyInputTd><p class=BodyInp>".$r['pass']."</p></td>
					";
					echo "</tr>";
			}
			echo "</table>";
		}else{
			# Nothing matched the query
			echo "<td class=BodyInputTd colspan=2><p class=BodyTxt>".$l['none'].".</p></td>";
		}
		echo "</tr>";

		### Last Edited By
		$query = "SELECT full_name FROM users WHERE id_record='$e_id_users'";
		$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
		if (mysql_num_rows($result)) {
			$r = mysql_fetch_array($result);
			$last_edit=$l['last_edited_by'];
			echo "<tr><td class=BodyInputTd colspan=2><hr></td></tr>
			<tr><td class=BodyInputTd colspan=2><p class=BodyLastEditTxt>".ereg_replace("\[edit_time\]",$e_when_entered,ereg_replace("\[user\]",$r['full_name'],$last_edit))."</p></td></tr>";
		}

		### End of table	
		echo "</table>";

	}

	foot();

?>