<?php

	# E-GADS! Electronic Ground Search and Rescue Administrative Database
	# Copyright (C) 2003 Calvin Martini

	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.

	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.

	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	# Program: tms_course_select.php
	# Version: 14 May 2004
	# Author: Calvin Martini
	# Description: Choose a course

	session_start(); 

	# Set client variables
	$client_vars=array(
		'e_seek',
		'mode',
		'province',
		't_scope',
		't_search',
		'team'
	); 
	foreach ($client_vars as $formvar){
	    $$formvar = (isset($_REQUEST[$formvar]))?$_REQUEST[$formvar]:NULL; 
	}

	require("globals.php");

	connect_db();
	
	# Limit for number of records to return per page
	$page_limit = 20;
	
	# Set the user's team access arrays
	list($a_search, $a_memb, $a_train, $a_cert, $a_all_teams, $a_team, $a_team_name)=team_access("access_training");

	# Check to ensure proper access level to edit record
	if ( max($a_train) < 1 || isset($_SESSION["id_user"])==FALSE) {
		fail_access($_SERVER['QUERY_STRING']);
	}

	# If user changed display or filter modes, set the session variables
	if ($team){$t_team2=$team;}
	if ($province){$t_province2=$province;}
	if ($t_scope){$t_search_scope=$t_scope;}

	# Set the search filter
	if ($t_scope && $t_search){
		switch ($t_scope) {
		# team, province, module, class
			case "team";
				$t_report="team";
				$t_filter="All";
				$t_search_filter="AND team_name LIKE '%$t_search%'"; 
				break 1;
			case "province";
				$t_report="province";
				$t_filter="All";
				$t_search_filter="AND types_province.type$lang LIKE '%$t_search%')"; 
				break 1;
			case "module":
				$t_report="module";
				$t_filter="All";
				$t_search_filter="AND modules.title$lang LIKE '%$t_search%'"; 
				break 1;
			case "course":
				$t_report="course";
				$t_filter="All";
				$t_search_filter="AND courses.title$lang LIKE '%$t_search%'";  
				break 1;
		}
	}	
	

	head("tms_course_select");

	# Set DB query
	$query="SELECT modules.id_record as id_record,
		courses.id_record as course,
		courses.title$lang AS course_name,
		modules.title$lang AS module_name,
		IF(courses.id_province=9999,'".$l['all']."',types_province.type$lang) AS province_name,
		IF(courses.id_teams=9999,'".$l['all']."',teams.team_name) AS team_name
		FROM modules
		LEFT JOIN courses ON courses.id_record=modules.id_course
		LEFT JOIN teams ON teams.id_record=courses.id_teams
		LEFT JOIN types_province ON types_province.id_record=courses.id_province
		".($a_team!=-1 ? "LEFT JOIN team_access ON team_access.id_teams=teams.id_record WHERE ((team_access.access_members>=2 AND team_access.id_users='$id_recno') OR (team_access.id_users IS NULL AND courses.id_teams=9999)) " : "WHERE 1=1")."
		".($a_province!=-1 ? "AND (courses.id_province='$a_province' OR courses.id_province=9999)" : "")."  
		$t_search_filter
		".($province && $province != "All" && $province != "None" ? " AND courses.id_province='$province'" : "")."				
		ORDER BY province_name, course_name, module_name";
	$result = mysql_query($query) or die (mysql_errno().": ".mysql_error()."<BR><BR>".$l['query_failed'].":$query");
	$res_row = mysql_num_rows($result);
#echo "$res_row<br>$query";exit;
	if ($res_row) {

		echo "<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/calendar/calendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"js/CallCalendar.js\"></SCRIPT>
				<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"js/add_days.js\"></SCRIPT>
				";

		echo "<form method=POST action=tms_course_edit.php ENCTYPE=\"application/x-www-form-urlencoded\" name=MForm>
				".SIDHIDDEN."
				<input type=hidden name=mode value=\"$mode\">";

		echo "<p class=BodyH2>".$l['new_class']."</p>
				<p class=BodyTxt>".$l['tms_choose_explain1']."</p>";

		# Print page links
		if ($res_row > $page_limit){
			if (!$e_seek){$e_seek=0;}
			if (($e_seek+$page_limit) <= $res_row){
				$e_end = $e_seek + $page_limit - 1;
			}else{
				$e_end = $res_row;
			}
			$start = $e_seek + 1;
			$end = $e_end + 1;
			$e_page = floor($e_seek/$page_limit) + 1;
			echo "<p class=BodyTxt>".ereg_replace("\[start\]","$start",ereg_replace("\[end\]","$end",ereg_replace("\[records\]","$res_row",$l['page_limit'])));
			echo "&nbsp;&nbsp;&nbsp;<b>".$l['page']."&nbsp;</b> ";
			for ($i = 1; $i <= ceil($res_row / $page_limit); $i++) {
				echo ($i == $e_page ? "<b>" : "")."<a href=\"tms_course_select.php?mode=new&s_id=-999&e_seek=".(($i-1) * $page_limit).SIDAND."\">$i</a>&nbsp;&nbsp;&nbsp".($i == $e_page ? "</b>" : "");
			}
			echo "</p>";
		}

		echo "<table class=BodyRepTh cellpadding=2 cellspacing=0>";

		$col[]=$l['province']; $col[]=$l['course']; $col[]=$l['module']; $col[]=$l['team'];
		$dat[]="province_name"; $dat[]="course_name"; $dat[]="module_name"; $dat[]="team_name";

		# Display column headings
		echo "<tr>";
		echo "<td class=BodyRepTh><p class=BodyRepH2>+</p></td>";
		foreach ($col as $column){
				echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
		}	
		if ($query2){
			foreach ($sub_col as $column){
					echo "<td class=BodyRepTh><p class=BodyRepH2>$column</p></td>";
			}
		}
		echo "</tr>";

		# Set start record
		if ($e_seek && (!mysql_data_seek($result, $e_seek))) {
			echo "<p class=BodyTxt>Cannot seek to row $e_seek</p>";
			continue;
		}

		$count = 0;
		while (($r = mysql_fetch_array($result)) && ($count < $page_limit)) {
			echo "<tr>";
			echo "<td class=BodyRepTd><p class=BodyRepTxt><a class=BodyLink href=\"tms_class_edit.php?mode=$mode&s_id=-999&module=".$r['id_record']."".SIDAND."\"><img src=\"images/blue.gif\" border=0></a></p></td>";

			foreach ($dat as $data){
				echo "<td class=BodyRepTd><p class=BodyRepTxt>".($r[$data] ? $r[$data] : "&nbsp;")."</p></td>";
			}

			echo "</tr>";
			$count++;

		}
		
		### End of table	
		echo "</table>";

	}else{
		# Nothing matched the query
		echo "<p class=BodyH2>".$l['new_class']."</p>";
		echo "<p class=BodyTxt>".$l['tms_choose_explain1']."</p>";
		echo "<p class=BodyTxt>".$l['no_results']."</p><br>";
	}
	
	foot();

?>