#!/bin/sh
#
# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#
# Backup MySQL database, compress and email
# Calvin Martini, 2001-10-05
#
## User definable parameters
g_file="file to transfer"
g_user="backup"
g_pwd="password"
g_db="e-gads"
g_target_dir="/home/backup/backup_e-gads"
g_archive_dir="/home/backup"
g_progpath="/usr/local/scripts"
g_list="your.email@host.org"
## End user definable parameters

# Get the date/time
g_date=$(date +%y%m%d%H%M)

# Copy the table(s) using mysqlhotcopy
#/usr/bin/mysqlhotcopy --u=$g_user --p=$g_pwd --noindices --allowold $g_db $g_target_dir
/usr/bin/mysqlhotcopy --u=$g_user --p=$g_pwd --allowold $g_db $g_target_dir

# Create tarball
tar --remove-files -cvf $g_archive_dir/$g_db.$g_date.tar $g_target_dir

# Compress the tarball
if [ -f $g_archive_dir/$g_db.$g_date.tar ] ; then
	gzip $g_archive_dir/$g_db.$g_date.tar
fi

# Mail the file
if [ -f $g_archive_dir/$g_db.$g_date.tar.gz ] ; then
	echo "E-GADS Backup for $(date)" | $g_progpath/biabam $g_archive_dir/$g_db.$g_date.tar.gz -s "AUTOMAIL: E-GADS DB $(date)" $g_list
fi

# Cleanup
if [ -f $g_archive_dir/$g_db.$g_date.tar.gz ] ; then
	rm $g_archive_dir/$g_db.$g_date.tar.gz
fi
