#!/usr/bin/perl

# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# This script is used to generate periodic directors reports for the NBGSARA database
# Last Updated: 11 October 2002

use DBI;

$user = "egads";
$password = "password";
$hostname = "localhost";
$database = "e-gads";
$recipients = "your.email\@host.org";
$out_path = "/home/httpd/html/e-gads/reports/directors";
$biabam = "/usr/local/scripts/biabam";

&gettime;
(@month) = split(/\|/, "January|February|March|April|May|June|July|August|September|October|November|December");

$out_file = "$out_path/$date.html";

$dbh = DBI->connect("DBI:mysql:$database:$hostname",$user, $password);

$statement = "	SELECT members.id_record AS id_record,
	CONCAT(members.name_first,' ',members.name_last) AS full_name,
	CONCAT(address_street,IF(address_street!='',', ',''),address_city,IF(address_city!='',', ',''),address_pcode,IF(address_city!='',', ',''),types_province.".($lang=="e" ? "type" : "type_f") . ") AS address,
	members.title AS title,
	members.phone_work,
	members.phone_home,
	members.phone_cell,
	members.phone_fax,
	members.phone_pager,
	members.phone_other,
	members.email,
	members.occupation,
	teams_members.id_teams AS team,
	teams.team_name AS team_name,
	IF(members.flag_director=1,'Director','Alternate') AS dir_type
	FROM members
	LEFT JOIN teams_members ON members.id_record=teams_members.id_members
	LEFT JOIN types_province ON members.id_address_province=types_province.id_record
	LEFT JOIN teams ON teams.id_record=teams_members.id_teams
	WHERE members.flag_director=1 OR members.flag_alternate=1
	ORDER BY dir_type, team, members.name_last";

$sth = $dbh->prepare($statement) or die "Can't prepare $statement: $dbh->errstr\n";

$rv = $sth->execute or die "Can't execute the query: $sth->errstr\n";

# Wite the modifed user list to disk
open (FILE, ">$out_file") || die "FATAL: Could not create output file $out_file.";
print FILE "<HTML><BODY><H1>NBGSARA DIRECTORS AND ALTERNATES</H1><H3>Generated $date $time</H3>";
print FILE "<br>This and other generated reports can be found at <a href=http://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/reports>http://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/reports</a><br><br>";
print FILE "<TABLE border=1 cellpadding=2 cellspacing=0>";

# Display column headings
print FILE "<tr>";
print FILE "<td class=h1><h2 class=inverse>Team</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Name</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Title</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Address</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Occupation</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Work</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Home</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Cell</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Fax</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Pager</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Other</h2></td>";
print FILE "<td class=h1><h2 class=inverse>Email</h2></td>";
print FILE  "</tr>";

# Initialize type
$h_type="";

while (@data = $sth->fetchrow_array()) {
	my $full_name = $data[1];
	my $address = $data[2];
	my $title = $data[3];
	my $phone_work = $data[4];
	my $phone_home = $data[5];
	my $phone_cell = $data[6];
	my $phone_fax = $data[7];
	my $phone_pager = $data[8];
	my $phone_other = $data[9];
	my $email = $data[10];
	my $occupation = $data[11];
	my $team = $data[12];
	my $team_name = $data[13];
	my $dir_type = $data[14];

	if($dir_type ne $h_type){
		print FILE "<tr>";
		print FILE "<td colspan=12 class=h1><h2 class=inverse>$dir_type&nbsp;</h2></td>";
		print FILE "</tr>";
		$h_type = $dir_type;	
	}

	#Display data row
	print FILE "<tr>";
	print FILE "<td>$team_name&nbsp;</td>";
	print FILE "<td>$full_name&nbsp;</td>";
	print FILE "<td>$title&nbsp;</td>";
	print FILE "<td>$address&nbsp;</td>";
	print FILE "<td>$occupation&nbsp;</td>";
	print FILE "<td>$phone_work&nbsp;</td>";
	print FILE "<td>$phone_home&nbsp;</td>";
	print FILE "<td>$phone_cell&nbsp;</td>";
	print FILE "<td>$phone_faxr&nbsp;</td>";
	print FILE "<td>$phone_pager&nbsp;</td>";
	print FILE "<td>$phone_other&nbsp;</td>";
	print FILE "<td>$email&nbsp;</td>";
	print FILE "</tr>";
}

print FILE "</TABLE><BR><P>For General Inquiries:<BR>NBGSARA Provincial Secretary<BR><A HREF=\"mailto:info\@nbgsara.nb.ca\">info\@nbgsara.nb.ca</A><BR><BR>For Technical Information:<BR>NBGSARA Provincial Webmaster<BR><A HREF=\"mailto:webmaster\@nbgsara.nb.ca\">webmaster\@nbgsara.nb.ca</A></P>";
print FILE "</BODY></HTML>";
close(FILE) || die "FATAL: Could not close output file.";

$rc = $sth->finish;

# Send the Email
#     use Mail::Sender;
#     $sender = new Mail::Sender
#      {smtp => 'localhost', from => 'root@nec.prv'};
#     $sender->MailFile({to => 'martinic@nbnet.nb.ca',
#      subject => 'Here is the file',
#      msg => "This is a test only.",
#      file => 'temp.txt'});

system "echo \"Attached is the NBGSARA Directors list for $month[$month_index] $year.\n\nThis and other generated reports can be found at http://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/reports\n\nFor General Inquiries:\nNBGSARA Provincial Secretary\ninfo\@nbgsara.nb.ca\n\nFor Technical Information:\nNBGSARA Provincial Webmaster\nwebmaster\@nbgsara.nb.ca\" | $biabam $out_file -s \"NBGSARA Directors list for $month[$month_index] $year\" $recipients";

exit;


sub gettime {
	($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
	$month_index = $mon;
	$mon++;
	$year += 1900;       
	if ($sec < 10) { $sec = "0$sec"; }
	if ($min < 10) { $min = "0$min"; }
	if ($hour < 10) { $hour = "0$hour"; }
	if ($mday < 10) { $mday = "0$mday"; }
	$date = "$year-$mon-$mday";
	$time = "$hour:$min:$sec";
}
