#!/usr/bin/perl

# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use DBI;

$user = "egads";
$password = "password";
$hostname = "localhost";
$database = "e-gads";
$flagpath = "/home/httpd/html/e-gads/data/e_flag.txt";
$period = "next_month";
$event_filter = "";
$recipients = "your.email\@host.org";
$out_file = "/tmp/emergency.html";
$biabam = "/usr/local/scripts/biabam";

# Test of the changes flag file exists, only continue if it does
if (-f $flagpath){

	# Read the list of changes
	open (FILE, "$flagpath");
	@changes = <FILE>;
	close(FILE);
	chomp(@changes);

	&gettime;
	(@month) = split(/\|/, "January|February|March|April|May|June|July|August|September|October|November|December");

	$dbh = DBI->connect("DBI:mysql:$database:$hostname",$user, $password);

	$statement = "SELECT members.id_record AS id_record,
			CONCAT(members.name_first,' ',members.name_last) AS full_name,
			members.title AS title,
			IF(teams_members.id_teams,teams_members.id_teams,-999) AS team,
			members.phone_work,
			members.phone_home,
			members.phone_cell,
			members.phone_fax,
			members.phone_pager,
			members.phone_other,
			members.email
			FROM members
			LEFT JOIN teams_members ON members.id_record=teams_members.id_members
			WHERE members.flag_emergency=1
			ORDER BY team, members.display_priority, members.name_last";

	$sth = $dbh->prepare($statement) or die "Can't prepare $statement: $dbh->errstr\n";

	$rv = $sth->execute or die "Can't execute the query: $sth->errstr\n";

	# Wite the modifed user list to disk
	open (FILE, ">$out_file") || die "FATAL: Could not create output file.";
	print FILE "<HTML><BODY><H1>NBGSARA EMERGENCY CONTACTS</H1><H3>Generated $date $time</H3>";
	print FILE "<b>CONTROLLED DOCUMENT:</b> <u>Obsolete once printed</u>.<br>Current version can be found at <a href=http://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/pub_emergency.php?action=print>http://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/pub_emergency.php?action=print</a><br><br>";
	print FILE "<TABLE border=1 cellpadding=2 cellspacing=0>";

	while (@data = $sth->fetchrow_array()) {
		my $full_name = $data[1];
		my $title = $data[2];
		my $team = $data[3];
		my $phone_work = $data[4];
		my $phone_home = $data[5];
		my $phone_cell = $data[6];
		my $phone_fax = $data[7];
		my $phone_pager = $data[8];
		my $phone_other = $data[9];
		my $email = $data[10];

		if ($team != $team_index){

			# Display Team Information
			$team_index=$team;
			if ($team_index != -999){

				$statement2 = "SELECT * FROM teams WHERE id_record='$team_index'";
				$sth2 = $dbh->prepare($statement2) or die "Can't prepare $statement2: $dbh->errstr\n";
				$rv2 = $sth2->execute or die "Can't execute the query: $sth2->errstr\n";
				@data2 = $sth2->fetchrow_array();
				my $id_record = $data2[0];
				my $id_users = $data2[1];
				my $when_entered = $data2[2];
				my $team_name = $data2[3];
				my $team_address = $data2[4];
				my $team_city = $data2[5];
				my $team_pcode = $data2[6];
				my $phone_1 = $data2[7];
				my $phone_2 = $data2[8];
				my $phone_pager = $data2[9];
				my $phone_cell = $data2[10];
				my $phone_fax = $data2[11];
				my $email = $data2[12];
				my $description = $data2[13];

				print FILE "<tr><td colspan=7><h2>$team_name".(length($team_city)>3 ? ", $team_city": "")."</h2>
						<h3>
						".(length($phone_1)>3 ? "&nbsp;&nbsp;<b>Team Primary Phone Contact:</b> $phone_1<br>": "")."
						".(length($phone_2)>3 ? "&nbsp;&nbsp;<b>Team Secondary Phone Contact:</b> $phone_2<br>": "")."
						".(length($phone_pager)>3 ? "&nbsp;&nbsp;<b>Team Pager:</b> $phone_pager<br>": "")."
						".(length($phone_cell)>3 ? "&nbsp;&nbsp;<b>Team Cellular:</b> $phone_cell<br>": "")."
						".(length($phone_fax)>3 ? "&nbsp;&nbsp;<b>Team Fax:</b> $phone_fax<br>": "")."
						".(length($email)>3 ? "&nbsp;&nbsp;<b>Team Email Address:</b> <a href=\"mailto:$email\">$email</a>": "")."
						</h3>
						</td></tr>";

			}else{
				print FILE "<tr><td colspan=7><h2>Unassigned</h2></td></tr>";
			}					
			# Display column headings
			print FILE "<tr>";
			print FILE "<td><h3>Full Name</h3></td>";
			print FILE "<td><h3>Title</h3></td>";
			print FILE "<td><h3>Phone: Work</h3></td>";
			print FILE "<td><h3>Phone: Home</h3></td>";
			print FILE "<td><h3>Phone: Cell</h3></td>";
			print FILE "<td><h3>Phone: Pager</h3></td>";
			print FILE "<td><h3>Phone: Other</h3></td>";
			print FILE  "</tr>";
		}

		print FILE "<tr>";
		print FILE "<td>$full_name&nbsp;</td>";
		print FILE "<td>$title&nbsp;</td>";
		print FILE "<td>$phone_work&nbsp;</td>";
		print FILE "<td>$phone_home&nbsp;</td>";
		print FILE "<td>$phone_cell&nbsp;</td>";
		print FILE "<td>$phone_pager&nbsp;</td>";
		print FILE "<td>$phone_other&nbsp;</td>";
		print FILE "</tr>";
	}
	print FILE "</table>";

	print FILE "</TABLE><BR><P>For General Inquiries:<BR>NBGSARA Provincial Secretary<BR><A HREF=\"mailto:info\@nbgsara.nb.ca\">info\@nbgsara.nb.ca</A><BR><BR>For Technical Information:<BR>NBGSARA Provincial Webmaster<BR><A HREF=\"mailto:webmaster\@nbgsara.nb.ca\">webmaster\@nbgsara.nb.ca</A></P>";
	print FILE "</BODY></HTML>";
	close(FILE) || die "FATAL: Could not close output file.";

	$rc = $sth->finish;

	# Send the Email
	#     use Mail::Sender;
	#     $sender = new Mail::Sender
	#      {smtp => 'localhost', from => 'root@nec.prv'};
	#     $sender->MailFile({to => 'martinic@nbnet.nb.ca',
	#      subject => 'Here is the file',
	#      msg => "This is a test only.",
	#      file => 'temp.txt'});

	$change_text="The following is the list of changes for this revision:\n";
	for (@changes) {
		($e_date_time,$e_ip,$e_recno,$e_full_name,$e_function) = split(/\t/);
		$change_text .= "$e_date_time - Contact $e_full_name $e_function\n";
	}
	
	system "echo \"Attached is the NBGSARA emergency contacts list for $month[$month_index] $year.\n\n$change_text\n**THIS IS A CONTROLLED DOCUMENT and is obsolete once emailed or printed. PLEASE DESTROY ANY OLDER COPIES IMMEDIATELY.\nThe current official version can be found at:\nhttp://www.nbgsara.nb.ca/apps/ip_forward.cgi?/nbgsaradb/pub_emergency.php?action=print\n\nFor General Inquiries:\nNBGSARA Provincial Secretary\ninfo\@nbgsara.nb.ca\n\nFor Technical Information:\nNBGSARA Provincial Webmaster\nwebmaster\@nbgsara.nb.ca\" | $biabam $out_file -s \"NBGSARA emergency contacts list for $month[$month_index] $year\" $recipients";

	# Remove the file
	system "rm $out_file";

	# Remove the flag file
	system "rm $flagpath";
}

exit;


sub gettime {
	($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
	$month_index = $mon;
	$mon++;
	$year += 1900;       
	if ($sec < 10) { $sec = "0$sec"; }
	if ($min < 10) { $min = "0$min"; }
	if ($hour < 10) { $hour = "0$hour"; }
	if ($mday < 10) { $mday = "0$mday"; }
	$date = "$year-$mon-$mday";
	$time = "$hour:$min:$sec";
}
